/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VueLoadColorMapValues
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1648400107478203724L;
    VARNAPanel _vp;
    JRadioButton urlCB = new JRadioButton("URL");
    JRadioButton fileCB = new JRadioButton("File");
    JPanel urlAux = new JPanel();
    JPanel fileAux = new JPanel();
    CardLayout l = new CardLayout();
    JPanel input = new JPanel();
    JTextField urlTxt = new JTextField();
    JTextField fileTxt = new JTextField();
    JButton load = new JButton("Choose file");

    public VueLoadColorMapValues(VARNAPanel vp) {
        this._vp = vp;
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(2, 1));
        JPanel choice = new JPanel();
        this.urlCB.addActionListener(this);
        this.fileCB.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.urlCB);
        group.add(this.fileCB);
        choice.add(new JLabel("Choose input source:"));
        choice.add(this.urlCB);
        choice.add(this.fileCB);
        this.input.setLayout(this.l);
        this.urlTxt.setPreferredSize(new Dimension(300, 30));
        this.fileTxt.setPreferredSize(new Dimension(300, 30));
        this.urlAux.add(this.urlTxt);
        this.fileAux.add(this.fileTxt);
        this.fileAux.add(this.load);
        this.input.add((Component)this.fileAux, "file");
        this.input.add((Component)this.urlAux, "url");
        group.setSelected(this.fileCB.getModel(), true);
        this.load.addActionListener(this);
        this.add(choice);
        this.add(this.input);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc;
        if (e.getSource() instanceof JRadioButton) {
            if (this.urlCB.isSelected()) {
                this.l.show(this.input, "url");
            } else {
                this.l.show(this.input, "file");
            }
        } else if (e.getSource() instanceof JButton && (fc = new JFileChooser()).showSaveDialog(this._vp) == 0) {
            this.fileTxt.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public Reader getReader() throws IOException {
        if (this.urlCB.isSelected()) {
            URL url = new URL(this.urlTxt.getText());
            URLConnection connexion = url.openConnection();
            connexion.setUseCaches(false);
            InputStream r = connexion.getInputStream();
            return new InputStreamReader(r);
        }
        return new FileReader(this.fileTxt.getText());
    }
}

