/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VueHighlightRegionEdit
implements ChangeListener,
ActionListener {
    private VARNAPanel _vp;
    private JSlider _fromSlider;
    private JSlider _toSlider;
    private JPanel panel;
    private HighlightRegionAnnotation _an;
    private static int CONTROL_HEIGHT = 50;
    private static int TITLE_WIDTH = 70;
    private static int CONTROL_WIDTH = 200;
    private JButton fillShow = new JButton();
    private JButton outlineShow = new JButton();
    JSpinner rad;
    HighlightRegionAnnotation _backup = null;

    public VueHighlightRegionEdit(VARNAPanel vp, HighlightRegionAnnotation an) {
        this._an = an;
        this._vp = vp;
        this._toSlider = new JSlider(0, 0, vp.getRNA().getSize() - 1, 0);
        this._toSlider.setMajorTickSpacing(10);
        this._toSlider.setPaintTicks(true);
        this._toSlider.setPaintLabels(true);
        this._toSlider.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this._fromSlider = new JSlider(0, 0, vp.getRNA().getSize() - 1, 0);
        this._fromSlider.setMajorTickSpacing(10);
        this._fromSlider.setPaintTicks(true);
        this._fromSlider.setPaintLabels(true);
        this._fromSlider.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this._fromSlider.addChangeListener(this);
        this._toSlider.addChangeListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0));
        JPanel fromp = new JPanel();
        JLabel l1 = new JLabel("From: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        fromp.add(l1);
        fromp.add(this._fromSlider);
        JPanel top = new JPanel();
        l1 = new JLabel("To: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        top.add(l1);
        top.add(this._toSlider);
        JPanel outlinep = new JPanel();
        l1 = new JLabel("Outline color: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.outlineShow.setContentAreaFilled(false);
        this.outlineShow.setOpaque(true);
        this.outlineShow.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.outlineShow.setBackground(an.getOutlineColor());
        this.outlineShow.addActionListener(this);
        this.outlineShow.setActionCommand("outline");
        outlinep.add(l1);
        outlinep.add(this.outlineShow);
        JPanel fillp = new JPanel();
        l1 = new JLabel("Fill color: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.fillShow.setContentAreaFilled(false);
        this.fillShow.setOpaque(true);
        this.fillShow.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.fillShow.setBackground(an.getFillColor());
        this.fillShow.addActionListener(this);
        this.fillShow.setActionCommand("fill");
        fillp.add(l1);
        fillp.add(this.fillShow);
        JPanel radiusp = new JPanel();
        l1 = new JLabel("Radius: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        SpinnerNumberModel jm = new SpinnerNumberModel(this._an.getRadius(), 1.0, 50.0, 0.1);
        this.rad = new JSpinner(jm);
        this.rad.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        radiusp.add(l1);
        radiusp.add(this.rad);
        this.rad.addChangeListener(this);
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(5, 1));
        jp.add(fromp);
        jp.add(top);
        jp.add(outlinep);
        jp.add(fillp);
        jp.add(radiusp);
        this.panel.add(jp);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double getAngle() {
        return this._toSlider.getValue();
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public boolean show() {
        boolean accept = false;
        int from = this._an.getMinIndex();
        int to = this._an.getMaxIndex();
        this._fromSlider.setValue(from);
        this._toSlider.setValue(to);
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Edit region annotation", 2, -1) == 0) {
            accept = true;
        }
        this._vp.repaint();
        return accept;
    }

    public void stateChanged(ChangeEvent e) {
        Object val;
        if (e.getSource() == this._toSlider || e.getSource() == this._fromSlider) {
            int to;
            int from = this._fromSlider.getValue();
            if (from > (to = this._toSlider.getValue())) {
                if (e.getSource().equals(this._fromSlider)) {
                    this._toSlider.setValue(from);
                } else if (e.getSource().equals(this._toSlider)) {
                    this._fromSlider.setValue(to);
                }
            }
            from = this._fromSlider.getValue();
            to = this._toSlider.getValue();
            this._an.setBases(this._vp.getRNA().getBasesBetween(from, to));
            this._vp.repaint();
        } else if (e.getSource().equals(this.rad) && (val = this.rad.getValue()) instanceof Double) {
            this._an.setRadius((Double)val);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        if (e.getActionCommand().equals("outline")) {
            Color c2 = JColorChooser.showDialog(this.getPanel(), "Choose new outline color", this._an.getOutlineColor());
            if (c2 != null) {
                this._an.setOutlineColor(c2);
            }
        } else if (e.getActionCommand().equals("fill") && (c = JColorChooser.showDialog(this.getPanel(), "Choose new fill color", this._an.getFillColor())) != null) {
            this._an.setFillColor(c);
        }
        this.outlineShow.setBackground(this._an.getOutlineColor());
        this.fillShow.setBackground(this._an.getFillColor());
        this._vp.repaint();
    }
}

