/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class VueFont {
    private VARNAPanel _vp;
    private Font font;
    private JComboBox stylesBox;
    private JComboBox boxPolice;
    private JPanel panel;
    private JSlider sizeSlider;

    public VueFont(VARNAPanel vp) {
        this._vp = vp;
        this.init();
        this.buildViewVPTitle();
    }

    public VueFont(Font f) {
        this.font = f;
        this.init();
        this.buildViewFont();
    }

    private void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] polices = ge.getAvailableFontFamilyNames();
        this.boxPolice = new JComboBox<String>(polices);
        this.sizeSlider = new JSlider(0, 4, 88, 14);
        this.sizeSlider.setMajorTickSpacing(10);
        this.sizeSlider.setMinorTickSpacing(5);
        this.sizeSlider.setPaintTicks(true);
        this.sizeSlider.setPaintLabels(true);
        String[] styles = new String[]{"Plain", "Italic", "Bold"};
        this.stylesBox = new JComboBox<String>(styles);
        this.panel = new JPanel();
        this.panel.add(this.boxPolice);
        this.panel.add(this.sizeSlider);
        this.panel.add(this.stylesBox);
    }

    private void buildViewFont() {
        this.boxPolice.setSelectedItem(this.font.getFamily());
        this.sizeSlider.setValue(this.font.getSize());
        this.stylesBox.setSelectedItem(this.styleIntToString(this.font.getStyle()));
    }

    private void buildViewVPTitle() {
        this.boxPolice.setSelectedItem(this._vp.getTitleFont().getFamily());
        this.sizeSlider.setValue(this._vp.getTitleFont().getSize());
        this.stylesBox.setSelectedItem(this.styleIntToString(this._vp.getTitleFont().getStyle()));
    }

    public String styleIntToString(int styleInt) {
        switch (styleInt) {
            case 0: {
                return "Plain";
            }
            case 2: {
                return "Italic";
            }
            case 1: {
                return "Bold";
            }
        }
        return "Plain";
    }

    public JComboBox getStylesBox() {
        return this.stylesBox;
    }

    public JComboBox getBoxPolice() {
        return this.boxPolice;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JSlider getSizeSlider() {
        return this.sizeSlider;
    }

    public Font getFont() {
        int style;
        switch (this.getStylesBox().getSelectedIndex()) {
            case 0: {
                style = 0;
                break;
            }
            case 1: {
                style = 2;
                break;
            }
            case 2: {
                style = 1;
                break;
            }
            default: {
                style = 0;
            }
        }
        return new Font((String)this.getBoxPolice().getSelectedItem(), style, this.getSizeSlider().getValue());
    }
}

