/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VueChemProbAnnotation
implements ChangeListener,
ActionListener,
ItemListener {
    private VARNAPanel _vp;
    private JPanel panel;
    private ChemProbAnnotation _an;
    private static int CONTROL_HEIGHT = 50;
    private static int TITLE_WIDTH = 70;
    private static int CONTROL_WIDTH = 200;
    private JButton color = new JButton();
    JSpinner intensity;
    JComboBox outward = new JComboBox<String>(new String[]{"Inward", "Outward"});
    JComboBox type = new JComboBox<ChemProbAnnotation.ChemProbAnnotationType>(ChemProbAnnotation.ChemProbAnnotationType.values());
    HighlightRegionAnnotation _backup = null;

    public VueChemProbAnnotation(VARNAPanel vp, ChemProbAnnotation an) {
        this._an = an;
        this._vp = vp;
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0));
        JPanel outlinep = new JPanel();
        JLabel l1 = new JLabel("Color: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.color.setContentAreaFilled(false);
        this.color.setOpaque(true);
        this.color.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.color.setBackground(this._an.getColor());
        this.color.addActionListener(this);
        this.color.setActionCommand("outline");
        outlinep.add(l1);
        outlinep.add(this.color);
        JPanel radiusp = new JPanel();
        l1 = new JLabel("Intensity: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        SpinnerNumberModel jm = new SpinnerNumberModel(this._an.getIntensity(), 0.01, 10.0, 0.01);
        this.intensity = new JSpinner(jm);
        radiusp.add(l1);
        radiusp.add(this.intensity);
        this.intensity.addChangeListener(this);
        JPanel dirp = new JPanel();
        l1 = new JLabel("Direction: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.outward.addItemListener(this);
        dirp.add(l1);
        dirp.add(this.outward);
        JPanel typep = new JPanel();
        l1 = new JLabel("Type: ");
        l1.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.type.addItemListener(this);
        typep.add(l1);
        typep.add(this.type);
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(4, 1));
        jp.add(outlinep);
        jp.add(radiusp);
        jp.add(dirp);
        jp.add(typep);
        this.panel.add(jp);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public boolean show() {
        boolean accept = false;
        this.intensity.setValue(this._an.getIntensity());
        this.color.setBackground(this._an.getColor());
        this.type.setSelectedItem((Object)this._an.getType());
        this.outward.setSelectedItem(this._an.isOut() ? "Inward" : "Outward");
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Edit chemical probing annotation", 2, -1) == 0) {
            accept = true;
        }
        this._vp.repaint();
        return accept;
    }

    public void stateChanged(ChangeEvent e) {
        Object val;
        if (e.getSource().equals(this.intensity) && (val = this.intensity.getValue()) instanceof Double) {
            this._an.setIntensity((Double)val);
            this._vp.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        if (e.getActionCommand().equals("outline") && (c = JColorChooser.showDialog(this.getPanel(), "Choose new outline color", this._an.getColor())) != null) {
            this._an.setColor(c);
        }
        this.color.setBackground(this._an.getColor());
        this._vp.repaint();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.outward) {
            this._an.setOut(!e.getItem().equals("Outward"));
            this._vp.repaint();
        } else if (e.getSource() == this.type && e.getItem() instanceof ChemProbAnnotation.ChemProbAnnotationType) {
            ChemProbAnnotation.ChemProbAnnotationType t = (ChemProbAnnotation.ChemProbAnnotationType)((Object)e.getItem());
            this._an.setType(t);
            this._vp.repaint();
        }
    }
}

