/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurSliderLabel;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VueBPThickness
implements ChangeListener {
    private VARNAPanel _vp;
    ArrayList<ModeleBP> _msbp;
    private JSlider _thicknessSlider;
    private JPanel panel;
    private ArrayList<Double> _backupThicknesses = new ArrayList();
    private double FACTOR = 10.0;

    public VueBPThickness(VARNAPanel vp, ArrayList<ModeleBP> msbp) {
        this._vp = vp;
        this._msbp = msbp;
        this.backupThicknesses();
        this._thicknessSlider = new JSlider(0, 1, 100, (int)(msbp.get(0).getStyle().getThickness(1.0) * this.FACTOR));
        this._thicknessSlider.setMajorTickSpacing(10);
        this._thicknessSlider.setPaintTicks(true);
        this._thicknessSlider.setPaintLabels(false);
        this._thicknessSlider.setPreferredSize(new Dimension(500, 50));
        JLabel thicknessLabel = new JLabel(String.valueOf(msbp.get(0).getStyle().getThickness(1.0)));
        thicknessLabel.setPreferredSize(new Dimension(50, thicknessLabel.getPreferredSize().height));
        this._thicknessSlider.addChangeListener(new ControleurSliderLabel(thicknessLabel, 1.0 / this.FACTOR));
        this._thicknessSlider.addChangeListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0));
        JLabel labelZ = new JLabel("Thickness:");
        this.panel.add(labelZ);
        this.panel.add(this._thicknessSlider);
        this.panel.add(thicknessLabel);
    }

    private void backupThicknesses() {
        int i = 0;
        while (i < this._msbp.size()) {
            this._backupThicknesses.add(this._msbp.get(i).getStyle().getThickness(1.0));
            ++i;
        }
    }

    public void restoreThicknesses() {
        int i = 0;
        while (i < this._msbp.size()) {
            this._msbp.get(i).getStyle().setThickness(this._backupThicknesses.get(i));
            ++i;
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double getThickness() {
        return (double)this._thicknessSlider.getValue() / this.FACTOR;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i = 0;
        while (i < this._msbp.size()) {
            this._msbp.get(i).getStyle().setThickness((double)this._thicknessSlider.getValue() / this.FACTOR);
            ++i;
        }
        this._vp.repaint();
    }
}

