/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ActionEditor;
import fr.orsay.lri.varna.components.ActionRenderer;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class VueBPList
extends JPanel
implements TableModelListener,
ActionListener {
    private JTable table;
    private BPTableModel _tm;
    private VARNAPanel _vp;
    private ArrayList<ModeleBP> data;
    private ArrayList<Double> _backup;
    private ArrayList<Object> columns;

    public VueBPList(VARNAPanel vp) {
        super(new GridLayout(1, 0));
        this._vp = vp;
        this.init();
    }

    private void init() {
        Object[] col = new Object[]{"Sec.Str.", "5' partner", "3' partner", "5' edge", "3' edge", "Orientation", "Remove"};
        this.columns = new ArrayList();
        int i = 0;
        while (i < col.length) {
            this.columns.add(col[i]);
            ++i;
        }
        this._backup = new ArrayList();
        this.data = new ArrayList();
        for (ModeleBP ms : this._vp.getRNA().getAllBPs()) {
            this.data.add(ms);
        }
        Collections.sort(this.data);
        this._tm = new BPTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultRenderer(Actions.class, new ActionRenderer());
        this.table.setDefaultEditor(ModeleBP.Edge.class, new DefaultCellEditor(new JComboBox<ModeleBP.Edge>(ModeleBP.Edge.values())));
        this.table.setDefaultEditor(ModeleBP.Stericity.class, new DefaultCellEditor(new JComboBox<ModeleBP.Stericity>(ModeleBP.Stericity.values())));
        this.table.setDefaultEditor(Actions.class, new ActionEditor(this));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.table.getModel().addTableModelListener(this);
        this.table.setRowHeight(25);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        this.setOpaque(true);
        this.doLayout();
        JOptionPane.showMessageDialog(this._vp, this, "Base pairs Edition", -1);
    }

    public void cancelChanges() {
        int i = 0;
        while (i < this._vp.getRNA().get_listeBases().size()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(i);
            mb.setValue(this._backup.get(i));
            ++i;
        }
        this._vp.getRNA().rescaleColorMap(this._vp.getColorMap());
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            this.table.repaint();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        System.out.println(arg0.toString());
        String[] data2 = arg0.getActionCommand().split("-");
        int row = Integer.parseInt(data2[data2.length - 1]);
        if (data2[0].equals("Delete")) {
            ModeleBP ms = this.data.get(row);
            this._vp.getVARNAUI().UIRemoveBP(ms);
            this.data.remove(row);
            this._tm.fireTableRowsDeleted(row, row);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Actions {
        ACTION_DELETE,
        ACTION_EDIT_STYLE;


        public String toString() {
            switch (this) {
                case ACTION_DELETE: {
                    return "Delete";
                }
                case ACTION_EDIT_STYLE: {
                    return "Edit Style";
                }
            }
            return "N/A";
        }
    }

    private class BPTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private BPTableModel() {
        }

        public String getColumnName(int col) {
            return VueBPList.this.columns.get(col).toString();
        }

        public int getRowCount() {
            return VueBPList.this.data.size();
        }

        public int getColumnCount() {
            return VueBPList.this.columns.size();
        }

        public Object getValueAt(int row, int col) {
            ModeleBP mb = (ModeleBP)VueBPList.this.data.get(row);
            if (col == 0) {
                return new Boolean(mb.getPartner3().getElementStructure() == mb.getPartner5().getIndex());
            }
            if (col == 1) {
                return new String(mb.getPartner5().getBaseNumber() + "-" + mb.getPartner5().getContent());
            }
            if (col == 2) {
                return new String(mb.getPartner3().getBaseNumber() + "-" + mb.getPartner3().getContent());
            }
            if (col == 3) {
                return mb.getEdgePartner5();
            }
            if (col == 4) {
                return mb.getEdgePartner3();
            }
            if (col == 5) {
                return mb.getStericity();
            }
            if (col == 6) {
                return Actions.ACTION_DELETE;
            }
            return "N/A";
        }

        public boolean isCellEditable(int row, int col) {
            return col == 3 || col == 4 || col == 5 || col == 6;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 3 || col == 4 || col == 5) {
                ModeleBP mb = (ModeleBP)VueBPList.this.data.get(row);
                if (col == 3) {
                    mb.setEdge5((ModeleBP.Edge)((Object)value));
                } else if (col == 4) {
                    mb.setEdge3((ModeleBP.Edge)((Object)value));
                } else if (col == 5) {
                    mb.setStericity((ModeleBP.Stericity)((Object)value));
                }
                this.fireTableCellUpdated(row, col);
                VueBPList.this._vp.repaint();
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

