/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

class PrintPanel
extends JPanel
implements Printable {
    PrintPanel() {
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawPage(g2);
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.draw(new Rectangle2D.Double(0.0, 0.0, pf.getImageableWidth(), pf.getImageableHeight()));
        this.drawPage(g2);
        return 0;
    }

    public void drawPage(Graphics2D g2) {
        FontRenderContext context = g2.getFontRenderContext();
        Font f = new Font("Serif", 0, 72);
        GeneralPath clipShape = new GeneralPath();
        TextLayout layout = new TextLayout("Hello", f, context);
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, 72.0);
        Shape outline = layout.getOutline(transform);
        clipShape.append(outline, false);
        layout = new TextLayout("World", f, context);
        transform = AffineTransform.getTranslateInstance(0.0, 144.0);
        outline = layout.getOutline(transform);
        clipShape.append(outline, false);
        g2.draw(clipShape);
        g2.clip(clipShape);
        int NLINES = 50;
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        int i = 0;
        while (i < 50) {
            double x = 2 * this.getWidth() * i / 50;
            double y = 2 * this.getHeight() * (49 - i) / 50;
            Point2D.Double q = new Point2D.Double(x, y);
            g2.draw(new Line2D.Double(p, q));
            ++i;
        }
    }
}

