/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<T>
implements Iterable<Tree<T>> {
    private List<Tree<T>> children;
    private T value;
    private Tree<T> tree = this;

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public void replaceChildrenListBy(List<Tree<T>> children) {
        this.children = children;
    }

    public Tree(Iterable<Tree<T>> children) {
        this();
        for (Tree<T> child : children) {
            this.children.add(child);
        }
    }

    public Tree() {
        this.children = new ArrayList<Tree<T>>();
    }

    public int rootDegree() {
        return this.children.size();
    }

    public int countNodes() {
        int count = 1;
        for (Tree<T> child : this.children) {
            count += child.countNodes();
        }
        return count;
    }

    public int computeDegree() {
        int max = this.children.size();
        for (Tree<T> child : this.children) {
            int maxCandidate = child.computeDegree();
            if (maxCandidate <= max) continue;
            max = maxCandidate;
        }
        return max;
    }

    public String toGraphvizNodeId() {
        return super.toString();
    }

    @Override
    public Iterator<Tree<T>> iterator() {
        return new DFSPrefixIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DFSPrefixIterator
    implements Iterator<Tree<T>> {
        private LinkedList<Tree<T>> remainingNodes = new LinkedList();

        @Override
        public boolean hasNext() {
            return !this.remainingNodes.isEmpty();
        }

        @Override
        public Tree<T> next() {
            if (this.remainingNodes.isEmpty()) {
                throw new NoSuchElementException();
            }
            Tree currentNode = this.remainingNodes.getLast();
            this.remainingNodes.removeLast();
            List children = currentNode.getChildren();
            int n = children.size();
            int i = n - 1;
            while (i >= 0) {
                this.remainingNodes.add(children.get(i));
                --i;
            }
            return currentNode;
        }

        public DFSPrefixIterator() {
            this.remainingNodes.add(Tree.this.tree);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

