/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.ExampleDistance3;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.RNATree;
import fr.orsay.lri.varna.models.treealign.RNATree2Exception;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNATree2 {
    public static Tree<RNANodeValue2> RNATree2FromRNA(RNA rna) throws RNATree2Exception {
        Tree<RNANodeValue> fullTree = RNATree.RNATreeFromRNA(rna);
        return RNATree2.RNATree2FromRNATree(fullTree);
    }

    public static Tree<RNANodeValue2> RNATree2FromRNATree(Tree<RNANodeValue> originalTree) throws RNATree2Exception {
        Tree<RNANodeValue2> newTree = new Tree<RNANodeValue2>();
        newTree.setValue(null);
        newTree.replaceChildrenListBy(RNATree2.RNAForest2FromRNAForest(originalTree.getChildren()));
        return newTree;
    }

    private static void RNAForest2FromRNAForestCommitNonPaired(List<Tree<RNANodeValue2>> forest, List<RNANodeValue> consecutiveNonPairedBases) {
        if (consecutiveNonPairedBases.size() > 0) {
            RNANodeValue2 groupOfConsecutiveBases = new RNANodeValue2(false);
            groupOfConsecutiveBases.getNodes().addAll(consecutiveNonPairedBases);
            Tree<RNANodeValue2> groupOfConsecutiveBasesNode = new Tree<RNANodeValue2>();
            groupOfConsecutiveBasesNode.setValue(groupOfConsecutiveBases);
            forest.add(groupOfConsecutiveBasesNode);
            consecutiveNonPairedBases.clear();
        }
    }

    private static List<Tree<RNANodeValue2>> RNAForest2FromRNAForest(List<Tree<RNANodeValue>> originalForest) throws RNATree2Exception {
        ArrayList<Tree<RNANodeValue2>> forest = new ArrayList<Tree<RNANodeValue2>>();
        LinkedList<RNANodeValue> consecutiveNonPairedBases = new LinkedList<RNANodeValue>();
        for (Tree<RNANodeValue> originalTree : originalForest) {
            Tree<RNANodeValue2> pairedBaseNode;
            RNANodeValue2 pairedBase;
            if (originalTree.getValue().getRightBasePosition() == -1) {
                if (originalTree.getChildren().size() > 0) {
                    throw new RNATree2Exception("Non-paired base cannot have children.");
                }
                switch (originalTree.getValue().getOrigin()) {
                    case BASE_FROM_HELIX_STRAND5: 
                    case BASE_FROM_HELIX_STRAND3: {
                        RNATree2.RNAForest2FromRNAForestCommitNonPaired(forest, consecutiveNonPairedBases);
                        pairedBase = new RNANodeValue2(true);
                        pairedBase.setNode(originalTree.getValue());
                        pairedBaseNode = new Tree();
                        pairedBaseNode.setValue(pairedBase);
                        forest.add(pairedBaseNode);
                        break;
                    }
                    case BASE_FROM_UNPAIRED_REGION: {
                        consecutiveNonPairedBases.add(originalTree.getValue());
                        break;
                    }
                    case BASE_PAIR_FROM_HELIX: {
                        throw new RNATree2Exception("Origin is BASE_PAIR_FROM_HELIX but this is not a pair.");
                    }
                }
                continue;
            }
            RNATree2.RNAForest2FromRNAForestCommitNonPaired(forest, consecutiveNonPairedBases);
            pairedBase = new RNANodeValue2(true);
            pairedBase.setNode(originalTree.getValue());
            pairedBaseNode = new Tree<RNANodeValue2>();
            pairedBaseNode.setValue(pairedBase);
            pairedBaseNode.replaceChildrenListBy(RNATree2.RNAForest2FromRNAForest(originalTree.getChildren()));
            forest.add(pairedBaseNode);
        }
        RNATree2.RNAForest2FromRNAForestCommitNonPaired(forest, consecutiveNonPairedBases);
        return forest;
    }

    public static Mapping mappingFromAlignment(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> alignment) throws MappingException {
        ConvertToMapping converter = new ConvertToMapping();
        return converter.convert(alignment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertToMapping {
        private Mapping m;
        ExampleDistance3 sequenceAligner = new ExampleDistance3();

        private ConvertToMapping() {
        }

        public Mapping convert(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> tree) throws MappingException {
            this.m = new Mapping();
            this.convertSubTree(tree);
            return this.m;
        }

        private void convertSubTree(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> tree) throws MappingException {
            AlignedNode<RNANodeValue2, RNANodeValue2> alignedNode = tree.getValue();
            Tree<RNANodeValue2> leftNode = alignedNode.getLeftNode();
            Tree<RNANodeValue2> rightNode = alignedNode.getRightNode();
            if (leftNode != null && rightNode != null) {
                RNANodeValue2 v1 = leftNode.getValue();
                RNANodeValue2 v2 = rightNode.getValue();
                if (v1.isSingleNode() && v2.isSingleNode()) {
                    RNANodeValue vsn1 = v1.getNode();
                    RNANodeValue vsn2 = v2.getNode();
                    int l1 = vsn1.getLeftBasePosition();
                    int r1 = vsn1.getRightBasePosition();
                    int l2 = vsn2.getLeftBasePosition();
                    int r2 = vsn2.getRightBasePosition();
                    if (l1 >= 0 && l2 >= 0) {
                        this.m.addCouple(l1, l2);
                    }
                    if (r1 >= 0 && r2 >= 0) {
                        this.m.addCouple(r1, r2);
                    }
                } else if (!v1.isSingleNode() && !v2.isSingleNode()) {
                    int[][] sequenceAlignment = this.sequenceAligner.alignSequenceNodes(v1, v2).getAlignment();
                    int l = sequenceAlignment[0].length;
                    int i = 0;
                    while (i < l) {
                        int b1 = sequenceAlignment[0][i];
                        int b2 = sequenceAlignment[1][i];
                        if (b1 != -1 && b2 != -1) {
                            int l1 = v1.getNodes().get(b1).getLeftBasePosition();
                            int l2 = v2.getNodes().get(b2).getLeftBasePosition();
                            this.m.addCouple(l1, l2);
                        }
                        ++i;
                    }
                }
            }
            for (Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> child : tree.getChildren()) {
                this.convertSubTree(child);
            }
        }
    }
}

