/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.GraphvizDrawableNodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2WrongTypeException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNANodeValue2
implements GraphvizDrawableNodeValue {
    private boolean singleNode = true;
    private RNANodeValue node;
    private List<RNANodeValue> nodes;

    public RNANodeValue2(boolean singleNode) {
        this.singleNode = singleNode;
        if (singleNode) {
            this.node = new RNANodeValue();
        } else {
            this.nodes = new ArrayList<RNANodeValue>();
        }
    }

    public RNANodeValue getNode() {
        if (this.singleNode) {
            return this.node;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public void setNode(RNANodeValue node) {
        if (!this.singleNode) {
            throw new RNANodeValue2WrongTypeException();
        }
        this.node = node;
    }

    public List<RNANodeValue> getNodes() {
        if (!this.singleNode) {
            return this.nodes;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public char[] computeSequence() {
        if (!this.singleNode) {
            int n = this.nodes.size();
            char[] sequence = new char[n];
            int i = 0;
            while (i < n) {
                sequence[i] = this.nodes.get(i).getLeftNucleotide().charAt(0);
                ++i;
            }
            return sequence;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public void setNodes(List<RNANodeValue> nodes) {
        if (this.singleNode) {
            throw new RNANodeValue2WrongTypeException();
        }
        this.nodes = nodes;
    }

    public boolean isSingleNode() {
        return this.singleNode;
    }

    public String toString() {
        return this.toGraphvizNodeName();
    }

    @Override
    public String toGraphvizNodeName() {
        if (this.singleNode) {
            return this.node.toGraphvizNodeName();
        }
        String s = "";
        for (RNANodeValue node : this.nodes) {
            if (s != "") {
                s = String.valueOf(s) + " ";
            }
            s = String.valueOf(s) + node.toGraphvizNodeName();
        }
        return s;
    }
}

