/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNANodeValue2TemplateDistance;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import fr.orsay.lri.varna.models.templates.RNATemplateMappingException;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.RNATree2;
import fr.orsay.lri.varna.models.treealign.RNATree2Exception;
import fr.orsay.lri.varna.models.treealign.Tree;
import fr.orsay.lri.varna.models.treealign.TreeAlign;
import fr.orsay.lri.varna.models.treealign.TreeAlignException;
import fr.orsay.lri.varna.models.treealign.TreeAlignResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNATemplateAlign {
    private static boolean canBePartOfAnHelix(RNANodeValue2 leftNodeValue) {
        return leftNodeValue != null && leftNodeValue.isSingleNode() && leftNodeValue.getNode().getRightBasePosition() > 0;
    }

    private static boolean canBePartOfASequence(RNANodeValue2 leftNodeValue) {
        return leftNodeValue != null && !leftNodeValue.isSingleNode();
    }

    private static boolean canBePartOfABrokenHelix(RNANodeValue2 leftNodeValue) {
        return leftNodeValue != null && leftNodeValue.isSingleNode() && leftNodeValue.getNode().getRightBasePosition() < 0;
    }

    public static RNATemplateMapping makeTemplateMapping(TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> alignResult, RNA rna) throws RNATemplateMappingException {
        RNATemplateMapping mapping = new RNATemplateMapping();
        Tree<AlignedNode<RNANodeValue2, RNANodeValueTemplate>> alignment = alignResult.getAlignment();
        mapping.setDistance(alignResult.getDistance());
        RNATemplate.RNATemplateHelix currentHelix = null;
        LinkedList<Tree> remainingNodes = new LinkedList<Tree>();
        LinkedList<RNANodeValue2> nodesInSameHelix = new LinkedList<RNANodeValue2>();
        remainingNodes.add(alignment);
        while (!remainingNodes.isEmpty()) {
            List children;
            int n;
            Tree node = (Tree)remainingNodes.getLast();
            remainingNodes.removeLast();
            Tree leftNode = ((AlignedNode)node.getValue()).getLeftNode();
            Tree rightNode = ((AlignedNode)node.getValue()).getRightNode();
            if (leftNode != null && leftNode.getValue() != null) {
                RNANodeValue2 leftNodeValue = (RNANodeValue2)leftNode.getValue();
                if (rightNode != null && rightNode.getValue() != null) {
                    RNANodeValueTemplate rightNodeValue = (RNANodeValueTemplate)rightNode.getValue();
                    if (rightNodeValue instanceof RNANodeValueTemplateBasePair && RNATemplateAlign.canBePartOfAnHelix(leftNodeValue)) {
                        RNATemplate.RNATemplateHelix helix;
                        currentHelix = helix = ((RNANodeValueTemplateBasePair)rightNodeValue).getHelix();
                        int i = leftNodeValue.getNode().getLeftBasePosition();
                        int j = leftNodeValue.getNode().getRightBasePosition();
                        mapping.addCouple(i, helix);
                        mapping.addCouple(j, helix);
                        if (nodesInSameHelix.size() > 0) {
                            boolean validExtension;
                            int k = Integer.MAX_VALUE;
                            int l = Integer.MIN_VALUE;
                            for (RNANodeValue2 v : nodesInSameHelix) {
                                k = Math.min(k, v.getNode().getLeftBasePosition());
                                l = Math.max(l, v.getNode().getRightBasePosition());
                            }
                            boolean bl = validExtension = k < i && j < l;
                            if (validExtension) {
                                for (RNANodeValue2 v : nodesInSameHelix) {
                                    mapping.addCouple(v.getNode().getLeftBasePosition(), helix);
                                    mapping.addCouple(v.getNode().getRightBasePosition(), helix);
                                }
                            }
                        }
                        nodesInSameHelix.clear();
                    } else if (rightNodeValue instanceof RNANodeValueTemplateSequence && RNATemplateAlign.canBePartOfASequence(leftNodeValue)) {
                        currentHelix = null;
                        nodesInSameHelix.clear();
                        RNATemplate.RNATemplateUnpairedSequence sequence = ((RNANodeValueTemplateSequence)rightNodeValue).getSequence();
                        for (RNANodeValue nodeValue : ((RNANodeValue2)leftNode.getValue()).getNodes()) {
                            mapping.addCouple(nodeValue.getLeftBasePosition(), sequence);
                        }
                    } else {
                        currentHelix = null;
                        nodesInSameHelix.clear();
                    }
                } else if (RNATemplateAlign.canBePartOfAnHelix(leftNodeValue)) {
                    if (currentHelix != null) {
                        boolean validExtension;
                        int i = leftNodeValue.getNode().getLeftBasePosition();
                        int j = leftNodeValue.getNode().getRightBasePosition();
                        int k = Integer.MAX_VALUE;
                        int l = Integer.MIN_VALUE;
                        for (int b : mapping.getAncestor(currentHelix)) {
                            k = Math.min(k, b);
                            l = Math.max(l, b);
                        }
                        boolean bl = validExtension = k < i && j < l;
                        if (validExtension) {
                            mapping.addCouple(i, currentHelix);
                            mapping.addCouple(j, currentHelix);
                        }
                    } else {
                        nodesInSameHelix.add(leftNodeValue);
                    }
                }
            }
            if ((n = (children = node.getChildren()).size()) <= 0) continue;
            int helixChildren = 0;
            ArrayList addToStack1 = new ArrayList();
            ArrayList addToStack2 = new ArrayList();
            int i = 0;
            while (i < n) {
                Tree child = children.get(i);
                Tree RNAchild = ((AlignedNode)child.getValue()).getLeftNode();
                if (RNAchild != null && RNAchild.getValue() != null && (RNATemplateAlign.canBePartOfAnHelix((RNANodeValue2)RNAchild.getValue()) || RNATemplateAlign.canBePartOfABrokenHelix((RNANodeValue2)RNAchild.getValue()))) {
                    ++helixChildren;
                    addToStack2.add(child);
                } else {
                    addToStack1.add(child);
                }
                ++i;
            }
            i = addToStack2.size() - 1;
            while (i >= 0) {
                remainingNodes.add((Tree)addToStack2.get(i));
                --i;
            }
            i = addToStack1.size() - 1;
            while (i >= 0) {
                remainingNodes.add((Tree)addToStack1.get(i));
                --i;
            }
            if (helixChildren < 2) continue;
            currentHelix = null;
            nodesInSameHelix.clear();
        }
        LinkedList remainingNodes2 = new LinkedList();
        remainingNodes2.add(alignment);
        RNATemplateMapping tempPKMapping = new RNATemplateMapping();
        while (!remainingNodes2.isEmpty()) {
            Tree node = (Tree)remainingNodes2.getLast();
            remainingNodes2.removeLast();
            List children = node.getChildren();
            int n = children.size();
            if (n <= 0) continue;
            int i = n - 1;
            while (i >= 0) {
                remainingNodes2.add(children.get(i));
                --i;
            }
            LinkedList<RNANodeValue2> nodesInSameHelix2 = new LinkedList<RNANodeValue2>();
            RNATemplate.RNATemplateHelix currentHelix2 = null;
            for (Tree child : node.getChildren()) {
                Tree leftNode = ((AlignedNode)child.getValue()).getLeftNode();
                Tree rightNode = ((AlignedNode)child.getValue()).getRightNode();
                if (leftNode != null && leftNode.getValue() != null) {
                    RNANodeValue2 leftNodeValue = (RNANodeValue2)leftNode.getValue();
                    if (rightNode != null && rightNode.getValue() != null) {
                        RNANodeValueTemplate rightNodeValue = (RNANodeValueTemplate)rightNode.getValue();
                        if (rightNodeValue instanceof RNANodeValueTemplateBrokenBasePair && RNATemplateAlign.canBePartOfABrokenHelix(leftNodeValue)) {
                            RNATemplate.RNATemplateHelix helix;
                            currentHelix2 = helix = ((RNANodeValueTemplateBrokenBasePair)rightNodeValue).getHelix();
                            tempPKMapping.addCouple(leftNodeValue.getNode().getLeftBasePosition(), helix);
                            for (RNANodeValue2 v : nodesInSameHelix2) {
                                tempPKMapping.addCouple(v.getNode().getLeftBasePosition(), helix);
                            }
                            nodesInSameHelix2.clear();
                            continue;
                        }
                        currentHelix2 = null;
                        nodesInSameHelix2.clear();
                        continue;
                    }
                    if (RNATemplateAlign.canBePartOfABrokenHelix(leftNodeValue)) {
                        if (currentHelix2 != null) {
                            tempPKMapping.addCouple(leftNodeValue.getNode().getLeftBasePosition(), currentHelix2);
                            continue;
                        }
                        nodesInSameHelix2.add(leftNodeValue);
                        continue;
                    }
                    currentHelix2 = null;
                    nodesInSameHelix2.clear();
                    continue;
                }
                currentHelix2 = null;
                nodesInSameHelix2.clear();
            }
        }
        for (RNATemplate.RNATemplateElement element : tempPKMapping.getTargetElemsAsSet()) {
            RNATemplate.RNATemplateHelix helix = (RNATemplate.RNATemplateHelix)element;
            HashSet<Integer> basesInHelix = new HashSet<Integer>(tempPKMapping.getAncestor(helix));
            for (int baseIndex : basesInHelix) {
                System.out.println("PK: " + helix + " aligned with " + baseIndex);
                boolean baseOK = false;
                ArrayList<ModeleBP> auxBasePairs = rna.getAuxBPs(baseIndex);
                for (ModeleBP auxBasePair : auxBasePairs) {
                    int partner5 = ((ModeleBaseNucleotide)auxBasePair.getPartner5()).getIndex();
                    int partner3 = ((ModeleBaseNucleotide)auxBasePair.getPartner3()).getIndex();
                    if (baseIndex == partner5) {
                        if (!basesInHelix.contains(partner3)) continue;
                        baseOK = true;
                        break;
                    }
                    if (baseIndex != partner3 || !basesInHelix.contains(partner5)) continue;
                    baseOK = true;
                    break;
                }
                if (!baseOK) continue;
                mapping.addCouple(baseIndex, helix);
            }
        }
        return mapping;
    }

    public static void printMapping(RNATemplateMapping mapping, RNATemplate template, String sequence) {
        Iterator<RNATemplate.RNATemplateElement> iter = template.rnaIterator();
        while (iter.hasNext()) {
            RNATemplate.RNATemplateElement element = iter.next();
            System.out.println(element.toString());
            ArrayList<Integer> A = mapping.getAncestor(element);
            if (A != null) {
                RNATemplateAlign.printIntArrayList(A);
                int n = A.size();
                int i = 0;
                while (i < n) {
                    System.out.print("\t" + sequence.charAt(A.get(i)));
                    ++i;
                }
                System.out.println("");
                continue;
            }
            System.out.println("\tno match");
        }
    }

    public static TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> alignRNAWithTemplate(RNA rna, RNATemplate template) throws RNATemplateDrawingAlgorithmException {
        try {
            Tree<RNANodeValue2> rnaAsTree = RNATree2.RNATree2FromRNA(rna);
            Tree<RNANodeValueTemplate> templateAsTree = template.toTree();
            TreeAlign<RNANodeValue2, RNANodeValueTemplate> treeAlign = new TreeAlign<RNANodeValue2, RNANodeValueTemplate>(new RNANodeValue2TemplateDistance());
            TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> result = treeAlign.align(rnaAsTree, templateAsTree);
            return result;
        }
        catch (RNATree2Exception e) {
            throw new RNATemplateDrawingAlgorithmException("RNATree2Exception: " + e.getMessage());
        }
        catch (ExceptionInvalidRNATemplate e) {
            throw new RNATemplateDrawingAlgorithmException("ExceptionInvalidRNATemplate: " + e.getMessage());
        }
        catch (TreeAlignException e) {
            throw new RNATemplateDrawingAlgorithmException("TreeAlignException: " + e.getMessage());
        }
    }

    public static RNATemplateMapping mapRNAWithTemplate(RNA rna, RNATemplate template) throws RNATemplateDrawingAlgorithmException {
        try {
            TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> alignResult = RNATemplateAlign.alignRNAWithTemplate(rna, template);
            RNATemplateMapping mapping = RNATemplateAlign.makeTemplateMapping(alignResult, rna);
            return mapping;
        }
        catch (RNATemplateMappingException e) {
            e.printStackTrace();
            throw new RNATemplateDrawingAlgorithmException("RNATemplateMappingException: " + e.getMessage());
        }
    }

    public static void printIntArray(int[] A) {
        int i = 0;
        while (i < A.length) {
            System.out.print("\t" + A[i]);
            ++i;
        }
        System.out.println("");
    }

    public static void printIntArrayList(ArrayList<Integer> A) {
        int i = 0;
        while (i < A.size()) {
            System.out.print("\t" + A.get(i));
            ++i;
        }
        System.out.println("");
    }

    public static void printShortMatrix(short[][] M) {
        System.out.println("Begin matrix");
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M[i].length) {
                System.out.print("\t" + M[i][j]);
                ++j;
            }
            System.out.println("");
            ++i;
        }
        System.out.println("End matrix");
    }

    public static int[] intArrayFromList(List<Integer> l) {
        if (l != null) {
            int n = l.size();
            int[] result = new int[n];
            int i = 0;
            while (i < n) {
                result[i] = l.get(i);
                ++i;
            }
            return result;
        }
        return null;
    }
}

