/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.exceptions.ExceptionEdgeEndpointAlreadyConnected;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionXMLGeneration;
import fr.orsay.lri.varna.exceptions.ExceptionXmlLoading;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.templates.RNATemplateAlign;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNATemplate {
    private Collection<RNATemplateElement> elements = new ArrayList<RNATemplateElement>();
    private final RNATemplate template = this;
    private static int NEXT_ID = 1;

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public RNATemplateElement getFirst() {
        return this.getFirstEndPoint().getElement();
    }

    public RNATemplateElement.EdgeEndPoint getFirstEndPoint() {
        if (this.elements.isEmpty()) {
            return null;
        }
        HashSet<RNATemplateElement.EdgeEndPoint> knownEndPoints = new HashSet<RNATemplateElement.EdgeEndPoint>();
        RNATemplateElement.EdgeEndPoint currentEndPoint = this.getAnyEndPoint();
        while (!knownEndPoints.contains(currentEndPoint)) {
            knownEndPoints.add(currentEndPoint);
            RNATemplateElement.EdgeEndPoint previousEndPoint = currentEndPoint.getPreviousEndPoint();
            if (previousEndPoint == null) {
                return currentEndPoint;
            }
            currentEndPoint = previousEndPoint;
        }
        return currentEndPoint;
    }

    public RNATemplateElement getAny() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.iterator().next();
    }

    public RNATemplateElement.EdgeEndPoint getAnyEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getAny().getIn1EndPoint();
    }

    public Iterator<RNATemplateElement> rnaIterator() {
        return new RNAIterator();
    }

    public Iterator<RNATemplateElement> classicIterator() {
        return this.elements.iterator();
    }

    public Iterator<RNATemplateElement.EdgeEndPoint> vertexIterator() {
        return new VertexIterator();
    }

    public List<RNATemplateElement.EdgeEndPoint> makeEdgeList() {
        MakeEdgeList listMaker = new MakeEdgeList();
        return listMaker.make();
    }

    public boolean connectedComponentIsCyclic(RNATemplateElement.EdgeEndPoint endPoint) {
        HashSet<RNATemplateElement.EdgeEndPoint> knownEndPoints = new HashSet<RNATemplateElement.EdgeEndPoint>();
        RNATemplateElement.EdgeEndPoint currentEndPoint = endPoint;
        while (!knownEndPoints.contains(currentEndPoint)) {
            knownEndPoints.add(currentEndPoint);
            RNATemplateElement.EdgeEndPoint previousEndPoint = currentEndPoint.getPreviousEndPoint();
            if (previousEndPoint == null) {
                return false;
            }
            currentEndPoint = previousEndPoint;
        }
        return true;
    }

    public boolean isConnected() {
        if (this.isEmpty()) {
            return true;
        }
        int n = 0;
        for (RNATemplateElement element : this.elements) {
            if (element instanceof RNATemplateHelix) {
                n += 4;
                continue;
            }
            if (!(element instanceof RNATemplateUnpairedSequence)) continue;
            n += 2;
        }
        HashSet<RNATemplateElement.EdgeEndPoint> knownEndPoints = new HashSet<RNATemplateElement.EdgeEndPoint>();
        RNATemplateElement.EdgeEndPoint currentEndPoint = this.getFirstEndPoint();
        while (!knownEndPoints.contains(currentEndPoint)) {
            knownEndPoints.add(currentEndPoint);
            RNATemplateElement.EdgeEndPoint nextEndPoint = currentEndPoint.getNextEndPoint();
            if (nextEndPoint == null) break;
            currentEndPoint = nextEndPoint;
        }
        return knownEndPoints.size() == n;
    }

    public void checkIsValidTemplate() throws ExceptionInvalidRNATemplate {
        if (this.isEmpty()) {
            throw new ExceptionInvalidRNATemplate("The template is empty.");
        }
        if (!this.isConnected()) {
            throw new ExceptionInvalidRNATemplate("The template is a non-connected graph.");
        }
        if (this.connectedComponentIsCyclic(this.getAnyEndPoint())) {
            throw new ExceptionInvalidRNATemplate("The template is cyclic.");
        }
    }

    public Tree<RNANodeValueTemplate> toTree() throws ExceptionInvalidRNATemplate {
        this.computeIn1Is();
        RemovePseudoKnots pseudoKnotKiller = new RemovePseudoKnots();
        Set<RNATemplateHelix> removedHelixes = pseudoKnotKiller.removePseudoKnots();
        ConvertToTree converter = new ConvertToTree(removedHelixes);
        return converter.convert();
    }

    public RNA toRNA() throws ExceptionInvalidRNATemplate {
        this.checkIsValidTemplate();
        ArrayList<Integer> str = new ArrayList<Integer>();
        HashMap<RNATemplateHelix, ArrayList> helixes = new HashMap<RNATemplateHelix, ArrayList>();
        Iterator<RNATemplateElement> iter = this.rnaIterator();
        while (iter.hasNext()) {
            int n;
            RNATemplateElement element = iter.next();
            if (element instanceof RNATemplateHelix) {
                int i;
                ArrayList helixMembers;
                int firstBase;
                RNATemplateHelix helix = (RNATemplateHelix)element;
                n = helix.getLength();
                if (helixes.containsKey(helix)) {
                    firstBase = str.size();
                    helixMembers = (ArrayList)helixes.get(helix);
                    i = 0;
                    while (i < n) {
                        int indexOfAssociatedBase = (Integer)helixMembers.get(n - 1 - i);
                        str.set(indexOfAssociatedBase, firstBase + i);
                        str.add(indexOfAssociatedBase);
                        ++i;
                    }
                    continue;
                }
                firstBase = str.size();
                helixMembers = new ArrayList();
                i = 0;
                while (i < n) {
                    str.add(-1);
                    helixMembers.add(firstBase + i);
                    ++i;
                }
                helixes.put(helix, helixMembers);
                continue;
            }
            if (element instanceof RNATemplateUnpairedSequence) {
                RNATemplateUnpairedSequence sequence = (RNATemplateUnpairedSequence)element;
                n = sequence.getLength();
                int i = 0;
                while (i < n) {
                    str.add(-1);
                    ++i;
                }
                continue;
            }
            throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
        }
        int[] strAsArray = RNATemplateAlign.intArrayFromList(str);
        Object[] seqAsArray = new String[strAsArray.length];
        Arrays.fill(seqAsArray, " ");
        RNA rna = new RNA();
        try {
            rna.setRNA((String[])seqAsArray, strAsArray);
        }
        catch (ExceptionFileFormatOrSyntax e) {
            throw new RuntimeException("Bug in toRNA(): setRNA() threw an ExceptionFileFormatOrSyntax exception.");
        }
        return rna;
    }

    public void toXMLFile(File file) throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
        try {
            Document xmlDocument = this.toXMLDocument();
            DOMSource source = new DOMSource(xmlDocument);
            StreamResult result = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new ExceptionXMLGeneration("TransformerConfigurationException: " + e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ExceptionXMLGeneration("TransformerFactoryConfigurationError: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new ExceptionXMLGeneration("TransformerException: " + e.getMessage());
        }
    }

    public Document toXMLDocument() throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
        ConvertToXml converter = new ConvertToXml();
        return converter.toXMLDocument();
    }

    public static RNATemplate fromXMLFile(File file) throws ExceptionXmlLoading {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDocument = builder.parse(file);
            return RNATemplate.fromXMLDocument(xmlDocument);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionXmlLoading("ParserConfigurationException: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new ExceptionXmlLoading("SAXException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new ExceptionXmlLoading("IOException: " + e.getMessage());
        }
    }

    public static RNATemplate fromXMLDocument(Document xmlDocument) throws ExceptionXmlLoading {
        RNATemplate template;
        RNATemplate rNATemplate = template = new RNATemplate();
        rNATemplate.getClass();
        LoadFromXml loader = rNATemplate.new LoadFromXml(xmlDocument);
        loader.load();
        return template;
    }

    public void computeIn1Is() throws ExceptionInvalidRNATemplate {
        this.checkIsValidTemplate();
        Iterator<RNATemplateElement.EdgeEndPoint> iter = this.vertexIterator();
        HashSet<RNATemplateHelix> knownHelices = new HashSet<RNATemplateHelix>();
        while (iter.hasNext()) {
            RNATemplateHelix helix;
            RNATemplateElement.EdgeEndPoint endPoint = iter.next();
            RNATemplateElement templateElement = endPoint.getElement();
            if (!(templateElement instanceof RNATemplateHelix) || knownHelices.contains(helix = (RNATemplateHelix)templateElement)) continue;
            switch (endPoint.getPosition()) {
                case IN1: 
                case OUT1: {
                    helix.setIn1Is(In1Is.IN1_IS_5PRIME);
                    break;
                }
                case IN2: 
                case OUT2: {
                    helix.setIn1Is(In1Is.IN1_IS_3PRIME);
                }
            }
            knownHelices.add(helix);
        }
    }

    public boolean removeElement(RNATemplateElement element) throws ExceptionInvalidRNATemplate {
        if (this.elements.contains(element)) {
            element.disconnectFromAny();
            this.elements.remove(element);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertToTree {
        private Set<RNATemplateHelix> removedHelixes;
        private Iterator<RNATemplateElement> iter;
        private Set<RNATemplateHelix> knownHelixes;

        public ConvertToTree(Set<RNATemplateHelix> removedHelixes) {
            this.iter = RNATemplate.this.template.rnaIterator();
            this.knownHelixes = new HashSet<RNATemplateHelix>();
            this.removedHelixes = removedHelixes;
        }

        public Tree<RNANodeValueTemplate> convert() throws ExceptionInvalidRNATemplate {
            Tree<RNANodeValueTemplate> root = new Tree<RNANodeValueTemplate>();
            root.setValue(null);
            this.makeChildren(root);
            return root;
        }

        private void makeChildren(Tree<RNANodeValueTemplate> father) throws ExceptionInvalidRNATemplate {
            List<Tree<RNANodeValueTemplate>> children = father.getChildren();
            try {
                block2: while (true) {
                    RNATemplateElement element;
                    if ((element = this.iter.next()) instanceof RNATemplateHelix) {
                        RNATemplateHelix helix = (RNATemplateHelix)element;
                        if (this.removedHelixes.contains(helix)) {
                            boolean firstPartOfHelix;
                            if (this.knownHelixes.contains(helix)) {
                                firstPartOfHelix = false;
                            } else {
                                this.knownHelixes.add(helix);
                                firstPartOfHelix = true;
                            }
                            int helixLength = helix.getLength();
                            if (helixLength < 1) {
                                throw new ExceptionInvalidRNATemplate("Helix length < 1");
                            }
                            int firstPosition = firstPartOfHelix ? 0 : helixLength;
                            int afterLastPosition = firstPartOfHelix ? helixLength : 2 * helixLength;
                            int i = firstPosition;
                            while (true) {
                                if (i >= afterLastPosition) continue block2;
                                RNANodeValueTemplateBrokenBasePair value = new RNANodeValueTemplateBrokenBasePair();
                                value.setHelix(helix);
                                value.setPositionInHelix(i);
                                Tree<RNANodeValueTemplateBrokenBasePair> child = new Tree<RNANodeValueTemplateBrokenBasePair>();
                                child.setValue(value);
                                father.getChildren().add(child);
                                ++i;
                            }
                        }
                        if (this.knownHelixes.contains(helix)) {
                            if (!(father.getValue() instanceof RNANodeValueTemplateBasePair) || ((RNANodeValueTemplateBasePair)father.getValue()).getHelix() != helix) {
                                throw new ExceptionInvalidRNATemplate("Unexpected helix. Looks like there still are pseudoknots even after we removed them so something is wrong about the template.");
                            }
                            return;
                        }
                        this.knownHelixes.add(helix);
                        int helixLength = helix.getLength();
                        if (helixLength < 1) {
                            throw new ExceptionInvalidRNATemplate("Helix length < 1");
                        }
                        Tree<RNANodeValueTemplate> lastChild = father;
                        int i = 0;
                        while (i < helixLength) {
                            RNANodeValueTemplateBasePair value = new RNANodeValueTemplateBasePair();
                            value.setHelix(helix);
                            value.setPositionInHelix(i);
                            Tree<RNANodeValueTemplateBasePair> child = new Tree<RNANodeValueTemplateBasePair>();
                            child.setValue(value);
                            lastChild.getChildren().add(child);
                            lastChild = child;
                            ++i;
                        }
                        this.makeChildren(lastChild);
                        continue;
                    }
                    if (!(element instanceof RNATemplateUnpairedSequence)) break;
                    RNATemplateUnpairedSequence sequence = (RNATemplateUnpairedSequence)element;
                    int seqLength = sequence.getLength();
                    if (seqLength < 1) {
                        throw new ExceptionInvalidRNATemplate("Non-paired sequence length < 1");
                    }
                    RNANodeValueTemplateSequence value = new RNANodeValueTemplateSequence();
                    value.setSequence(sequence);
                    Tree<RNANodeValueTemplateSequence> child = new Tree<RNANodeValueTemplateSequence>();
                    child.setValue(value);
                    children.add(child);
                }
                throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
            }
            catch (NoSuchElementException e) {
                if (father.getValue() == null) {
                    return;
                }
                throw new ExceptionInvalidRNATemplate("Unexpected end of template endpoint list.");
            }
        }
    }

    private class ConvertToXml {
        private Map<RNATemplateElement, String> elementNames = new HashMap<RNATemplateElement, String>();
        private Element connectionsXmlElement;
        private Document document;

        private ConvertToXml() {
        }

        private void addConnectionIfNecessary(RNATemplateElement.EdgeEndPoint endPoint) {
            if (endPoint != null && endPoint.isConnected()) {
                RNATemplateElement e1 = endPoint.getElement();
                EdgeEndPointPosition p1 = endPoint.getPosition();
                RNATemplateElement e2 = endPoint.getOtherElement();
                EdgeEndPointPosition p2 = endPoint.getOtherEndPoint().getPosition();
                Element xmlElement = this.document.createElement("edge");
                Element fromXmlElement = this.document.createElement("from");
                fromXmlElement.setAttribute("endpoint", this.elementNames.get(e1));
                fromXmlElement.setAttribute("position", p1.toString());
                xmlElement.appendChild(fromXmlElement);
                Element toXmlElement = this.document.createElement("to");
                toXmlElement.setAttribute("endpoint", this.elementNames.get(e2));
                toXmlElement.setAttribute("position", p2.toString());
                xmlElement.appendChild(toXmlElement);
                this.connectionsXmlElement.appendChild(xmlElement);
            }
        }

        public Document toXMLDocument() throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
            try {
                RNATemplateUnpairedSequence sequence;
                RNATemplateHelix helix;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.document = builder.newDocument();
                Element root = this.document.createElement("RNATemplate");
                this.document.appendChild(root);
                Element elementsXmlElement = this.document.createElement("elements");
                root.appendChild(elementsXmlElement);
                this.connectionsXmlElement = this.document.createElement("edges");
                root.appendChild(this.connectionsXmlElement);
                int nextHelix = 1;
                int nextNonPairedSequence = 1;
                for (RNATemplateElement templateElement : RNATemplate.this.elements) {
                    if (templateElement instanceof RNATemplateHelix) {
                        helix = (RNATemplateHelix)templateElement;
                        if (this.elementNames.containsKey(helix)) continue;
                        this.elementNames.put(helix, "H ID " + nextHelix);
                        ++nextHelix;
                        continue;
                    }
                    if (templateElement instanceof RNATemplateUnpairedSequence) {
                        sequence = (RNATemplateUnpairedSequence)templateElement;
                        if (this.elementNames.containsKey(sequence)) continue;
                        this.elementNames.put(sequence, "S ID " + nextNonPairedSequence);
                        ++nextNonPairedSequence;
                        continue;
                    }
                    throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
                }
                for (RNATemplateElement templateElement : RNATemplate.this.elements) {
                    Element xmlElement;
                    String elementXmlName = this.elementNames.get(templateElement);
                    if (templateElement instanceof RNATemplateHelix) {
                        helix = (RNATemplateHelix)templateElement;
                        xmlElement = this.document.createElement("helix");
                        xmlElement.setAttribute("id", elementXmlName);
                        xmlElement.setAttribute("length", Integer.toString(helix.getLength()));
                        xmlElement.setAttribute("flipped", Boolean.toString(helix.isFlipped()));
                        if (helix.hasCaption()) {
                            xmlElement.setAttribute("caption", helix.getCaption());
                        }
                        Element startPositionXmlElement = this.document.createElement("startPosition");
                        startPositionXmlElement.setAttribute("x", Double.toString(helix.getStartPosition().x));
                        startPositionXmlElement.setAttribute("y", Double.toString(helix.getStartPosition().y));
                        xmlElement.appendChild(startPositionXmlElement);
                        Element endPositionXmlElement = this.document.createElement("endPosition");
                        endPositionXmlElement.setAttribute("x", Double.toString(helix.getEndPosition().x));
                        endPositionXmlElement.setAttribute("y", Double.toString(helix.getEndPosition().y));
                        xmlElement.appendChild(endPositionXmlElement);
                        this.addConnectionIfNecessary(helix.getOut1());
                        this.addConnectionIfNecessary(helix.getOut2());
                    } else if (templateElement instanceof RNATemplateUnpairedSequence) {
                        sequence = (RNATemplateUnpairedSequence)templateElement;
                        xmlElement = this.document.createElement("sequence");
                        xmlElement.setAttribute("id", elementXmlName);
                        xmlElement.setAttribute("length", Integer.toString(sequence.getLength()));
                        Element vertex5XmlElement = this.document.createElement("vertex5");
                        vertex5XmlElement.setAttribute("x", Double.toString(sequence.getVertex5().x));
                        vertex5XmlElement.setAttribute("y", Double.toString(sequence.getVertex5().y));
                        xmlElement.appendChild(vertex5XmlElement);
                        Element vertex3XmlElement = this.document.createElement("vertex3");
                        vertex3XmlElement.setAttribute("x", Double.toString(sequence.getVertex3().x));
                        vertex3XmlElement.setAttribute("y", Double.toString(sequence.getVertex3().y));
                        xmlElement.appendChild(vertex3XmlElement);
                        Element inTangentVectorXmlElement = this.document.createElement("inTangentVector");
                        inTangentVectorXmlElement.setAttribute("angle", Double.toString(sequence.getInTangentVectorAngle()));
                        inTangentVectorXmlElement.setAttribute("length", Double.toString(sequence.getInTangentVectorLength()));
                        xmlElement.appendChild(inTangentVectorXmlElement);
                        Element outTangentVectorXmlElement = this.document.createElement("outTangentVector");
                        outTangentVectorXmlElement.setAttribute("angle", Double.toString(sequence.getOutTangentVectorAngle()));
                        outTangentVectorXmlElement.setAttribute("length", Double.toString(sequence.getOutTangentVectorLength()));
                        xmlElement.appendChild(outTangentVectorXmlElement);
                        this.addConnectionIfNecessary(sequence.getOut());
                    } else {
                        throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
                    }
                    elementsXmlElement.appendChild(xmlElement);
                }
                return this.document;
            }
            catch (ParserConfigurationException e) {
                throw new ExceptionXMLGeneration("ParserConfigurationException: " + e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeEndPointPosition {
        IN1,
        IN2,
        OUT1,
        OUT2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum In1Is {
        IN1_IS_5PRIME,
        IN1_IS_3PRIME;

    }

    private class LoadFromXml {
        private Document xmlDocument;
        private Map<String, RNATemplateElement> elementNames = new HashMap<String, RNATemplateElement>();

        public LoadFromXml(Document xmlDocument) {
            this.xmlDocument = xmlDocument;
        }

        private Point2D.Double pointFromXml(Element xmlPoint) {
            Point2D.Double point = new Point2D.Double();
            point.x = Double.parseDouble(xmlPoint.getAttribute("x"));
            point.y = Double.parseDouble(xmlPoint.getAttribute("y"));
            return point;
        }

        private double vectorLengthFromXml(Element xmlVector) {
            return Double.parseDouble(xmlVector.getAttribute("length"));
        }

        private double vectorAngleFromXml(Element xmlVector) {
            return Double.parseDouble(xmlVector.getAttribute("angle"));
        }

        private RNATemplateElement.EdgeEndPoint endPointFromXml(Element xmlEdgeEndPoint) throws ExceptionXmlLoading {
            String elementId = xmlEdgeEndPoint.getAttribute("endpoint");
            if (elementId == null || elementId == "") {
                throw new ExceptionXmlLoading("Missing endpoint attribute on " + xmlEdgeEndPoint);
            }
            String positionOnElement = xmlEdgeEndPoint.getAttribute("position");
            if (positionOnElement == null || positionOnElement == "") {
                throw new ExceptionXmlLoading("Missing position attribute on " + xmlEdgeEndPoint);
            }
            if (this.elementNames.containsKey(elementId)) {
                RNATemplateElement templateElement = this.elementNames.get(elementId);
                EdgeEndPointPosition relativePosition = EdgeEndPointPosition.valueOf(positionOnElement);
                if (relativePosition == null) {
                    throw new ExceptionXmlLoading("Could not compute relativePosition");
                }
                return templateElement.getEndPointFromPosition(relativePosition);
            }
            throw new ExceptionXmlLoading("Edge is connected on unkown element: " + elementId);
        }

        private String connectErrMsg(RNATemplateElement.EdgeEndPoint v1, RNATemplateElement.EdgeEndPoint v2, String reason) {
            return "Error while connecting\n" + v1.toString() + " to\n" + v2.toString() + " because:\n" + reason;
        }

        private void connect(RNATemplateElement.EdgeEndPoint v1, RNATemplateElement.EdgeEndPoint v2) throws ExceptionXmlLoading {
            if (v1 == null || v2 == null) {
                throw new ExceptionXmlLoading("Invalid edge: missing endpoint\n v1 = " + v1 + "\n v2 = " + v2);
            }
            if (v2.isConnected()) {
                throw new ExceptionXmlLoading(this.connectErrMsg(v1, v2, "Second vertex is already connected to " + v2.getOtherElement().toString()));
            }
            if (v1.isConnected()) {
                throw new ExceptionXmlLoading(this.connectErrMsg(v1, v2, "First vertex is already connected to " + v1.getOtherElement().toString()));
            }
            try {
                v1.connectTo(v2);
            }
            catch (ExceptionEdgeEndpointAlreadyConnected e) {
                throw new ExceptionXmlLoading("A vertex is on two edges at the same time: " + e.getMessage());
            }
            catch (ExceptionInvalidRNATemplate e) {
                throw new ExceptionXmlLoading("ExceptionInvalidRNATemplate: " + e.getMessage());
            }
        }

        public void load() throws ExceptionXmlLoading {
            Element xmlElements = (Element)this.xmlDocument.getElementsByTagName("elements").item(0);
            NodeList xmlElementsChildren = xmlElements.getChildNodes();
            int i = 0;
            while (i < xmlElementsChildren.getLength()) {
                Node xmlElementsChild = xmlElementsChildren.item(i);
                if (xmlElementsChild instanceof Element) {
                    int j;
                    Element xmlTemplateElement = (Element)xmlElementsChild;
                    String tagName = xmlTemplateElement.getTagName();
                    if (tagName == "helix") {
                        RNATemplateHelix helix = new RNATemplateHelix(xmlTemplateElement.getAttribute("id"));
                        helix.setFlipped(Boolean.parseBoolean(xmlTemplateElement.getAttribute("flipped")));
                        helix.setLength(Integer.parseInt(xmlTemplateElement.getAttribute("length")));
                        if (xmlTemplateElement.hasAttribute("caption")) {
                            helix.setCaption(xmlTemplateElement.getAttribute("caption"));
                        }
                        this.elementNames.put(xmlTemplateElement.getAttribute("id"), helix);
                        NodeList xmlHelixChildren = xmlTemplateElement.getChildNodes();
                        j = 0;
                        while (j < xmlHelixChildren.getLength()) {
                            Node xmlHelixChild = xmlHelixChildren.item(j);
                            if (xmlHelixChild instanceof Element) {
                                Element xmlHelixChildElement = (Element)xmlHelixChild;
                                String helixChildTagName = xmlHelixChildElement.getTagName();
                                if (helixChildTagName == "startPosition") {
                                    helix.setStartPosition(this.pointFromXml(xmlHelixChildElement));
                                } else if (helixChildTagName == "endPosition") {
                                    helix.setEndPosition(this.pointFromXml(xmlHelixChildElement));
                                }
                            }
                            ++j;
                        }
                    } else if (tagName == "sequence") {
                        RNATemplateUnpairedSequence sequence = new RNATemplateUnpairedSequence(xmlTemplateElement.getAttribute("id"));
                        sequence.setLength(Integer.parseInt(xmlTemplateElement.getAttribute("length")));
                        this.elementNames.put(xmlTemplateElement.getAttribute("id"), sequence);
                        NodeList xmlSequenceChildren = xmlTemplateElement.getChildNodes();
                        j = 0;
                        while (j < xmlSequenceChildren.getLength()) {
                            Node xmlSequenceChild = xmlSequenceChildren.item(j);
                            if (xmlSequenceChild instanceof Element) {
                                Element xmlSequenceChildElement = (Element)xmlSequenceChild;
                                String sequenceChildTagName = xmlSequenceChildElement.getTagName();
                                if (sequenceChildTagName == "inTangentVector") {
                                    sequence.setInTangentVectorLength(this.vectorLengthFromXml(xmlSequenceChildElement));
                                    sequence.setInTangentVectorAngle(this.vectorAngleFromXml(xmlSequenceChildElement));
                                } else if (sequenceChildTagName == "outTangentVector") {
                                    sequence.setOutTangentVectorLength(this.vectorLengthFromXml(xmlSequenceChildElement));
                                    sequence.setOutTangentVectorAngle(this.vectorAngleFromXml(xmlSequenceChildElement));
                                } else if (sequenceChildTagName == "vertex5") {
                                    sequence.setVertex5(this.pointFromXml(xmlSequenceChildElement));
                                } else if (sequenceChildTagName == "vertex3") {
                                    sequence.setVertex3(this.pointFromXml(xmlSequenceChildElement));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            Element xmlEdges = (Element)this.xmlDocument.getElementsByTagName("edges").item(0);
            NodeList xmlEdgesChildren = xmlEdges.getChildNodes();
            int i2 = 0;
            while (i2 < xmlEdgesChildren.getLength()) {
                Element xmlTemplateEdge;
                Node xmlEdgesChild = xmlEdgesChildren.item(i2);
                if (xmlEdgesChild instanceof Element && (xmlTemplateEdge = (Element)xmlEdgesChild).getTagName() == "edge") {
                    RNATemplateElement.EdgeEndPoint v1 = null;
                    RNATemplateElement.EdgeEndPoint v2 = null;
                    NodeList xmlEdgeChildren = xmlTemplateEdge.getChildNodes();
                    int j = 0;
                    while (j < xmlEdgeChildren.getLength()) {
                        Node xmlEdgeChild = xmlEdgeChildren.item(j);
                        if (xmlEdgeChild instanceof Element) {
                            Element xmlEdgeChildElement = (Element)xmlEdgeChild;
                            String edgeChildTagName = xmlEdgeChildElement.getTagName();
                            if (edgeChildTagName == "from") {
                                v1 = this.endPointFromXml(xmlEdgeChildElement);
                            } else if (edgeChildTagName == "to") {
                                v2 = this.endPointFromXml(xmlEdgeChildElement);
                            }
                        }
                        ++j;
                    }
                    if (v1 == null) {
                        throw new ExceptionXmlLoading("Invalid edge: missing \"from\" declaration");
                    }
                    if (v2 == null) {
                        throw new ExceptionXmlLoading("Invalid edge: missing \"to\" declaration");
                    }
                    this.connect(v1, v2);
                }
                ++i2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MakeEdgeList {
        List<RNATemplateElement.EdgeEndPoint> list = new LinkedList<RNATemplateElement.EdgeEndPoint>();

        private MakeEdgeList() {
        }

        private void addEdgeIfNecessary(RNATemplateElement.EdgeEndPoint endPoint) {
            if (endPoint.isConnected()) {
                this.list.add(endPoint);
            }
        }

        public List<RNATemplateElement.EdgeEndPoint> make() {
            for (RNATemplateElement element : RNATemplate.this.elements) {
                if (element instanceof RNATemplateHelix) {
                    RNATemplateHelix helix = (RNATemplateHelix)element;
                    this.addEdgeIfNecessary(helix.getIn1());
                    this.addEdgeIfNecessary(helix.getIn2());
                    continue;
                }
                if (!(element instanceof RNATemplateUnpairedSequence)) continue;
                RNATemplateUnpairedSequence sequence = (RNATemplateUnpairedSequence)element;
                this.addEdgeIfNecessary(sequence.getIn());
            }
            return this.list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RNAIterator
    implements Iterator<RNATemplateElement> {
        private Iterator<RNATemplateElement.EdgeEndPoint> iter;

        private RNAIterator() {
            this.iter = RNATemplate.this.vertexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RNATemplateElement next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            RNATemplateElement.EdgeEndPoint currentEndPoint = this.iter.next();
            switch (currentEndPoint.getPosition()) {
                case IN1: 
                case IN2: {
                    currentEndPoint = this.iter.next();
                }
            }
            return currentEndPoint.getElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public abstract class RNATemplateElement {
        public int _id;
        private final RNATemplateElement element;

        public String getName() {
            return "RNATemplate" + this._id;
        }

        public RNATemplateElement() {
            int n = NEXT_ID;
            NEXT_ID = n + 1;
            this._id = n;
            this.element = this;
            RNATemplate.this.elements.add(this);
        }

        public abstract void disconnectFromAny();

        public abstract EdgeEndPoint getIn1EndPoint();

        public RNATemplate getParentTemplate() {
            return RNATemplate.this.template;
        }

        protected abstract EdgeEndPoint getNextEndPoint(EdgeEndPoint var1);

        protected abstract EdgeEndPoint getPreviousEndPoint(EdgeEndPoint var1);

        public abstract EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition var1);

        public abstract EdgeEndPointPosition getPositionFromEndPoint(EdgeEndPoint var1);

        public void connectTo(EdgeEndPointPosition positionHere, EdgeEndPoint otherEndPoint) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
            EdgeEndPoint endPointHere = this.getEndPointFromPosition(positionHere);
            endPointHere.connectTo(otherEndPoint);
        }

        public void connectTo(EdgeEndPointPosition positionHere, RNATemplateElement otherElement, EdgeEndPointPosition positionOnOtherElement) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
            EdgeEndPoint otherEndPoint = otherElement.getEndPointFromPosition(positionOnOtherElement);
            this.connectTo(positionHere, otherEndPoint);
        }

        public class EdgeEndPoint {
            private EdgeEndPoint otherEndPoint;

            private EdgeEndPoint() {
            }

            public EdgeEndPoint getNextEndPoint() {
                return RNATemplateElement.this.element.getNextEndPoint(this);
            }

            public EdgeEndPoint getPreviousEndPoint() {
                return RNATemplateElement.this.element.getPreviousEndPoint(this);
            }

            public EdgeEndPointPosition getPosition() {
                return RNATemplateElement.this.element.getPositionFromEndPoint(this);
            }

            public RNATemplateElement getElement() {
                return RNATemplateElement.this.element;
            }

            public EdgeEndPoint getOtherEndPoint() {
                return this.otherEndPoint;
            }

            public RNATemplateElement getOtherElement() {
                return this.otherEndPoint != null ? this.otherEndPoint.getElement() : null;
            }

            public void disconnect() {
                if (this.otherEndPoint != null) {
                    this.otherEndPoint.otherEndPoint = null;
                    this.otherEndPoint = null;
                }
            }

            public boolean isConnected() {
                return this.otherEndPoint != null;
            }

            public void connectTo(EdgeEndPoint otherEndPoint) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
                if (this.otherEndPoint != null || otherEndPoint.otherEndPoint != null) {
                    throw new ExceptionEdgeEndpointAlreadyConnected();
                }
                if (RNATemplate.this.template != otherEndPoint.getElement().getParentTemplate()) {
                    throw new ExceptionInvalidRNATemplate("Elements from different templates cannot be connected with each other.");
                }
                this.otherEndPoint = otherEndPoint;
                otherEndPoint.otherEndPoint = this;
            }

            public String toString() {
                return "Edge endpoint on element " + RNATemplateElement.this.element.toString() + " at position " + this.getPosition().toString();
            }
        }
    }

    public class RNATemplateHelix
    extends RNATemplateElement {
        private int length;
        private Point2D.Double startPosition;
        private Point2D.Double endPosition;
        private boolean flipped = false;
        private In1Is in1Is = null;
        private String caption = null;
        private final RNATemplateElement.EdgeEndPoint in1 = new RNATemplateElement.EdgeEndPoint();
        private final RNATemplateElement.EdgeEndPoint out1 = new RNATemplateElement.EdgeEndPoint();
        private final RNATemplateElement.EdgeEndPoint in2 = new RNATemplateElement.EdgeEndPoint();
        private final RNATemplateElement.EdgeEndPoint out2 = new RNATemplateElement.EdgeEndPoint();
        private String _name;

        public boolean isFlipped() {
            return this.flipped;
        }

        public void setFlipped(boolean flipped) {
            this.flipped = flipped;
        }

        public In1Is getIn1Is() {
            return this.in1Is;
        }

        public void setIn1Is(In1Is in1Is) {
            this.in1Is = in1Is;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public boolean hasCaption() {
            return this.caption != null;
        }

        public RNATemplateHelix(String name) {
            this._name = name;
        }

        public String toString() {
            return "Helix    @" + Integer.toHexString(this.hashCode()) + " len=" + this.length + " caption=" + this.caption;
        }

        public String getName() {
            return this._name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public Point2D.Double getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(Point2D.Double startPosition) {
            this.startPosition = startPosition;
        }

        public Point2D.Double getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(Point2D.Double endPosition) {
            this.endPosition = endPosition;
        }

        public RNATemplateElement.EdgeEndPoint getIn1() {
            return this.in1;
        }

        public RNATemplateElement.EdgeEndPoint getOut1() {
            return this.out1;
        }

        public RNATemplateElement.EdgeEndPoint getIn2() {
            return this.in2;
        }

        public RNATemplateElement.EdgeEndPoint getOut2() {
            return this.out2;
        }

        public void disconnectFromAny() {
            this.getIn1().disconnect();
            this.getIn2().disconnect();
            this.getOut1().disconnect();
            this.getOut2().disconnect();
        }

        protected RNATemplateElement.EdgeEndPoint getNextEndPoint(RNATemplateElement.EdgeEndPoint endpoint) {
            if (endpoint == this.in1) {
                return this.out1;
            }
            if (endpoint == this.in2) {
                return this.out2;
            }
            return endpoint.getOtherEndPoint();
        }

        protected RNATemplateElement.EdgeEndPoint getPreviousEndPoint(RNATemplateElement.EdgeEndPoint endpoint) {
            if (endpoint == this.out1) {
                return this.in1;
            }
            if (endpoint == this.out2) {
                return this.in2;
            }
            return endpoint.getOtherEndPoint();
        }

        public RNATemplateElement.EdgeEndPoint getIn1EndPoint() {
            return this.in1;
        }

        public RNATemplateElement.EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition position) {
            switch (position) {
                case IN1: {
                    return this.getIn1();
                }
                case IN2: {
                    return this.getIn2();
                }
                case OUT1: {
                    return this.getOut1();
                }
                case OUT2: {
                    return this.getOut2();
                }
            }
            return null;
        }

        public EdgeEndPointPosition getPositionFromEndPoint(RNATemplateElement.EdgeEndPoint endPoint) {
            if (endPoint == this.in1) {
                return EdgeEndPointPosition.IN1;
            }
            if (endPoint == this.in2) {
                return EdgeEndPointPosition.IN2;
            }
            if (endPoint == this.out1) {
                return EdgeEndPointPosition.OUT1;
            }
            if (endPoint == this.out2) {
                return EdgeEndPointPosition.OUT2;
            }
            return null;
        }
    }

    public class RNATemplateUnpairedSequence
    extends RNATemplateElement {
        private int length;
        private static final double defaultTangentVectorAngle = 1.5707963267948966;
        private static final double defaultTangentVectorLength = 100.0;
        private double inTangentVectorAngle = 1.5707963267948966;
        private double inTangentVectorLength = 100.0;
        private double outTangentVectorAngle = 1.5707963267948966;
        private double outTangentVectorLength = 100.0;
        private Point2D.Double vertex5;
        private Point2D.Double vertex3;
        private final RNATemplateElement.EdgeEndPoint in = new RNATemplateElement.EdgeEndPoint();
        private final RNATemplateElement.EdgeEndPoint out = new RNATemplateElement.EdgeEndPoint();
        private String _name;

        public Point2D.Double getVertex5() {
            return this.vertex5;
        }

        public void setVertex5(Point2D.Double vertex5) {
            this.vertex5 = vertex5;
        }

        public Point2D.Double getVertex3() {
            return this.vertex3;
        }

        public void setVertex3(Point2D.Double vertex3) {
            this.vertex3 = vertex3;
        }

        public RNATemplateUnpairedSequence(String name) {
            this._name = name;
        }

        public String toString() {
            return "Sequence @" + Integer.toHexString(this.hashCode()) + " len=" + this.length;
        }

        public String getName() {
            return this._name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public double getInTangentVectorAngle() {
            return this.inTangentVectorAngle;
        }

        public void setInTangentVectorAngle(double inTangentVectorAngle) {
            this.inTangentVectorAngle = inTangentVectorAngle;
        }

        public double getInTangentVectorLength() {
            return this.inTangentVectorLength;
        }

        public void setInTangentVectorLength(double inTangentVectorLength) {
            this.inTangentVectorLength = inTangentVectorLength;
        }

        public double getOutTangentVectorAngle() {
            return this.outTangentVectorAngle;
        }

        public void setOutTangentVectorAngle(double outTangentVectorAngle) {
            this.outTangentVectorAngle = outTangentVectorAngle;
        }

        public double getOutTangentVectorLength() {
            return this.outTangentVectorLength;
        }

        public void setOutTangentVectorLength(double outTangentVectorLength) {
            this.outTangentVectorLength = outTangentVectorLength;
        }

        public RNATemplateElement.EdgeEndPoint getIn() {
            return this.in;
        }

        public RNATemplateElement.EdgeEndPoint getOut() {
            return this.out;
        }

        public void disconnectFromAny() {
            this.getIn().disconnect();
            this.getOut().disconnect();
        }

        protected RNATemplateElement.EdgeEndPoint getNextEndPoint(RNATemplateElement.EdgeEndPoint endpoint) {
            if (endpoint == this.in) {
                return this.out;
            }
            return endpoint.getOtherEndPoint();
        }

        protected RNATemplateElement.EdgeEndPoint getPreviousEndPoint(RNATemplateElement.EdgeEndPoint endpoint) {
            if (endpoint == this.out) {
                return this.in;
            }
            return endpoint.getOtherEndPoint();
        }

        public RNATemplateElement.EdgeEndPoint getIn1EndPoint() {
            return this.in;
        }

        public RNATemplateElement.EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition position) {
            switch (position) {
                case IN1: {
                    return this.getIn();
                }
                case OUT1: {
                    return this.getOut();
                }
            }
            return null;
        }

        public EdgeEndPointPosition getPositionFromEndPoint(RNATemplateElement.EdgeEndPoint endPoint) {
            if (endPoint == this.in) {
                return EdgeEndPointPosition.IN1;
            }
            if (endPoint == this.out) {
                return EdgeEndPointPosition.OUT1;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemovePseudoKnots {
        private ArrayList<RNATemplateHelix> helixesSeq;
        private ArrayList<Integer> helixesStruct;
        private int[] helixesStructWithoutPseudoKnots;

        private RemovePseudoKnots() {
        }

        private void initArrays() throws ExceptionInvalidRNATemplate {
            this.helixesSeq = new ArrayList();
            this.helixesStruct = new ArrayList();
            Hashtable<RNATemplateHelix, Integer> knownHelixes = new Hashtable<RNATemplateHelix, Integer>();
            Iterator<RNATemplateElement> iter = RNATemplate.this.rnaIterator();
            while (iter.hasNext()) {
                RNATemplateElement element = iter.next();
                if (!(element instanceof RNATemplateHelix)) continue;
                this.helixesSeq.add((RNATemplateHelix)element);
                int index = this.helixesSeq.size() - 1;
                if (knownHelixes.containsKey(element)) {
                    int otherOccurenceIndex = (Integer)knownHelixes.get(element);
                    this.helixesStruct.add(otherOccurenceIndex);
                    if (this.helixesStruct.get(otherOccurenceIndex) != -1) {
                        throw new ExceptionInvalidRNATemplate("We met an helix 3 times. Is there a cycle?");
                    }
                    this.helixesStruct.set(otherOccurenceIndex, index);
                    continue;
                }
                knownHelixes.put((RNATemplateHelix)element, index);
                this.helixesStruct.add(-1);
            }
        }

        private boolean isSelfCrossing() {
            Stack<Point> intervals = new Stack<Point>();
            intervals.add(new Point(0, this.helixesStruct.size() - 1));
            while (!intervals.empty()) {
                Point p = (Point)intervals.pop();
                if (p.x > p.y) continue;
                if (this.helixesStruct.get(p.x) == -1) {
                    intervals.push(new Point(p.x + 1, p.y));
                    continue;
                }
                int i = p.x;
                int j = p.y;
                int k = this.helixesStruct.get(i);
                if (k <= i || k > j) {
                    return true;
                }
                intervals.push(new Point(i + 1, k - 1));
                intervals.push(new Point(k + 1, j));
            }
            return false;
        }

        private void removePseudoKnotsAux() {
            if (!this.isSelfCrossing()) {
                this.helixesStructWithoutPseudoKnots = new int[this.helixesStruct.size()];
                int i = 0;
                while (i < this.helixesStructWithoutPseudoKnots.length) {
                    this.helixesStructWithoutPseudoKnots[i] = this.helixesStruct.get(i);
                    ++i;
                }
            } else {
                int length = this.helixesStruct.size();
                int[] result = new int[length];
                int i = 0;
                while (i < result.length) {
                    result[i] = -1;
                    ++i;
                }
                short[][] tab = new short[length][length];
                short[][] backtrack = new short[length][length];
                int i2 = 0;
                while (i2 < result.length) {
                    backtrack[i2][i2] = -1;
                    ++i2;
                }
                int n = 1;
                while (n < length) {
                    int i3 = 0;
                    while (i3 < length - n) {
                        int j = i3 + n;
                        tab[i3][j] = tab[i3 + 1][j];
                        backtrack[i3][j] = -1;
                        int k = this.helixesStruct.get(i3);
                        assert (k != -1);
                        if (k <= j && i3 < k) {
                            int tmp = this.helixesSeq.get(i3).getLength();
                            if (i3 + 1 <= k - 1) {
                                tmp += tab[i3 + 1][k - 1];
                            }
                            if (k + 1 <= j) {
                                tmp += tab[k + 1][j];
                            }
                            if (tmp > tab[i3][j]) {
                                tab[i3][j] = (short)tmp;
                                backtrack[i3][j] = (short)k;
                            }
                        }
                        ++i3;
                    }
                    ++n;
                }
                Stack<Point> intervals = new Stack<Point>();
                intervals.add(new Point(0, length - 1));
                while (!intervals.empty()) {
                    int k;
                    Point p = (Point)intervals.pop();
                    if (p.x > p.y) continue;
                    if (backtrack[p.x][p.y] == -1) {
                        result[p.x] = -1;
                        intervals.push(new Point(p.x + 1, p.y));
                        continue;
                    }
                    int i4 = p.x;
                    int j = p.y;
                    result[i4] = k = backtrack[i4][j];
                    result[k] = i4;
                    intervals.push(new Point(i4 + 1, k - 1));
                    intervals.push(new Point(k + 1, j));
                }
                this.helixesStructWithoutPseudoKnots = result;
            }
        }

        private Set<RNATemplateHelix> makeSet() {
            HashSet<RNATemplateHelix> removedHelixes = new HashSet<RNATemplateHelix>();
            int i = 0;
            while (i < this.helixesStructWithoutPseudoKnots.length) {
                if (this.helixesStructWithoutPseudoKnots[i] < 0) {
                    removedHelixes.add(this.helixesSeq.get(i));
                }
                ++i;
            }
            return removedHelixes;
        }

        public Set<RNATemplateHelix> removePseudoKnots() throws ExceptionInvalidRNATemplate {
            this.initArrays();
            this.removePseudoKnotsAux();
            return this.makeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertexIterator
    implements Iterator<RNATemplateElement.EdgeEndPoint> {
        private RNATemplateElement.EdgeEndPoint endpoint;

        private VertexIterator() {
            this.endpoint = RNATemplate.this.getFirstEndPoint();
        }

        @Override
        public boolean hasNext() {
            return this.endpoint != null;
        }

        @Override
        public RNATemplateElement.EdgeEndPoint next() {
            if (this.endpoint == null) {
                throw new NoSuchElementException();
            }
            RNATemplateElement.EdgeEndPoint currentEndPoint = this.endpoint;
            this.endpoint = currentEndPoint.getNextEndPoint();
            return currentEndPoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

