/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Point;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAMLParser
extends DefaultHandler {
    private Hashtable<String, RNATmp> _molecules = new Hashtable();
    private boolean _inSequenceIDs = false;
    private boolean _inLength;
    private boolean _inSequence = false;
    private boolean _inHelix = false;
    private boolean _inStrAnnotation = false;
    private boolean _inBP = false;
    private boolean _inBP5 = false;
    private boolean _inBP3 = false;
    private boolean _inEdge5 = false;
    private boolean _inEdge3 = false;
    private boolean _inPosition = false;
    private boolean _inBondOrientation = false;
    private boolean _inMolecule = false;
    private StringBuffer _buffer;
    private String _currentModel = "";
    private int _id5;
    private int _id3;
    private int _length;
    String _edge5;
    String _edge3;
    String _orientation;
    String _helixID;

    public InputSource createSourceFromURL(String path) {
        URL url = null;
        try {
            url = new URL(path);
            URLConnection connexion = url.openConnection();
            connexion.setUseCaches(false);
            InputStream r = connexion.getInputStream();
            InputStreamReader inr = new InputStreamReader(r);
            return new InputSource(inr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new InputSource(new StringReader(""));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("numbering-table")) {
            this._inSequenceIDs = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("helix")) {
            this._inHelix = true;
            this._buffer = new StringBuffer();
            this._helixID = attributes.getValue("id");
        } else if (qName.equals("seq-data")) {
            this._inSequence = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("length")) {
            this._inLength = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("str-annotation")) {
            this._inStrAnnotation = true;
        } else if (qName.equals("base-pair")) {
            this._inBP = true;
        } else if (qName.equals("base-id-5p")) {
            if (this._inBP || this._inHelix) {
                this._inBP5 = true;
            }
        } else if (qName.equals("base-id-3p")) {
            if (this._inBP || this._inHelix) {
                this._inBP3 = true;
            }
        } else if (qName.equals("edge-5p")) {
            this._inEdge5 = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("edge-3p")) {
            this._inEdge3 = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("position")) {
            this._inPosition = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("bond-orientation")) {
            this._inBondOrientation = true;
            this._buffer = new StringBuffer();
        } else if (qName.equals("molecule")) {
            this._inMolecule = true;
            String id = attributes.getValue("id");
            System.err.println("Molecule#" + id);
            this._molecules.put(id, new RNATmp());
            this._currentModel = id;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("numbering-table")) {
            this._inSequenceIDs = false;
            String content = this._buffer.toString();
            content = content.trim();
            String[] tokens = content.split("\\s+");
            Vector<Integer> results = new Vector<Integer>();
            int i = 0;
            while (i < tokens.length) {
                try {
                    results.add(new Integer(Integer.parseInt(tokens[i])));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this._molecules.get((Object)this._currentModel)._sequenceIDs = results;
            this._buffer = null;
        } else if (qName.equals("seq-data")) {
            this._inSequence = false;
            String content = this._buffer.toString();
            content = content.trim();
            String[] tokens = content.split("\\s+");
            ArrayList<String> results = new ArrayList<String>();
            int i = 0;
            while (i < tokens.length) {
                int j = 0;
                while (j < tokens[i].length()) {
                    results.add("" + tokens[i].charAt(j));
                    ++j;
                }
                ++i;
            }
            System.err.println("  Seq: " + results);
            this._molecules.get((Object)this._currentModel)._sequence = results;
            this._buffer = null;
        } else if (qName.equals("bond-orientation")) {
            this._inBondOrientation = false;
            String content = this._buffer.toString();
            this._orientation = content = content.trim();
            this._buffer = null;
        } else if (qName.equals("str-annotation")) {
            this._inStrAnnotation = false;
        } else if (qName.equals("base-pair")) {
            if (this._inMolecule) {
                this._inBP = false;
                BPTemp bp = new BPTemp(this._id5, this._id3, this._edge5, this._edge3, this._orientation);
                this._molecules.get((Object)this._currentModel)._structure.add(bp);
                System.err.println("  " + bp);
            }
        } else if (qName.equals("helix")) {
            this._inHelix = false;
            if (this._inMolecule) {
                HelixTemp h = new HelixTemp(this._id5, this._id3, this._length, this._helixID);
                this._molecules.get((Object)this._currentModel)._helices.add(h);
            }
        } else if (qName.equals("base-id-5p")) {
            this._inBP5 = false;
        } else if (qName.equals("base-id-3p")) {
            this._inBP3 = false;
        } else if (qName.equals("length")) {
            this._inLength = false;
            String content = this._buffer.toString();
            content = content.trim();
            this._length = Integer.parseInt(content);
            this._buffer = null;
        } else if (qName.equals("position")) {
            String content = this._buffer.toString();
            content = content.trim();
            int pos = Integer.parseInt(content);
            if (this._inBP5) {
                this._id5 = pos;
            }
            if (this._inBP3) {
                this._id3 = pos;
            }
            this._buffer = null;
        } else if (qName.equals("edge-5p")) {
            this._inEdge5 = false;
            String content = this._buffer.toString();
            this._edge5 = content = content.trim();
            this._buffer = null;
        } else if (qName.equals("edge-3p")) {
            this._inEdge3 = false;
            String content = this._buffer.toString();
            this._edge3 = content = content.trim();
            this._buffer = null;
        } else if (qName.equals("molecule")) {
            this._inMolecule = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String lecture = new String(ch, start, length);
        if (this._buffer != null) {
            this._buffer.append(lecture);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.postProcess();
    }

    private void discardStacking() {
        Vector<BPTemp> result = new Vector<BPTemp>();
        int i = 0;
        while (i < this._molecules.get((Object)this._currentModel)._structure.size()) {
            BPTemp bp = this._molecules.get((Object)this._currentModel)._structure.get(i);
            if (bp.orientation.equals("c") || bp.orientation.equals("t")) {
                result.add(bp);
            }
            ++i;
        }
        this._molecules.get((Object)this._currentModel)._structure = result;
    }

    public static boolean isSelfCrossing(int[] str) {
        Stack<Point> intervals = new Stack<Point>();
        intervals.add(new Point(0, str.length - 1));
        while (!intervals.empty()) {
            Point p = (Point)intervals.pop();
            if (p.x > p.y) continue;
            if (str[p.x] == -1) {
                intervals.push(new Point(p.x + 1, p.y));
                continue;
            }
            int i = p.x;
            int j = p.y;
            int k = str[i];
            if (k <= i || k > j) {
                return true;
            }
            intervals.push(new Point(i + 1, k - 1));
            intervals.push(new Point(k + 1, j));
        }
        return false;
    }

    private void debugPrintArray(Object[] str) {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        while (i < str.length) {
            if (i != 0) {
                s.append(",");
            }
            s.append(str[i]);
            ++i;
        }
        s.append("]");
        System.out.println(s.toString());
    }

    public static int[] planarize(int[] str) {
        if (!RNAMLParser.isSelfCrossing(str)) {
            return str;
        }
        int length = str.length;
        int[] result = new int[length];
        int i = 0;
        while (i < result.length) {
            result[i] = -1;
            ++i;
        }
        short[][] tab = new short[length][length];
        short[][] backtrack = new short[length][length];
        int theta = 3;
        int i2 = 0;
        while (i2 < result.length) {
            int j = i2;
            while (j < Math.min(i2 + theta, result.length)) {
                tab[i2][j] = 0;
                backtrack[i2][j] = -1;
                ++j;
            }
            ++i2;
        }
        int n = theta;
        while (n < length) {
            int i3 = 0;
            while (i3 < length - n) {
                int j = i3 + n;
                tab[i3][j] = tab[i3 + 1][j];
                backtrack[i3][j] = -1;
                int k = str[i3];
                if (k != -1 && k <= j && i3 < k) {
                    int tmp = 1;
                    if (i3 + 1 <= k - 1) {
                        tmp += tab[i3 + 1][k - 1];
                    }
                    if (k + 1 <= j) {
                        tmp += tab[k + 1][j];
                    }
                    if (tmp > tab[i3][j]) {
                        tab[i3][j] = (short)tmp;
                        backtrack[i3][j] = (short)k;
                    }
                }
                ++i3;
            }
            ++n;
        }
        Stack<Point> intervals = new Stack<Point>();
        intervals.add(new Point(0, length - 1));
        while (!intervals.empty()) {
            int k;
            Point p = (Point)intervals.pop();
            if (p.x > p.y) continue;
            if (backtrack[p.x][p.y] == -1) {
                result[p.x] = -1;
                intervals.push(new Point(p.x + 1, p.y));
                continue;
            }
            int i4 = p.x;
            int j = p.y;
            result[i4] = k = backtrack[p.x][p.y];
            result[k] = i4;
            intervals.push(new Point(i4 + 1, k - 1));
            intervals.push(new Point(k + 1, j));
        }
        return result;
    }

    public static void planarize(ArrayList<ModeleBP> input, ArrayList<ModeleBP> planar, ArrayList<ModeleBP> others, int length) {
        int k;
        ModeleBP mb;
        ArrayList vi;
        Hashtable index2BPs = new Hashtable();
        for (ModeleBP msbp : input) {
            int i = msbp.getPartner5().getIndex();
            if (!index2BPs.containsKey(i)) {
                index2BPs.put(i, new ArrayList());
            }
            ((ArrayList)index2BPs.get(i)).add(msbp);
        }
        short[][] tab = new short[length][length];
        short[][] backtrack = new short[length][length];
        int theta = 3;
        int i = 0;
        while (i < length) {
            int j = i;
            while (j < Math.min(i + theta, length)) {
                tab[i][j] = 0;
                backtrack[i][j] = -1;
                ++j;
            }
            ++i;
        }
        int n = theta;
        while (n < length) {
            int i2 = 0;
            while (i2 < length - n) {
                int j = i2 + n;
                tab[i2][j] = tab[i2 + 1][j];
                backtrack[i2][j] = -1;
                if (index2BPs.containsKey(i2)) {
                    vi = (ArrayList)index2BPs.get(i2);
                    int numBP = 0;
                    while (numBP < vi.size()) {
                        mb = (ModeleBP)vi.get(numBP);
                        k = mb.getPartner3().getIndex();
                        if (k != -1 && k <= j && i2 < k) {
                            int tmp = 1;
                            if (i2 + 1 <= k - 1) {
                                tmp += tab[i2 + 1][k - 1];
                            }
                            if (k + 1 <= j) {
                                tmp += tab[k + 1][j];
                            }
                            if (tmp > tab[i2][j]) {
                                tab[i2][j] = (short)tmp;
                                backtrack[i2][j] = (short)numBP;
                            }
                        }
                        ++numBP;
                    }
                }
                ++i2;
            }
            ++n;
        }
        Stack<Point> intervals = new Stack<Point>();
        intervals.add(new Point(0, length - 1));
        while (!intervals.empty()) {
            Point p = (Point)intervals.pop();
            if (p.x > p.y) continue;
            if (backtrack[p.x][p.y] == -1) {
                intervals.push(new Point(p.x + 1, p.y));
                continue;
            }
            int i3 = p.x;
            int j = p.y;
            short nb = backtrack[p.x][p.y];
            mb = (ModeleBP)((ArrayList)index2BPs.get(i3)).get(nb);
            k = mb.getPartner3().getIndex();
            planar.add(mb);
            intervals.push(new Point(i3 + 1, k - 1));
            intervals.push(new Point(k + 1, j));
        }
        Iterator iterator = index2BPs.keySet().iterator();
        while (iterator.hasNext()) {
            int i4 = (Integer)iterator.next();
            vi = (ArrayList)index2BPs.get(i4);
            for (ModeleBP mb2 : vi) {
                if (planar.contains(mb2)) continue;
                others.add(mb2);
            }
        }
    }

    private void postProcess() {
        for (RNATmp r : this._molecules.values()) {
            int i;
            if (r._sequenceIDs.size() == 0) {
                Vector<Integer> results = new Vector<Integer>();
                i = 0;
                while (i < r._sequence.size()) {
                    results.add(new Integer(i + 1));
                    ++i;
                }
                r._sequenceIDs = results;
            }
            Hashtable<Integer, Integer> ID2Index = new Hashtable<Integer, Integer>();
            i = 0;
            while (i < r._sequenceIDs.size()) {
                ID2Index.put(r._sequenceIDs.get(i), i);
                ++i;
            }
            for (BPTemp bp : r._structure) {
                --bp.pos3;
                --bp.pos5;
            }
            this.discardStacking();
            System.err.println("  Discard stacking (length=" + r._sequence.size() + ") => " + r._structure);
            i = 0;
            while (i < r._helices.size()) {
                HelixTemp h = r._helices.get(i);
                int j = 0;
                while (j < h.length) {
                    int a = h.pos5 + j - 1;
                    int b = h.pos3 - j - 1;
                    BPTemp bp = new BPTemp(a, b, "+", "+", "c");
                    r._structure.add(bp);
                    ++j;
                }
                ++i;
            }
            Hashtable index2BPs = new Hashtable();
            for (BPTemp msbp : r._structure) {
                int i2 = msbp.pos5;
                if (!index2BPs.containsKey(i2)) {
                    index2BPs.put(i2, new ArrayList());
                }
                if (((ArrayList)index2BPs.get(i2)).contains(msbp.pos3)) continue;
                ((ArrayList)index2BPs.get(i2)).add(msbp);
            }
            Vector<BPTemp> newStructure = new Vector<BPTemp>();
            Iterator iterator = index2BPs.keySet().iterator();
            while (iterator.hasNext()) {
                int i3 = (Integer)iterator.next();
                for (BPTemp bp : (ArrayList)index2BPs.get(i3)) {
                    newStructure.add(bp);
                }
            }
            r._structure = newStructure;
        }
    }

    public ArrayList<RNATmp> getMolecules() {
        return new ArrayList<RNATmp>(this._molecules.values());
    }

    public class BPTemp {
        public int pos5;
        public int pos3;
        public String edge5;
        public String edge3;
        public String orientation;

        public BPTemp(int pos5, int pos3, String edge5, String edge3, String orientation) {
            if (edge3 == null) {
                edge3 = "+";
            }
            if (edge5 == null) {
                edge5 = "+";
            }
            if (orientation == null) {
                orientation = "c";
            }
            this.pos5 = pos5;
            this.pos3 = pos3;
            this.edge5 = edge5;
            this.edge3 = edge3;
            this.orientation = orientation;
        }

        public ModeleBP createBPStyle(ModeleBase mb5, ModeleBase mb3) {
            boolean isCanonical = false;
            ModeleBP.Edge e5 = this.edge5.equals("W") ? ModeleBP.Edge.WATSON_CRICK : (this.edge5.equals("H") ? ModeleBP.Edge.HOOGSTEEN : (this.edge5.equals("S") ? ModeleBP.Edge.SUGAR : ModeleBP.Edge.WATSON_CRICK));
            ModeleBP.Edge e3 = this.edge3.equals("W") ? ModeleBP.Edge.WATSON_CRICK : (this.edge3.equals("H") ? ModeleBP.Edge.HOOGSTEEN : (this.edge3.equals("S") ? ModeleBP.Edge.SUGAR : ModeleBP.Edge.WATSON_CRICK));
            if (this.edge5.equals("+") && this.edge3.equals("+") || this.edge5.equals("-") && this.edge3.equals("-")) {
                e3 = ModeleBP.Edge.WATSON_CRICK;
                e5 = ModeleBP.Edge.WATSON_CRICK;
            }
            ModeleBP.Stericity ster = this.orientation.equals("c") ? ModeleBP.Stericity.CIS : (this.orientation.equals("t") ? ModeleBP.Stericity.TRANS : ModeleBP.Stericity.CIS);
            return new ModeleBP(mb5, mb3, e5, e3, ster);
        }

        public String toString() {
            return "[" + this.pos5 + "," + this.pos3 + "," + this.edge5 + "," + this.edge3 + "," + this.orientation + "]";
        }
    }

    public class HelixTemp {
        public int pos5;
        public int pos3;
        public int length;
        public String name;

        public HelixTemp(int pos5, int pos3, int length, String name) {
            this.pos3 = pos3;
            this.pos5 = pos5;
            this.length = length;
            this.name = name;
        }

        public String toString() {
            return "[" + this.name + "," + this.pos5 + "," + this.pos3 + "," + this.length + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RNATmp {
        public ArrayList<String> _sequence = new ArrayList();
        public Vector<Integer> _sequenceIDs = new Vector();
        public Vector<BPTemp> _structure = new Vector();
        public Vector<HelixTemp> _helices = new Vector();

        public ArrayList<String> getSequence() {
            return this._sequence;
        }

        public Vector<BPTemp> getStructure() {
            return this._structure;
        }
    }
}

