/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAObservable;
import fr.orsay.lri.varna.models.CubicBezierCurve;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.export.PSExport;
import fr.orsay.lri.varna.models.export.SVGExport;
import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import fr.orsay.lri.varna.models.export.XFIGExport;
import fr.orsay.lri.varna.models.naView.NAView;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.ModeleStyleBase;
import fr.orsay.lri.varna.models.rna.Motif;
import fr.orsay.lri.varna.models.rna.RNAMLParser;
import fr.orsay.lri.varna.models.rna.StructureTemp;
import fr.orsay.lri.varna.models.rna.VARNASecDraw;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateAlign;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import fr.orsay.lri.varna.models.treealign.Tree;
import fr.orsay.lri.varna.views.VueUI;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNA
extends InterfaceVARNAObservable
implements Serializable {
    private static final long serialVersionUID = 7541274455751497303L;
    public static final int DRAW_MODE_CIRCULAR = 1;
    public static final int DRAW_MODE_RADIATE = 2;
    public static final int DRAW_MODE_NAVIEW = 3;
    public static final int DRAW_MODE_LINEAR = 4;
    public static final int DRAW_MODE_VARNA_VIEW = 5;
    public static final int DRAW_MODE_MOTIFVIEW = 6;
    public static final int DRAW_MODE_TEMPLATE = 7;
    public static final int DEFAULT_DRAW_MODE = 2;
    private Double _spaceBetweenBases = 1.0;
    private int _drawMode = 2;
    public int BASE_RADIUS = 10;
    public static final double LOOP_DISTANCE = 40.0;
    public static final double BASE_PAIR_DISTANCE = 65.0;
    public static final double MULTILOOP_DISTANCE = 35.0;
    public static final double VIRTUAL_LOOP_RADIUS = 40.0;
    public double CHEM_PROB_DIST = 14.0;
    public double CHEM_PROB_BASE_LENGTH = 30.0;
    public double CHEM_PROB_ARROW_HEIGHT = 10.0;
    public double CHEM_PROB_ARROW_WIDTH = 5.0;
    public double CHEM_PROB_TRIANGLE_WIDTH = 2.5;
    public double CHEM_PROB_PIN_SEMIDIAG = 6.0;
    public double CHEM_PROB_DOT_RADIUS = 6.0;
    public GeneralPath _debugShape = null;
    private boolean _drawn = false;
    public double _bpHeightIncrement = 0.65;
    protected ArrayList<ModeleBase> _listeBases;
    StructureTemp _listStrands = new StructureTemp();
    private ArrayList<ModeleBP> _structureAux = new ArrayList();
    private transient ArrayList<InterfaceVARNAListener> _listeVARNAListener = new ArrayList();
    static ArrayList<String> _normalBases = new ArrayList();
    private ArrayList<TextAnnotation> _listeAnnotations;
    private ArrayList<HighlightRegionAnnotation> _listeRegionHighlights;
    private String _name;
    public static double CHEM_PROB_ARROW_THICKNESS = 2.0;
    private boolean _strandEndsAnnotated;
    private ArrayList<ChemProbAnnotation> _ChemProbAnnotations;

    public RNA() {
        this("");
    }

    public RNA(String n) {
        _normalBases.add("a");
        _normalBases.add("c");
        _normalBases.add("g");
        _normalBases.add("u");
        _normalBases.add("t");
        this._listeAnnotations = new ArrayList();
        this._listeRegionHighlights = new ArrayList();
        this._name = "";
        this._strandEndsAnnotated = false;
        this._ChemProbAnnotations = new ArrayList();
        this._name = n;
        this._listeBases = new ArrayList();
        this._drawn = false;
        this.init();
    }

    public String toString() {
        if (this._name.equals("")) {
            return this.getStructDBN();
        }
        return this._name;
    }

    public RNA(RNA r) {
        _normalBases.add("a");
        _normalBases.add("c");
        _normalBases.add("g");
        _normalBases.add("u");
        _normalBases.add("t");
        this._listeAnnotations = new ArrayList();
        this._listeRegionHighlights = new ArrayList();
        this._name = "";
        this._strandEndsAnnotated = false;
        this._ChemProbAnnotations = new ArrayList();
        this._spaceBetweenBases = r._spaceBetweenBases;
        this._drawMode = r._drawMode;
        this._listeBases.addAll(r._listeBases);
        this._listeVARNAListener = r._listeVARNAListener;
        this._drawn = r._drawn;
        this.init();
    }

    public void init() {
    }

    public void saveRNADBN(String path, String title) throws ExceptionWritingForbidden {
        try {
            FileWriter out = new FileWriter(path);
            if (!title.equals("")) {
                out.write("> " + title + "\n");
            }
            out.write(this.getListeBasesToString());
            out.write(10);
            String str = "";
            int i = 0;
            while (i < this._listeBases.size()) {
                str = this._listeBases.get(i).getElementStructure() == -1 ? String.valueOf(str) + '.' : (this._listeBases.get(i).getElementStructure() > i ? String.valueOf(str) + '(' : String.valueOf(str) + ')');
                ++i;
            }
            out.write(str);
            out.write(10);
            out.close();
        }
        catch (IOException e) {
            throw new ExceptionWritingForbidden(e.getMessage());
        }
    }

    public Color getBaseInnerColor(int i, VARNAConfig conf) {
        Color result = this._listeBases.get(i).getStyleBase().get_base_inner_color();
        String res = this._listeBases.get(i).getContent();
        if (conf._drawColorMap) {
            result = conf._cm.getColorForValue(this._listeBases.get(i).getValue());
        } else if (conf._colorDashBases && res.contains("-")) {
            result = conf._dashBasesColor;
        } else if (conf._colorSpecialBases && !_normalBases.contains(res.toLowerCase())) {
            result = conf._specialBasesColor;
        }
        return result;
    }

    public Color getBaseOuterColor(int i, VARNAConfig conf) {
        Color result = this._listeBases.get(i).getStyleBase().get_base_outline_color();
        return result;
    }

    public Color getBaseNameColor(int i, VARNAConfig conf) {
        Color result = this._listeBases.get(i).getStyleBase().get_base_name_color();
        return result;
    }

    public Color getBasePairColor(ModeleBP bp, VARNAConfig conf) {
        Color bondColor = conf._bondColor;
        if (conf._useBaseColorsForBPs) {
            bondColor = this._listeBases.get(bp.getPartner5().getIndex()).getStyleBase().get_base_inner_color();
        }
        if (bp != null) {
            bondColor = bp.getStyle().getColor(bondColor);
        }
        return bondColor;
    }

    public double getBasePairThickness(ModeleBP bp, VARNAConfig conf) {
        double thickness = bp.getStyle().getThickness(conf._bpThickness);
        return thickness;
    }

    private void drawSymbol(SecStrDrawingProducer out, double posx, double posy, double normx, double normy, double radius, boolean isCIS, ModeleBP.Edge e, double thickness) {
        Color bck = out.getCurrentColor();
        switch (e) {
            case WATSON_CRICK: {
                if (isCIS) {
                    out.fillCircle(posx, posy, radius / 2.0, thickness, bck);
                    break;
                }
                out.drawCircle(posx, posy, radius / 2.0, thickness);
                out.fillCircle(posx, posy, radius / 2.0, thickness, Color.white);
                break;
            }
            case HOOGSTEEN: {
                double[] xtab = new double[4];
                double[] ytab = new double[4];
                xtab[0] = posx - radius * normx / 2.0 - radius * normy / 2.0;
                ytab[0] = posy - radius * normy / 2.0 + radius * normx / 2.0;
                xtab[1] = posx + radius * normx / 2.0 - radius * normy / 2.0;
                ytab[1] = posy + radius * normy / 2.0 + radius * normx / 2.0;
                xtab[2] = posx + radius * normx / 2.0 + radius * normy / 2.0;
                ytab[2] = posy + radius * normy / 2.0 - radius * normx / 2.0;
                xtab[3] = posx - radius * normx / 2.0 + radius * normy / 2.0;
                ytab[3] = posy - radius * normy / 2.0 - radius * normx / 2.0;
                if (isCIS) {
                    out.fillPolygon(xtab, ytab, bck);
                    break;
                }
                out.drawPolygon(xtab, ytab, thickness);
                out.fillPolygon(xtab, ytab, Color.white);
                break;
            }
            case SUGAR: {
                double ix = radius * normx / 2.0;
                double iy = radius * normy / 2.0;
                double jx = radius * normy / 2.0;
                double jy = -radius * normx / 2.0;
                double[] xtab = new double[3];
                double[] ytab = new double[3];
                xtab[0] = posx - ix + jx;
                ytab[0] = posy - iy + jy;
                xtab[1] = posx + ix + jx;
                ytab[1] = posy + iy + jy;
                xtab[2] = posx - jx;
                ytab[2] = posy - jy;
                if (isCIS) {
                    out.fillPolygon(xtab, ytab, bck);
                    break;
                }
                out.drawPolygon(xtab, ytab, thickness);
                out.fillPolygon(xtab, ytab, Color.white);
            }
        }
    }

    private void drawBasePair(SecStrDrawingProducer out, Point2D.Double orig, Point2D.Double dest, ModeleBP style, VARNAConfig conf) {
        double dx = dest.x - orig.x;
        double dy = dest.y - orig.y;
        double dist = Math.sqrt((dest.x - orig.x) * (dest.x - orig.x) + (dest.y - orig.y) * (dest.y - orig.y));
        double nx = -(dy /= dist);
        double ny = dx /= dist;
        orig = new Point2D.Double(orig.x + (double)this.BASE_RADIUS * dx, orig.y + (double)this.BASE_RADIUS * dy);
        dest = new Point2D.Double(dest.x - (double)this.BASE_RADIUS * dx, dest.y - (double)this.BASE_RADIUS * dy);
        if (conf._mainBPStyle == VARNAConfig.BP_STYLE.BP_STYLE_LW) {
            double thickness = this.getBasePairThickness(style, conf);
            double radiusCircle = (65.0 - (double)this.BASE_RADIUS) / 5.0;
            if (style.isCanonical()) {
                if (style.isCanonicalGC()) {
                    if (orig.x != dest.x || orig.y != dest.y) {
                        out.drawLine(orig.x + (nx *= (double)this.BASE_RADIUS / 4.0), orig.y + (ny *= (double)this.BASE_RADIUS / 4.0), dest.x + nx, dest.y + ny, conf._bpThickness);
                        out.drawLine(orig.x - nx, orig.y - ny, dest.x - nx, dest.y - ny, conf._bpThickness);
                    }
                } else if (!style.isWobbleUG()) {
                    double cx = (dest.x + orig.x) / 2.0;
                    double cy = (dest.y + orig.y) / 2.0;
                    out.drawLine(orig.x, orig.y, dest.x, dest.y, conf._bpThickness);
                    this.drawSymbol(out, cx, cy, nx, ny, radiusCircle, style.isCIS(), style.getEdgePartner5(), thickness);
                } else {
                    out.drawLine(orig.x, orig.y, dest.x, dest.y, conf._bpThickness);
                }
            } else {
                ModeleBP.Edge p1 = style.getEdgePartner5();
                ModeleBP.Edge p2 = style.getEdgePartner3();
                double cx = (dest.x + orig.x) / 2.0;
                double cy = (dest.y + orig.y) / 2.0;
                out.drawLine(orig.x, orig.y, dest.x, dest.y, conf._bpThickness);
                if (p1 == p2) {
                    this.drawSymbol(out, cx, cy, nx, ny, radiusCircle, style.isCIS(), p1, thickness);
                } else {
                    double vdx = dest.x - orig.x;
                    double vdy = dest.y - orig.y;
                    this.drawSymbol(out, cx + (vdx /= 6.0), cy + (vdy /= 6.0), nx, ny, radiusCircle, style.isCIS(), p2, thickness);
                    this.drawSymbol(out, cx - vdx, cy - vdy, nx, ny, radiusCircle, style.isCIS(), p1, thickness);
                }
            }
        } else if (conf._mainBPStyle == VARNAConfig.BP_STYLE.BP_STYLE_RNAVIZ) {
            double xcenter = (orig.x + dest.x) / 2.0;
            double ycenter = (orig.y + dest.y) / 2.0;
            out.fillCircle(xcenter, ycenter, 3.0 * conf._bpThickness, conf._bpThickness, out.getCurrentColor());
        } else {
            VARNAConfig.BP_STYLE cfr_ignored_0 = conf._mainBPStyle;
        }
    }

    private void drawColorMap(VARNAConfig _conf, SecStrDrawingProducer out) {
        double v1 = _conf._cm.getMinValue();
        double v2 = _conf._cm.getMaxValue();
        double xSpaceAvail = 0.0;
        double ySpaceAvail = 0.0;
        double thickness = 1.0;
        Rectangle2D.Double currentBBox = out.getBoundingBox();
        double xBase = currentBBox.getMaxX() - _conf._colorMapWidth - _conf._colorMapXOffset;
        double yBase = currentBBox.getMinY() - _conf._colorMapHeight - (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        int i = 0;
        while ((double)i < _conf._colorMapWidth) {
            double ratio = (double)i / (_conf._colorMapWidth - 1.0);
            double val = v1 + (v2 - v1) * ratio;
            Color c = _conf._cm.getColorForValue(val);
            int x = (int)(xBase + (double)i);
            int y = (int)yBase;
            out.fillRectangle(x, y, VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH, _conf._colorMapHeight, c);
            ++i;
        }
        out.setColor(VARNAConfig.DEFAULT_COLOR_MAP_OUTLINE);
        out.drawRectangle(xBase, yBase, _conf._colorMapWidth + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH - 1.0, _conf._colorMapHeight, thickness);
        out.setColor(VARNAConfig.DEFAULT_COLOR_MAP_FONT_COLOR);
        out.setFont(out.getCurrentFont(), (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.5);
        out.drawText(xBase, yBase + _conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, "" + _conf._cm.getMinValue());
        out.drawText(xBase + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + _conf._colorMapWidth, yBase + _conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, "" + _conf._cm.getMaxValue());
        out.drawText(xBase + ((double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + _conf._colorMapWidth) / 2.0, yBase - (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, _conf._colorMapCaption);
    }

    private void renderRegionHighlights(SecStrDrawingProducer out, Point2D.Double[] realCoords, Point2D.Double[] realCenters) {
        for (HighlightRegionAnnotation r : this._listeRegionHighlights) {
            GeneralPath s = r.getShape(realCoords, realCenters, 1.0);
            out.setColor(r.getFillColor());
            out.fillPolygon(s, r.getFillColor());
            out.setColor(r.getOutlineColor());
            out.drawPolygon(s, 1.0);
        }
    }

    private void saveRNA(String path, VARNAConfig conf, double scale, SecStrDrawingProducer out) throws ExceptionWritingForbidden {
        int i;
        double norm;
        double dy;
        double dx;
        double y1;
        double x1;
        double y0;
        double x0;
        out.setScale(scale);
        double EPSMargin = 40.0;
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        int i2 = 0;
        while (i2 < this._listeBases.size()) {
            minX = Math.min(minX, this._listeBases.get(i2).getCoords().getX() - (double)this.BASE_RADIUS - EPSMargin);
            minY = Math.min(minY, -(this._listeBases.get(i2).getCoords().getY() - (double)this.BASE_RADIUS - EPSMargin));
            maxX = Math.max(maxX, this._listeBases.get(i2).getCoords().getX() + (double)this.BASE_RADIUS + EPSMargin);
            maxY = Math.max(maxY, -(this._listeBases.get(i2).getCoords().getY() + (double)this.BASE_RADIUS + EPSMargin));
            ++i2;
        }
        Point2D.Double[] coords = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] centers = new Point2D.Double[this._listeBases.size()];
        int i3 = 0;
        while (i3 < this._listeBases.size()) {
            double xp = this._listeBases.get(i3).getCoords().getX() - minX;
            double yp = -(this._listeBases.get(i3).getCoords().getY() - minY);
            coords[i3] = new Point2D.Double(xp, yp);
            Point2D.Double centerBck = this.getCenter(i3);
            if ((this.get_drawMode() == 3 || this.get_drawMode() == 2) && this._listeBases.get(i3).getElementStructure() != -1 && i3 < this._listeBases.size() - 1 && i3 > 1) {
                int j2;
                ModeleBase b1 = this.get_listeBases().get(i3 - 1);
                ModeleBase b2 = this.get_listeBases().get(i3 + 1);
                int j1 = b1.getElementStructure();
                if (j1 == -1 ^ (j2 = b2.getElementStructure()) == -1) {
                    Point2D.Double a1 = b1.getCoords();
                    Point2D.Double a2 = b2.getCoords();
                    Point2D.Double c1 = b1.getCenter();
                    Point2D.Double c2 = b2.getCenter();
                    centerBck.x = this._listeBases.get((int)i3).getCoords().x + (c1.x - a1.x) / c1.distance(a1) + (c2.x - a2.x) / c2.distance(a2);
                    centerBck.y = this._listeBases.get((int)i3).getCoords().y + (c1.y - a1.y) / c1.distance(a1) + (c2.y - a2.y) / c2.distance(a2);
                }
            }
            double xc = centerBck.getX() - minX;
            double yc = -(centerBck.getY() - minY);
            centers[i3] = new Point2D.Double(xc, yc);
            ++i3;
        }
        if (conf._drawBackground) {
            out.setBackgroundColor(conf._backgroundColor);
        }
        this.renderRegionHighlights(out, coords, centers);
        out.setColor(conf._backboneColor);
        i3 = 1;
        while (i3 < this._listeBases.size()) {
            boolean consecutive;
            Point2D.Double p1 = coords[i3 - 1];
            Point2D.Double p2 = coords[i3];
            x0 = p1.x;
            y0 = p1.y;
            x1 = p2.x;
            y1 = p2.y;
            Point2D.Double vn = new Point2D.Double();
            double dist = p1.distance(p2);
            boolean discontinuous = this.getBaseNumber(i3) - this.getBaseNumber(i3 - 1) != 1;
            int a = this._listeBases.get(i3 - 1).getElementStructure();
            int b = this._listeBases.get(i3).getElementStructure();
            boolean bl = consecutive = a == i3 && b == i3 - 1;
            if (dist > 0.0) {
                vn.x = (x1 - x0) / dist;
                vn.y = (y1 - y0) / dist;
                if (consecutive && this.getDrawMode() != 4 && this.getDrawMode() != 1) {
                    int dir = 0;
                    if (i3 + 1 < coords.length) {
                        dir = this.testDirectionality(i3 - 1, i3, i3 + 1) ? -1 : 1;
                    } else if (i3 - 2 >= 0) {
                        dir = this.testDirectionality(i3 - 2, i3 - 1, i3) ? -1 : 1;
                    }
                    Point2D.Double centerSeg = new Point2D.Double((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
                    double centerDist = 40.0 * scale;
                    Point2D.Double centerLoop = new Point2D.Double(centerSeg.x + centerDist * (double)dir * vn.y, centerSeg.y - centerDist * (double)dir * vn.x);
                    out.drawLine(centerLoop.x - 5.0, centerLoop.y, centerLoop.x + 5.0, centerLoop.y, 2.0);
                    out.drawLine(centerLoop.x, centerLoop.y - 5.0, centerLoop.x, centerLoop.y + 5.0, 2.0);
                    double radius = centerLoop.distance(p1);
                    double a1 = 360.0 * Math.atan2((double)dir * (p1.x - centerLoop.x), (double)dir * (p1.y - centerLoop.y)) / (Math.PI * 2);
                    double a2 = 360.0 * Math.atan2((double)dir * (centerLoop.x - p2.x), (double)dir * (centerLoop.y - p2.y)) / (Math.PI * 2);
                    if (a1 < 0.0) {
                        a1 += 360.0;
                    }
                    if (a2 < 0.0) {
                        a2 += 360.0;
                    }
                    double angle = a2 - a1;
                    if ((double)dir * (a2 - a1) < 0.0) {
                        angle += (double)dir * 360.0;
                    }
                    out.drawArc(centerLoop, 2.0 * radius, 2.0 * radius, a1, angle);
                } else {
                    out.drawLine(x0 + (double)this.BASE_RADIUS * vn.x, y0 + (double)this.BASE_RADIUS * vn.y, x1 - (double)this.BASE_RADIUS * vn.x, y1 - (double)this.BASE_RADIUS * vn.y, 1.0);
                }
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this._listeBases.size()) {
            ModeleBP style;
            if (this._listeBases.get(i3).getElementStructure() > i3 && ((style = this._listeBases.get(i3).getStyleBP()).isCanonical() || conf._drawnNonCanonicalBP)) {
                Color bpcol = this.getBasePairColor(style, conf);
                out.setColor(bpcol);
                int j = this._listeBases.get(i3).getElementStructure();
                x0 = coords[i3].x;
                y0 = coords[i3].y;
                x1 = coords[j].x;
                y1 = coords[j].y;
                dx = x1 - x0;
                dy = y1 - y0;
                norm = Math.sqrt(dx * dx + dy * dy);
                dx /= norm;
                dy /= norm;
                if (this._drawMode == 1 || this._drawMode == 2 || this._drawMode == 3) {
                    this.drawBasePair(out, new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), style, conf);
                } else if (this._drawMode == 4) {
                    double coef = j - i3 == 1 ? this._bpHeightIncrement * 2.0 : this._bpHeightIncrement * 1.0;
                    double distance = (int)Math.round(x1 - x0);
                    out.drawArc(new Point2D.Double(x0, y0), distance, distance * coef, 0.0, 180.0);
                }
            }
            ++i3;
        }
        if (conf._drawnNonPlanarBP) {
            i3 = 0;
            while (i3 < this._structureAux.size()) {
                ModeleBP bp = this._structureAux.get(i3);
                out.setColor(this.getBasePairColor(bp, conf));
                int a = bp.getPartner5().getIndex();
                int b = bp.getPartner3().getIndex();
                if (bp.isCanonical() || conf._drawnNonCanonicalBP) {
                    x0 = coords[a].x;
                    y0 = coords[a].y;
                    x1 = coords[b].x;
                    y1 = coords[b].y;
                    dx = x1 - x0;
                    dy = y1 - y0;
                    norm = Math.sqrt(dx * dx + dy * dy);
                    dx /= norm;
                    dy /= norm;
                    if (this._drawMode == 1 || this._drawMode == 2 || this._drawMode == 3) {
                        this.drawBasePair(out, new Point2D.Double(x0, y0), new Point2D.Double(x1, y1), bp, conf);
                    } else if (this._drawMode == 4) {
                        double coef = b - a == 1 ? this._bpHeightIncrement * 2.0 : this._bpHeightIncrement * 1.0;
                        double distance = (int)Math.round(x1 - x0);
                        out.drawArc(new Point2D.Double(x0, y0), distance, distance * coef, 0.0, 180.0);
                    }
                }
                ++i3;
            }
        }
        double baseFontSize = 1.5 * (double)this.BASE_RADIUS;
        out.setFont(18, baseFontSize);
        if (conf._comparisonMode) {
            i = 0;
            while (i < this._listeBases.size()) {
                x0 = coords[i].x;
                y0 = coords[i].y;
                out.fillCircle(x0, y0, this.BASE_RADIUS, 1.0, this.getBaseInnerColor(i, conf));
                out.setColor(this.getBaseOuterColor(i, conf));
                out.drawCircle(x0, y0, this.BASE_RADIUS, 1.0);
                out.setColor(this.getBaseNameColor(i, conf));
                out.drawText(x0, y0, ((ModeleBasesComparison)this._listeBases.get(i)).getBases());
                ++i;
            }
        } else {
            i = 0;
            while (i < this._listeBases.size()) {
                ModeleBase mb = this._listeBases.get(i);
                x0 = coords[i].x;
                y0 = coords[i].y;
                if (conf._fillBase) {
                    out.fillCircle(x0, y0, this.BASE_RADIUS, 1.0, this.getBaseInnerColor(i, conf));
                }
                if (conf._drawOutlineBase) {
                    out.setColor(this.getBaseOuterColor(i, conf));
                    out.drawCircle(x0, y0, this.BASE_RADIUS, 1.0);
                }
                out.setColor(this.getBaseNameColor(i, conf));
                out.drawText(x0, y0, this._listeBases.get(i).getContent());
                ++i;
            }
        }
        double numFontSize = 1.5 * (double)this.BASE_RADIUS;
        out.setFont(18, numFontSize);
        int i4 = 0;
        while (i4 < this._listeBases.size()) {
            int basenum = this._listeBases.get(i4).getBaseNumber();
            if (basenum == -1) {
                basenum = i4 + 1;
            }
            if (this.isNumberDrawn(this._listeBases.get(i4), conf._numPeriod)) {
                out.setColor(this._listeBases.get(i4).getStyleBase().get_base_number_color());
                x0 = coords[i4].x;
                y0 = coords[i4].y;
                x1 = centers[i4].x;
                y1 = centers[i4].y;
                dx = x1 - x0;
                dy = y1 - y0;
                norm = Math.sqrt(dx * dx + dy * dy);
                out.drawLine(x0 - 1.5 * (double)this.BASE_RADIUS * (dx /= norm), y0 - 1.5 * (double)this.BASE_RADIUS * (dy /= norm), x0 - 2.5 * (double)this.BASE_RADIUS * dx, y0 - 2.5 * (double)this.BASE_RADIUS * dy, 1.0);
                out.drawText(x0 - (conf._distNumbers + 1.0) * (double)this.BASE_RADIUS * dx, y0 - (conf._distNumbers + 1.0) * (double)this.BASE_RADIUS * dy, "" + basenum);
            }
            ++i4;
        }
        this.renderAnnotations(out, minX, minY, conf);
        if (conf._drawColorMap) {
            this.drawColorMap(conf, out);
        }
        Rectangle2D.Double currentBBox = out.getBoundingBox();
        double titleFontSize = 2.0 * (double)conf._titleFont.getSize();
        out.setColor(conf._titleColor);
        out.setFont(16, titleFontSize);
        double yTitle = currentBBox.y - titleFontSize / 2.0;
        if (!this.getName().equals("")) {
            out.drawText((maxX - minX) / 2.0, yTitle, this.getName());
        } else if (!conf._title.equals("")) {
            out.drawText((maxX - minX) / 2.0, yTitle, this.getName());
        }
        try {
            OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            fout.write(out.export());
            fout.close();
        }
        catch (IOException e) {
            throw new ExceptionWritingForbidden(e.getMessage());
        }
    }

    Point2D.Double buildCaptionPosition(ModeleBase mb, double heightEstimate, VARNAConfig conf) {
        double radius = 2.0;
        if (this.isNumberDrawn(mb, conf._numPeriod)) {
            radius += conf._distNumbers + 1.0;
        }
        Point2D.Double center = mb.getCenter();
        Point2D.Double p = mb.getCoords();
        double realDistance = (double)this.BASE_RADIUS * radius + heightEstimate;
        return new Point2D.Double(center.getX() + (p.getX() - center.getX()) * ((p.distance(center) + realDistance) / p.distance(center)), center.getY() + (p.getY() - center.getY()) * ((p.distance(center) + realDistance) / p.distance(center)));
    }

    public double getBPHeightIncrement() {
        return this._bpHeightIncrement;
    }

    public void setBPHeightIncrement(double d) {
        this._bpHeightIncrement = d;
    }

    private void drawChemProbAnnotation(SecStrDrawingProducer out, ChemProbAnnotation cpa, Point2D.Double anchor, double minX, double minY) {
        out.setColor(cpa.getColor());
        Point2D.Double v = cpa.getDirVector();
        Point2D.Double vn = cpa.getNormalVector();
        Point2D.Double base = new Point2D.Double(anchor.x + this.CHEM_PROB_DIST * v.x, anchor.y + this.CHEM_PROB_DIST * v.y);
        Point2D.Double edge = new Point2D.Double(base.x + this.CHEM_PROB_BASE_LENGTH * cpa.getIntensity() * v.x, base.y + this.CHEM_PROB_BASE_LENGTH * cpa.getIntensity() * v.y);
        double thickness = CHEM_PROB_ARROW_THICKNESS * cpa.getIntensity();
        switch (cpa.getType()) {
            case ARROW_TYPE: {
                Point2D.Double arrowTip1 = new Point2D.Double(base.x + cpa.getIntensity() * (this.CHEM_PROB_ARROW_WIDTH * vn.x + this.CHEM_PROB_ARROW_HEIGHT * v.x), base.y + cpa.getIntensity() * (this.CHEM_PROB_ARROW_WIDTH * vn.y + this.CHEM_PROB_ARROW_HEIGHT * v.y));
                Point2D.Double arrowTip2 = new Point2D.Double(base.x + cpa.getIntensity() * (-this.CHEM_PROB_ARROW_WIDTH * vn.x + this.CHEM_PROB_ARROW_HEIGHT * v.x), base.y + cpa.getIntensity() * (-this.CHEM_PROB_ARROW_WIDTH * vn.y + this.CHEM_PROB_ARROW_HEIGHT * v.y));
                out.drawLine(base.x - minX, minY - base.y, edge.x - minX, minY - edge.y, thickness);
                out.drawLine(base.x - minX, minY - base.y, arrowTip1.x - minX, minY - arrowTip1.y, thickness);
                out.drawLine(base.x - minX, minY - base.y, arrowTip2.x - minX, minY - arrowTip2.y, thickness);
                break;
            }
            case PIN_TYPE: {
                Point2D.Double side1 = new Point2D.Double(edge.x - cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * v.x), edge.y - cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * v.y));
                Point2D.Double side2 = new Point2D.Double(edge.x - cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * vn.x), edge.y - cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * vn.y));
                Point2D.Double side3 = new Point2D.Double(edge.x + cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * v.x), edge.y + cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * v.y));
                Point2D.Double side4 = new Point2D.Double(edge.x + cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * vn.x), edge.y + cpa.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * vn.y));
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)(side1.x - minX), (float)(minY - side1.y));
                p2.lineTo((float)(side2.x - minX), (float)(minY - side2.y));
                p2.lineTo((float)(side3.x - minX), (float)(minY - side3.y));
                p2.lineTo((float)(side4.x - minX), (float)(minY - side4.y));
                p2.closePath();
                out.fillPolygon(p2, cpa.getColor());
                out.drawLine(base.x - minX, minY - base.y, edge.x - minX, minY - edge.y, thickness);
                break;
            }
            case TRIANGLE_TYPE: {
                Point2D.Double arrowTip1 = new Point2D.Double(edge.x + cpa.getIntensity() * (this.CHEM_PROB_TRIANGLE_WIDTH * vn.x), edge.y + cpa.getIntensity() * (this.CHEM_PROB_TRIANGLE_WIDTH * vn.y));
                Point2D.Double arrowTip2 = new Point2D.Double(edge.x + cpa.getIntensity() * (-this.CHEM_PROB_TRIANGLE_WIDTH * vn.x), edge.y + cpa.getIntensity() * (-this.CHEM_PROB_TRIANGLE_WIDTH * vn.y));
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)(base.x - minX), (float)(minY - base.y));
                p2.lineTo((float)(arrowTip1.x - minX), (float)(minY - arrowTip1.y));
                p2.lineTo((float)(arrowTip2.x - minX), (float)(minY - arrowTip2.y));
                p2.closePath();
                out.fillPolygon(p2, cpa.getColor());
                break;
            }
            case DOT_TYPE: {
                Double radius = this.CHEM_PROB_DOT_RADIUS * cpa.getIntensity();
                Point2D.Double center = new Point2D.Double(base.x + radius * v.x - minX, minY - (base.y + radius * v.y));
                out.fillCircle(center.x, center.y, radius, thickness, cpa.getColor());
            }
        }
    }

    private void renderAnnotations(SecStrDrawingProducer out, double minX, double minY, VARNAConfig conf) {
        for (TextAnnotation textAnnotation : this.getAnnotations()) {
            out.setColor(textAnnotation.getColor());
            out.setFont(18, 2.0 * (double)textAnnotation.getFont().getSize());
            Point2D.Double position = textAnnotation.getCenterPosition();
            if (textAnnotation.getType() == 1) {
                ModeleBase mb = (ModeleBase)textAnnotation.getAncrage();
                double fontHeight = Math.ceil(textAnnotation.getFont().getSize());
                position = this.buildCaptionPosition(mb, fontHeight, conf);
            }
            out.drawText(position.x - minX, -(position.y - minY), textAnnotation.getTexte());
        }
        for (ChemProbAnnotation cpa : this.getChemProbAnnotations()) {
            Point2D.Double anchor = cpa.getAnchorPosition();
            this.drawChemProbAnnotation(out, cpa, anchor, minX, minY);
        }
    }

    public boolean isNumberDrawn(ModeleBase mb, int numPeriod) {
        if (numPeriod <= 0) {
            return false;
        }
        return mb.getIndex() == 0 || mb.getBaseNumber() % numPeriod == 0 || mb.getIndex() == this.get_listeBases().size() - 1;
    }

    public void saveRNAEPS(String path, VARNAConfig conf) throws ExceptionWritingForbidden {
        PSExport out = new PSExport();
        this.saveRNA(path, conf, 0.4, out);
    }

    public void saveRNAXFIG(String path, VARNAConfig conf) throws ExceptionWritingForbidden {
        XFIGExport out = new XFIGExport();
        this.saveRNA(path, conf, 20.0, out);
    }

    public void saveRNASVG(String path, VARNAConfig conf) throws ExceptionWritingForbidden {
        SVGExport out = new SVGExport();
        this.saveRNA(path, conf, 0.5, out);
    }

    public Rectangle2D.Double getBBox() {
        Rectangle2D.Double result = new Rectangle2D.Double(10.0, 10.0, 10.0, 10.0);
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        int i = 0;
        while (i < this._listeBases.size()) {
            minx = Math.min(this._listeBases.get(i).getCoords().getX() - (double)this.BASE_RADIUS, minx);
            miny = Math.min(this._listeBases.get(i).getCoords().getY() - (double)this.BASE_RADIUS, miny);
            maxx = Math.max(this._listeBases.get(i).getCoords().getX() + (double)this.BASE_RADIUS, maxx);
            maxy = Math.max(this._listeBases.get(i).getCoords().getY() + (double)this.BASE_RADIUS, maxy);
            ++i;
        }
        result.x = minx;
        result.y = miny;
        result.width = Math.max(maxx - minx, 1.0);
        result.height = Math.max(maxy - miny, 1.0);
        if (this._drawMode == 4) {
            double realHeight = this._bpHeightIncrement * result.width / 2.0;
            result.height += realHeight;
            result.y -= realHeight;
        }
        return result;
    }

    public void setCoord(int index, Point2D.Double p) {
        this.setCoord(index, p.x, p.y);
    }

    public void setCoord(int index, double x, double y) {
        if (index < this._listeBases.size()) {
            this._listeBases.get(index).setCoords(new Point2D.Double(x, y));
        }
    }

    public Point2D.Double getCoords(int i) {
        if (i < this._listeBases.size() && i >= 0) {
            return this._listeBases.get(i).getCoords();
        }
        return new Point2D.Double();
    }

    public String getBaseContent(int i) {
        if (i >= 0 && i < this._listeBases.size()) {
            return this._listeBases.get(i).getContent();
        }
        return "";
    }

    public int getBaseNumber(int i) {
        if (i >= 0 && i < this._listeBases.size()) {
            return this._listeBases.get(i).getBaseNumber();
        }
        return -1;
    }

    public Point2D.Double getCenter(int i) {
        if (i < this._listeBases.size()) {
            return this._listeBases.get(i).getCenter();
        }
        return new Point2D.Double();
    }

    public void setCenter(int i, double x, double y) {
        this.setCenter(i, new Point2D.Double(x, y));
    }

    public void setCenter(int i, Point2D.Double p) {
        if (i < this._listeBases.size()) {
            this._listeBases.get(i).setCenter(p);
        }
    }

    public void drawRNACircle() {
        this._drawn = true;
        this._drawMode = 1;
        int radius = (int)((double)(3 * (this._listeBases.size() + 1) * this.BASE_RADIUS) / (Math.PI * 2));
        int i = 0;
        while (i < this._listeBases.size()) {
            double angle = -((double)(-(i + 1)) * 2.0 * Math.PI / (double)(this._listeBases.size() + 1) - 1.5707963267948966);
            this._listeBases.get(i).setCoords(new Point2D.Double((double)radius * Math.cos(angle) * this._spaceBetweenBases, (double)radius * Math.sin(angle) * this._spaceBetweenBases));
            this._listeBases.get(i).setCenter(new Point2D.Double(0.0, 0.0));
            ++i;
        }
    }

    public void drawRNAVARNAView() {
        this._drawn = true;
        this._drawMode = 5;
        VARNASecDraw vs = new VARNASecDraw();
        vs.drawRNA(1.0, this);
    }

    public void drawRNALine() {
        this._drawn = true;
        this._drawMode = 4;
        int i = 0;
        while (i < this.get_listeBases().size()) {
            this.get_listeBases().get(i).setCoords(new Point2D.Double((double)i * this._spaceBetweenBases * 20.0, 0.0));
            this.get_listeBases().get(i).setCenter(new Point2D.Double((double)i * this._spaceBetweenBases * 20.0, -10.0));
            ++i;
        }
    }

    private void computeHelixEndPointDirections(RNATemplate.RNATemplateElement.EdgeEndPoint helixEndPoint, Point2D.Double i, Point2D.Double j) {
        RNATemplate.RNATemplateHelix helix = (RNATemplate.RNATemplateHelix)helixEndPoint.getElement();
        Point2D.Double startpos = helix.getStartPosition();
        Point2D.Double endpos = helix.getEndPosition();
        Point2D.Double helixVector = new Point2D.Double();
        switch (helixEndPoint.getPosition()) {
            case IN1: 
            case OUT2: {
                helixVector.x = startpos.x - endpos.x;
                helixVector.y = startpos.y - endpos.y;
                break;
            }
            case IN2: 
            case OUT1: {
                helixVector.x = endpos.x - startpos.x;
                helixVector.y = endpos.y - startpos.y;
            }
        }
        double helixVectorLength = Math.hypot(helixVector.x, helixVector.y);
        i.x = helixVector.x / helixVectorLength;
        i.y = helixVector.y / helixVectorLength;
        switch (helixEndPoint.getPosition()) {
            case IN1: 
            case IN2: {
                j.x = -i.y;
                j.y = i.x;
                break;
            }
            case OUT1: 
            case OUT2: {
                j.x = i.y;
                j.y = -i.x;
            }
        }
        if (helix.isFlipped()) {
            j.x = -j.x;
            j.y = -j.y;
        }
    }

    private void computeBezierTangentVectorTarget(RNATemplate.RNATemplateElement.EdgeEndPoint endPoint, Point2D.Double curveEndPoint, Point2D.Double curveVectorOtherPoint) throws RNATemplateDrawingAlgorithmException {
        boolean sequenceEndPointIsIn;
        RNATemplate.RNATemplateUnpairedSequence sequence;
        if (endPoint.getElement() instanceof RNATemplate.RNATemplateHelix) {
            RNATemplate.RNATemplateElement.EdgeEndPoint endPointOnHelix;
            sequence = (RNATemplate.RNATemplateUnpairedSequence)endPoint.getOtherElement();
            RNATemplate.EdgeEndPointPosition endPointPositionOnHelix = endPoint.getPosition();
            switch (endPointPositionOnHelix) {
                case IN1: 
                case IN2: {
                    sequenceEndPointIsIn = false;
                    break;
                }
                default: {
                    sequenceEndPointIsIn = true;
                }
            }
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint = endPointOnHelix = sequenceEndPointIsIn ? sequence.getIn().getOtherEndPoint() : sequence.getOut().getOtherEndPoint();
            if (endPointOnHelix == null) {
                throw new RNATemplateDrawingAlgorithmException("Sequence is not connected to an helix.");
            }
        } else {
            sequence = (RNATemplate.RNATemplateUnpairedSequence)endPoint.getElement();
            sequenceEndPointIsIn = endPoint == sequence.getIn();
        }
        double l = sequenceEndPointIsIn ? sequence.getInTangentVectorLength() : sequence.getOutTangentVectorLength();
        double theta = sequenceEndPointIsIn ? sequence.getInTangentVectorAngle() : sequence.getOutTangentVectorAngle();
        Point2D.Double v = new Point2D.Double();
        v.x = l * Math.cos(theta);
        v.y = l * Math.sin(theta);
        curveVectorOtherPoint.x = curveEndPoint.x + v.x;
        curveVectorOtherPoint.y = curveEndPoint.y + v.y;
    }

    private static double angleFromVector(Point2D.Double v) {
        return RNA.angleFromVector(v.x, v.y);
    }

    private static double angleFromVector(double x, double y) {
        double l = Math.hypot(x, y);
        if (y > 0.0) {
            return Math.acos(x / l);
        }
        if (y < 0.0) {
            return -Math.acos(x / l);
        }
        return x > 0.0 ? 0.0 : Math.PI;
    }

    private double computeLengthIncreaseFactor(int[] basesInHelixArray, RNATemplate.RNATemplateHelix helix) {
        double templateLength = this.computeHelixTemplateLength(helix);
        double realLength = this.computeHelixRealLength(basesInHelixArray);
        return realLength / templateLength;
    }

    private Point2D.Double computeLengthIncreaseDelta(int[] basesInHelixArray, RNATemplate.RNATemplateHelix helix) {
        double templateLength = this.computeHelixTemplateLength(helix);
        double realLength = this.computeHelixRealLength(basesInHelixArray);
        Point2D.Double i = new Point2D.Double();
        this.computeTemplateHelixVectors(helix, null, i, null);
        return new Point2D.Double(i.x * (realLength - templateLength), i.y * (realLength - templateLength));
    }

    private void computeTemplateHelixVectors(RNATemplate.RNATemplateHelix helix, Point2D.Double o, Point2D.Double i, Point2D.Double j) {
        Point2D.Double endpos;
        Point2D.Double startpos;
        if (helix.getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME) {
            startpos = helix.getStartPosition();
            endpos = helix.getEndPosition();
        } else {
            endpos = helix.getStartPosition();
            startpos = helix.getEndPosition();
        }
        if (o != null) {
            o.x = startpos.x;
            o.y = startpos.y;
        }
        if (i != null || j != null) {
            if (i == null) {
                i = new Point2D.Double();
            }
            i.x = endpos.x - startpos.x;
            i.y = endpos.y - startpos.y;
            double i_original_norm = Math.hypot(i.x, i.y);
            i.x /= i_original_norm;
            i.y /= i_original_norm;
            if (j != null) {
                j.x = -i.y;
                j.y = i.x;
                if (helix.isFlipped()) {
                    j.x = -j.x;
                    j.y = -j.y;
                }
                double j_original_norm = Math.hypot(j.x, j.y);
                j.x /= j_original_norm;
                j.y /= j_original_norm;
            }
        }
    }

    private double estimateBulgeArcLength(int firstBase, int lastBase) {
        if (firstBase + 1 == lastBase) {
            return 40.0;
        }
        double len = 0.0;
        int k = firstBase;
        while (k < lastBase) {
            int l = this._listeBases.get(k).getElementStructure();
            if (k < l && l < lastBase) {
                len += 65.0;
                k = l;
                continue;
            }
            len += 40.0;
            ++k;
        }
        return len;
    }

    private double estimateBulgeWidth(int firstBase, int lastBase) {
        double len = this.estimateBulgeArcLength(firstBase, lastBase);
        return 2.0 * (len / Math.PI);
    }

    private double estimateBulgeWidthOLD(int firstBase, int lastBase) {
        if (firstBase + 1 == lastBase) {
            return 40.0;
        }
        double len = this.estimateBulgeArcLength(firstBase, lastBase);
        return 2.0 * ((len += 65.0) / Math.PI);
    }

    private double computeHelixTemplateLength(RNATemplate.RNATemplateHelix helix) {
        return Math.hypot(helix.getStartPosition().x - helix.getEndPosition().x, helix.getStartPosition().y - helix.getEndPosition().y);
    }

    private double computeHelixRealLength(int[] basesInHelixArray) {
        return this.drawHelixLikeTemplateHelix(basesInHelixArray, null, null, null, 0.0, null);
    }

    private double drawHelixLikeTemplateHelix(int[] basesInHelixArray, RNATemplate.RNATemplateHelix helix, Point2D.Double[] coords, Point2D.Double[] centers, double scaleHelixOrigin, Map<RNATemplate.RNATemplateHelix, Point2D.Double> translateVectors) {
        int n = basesInHelixArray.length / 2;
        if (n == 0) {
            return 0.0;
        }
        Point2D.Double o = new Point2D.Double(0.0, 0.0);
        Point2D.Double i = new Point2D.Double(1.0, 0.0);
        Point2D.Double j = new Point2D.Double(0.0, 1.0);
        boolean flipped = false;
        if (helix != null) {
            this.computeTemplateHelixVectors(helix, o, i, j);
            flipped = helix.isFlipped();
        }
        Point2D.Double li = new Point2D.Double(i.x * 40.0, i.y * 40.0);
        o.x = (o.x - j.x * 65.0 / 2.0) * scaleHelixOrigin;
        o.y = (o.y - j.y * 65.0 / 2.0) * scaleHelixOrigin;
        if (translateVectors != null && translateVectors.containsKey(helix)) {
            Point2D.Double v = translateVectors.get(helix);
            o.x += v.x;
            o.y += v.y;
        }
        Point2D.Double[] helixBasesPositions = new Point2D.Double[basesInHelixArray.length];
        int k = 0;
        while (k < helixBasesPositions.length) {
            helixBasesPositions[k] = new Point2D.Double();
            ++k;
        }
        Point2D.Double accDelta = new Point2D.Double(0.0, 0.0);
        int k2 = 0;
        while (k2 < n) {
            boolean bulge;
            int kp = 2 * n - k2 - 1;
            Point2D.Double p1 = helixBasesPositions[k2];
            Point2D.Double p2 = helixBasesPositions[kp];
            boolean bl = bulge = k2 >= 1 && (basesInHelixArray[k2] != basesInHelixArray[k2 - 1] + 1 || basesInHelixArray[kp + 1] != basesInHelixArray[kp] + 1);
            if (k2 >= 1) {
                if (basesInHelixArray[k2] < basesInHelixArray[k2 - 1] || basesInHelixArray[kp + 1] < basesInHelixArray[kp]) {
                    throw new Error("Internal bug: basesInHelixArray must be sorted");
                }
                if (bulge) {
                    double delta1 = this.estimateBulgeWidth(basesInHelixArray[k2 - 1], basesInHelixArray[k2]);
                    double delta2 = this.estimateBulgeWidth(basesInHelixArray[kp], basesInHelixArray[kp + 1]);
                    double delta = Math.max(delta1, delta2);
                    if (coords != null) {
                        int side = 0;
                        while (side < 2) {
                            int lastBase;
                            int firstBase;
                            Point2D.Double pstart = new Point2D.Double();
                            Point2D.Double pend = new Point2D.Double();
                            Point2D.Double bisectVect = new Point2D.Double();
                            Point2D.Double is = new Point2D.Double();
                            double alphasign = flipped ? -1 : 1;
                            if (side == 0) {
                                firstBase = basesInHelixArray[k2 - 1];
                                lastBase = basesInHelixArray[k2];
                                pstart.setLocation(o.x + accDelta.x, o.y + accDelta.y);
                                pend.setLocation(o.x + accDelta.x + i.x * delta, o.y + accDelta.y + i.y * delta);
                                bisectVect.setLocation(-j.x, -j.y);
                                is.setLocation(i);
                            } else {
                                firstBase = basesInHelixArray[kp];
                                lastBase = basesInHelixArray[kp + 1];
                                pstart.setLocation(o.x + accDelta.x + i.x * delta + j.x * 65.0, o.y + accDelta.y + i.y * delta + j.y * 65.0);
                                pend.setLocation(o.x + accDelta.x + j.x * 65.0, o.y + accDelta.y + j.y * 65.0);
                                bisectVect.setLocation(j);
                                is.setLocation(-i.x, -i.y);
                            }
                            double arclen = this.estimateBulgeArcLength(firstBase, lastBase);
                            double centerOnBisect = ComputeArcCenter.computeArcCenter(delta, arclen);
                            if (centerOnBisect > -1000.0) {
                                Point2D.Double center = new Point2D.Double(pstart.x + is.x * delta / 2.0 + bisectVect.x * centerOnBisect, pstart.y + is.y * delta / 2.0 + bisectVect.y * centerOnBisect);
                                int b = firstBase;
                                double len = 0.0;
                                double r = Math.hypot(pstart.x - center.x, pstart.y - center.y);
                                double alpha0 = RNA.angleFromVector(pstart.x - center.x, pstart.y - center.y);
                                while (b < lastBase) {
                                    int l = this._listeBases.get(b).getElementStructure();
                                    if (b < l && l < lastBase) {
                                        len += 65.0;
                                        b = l;
                                    } else {
                                        len += 40.0;
                                        ++b;
                                    }
                                    if (b >= lastBase) continue;
                                    coords[b].x = center.x + r * Math.cos(alpha0 + alphasign * len / r);
                                    coords[b].y = center.y + r * Math.sin(alpha0 + alphasign * len / r);
                                }
                            } else {
                                double nBP = 0.0;
                                double nLD = 0.0;
                                int b = firstBase;
                                while (b < lastBase) {
                                    int l = this._listeBases.get(b).getElementStructure();
                                    if (b < l && l < lastBase) {
                                        nBP += 1.0;
                                        b = l;
                                        continue;
                                    }
                                    nLD += 1.0;
                                    ++b;
                                }
                                double LD = Math.max((delta - nBP * 65.0) / nLD, 0.0);
                                double len = 0.0;
                                int b2 = firstBase;
                                while (b2 < lastBase) {
                                    int l = this._listeBases.get(b2).getElementStructure();
                                    if (b2 < l && l < lastBase) {
                                        len += 65.0;
                                        b2 = l;
                                    } else {
                                        len += LD;
                                        ++b2;
                                    }
                                    if (b2 >= lastBase) continue;
                                    coords[b2].x = pstart.x + is.x * len;
                                    coords[b2].y = pstart.y + is.y * len;
                                }
                            }
                            int b = firstBase;
                            while (b < lastBase) {
                                int l = this._listeBases.get(b).getElementStructure();
                                if (b < l && l < lastBase) {
                                    Point2D.Double b1pos = coords[b];
                                    Point2D.Double b2pos = coords[l];
                                    double beta = RNA.angleFromVector(b2pos.x - b1pos.x, b2pos.y - b1pos.y) - 1.5707963267948966 + (flipped ? Math.PI : 0.0);
                                    Point2D.Double loopCenter = new Point2D.Double((b1pos.x + b2pos.x) / 2.0, (b1pos.y + b2pos.y) / 2.0);
                                    this.drawLoop(b, l, loopCenter.x, loopCenter.y, beta, coords, centers);
                                    if (helix.isFlipped()) {
                                        Point2D.Double v = new Point2D.Double(Math.cos(beta), Math.sin(beta));
                                        Point2D.Double[] points1 = new Point2D.Double[l - b + 1];
                                        Point2D.Double[] points2 = new Point2D.Double[l - b + 1];
                                        int c = b;
                                        while (c <= l) {
                                            points1[c - b] = coords[c];
                                            points2[c - b] = centers[c];
                                            ++c;
                                        }
                                        RNA.symmetric(loopCenter, v, points1);
                                        RNA.symmetric(loopCenter, v, points2);
                                    }
                                    b = l;
                                    continue;
                                }
                                ++b;
                            }
                            ++side;
                        }
                    }
                    accDelta.x += i.x * delta;
                    accDelta.y += i.y * delta;
                    p1.x = o.x + accDelta.x;
                    p1.y = o.y + accDelta.y;
                    p2.x = p1.x + j.x * 65.0;
                    p2.y = p1.y + j.y * 65.0;
                } else {
                    accDelta.x += li.x;
                    accDelta.y += li.y;
                    p1.x = o.x + accDelta.x;
                    p1.y = o.y + accDelta.y;
                    p2.x = p1.x + j.x * 65.0;
                    p2.y = p1.y + j.y * 65.0;
                }
            } else {
                p1.x = o.x;
                p1.y = o.y;
                p2.x = p1.x + j.x * 65.0;
                p2.y = p1.y + j.y * 65.0;
            }
            ++k2;
        }
        Point2D.Double p1 = helixBasesPositions[0];
        Point2D.Double p2 = helixBasesPositions[n - 1];
        if (coords != null) {
            int k3 = 0;
            while (k3 < helixBasesPositions.length) {
                coords[basesInHelixArray[k3]] = helixBasesPositions[k3];
                ++k3;
            }
        }
        return Math.hypot(p2.x - p1.x, p2.y - p1.y);
    }

    private void drawHelixLikeTemplateHelixOLD(int[] basesInHelixArray, RNATemplate.RNATemplateHelix helix, Point2D.Double[] coords, Point2D.Double[] centers, double scaleHelixOrigin, Map<RNATemplate.RNATemplateHelix, Point2D.Double> translateVectors) {
        int b2;
        int b1;
        int n = basesInHelixArray.length / 2;
        Point2D.Double o = new Point2D.Double();
        Point2D.Double i = new Point2D.Double();
        Point2D.Double j = new Point2D.Double();
        this.computeTemplateHelixVectors(helix, o, i, j);
        i.x *= 40.0;
        i.y *= 40.0;
        o.x = (o.x - j.x * 65.0 / 2.0) * scaleHelixOrigin;
        o.y = (o.y - j.y * 65.0 / 2.0) * scaleHelixOrigin;
        if (translateVectors != null && translateVectors.containsKey(helix)) {
            Point2D.Double v = translateVectors.get(helix);
            o.x += v.x;
            o.y += v.y;
        }
        int k = 0;
        while (k < n) {
            b1 = basesInHelixArray[k];
            b2 = basesInHelixArray[2 * n - k - 1];
            Point2D.Double p1 = coords[b1];
            p1.x = o.x + (double)k * i.x;
            p1.y = o.y + (double)k * i.y;
            Point2D.Double p2 = coords[b2];
            p2.x = p1.x + j.x * 65.0;
            p2.y = p1.y + j.y * 65.0;
            ++k;
        }
        k = 0;
        while (k < 2 * n - 1) {
            if (k != n - 1 && (b1 = basesInHelixArray[k]) + 1 != (b2 = basesInHelixArray[k + 1])) {
                Point2D.Double b1pos = coords[b1];
                Point2D.Double b2pos = coords[b2];
                Point2D.Double v = new Point2D.Double();
                if (k >= n) {
                    v.x = j.x;
                    v.y = j.y;
                } else {
                    v.x = -j.x;
                    v.y = -j.y;
                }
                Point2D.Double loopCenter = new Point2D.Double();
                loopCenter.x = (b1pos.x + b2pos.x) / 2.0 + v.x * 40.0;
                loopCenter.y = (b1pos.y + b2pos.y) / 2.0 + v.y * 40.0;
                this.drawLoop(b1 + 1, b2 - 1, loopCenter.x, loopCenter.y, RNA.angleFromVector(v), coords, centers);
                if (helix.isFlipped()) {
                    int from = b1 + 1;
                    int to = b2 - 1;
                    Point2D.Double[] points1 = new Point2D.Double[to - from + 1];
                    Point2D.Double[] points2 = new Point2D.Double[to - from + 1];
                    int b = from;
                    while (b <= to) {
                        points1[b - from] = coords[b];
                        points2[b - from] = centers[b];
                        ++b;
                    }
                    RNA.symmetric(loopCenter, v, points1);
                    RNA.symmetric(loopCenter, v, points2);
                }
            }
            ++k;
        }
    }

    private void drawOnBezierCurve(int[] basesInSequence, Point2D.Double P0, Point2D.Double P1, Point2D.Double P2, Point2D.Double P3, Point2D.Double[] coords, Point2D.Double[] centers) {
        int n = basesInSequence.length;
        CubicBezierCurve bezier = new CubicBezierCurve(P0, P1, P2, P3, 10 * n);
        double curveLength = bezier.getApproxCurveLength();
        double delta_t = curveLength / (double)(n + 1);
        double[] t = new double[n];
        int k = 0;
        while (k < n) {
            t[k] = (double)(k + 1) * delta_t;
            ++k;
        }
        Point2D.Double[] sequenceBasesCoords = bezier.uniformParam(t);
        int k2 = 0;
        while (k2 < n) {
            coords[basesInSequence[k2]] = sequenceBasesCoords[k2];
            ++k2;
        }
    }

    private void drawOnStraightLine(int[] basesInSequence, Point2D.Double P0, Point2D.Double P3, Point2D.Double[] coords, Point2D.Double[] centers) {
        int n = basesInSequence.length;
        Point2D.Double v = new Point2D.Double(P3.x - P0.x, P3.y - P0.y);
        int k = 0;
        while (k < n) {
            coords[basesInSequence[k]].x = P0.x + (double)(k + 1) / (double)(n + 1) * v.x;
            coords[basesInSequence[k]].y = P0.y + (double)(k + 1) / (double)(n + 1) * v.y;
            ++k;
        }
    }

    private void drawAlongCurve(int firstBase, int lastBase, Point2D.Double P0, Point2D.Double P1, Point2D.Double P2, Point2D.Double P3, Point2D.Double[] coords, Point2D.Double[] centers) {
        int k;
        ArrayList<Integer> alongBezierCurve = new ArrayList<Integer>();
        int depth = 0;
        int i = firstBase;
        while (i <= lastBase) {
            k = this._listeBases.get(i).getElementStructure();
            if (k < 0 || k > lastBase || k < firstBase) {
                if (depth == 0) {
                    alongBezierCurve.add(i);
                }
            } else if (i < k) {
                if (depth == 0) {
                    alongBezierCurve.add(i);
                    alongBezierCurve.add(k);
                }
                ++depth;
            } else {
                --depth;
            }
            ++i;
        }
        int n = alongBezierCurve.size();
        int[] alongBezierCurveArray = RNATemplateAlign.intArrayFromList(alongBezierCurve);
        if (n > 0) {
            if (P1 != null && P2 != null) {
                this.drawOnBezierCurve(alongBezierCurveArray, P0, P1, P2, P3, coords, centers);
            } else {
                this.drawOnStraightLine(alongBezierCurveArray, P0, P3, coords, centers);
            }
        }
        k = 0;
        while (k < n - 1) {
            int b1 = alongBezierCurveArray[k];
            int b2 = alongBezierCurveArray[k + 1];
            if (this._listeBases.get(b1).getElementStructure() == b2) {
                Point2D.Double b1pos = coords[b1];
                Point2D.Double b2pos = coords[b2];
                double alpha = RNA.angleFromVector(b2pos.x - b1pos.x, b2pos.y - b1pos.y);
                this.drawLoop(b1, b2, (b1pos.x + b2pos.x) / 2.0, (b1pos.y + b2pos.y) / 2.0, alpha - 1.5707963267948966, coords, centers);
            }
            ++k;
        }
    }

    private static void symmetric(Point2D.Double p, Point2D.Double v, Point2D.Double[] points) {
        double lv = v.x * v.x + v.y * v.y;
        int i = 0;
        while (i < points.length) {
            Point2D.Double A = new Point2D.Double(points[i].x - p.x, points[i].y - p.y);
            Point2D.Double B = new Point2D.Double(-(A.x * v.y * v.y - 2.0 * A.y * v.x * v.y - A.x * v.x * v.x) / lv, (A.y * v.y * v.y + 2.0 * A.x * v.x * v.y - A.y * v.x * v.x) / lv);
            points[i].x = B.x + p.x;
            points[i].y = B.y + p.y;
            ++i;
        }
    }

    private void computeHelixTranslations(Tree<RNANodeValueTemplate> tree, Map<RNATemplate.RNATemplateHelix, Point2D.Double> translateVectors, RNATemplateMapping mapping, Point2D.Double parentDeltaVector) {
        RNATemplate.RNATemplateHelix helix;
        RNANodeValueTemplate nvt = tree.getValue();
        Point2D.Double newDeltaVector = parentDeltaVector;
        if (nvt instanceof RNANodeValueTemplateBasePair && !translateVectors.containsKey(helix = ((RNANodeValueTemplateBasePair)nvt).getHelix())) {
            int[] basesInHelixArray;
            translateVectors.put(helix, parentDeltaVector);
            if (mapping.getAncestor(helix) != null) {
                basesInHelixArray = RNATemplateAlign.intArrayFromList(mapping.getAncestor(helix));
                Arrays.sort(basesInHelixArray);
            } else {
                basesInHelixArray = new int[]{};
            }
            Point2D.Double helixDeltaVector = this.computeLengthIncreaseDelta(basesInHelixArray, helix);
            newDeltaVector = new Point2D.Double(parentDeltaVector.x + helixDeltaVector.x, parentDeltaVector.y + helixDeltaVector.y);
        }
        for (Tree<RNANodeValueTemplate> subtree : tree.getChildren()) {
            this.computeHelixTranslations(subtree, translateVectors, mapping, newDeltaVector);
        }
    }

    private Map<RNATemplate.RNATemplateHelix, Point2D.Double> computeHelixTranslations(Tree<RNANodeValueTemplate> tree, RNATemplateMapping mapping) {
        HashMap<RNATemplate.RNATemplateHelix, Point2D.Double> translateVectors = new HashMap<RNATemplate.RNATemplateHelix, Point2D.Double>();
        this.computeHelixTranslations(tree, translateVectors, mapping, new Point2D.Double(0.0, 0.0));
        return translateVectors;
    }

    public RNATemplateMapping drawRNATemplate(RNATemplate template) throws RNATemplateDrawingAlgorithmException {
        return this.drawRNATemplate(template, DrawRNATemplateMethod.NOADJUST);
    }

    public RNATemplateMapping drawRNATemplate(RNATemplate template, int helixLengthAdjustmentMethod) throws RNATemplateDrawingAlgorithmException {
        Iterator<RNATemplate.RNATemplateElement> iter;
        this._drawn = true;
        this._drawMode = 7;
        RNATemplateMapping mapping = RNATemplateAlign.mapRNAWithTemplate(this, template);
        System.out.println(mapping.showCompact(this));
        double globalIncreaseFactor = 1.0;
        Map<RNATemplate.RNATemplateHelix, Point2D.Double> translateVectors = null;
        if (helixLengthAdjustmentMethod == DrawRNATemplateMethod.MAXSCALINGFACTOR) {
            HashMap<RNATemplate.RNATemplateHelix, Double> lengthIncreaseFactor = new HashMap<RNATemplate.RNATemplateHelix, Double>();
            double maxLengthIncreaseFactor = Double.NEGATIVE_INFINITY;
            RNATemplate.RNATemplateHelix maxIncreaseHelix = null;
            iter = template.rnaIterator();
            while (iter.hasNext()) {
                RNATemplate.RNATemplateElement element = iter.next();
                if (!(element instanceof RNATemplate.RNATemplateHelix) || mapping.getAncestor(element) == null || lengthIncreaseFactor.containsKey(element)) continue;
                RNATemplate.RNATemplateHelix helix = (RNATemplate.RNATemplateHelix)element;
                int[] basesInHelixArray = RNATemplateAlign.intArrayFromList(mapping.getAncestor(helix));
                Arrays.sort(basesInHelixArray);
                double l = this.computeLengthIncreaseFactor(basesInHelixArray, helix);
                lengthIncreaseFactor.put(helix, l);
                if (!(l > maxLengthIncreaseFactor)) continue;
                maxLengthIncreaseFactor = l;
                maxIncreaseHelix = helix;
            }
            System.out.println("Max helix length increase factor = " + maxLengthIncreaseFactor + " reached with helix " + maxIncreaseHelix);
            globalIncreaseFactor = Math.max(1.0, maxLengthIncreaseFactor);
        } else if (helixLengthAdjustmentMethod == DrawRNATemplateMethod.HELIXTRANSLATE) {
            try {
                Tree<RNANodeValueTemplate> templateAsTree = template.toTree();
                translateVectors = this.computeHelixTranslations(templateAsTree, mapping);
            }
            catch (ExceptionInvalidRNATemplate e) {
                throw new RNATemplateDrawingAlgorithmException("ExceptionInvalidRNATemplate: " + e.getMessage());
            }
        }
        Point2D.Double[] coords = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] centers = new Point2D.Double[this._listeBases.size()];
        int i = 0;
        while (i < this._listeBases.size()) {
            coords[i] = new Point2D.Double(0.0, 0.0);
            centers[i] = new Point2D.Double(0.0, 0.0);
            ++i;
        }
        boolean computeCoords = true;
        while (computeCoords) {
            computeCoords = false;
            HashSet<RNATemplate.RNATemplateHelix> alreadyDrawnHelixes = new HashSet<RNATemplate.RNATemplateHelix>();
            RNATemplate.RNATemplateHelix lastMappedHelix = null;
            RNATemplate.RNATemplateElement.EdgeEndPoint howWeGotOutOfLastHelix = null;
            int howWeGotOutOfLastHelixBaseIndex = 0;
            iter = template.rnaIterator();
            RNATemplate.RNATemplateElement element = null;
            while (iter.hasNext()) {
                boolean firstTimeWeMeetThisHelix;
                element = iter.next();
                if (!(element instanceof RNATemplate.RNATemplateHelix) || mapping.getAncestor(element) == null) continue;
                RNATemplate.RNATemplateHelix helix = (RNATemplate.RNATemplateHelix)element;
                int[] basesInHelixArray = RNATemplateAlign.intArrayFromList(mapping.getAncestor(helix));
                Arrays.sort(basesInHelixArray);
                if (!alreadyDrawnHelixes.contains(helix)) {
                    firstTimeWeMeetThisHelix = true;
                    this.drawHelixLikeTemplateHelix(basesInHelixArray, helix, coords, centers, globalIncreaseFactor, translateVectors);
                    alreadyDrawnHelixes.add(helix);
                } else {
                    firstTimeWeMeetThisHelix = false;
                }
                RNATemplate.RNATemplateElement.EdgeEndPoint howWeGetInCurrentHelix = firstTimeWeMeetThisHelix ? (helix.getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME ? helix.getIn1() : helix.getIn2()) : (helix.getIn1Is() == RNATemplate.In1Is.IN1_IS_5PRIME ? helix.getIn2() : helix.getIn1());
                Point2D.Double P0 = new Point2D.Double();
                Point2D.Double P3 = new Point2D.Double();
                if (lastMappedHelix != null) {
                    if (lastMappedHelix == helix) {
                        Point2D.Double helixVector = new Point2D.Double();
                        this.computeHelixEndPointDirections(howWeGotOutOfLastHelix, helixVector, new Point2D.Double());
                        double angle = RNA.angleFromVector(helixVector);
                        int b1 = basesInHelixArray[basesInHelixArray.length / 2 - 1];
                        P0.setLocation(coords[b1]);
                        int b2 = basesInHelixArray[basesInHelixArray.length / 2];
                        P3.setLocation(coords[b2]);
                        Point2D.Double loopCenter = new Point2D.Double((P0.x + P3.x) / 2.0, (P0.y + P3.y) / 2.0);
                        this.drawLoop(b1, b2, loopCenter.x, loopCenter.y, angle, coords, centers);
                        if (helix.isFlipped()) {
                            Point2D.Double[] points1 = new Point2D.Double[b2 - b1 + 1];
                            Point2D.Double[] points2 = new Point2D.Double[b2 - b1 + 1];
                            int b = b1;
                            while (b <= b2) {
                                points1[b - b1] = coords[b];
                                points2[b - b1] = centers[b];
                                ++b;
                            }
                            RNA.symmetric(loopCenter, helixVector, points1);
                            RNA.symmetric(loopCenter, helixVector, points2);
                        }
                    } else {
                        Point2D.Double P2;
                        Point2D.Double P1;
                        int b1 = howWeGotOutOfLastHelixBaseIndex;
                        int b2 = firstTimeWeMeetThisHelix ? basesInHelixArray[0] : basesInHelixArray[basesInHelixArray.length / 2];
                        P0.setLocation(coords[b1]);
                        P3.setLocation(coords[b2]);
                        if (howWeGotOutOfLastHelix.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && howWeGetInCurrentHelix.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence) {
                            P1 = new Point2D.Double();
                            this.computeBezierTangentVectorTarget(howWeGotOutOfLastHelix, P0, P1);
                            P2 = new Point2D.Double();
                            this.computeBezierTangentVectorTarget(howWeGetInCurrentHelix, P3, P2);
                        } else {
                            P1 = null;
                            P2 = null;
                        }
                        this.drawAlongCurve(b1 + 1, b2 - 1, P0, P1, P2, P3, coords, centers);
                    }
                } else if (basesInHelixArray[0] > 0) {
                    Point2D.Double P2;
                    Point2D.Double P1;
                    RNATemplate.RNATemplateElement templateSequenceCandidate = mapping.getPartner(0);
                    RNATemplate.RNATemplateUnpairedSequence templateSequence = templateSequenceCandidate != null && templateSequenceCandidate instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate : ((templateSequenceCandidate = template.getFirst()) != null && templateSequenceCandidate instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate : null);
                    int b1 = 0;
                    int b2 = firstTimeWeMeetThisHelix ? basesInHelixArray[0] : basesInHelixArray[basesInHelixArray.length / 2];
                    P3.setLocation(coords[b2]);
                    if (templateSequence != null) {
                        coords[0].setLocation(templateSequence.getVertex5());
                        coords[0].x *= globalIncreaseFactor;
                        coords[0].y *= globalIncreaseFactor;
                    } else {
                        coords[0].setLocation(coords[b2].x, coords[b2].y + 100.0);
                    }
                    P0.setLocation(coords[0]);
                    if (howWeGetInCurrentHelix.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && templateSequence != null) {
                        P1 = new Point2D.Double();
                        this.computeBezierTangentVectorTarget(templateSequence.getIn(), P0, P1);
                        P2 = new Point2D.Double();
                        this.computeBezierTangentVectorTarget(howWeGetInCurrentHelix, P3, P2);
                    } else {
                        P1 = null;
                        P2 = null;
                    }
                    this.drawAlongCurve(b1, b2 - 1, P0, P1, P2, P3, coords, centers);
                }
                lastMappedHelix = helix;
                howWeGotOutOfLastHelix = howWeGetInCurrentHelix.getNextEndPoint();
                howWeGotOutOfLastHelixBaseIndex = firstTimeWeMeetThisHelix ? basesInHelixArray[basesInHelixArray.length / 2 - 1] : basesInHelixArray[basesInHelixArray.length - 1];
            }
            if (howWeGotOutOfLastHelixBaseIndex < coords.length - 1 && element != null && coords.length > 1) {
                Point2D.Double P2;
                Point2D.Double P1;
                RNATemplate.RNATemplateElement templateSequenceCandidate;
                RNATemplate.RNATemplateElement templateSequenceCandidate2;
                RNATemplate.RNATemplateUnpairedSequence beginTemplateSequence = null;
                if (lastMappedHelix == null && (beginTemplateSequence = (templateSequenceCandidate2 = mapping.getPartner(0)) != null && templateSequenceCandidate2 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate2 : ((templateSequenceCandidate2 = template.getFirst()) != null && templateSequenceCandidate2 instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate2 : null)) != null) {
                    coords[0].setLocation(beginTemplateSequence.getVertex5());
                    coords[0].x *= globalIncreaseFactor;
                    coords[0].y *= globalIncreaseFactor;
                }
                RNATemplate.RNATemplateUnpairedSequence endTemplateSequence = (templateSequenceCandidate = mapping.getPartner(coords.length - 1)) != null && templateSequenceCandidate instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate : ((templateSequenceCandidate = element) != null && templateSequenceCandidate instanceof RNATemplate.RNATemplateUnpairedSequence ? (RNATemplate.RNATemplateUnpairedSequence)templateSequenceCandidate : null);
                int b1 = howWeGotOutOfLastHelixBaseIndex;
                int b2 = coords.length - 1;
                if (endTemplateSequence != null) {
                    coords[b2].setLocation(endTemplateSequence.getVertex3());
                } else {
                    coords[b2].setLocation(coords[b1].x, coords[b1].y + 100.0);
                }
                coords[coords.length - 1].x *= globalIncreaseFactor;
                coords[coords.length - 1].y *= globalIncreaseFactor;
                if (lastMappedHelix == null && beginTemplateSequence == null && endTemplateSequence == null) {
                    coords[coords.length - 1].setLocation(1000.0, 1000.0);
                }
                Point2D.Double P0 = new Point2D.Double();
                Point2D.Double P3 = new Point2D.Double();
                P0.setLocation(coords[b1]);
                P3.setLocation(coords[b2]);
                if (howWeGotOutOfLastHelix != null && howWeGotOutOfLastHelix.getOtherElement() instanceof RNATemplate.RNATemplateUnpairedSequence && endTemplateSequence != null) {
                    P1 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(howWeGotOutOfLastHelix, P0, P1);
                    P2 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(endTemplateSequence.getOut(), P3, P2);
                } else if (lastMappedHelix == null && beginTemplateSequence != null && endTemplateSequence != null) {
                    P1 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(beginTemplateSequence.getIn(), P0, P1);
                    P2 = new Point2D.Double();
                    this.computeBezierTangentVectorTarget(endTemplateSequence.getOut(), P3, P2);
                } else {
                    P1 = null;
                    P2 = null;
                }
                this.drawAlongCurve(lastMappedHelix != null ? b1 + 1 : b1, b2, P0, P1, P2, P3, coords, centers);
            }
            if (helixLengthAdjustmentMethod != DrawRNATemplateMethod.NOINTERSECT || coords.length <= 3) continue;
            Line2D.Double[] lines = new Line2D.Double[coords.length - 1];
            int i2 = 0;
            while (i2 < coords.length - 1) {
                lines[i2] = new Line2D.Double(coords[i2], coords[i2 + 1]);
                ++i2;
            }
            int intersectLines = 0;
            int i3 = 0;
            while (i3 < lines.length) {
                int j = i3 + 2;
                while (j < lines.length) {
                    if (lines[i3].intersectsLine(lines[j])) {
                        ++intersectLines;
                    }
                    ++j;
                }
                ++i3;
            }
            if (intersectLines <= 0 || !(globalIncreaseFactor < 3.0)) continue;
            System.out.println("globalIncreaseFactor increased to " + (globalIncreaseFactor += 0.1));
            computeCoords = true;
        }
        if (helixLengthAdjustmentMethod == DrawRNATemplateMethod.MAXSCALINGFACTOR || helixLengthAdjustmentMethod == DrawRNATemplateMethod.NOINTERSECT) {
            System.out.println("globalIncreaseFactor = " + globalIncreaseFactor);
        }
        int i4 = 0;
        while (i4 < this._listeBases.size()) {
            this._listeBases.get(i4).setCoords(new Point2D.Double(coords[i4].x * this._spaceBetweenBases, coords[i4].y * this._spaceBetweenBases));
            this._listeBases.get(i4).setCenter(new Point2D.Double(centers[i4].x * this._spaceBetweenBases, centers[i4].y * this._spaceBetweenBases));
            ++i4;
        }
        return mapping;
    }

    private static double objFun(int n1, int n2, double r, double bpdist, double multidist) {
        return (double)n1 * 2.0 * Math.asin(bpdist / (2.0 * r)) + (double)n2 * 2.0 * Math.asin(multidist / (2.0 * r)) - Math.PI * 2;
    }

    public double determineRadius(int nbHel, int nbUnpaired, double startRadius) {
        return RNA.determineRadius(nbHel, nbUnpaired, startRadius, 65.0, 35.0);
    }

    public static double determineRadius(int nbHel, int nbUnpaired, double startRadius, double bpdist, double multidist) {
        double xmin = bpdist / 2.0;
        double xmax = 3.0 * multidist + 1.0;
        double x = (xmin + xmax) / 2.0;
        double y = 10000.0;
        double ymin = -1000.0;
        double ymax = 1000.0;
        int numIt = 0;
        double precision = 1.0E-5;
        while (Math.abs(y) > precision && numIt < 10000) {
            x = (xmin + xmax) / 2.0;
            y = RNA.objFun(nbHel, nbUnpaired, x, bpdist, multidist);
            ymin = RNA.objFun(nbHel, nbUnpaired, xmax, bpdist, multidist);
            ymax = RNA.objFun(nbHel, nbUnpaired, xmin, bpdist, multidist);
            if (ymin > 0.0) {
                xmax += xmax - xmin;
            } else if (y <= 0.0 && ymax > 0.0) {
                xmax = x;
            } else if (y >= 0.0 && ymin < 0.0) {
                xmin = x;
            } else if (ymax < 0.0) {
                xmin = Math.max(xmin - (x - xmin), Math.max(bpdist / 2.0, multidist / 2.0));
                xmax = x;
            }
            ++numIt;
        }
        return x;
    }

    public void drawRNA(VARNAConfig conf) throws ExceptionNAViewAlgorithm {
        this.drawRNA(2, conf);
    }

    public void drawRNA(int mode, VARNAConfig conf) throws ExceptionNAViewAlgorithm {
        this._drawMode = mode;
        switch (this.get_drawMode()) {
            case 2: {
                this.drawRNARadiate(conf);
                break;
            }
            case 4: {
                this.drawRNALine();
                break;
            }
            case 1: {
                this.drawRNACircle();
                break;
            }
            case 3: {
                this.drawRNANAView();
                break;
            }
            case 5: {
                this.drawRNAVARNAView();
                break;
            }
            case 6: {
                this.drawMOTIFView();
                break;
            }
        }
    }

    public int getDrawMode() {
        return this._drawMode;
    }

    private void drawLoop(int i, int j, double x, double y, double dirAngle, Point2D.Double[] coords, Point2D.Double[] centers) {
        if (i > j) {
            return;
        }
        if (this._listeBases.get(i).getElementStructure() == j) {
            double normalAngle = 1.5707963267948966;
            centers[i] = new Point2D.Double(x, y);
            centers[j] = new Point2D.Double(x, y);
            coords[i].x = x + 65.0 * Math.cos(dirAngle - normalAngle) / 2.0;
            coords[i].y = y + 65.0 * Math.sin(dirAngle - normalAngle) / 2.0;
            coords[j].x = x + 65.0 * Math.cos(dirAngle + normalAngle) / 2.0;
            coords[j].y = y + 65.0 * Math.sin(dirAngle + normalAngle) / 2.0;
            this.drawLoop(i + 1, j - 1, x + 40.0 * Math.cos(dirAngle), y + 40.0 * Math.sin(dirAngle), dirAngle, coords, centers);
        } else {
            double angleIncrementBP;
            double angleIncrementML;
            double multiLoopRadius;
            int l;
            int k = i;
            Vector<Integer> basesMultiLoop = new Vector<Integer>();
            Vector<Integer> helices = new Vector<Integer>();
            while (k <= j) {
                l = this._listeBases.get(k).getElementStructure();
                if (l > k) {
                    basesMultiLoop.add(new Integer(k));
                    basesMultiLoop.add(new Integer(l));
                    helices.add(new Integer(k));
                    k = l + 1;
                    continue;
                }
                basesMultiLoop.add(new Integer(k));
                ++k;
            }
            int mlSize = basesMultiLoop.size() + 2;
            int numHelices = helices.size() + 1;
            double totalLength = 35.0 * (double)(mlSize - numHelices) + 65.0 * (double)numHelices;
            if (mlSize > 3) {
                multiLoopRadius = RNA.determineRadius(numHelices, mlSize - numHelices, totalLength / (Math.PI * 2), 65.0, 35.0);
                angleIncrementML = -2.0 * Math.asin(35.0 / (2.0 * multiLoopRadius));
                angleIncrementBP = -2.0 * Math.asin(65.0 / (2.0 * multiLoopRadius));
            } else {
                multiLoopRadius = 35.0;
                angleIncrementBP = -2.0 * Math.asin(65.0 / (2.0 * multiLoopRadius));
                angleIncrementML = (Math.PI * -2 - angleIncrementBP) / 2.0;
            }
            double centerDist = Math.sqrt(Math.max(Math.pow(multiLoopRadius, 2.0) - Math.pow(32.5, 2.0), 0.0)) - 40.0;
            Point2D.Double mlCenter = new Point2D.Double(x + centerDist * Math.cos(dirAngle), y + centerDist * Math.sin(dirAngle));
            double baseAngle = dirAngle + Math.PI + 0.5 * angleIncrementBP + 1.0 * angleIncrementML;
            double[] angles = new double[this._listeBases.size()];
            int n1 = 1;
            int n2 = 1;
            k = basesMultiLoop.size() - 1;
            while (k >= 0) {
                l = (Integer)basesMultiLoop.get(k);
                centers[l] = mlCenter;
                angles[l] = baseAngle;
                coords[l].x = mlCenter.x + multiLoopRadius * Math.cos(baseAngle);
                coords[l].y = mlCenter.y + multiLoopRadius * Math.sin(baseAngle);
                if (this._listeBases.get(l).getElementStructure() < l && this._listeBases.get(l).getElementStructure() != -1) {
                    baseAngle += angleIncrementBP;
                    ++n1;
                } else {
                    baseAngle += angleIncrementML;
                    ++n2;
                }
                --k;
            }
            k = 0;
            while (k < helices.size()) {
                int m = (Integer)helices.get(k);
                int n = this._listeBases.get(m).getElementStructure();
                double newAngle = (angles[m] + angles[n]) / 2.0;
                this.drawLoop(m + 1, n - 1, 40.0 * Math.cos(newAngle) + (coords[m].x + coords[n].x) / 2.0, 40.0 * Math.sin(newAngle) + (coords[m].y + coords[n].y) / 2.0, newAngle, coords, centers);
                ++k;
            }
        }
    }

    public void drawRNARadiate(VARNAConfig conf) {
        this.drawRNARadiate(-1.0, conf._flatExteriorLoop);
    }

    public void drawRNARadiate(double dirAngle, boolean flatExteriorLoop) {
        this._drawn = true;
        this._drawMode = 2;
        Point2D.Double[] coords = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] centers = new Point2D.Double[this._listeBases.size()];
        int i = 0;
        while (i < this._listeBases.size()) {
            coords[i] = new Point2D.Double(0.0, 0.0);
            centers[i] = new Point2D.Double(0.0, 0.0);
            ++i;
        }
        if (flatExteriorLoop) {
            i = 0;
            double x = 0.0;
            double y = 0.0;
            double vx = -Math.sin(dirAngle += -0.5707963267948966);
            double vy = Math.cos(dirAngle);
            while (i < this._listeBases.size()) {
                coords[i].x = x;
                coords[i].y = y;
                centers[i].x = x + 65.0 * vy;
                centers[i].y = y - 65.0 * vx;
                int j = this._listeBases.get(i).getElementStructure();
                if (j > i) {
                    this.drawLoop(i, j, x + 65.0 * vx / 2.0, y + 65.0 * vy / 2.0, dirAngle, coords, centers);
                    centers[i].x = coords[i].x + 65.0 * vy;
                    centers[i].y = y - 65.0 * vx;
                    i = j;
                    x += 65.0 * vx;
                    centers[i].x = coords[i].x + 65.0 * vy;
                    centers[i].y = (y += 65.0 * vy) - 65.0 * vx;
                }
                x += 35.0 * vx;
                y += 35.0 * vy;
                ++i;
            }
        } else {
            this.drawLoop(0, this._listeBases.size() - 1, 0.0, 0.0, dirAngle, coords, centers);
        }
        i = 0;
        while (i < this._listeBases.size()) {
            this._listeBases.get(i).setCoords(new Point2D.Double(coords[i].x * this._spaceBetweenBases, coords[i].y * this._spaceBetweenBases));
            this._listeBases.get(i).setCenter(new Point2D.Double(centers[i].x * this._spaceBetweenBases, centers[i].y * this._spaceBetweenBases));
            ++i;
        }
    }

    public void drawRNANAView() throws ExceptionNAViewAlgorithm {
        this._drawMode = 3;
        this._drawn = true;
        ArrayList<Double> X = new ArrayList<Double>(this._listeBases.size());
        ArrayList<Double> Y = new ArrayList<Double>(this._listeBases.size());
        ArrayList<Short> pair_table = new ArrayList<Short>(this._listeBases.size());
        int i = 0;
        while (i < this._listeBases.size()) {
            pair_table.add(Short.valueOf(String.valueOf(this._listeBases.get(i).getElementStructure())));
            ++i;
        }
        NAView naView = new NAView();
        naView.naview_xy_coordinates(pair_table, X, Y);
        int i2 = 0;
        while (i2 < this._listeBases.size()) {
            this._listeBases.get(i2).setCoords(new Point2D.Double(X.get(i2) * 2.5 * this._spaceBetweenBases, Y.get(i2) * 2.5 * this._spaceBetweenBases));
            ++i2;
        }
        i2 = 0;
        while (i2 < this._listeBases.size()) {
            int indicePartner = this._listeBases.get(i2).getElementStructure();
            if (indicePartner != -1) {
                Point2D.Double base = this._listeBases.get(i2).getCoords();
                Point2D.Double partner = this._listeBases.get(indicePartner).getCoords();
                this._listeBases.get(i2).setCenter(new Point2D.Double((base.x + partner.x) / 2.0, (base.y + partner.y) / 2.0));
            } else {
                Vector<Integer> loop = this.getLoopBases(i2);
                double tmpx = 0.0;
                double tmpy = 0.0;
                int j = 0;
                while (j < loop.size()) {
                    int partner = loop.elementAt(j);
                    Point2D.Double loopmember = this._listeBases.get(partner).getCoords();
                    tmpx += loopmember.x;
                    tmpy += loopmember.y;
                    ++j;
                }
                this._listeBases.get(i2).setCenter(new Point2D.Double(tmpx / (double)loop.size(), tmpy / (double)loop.size()));
            }
            ++i2;
        }
    }

    public void drawMOTIFView() {
        this._drawn = true;
        this._drawMode = 6;
        boolean spaceBetweenStrand = false;
        Motif motif = new Motif(this, this.get_listeBases());
        motif.listStrand();
        int i = 0;
        while (i < motif.getListStrand().sizeStruct()) {
            int j = 0;
            while (j < motif.getListStrand().getStrand(i).sizeStrand()) {
                int indice = motif.getListStrand().getStrand(i).getMB(j).getIndex();
                this.get_listeBases().get(indice).setCoords(new Point2D.Double(0.0, 0.0));
                this.get_listeBases().get(indice).setCenter(new Point2D.Double(0.0, 0.0));
                ++j;
            }
            ++i;
        }
        int centralStrand = motif.getCentralStrand();
        if (centralStrand != -1) {
            motif.positionneSpecificStrand(centralStrand, (double)spaceBetweenStrand);
            motif.orderStrands(centralStrand);
        } else {
            centralStrand = 0;
            motif.positionneStrand();
            motif.ajusteStrand();
        }
        motif.reajustement();
        motif.deviationBasePair();
        motif.setCenterMotif();
    }

    public ArrayList<ModeleBase> getAllPartners(int indice) {
        ArrayList<ModeleBase> result = new ArrayList<ModeleBase>();
        ModeleBase me = this.getBaseAt(indice);
        int i = me.getElementStructure();
        if (i != -1) {
            result.add(this.getBaseAt(i));
        }
        ArrayList<ModeleBP> msbps = this.getAuxBPs(indice);
        for (ModeleBP m : msbps) {
            result.add(m.getPartner(me));
        }
        return result;
    }

    public int get_drawMode() {
        return this._drawMode;
    }

    public void setDrawMode(int drawMode) {
        this._drawMode = drawMode;
    }

    public void setRNA(String seq, String str) throws ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses {
        this.setRNA(RNA.explodeSequence(seq), str);
    }

    public void setRNA(String[] seq, int[] str) throws ExceptionFileFormatOrSyntax {
        this.setRNA(seq, str, 1);
    }

    public void setRNA(List<String> seq, int[] str) throws ExceptionFileFormatOrSyntax {
        this.setRNA(seq.toArray(new String[seq.size()]), str, 1);
    }

    public void setRNA(List<String> seq, int[] str, int baseIndex) throws ExceptionFileFormatOrSyntax {
        this.setRNA(seq.toArray(new String[seq.size()]), str, baseIndex);
    }

    public void setRNA(String[] seq, int[] str, int baseIndex) throws ExceptionFileFormatOrSyntax {
        this.clearAnnotations();
        this._listeBases = new ArrayList();
        if (seq.length != str.length) {
            int i;
            this.warningEmition("Sequence length " + seq.length + " differs from that of secondary structure " + str.length + ". \nAdapting sequence length ...");
            if (seq.length < str.length) {
                String[] nseq = new String[str.length];
                i = 0;
                while (i < seq.length) {
                    nseq[i] = seq[i];
                    ++i;
                }
                i = seq.length;
                while (i < nseq.length) {
                    nseq[i] = "";
                    ++i;
                }
                seq = nseq;
            } else {
                String[] seqTmp = new String[str.length];
                i = 0;
                while (i < str.length) {
                    seqTmp[i] = seq[i];
                    ++i;
                }
                seq = seqTmp;
            }
        }
        int i = 0;
        while (i < str.length) {
            this._listeBases.add(new ModeleBaseNucleotide(seq[i], i, baseIndex + i));
            ++i;
        }
        this.applyStruct(str);
    }

    public void setRNA(String seq, String struct, ArrayList<Integer> basesOwn) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        this.clearAnnotations();
        this._listeBases = new ArrayList();
        int[] array_struct = this.parseStruct(struct);
        int size = struct.length();
        int j = 0;
        int i = 0;
        while (i < size) {
            ModeleBase mb;
            if (seq.charAt(j) != seq.charAt(j + 1)) {
                ModeleBasesComparison mbc = new ModeleBasesComparison(seq.charAt(j), seq.charAt(j + 1), i);
                mbc.set_appartenance(basesOwn.get(i));
                mbc.setBaseNumber(i + 1);
                mb = mbc;
            } else {
                mb = new ModeleBaseNucleotide("" + seq.charAt(j), i, i + 1);
            }
            this._listeBases.add(mb);
            j += 2;
            ++i;
        }
        i = 0;
        while (i < size) {
            if (array_struct[i] != -1) {
                this.addBP(i, array_struct[i]);
            }
            j += 2;
            ++i;
        }
    }

    public void setRNA(List<String> seq, String dbnStr) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        this.clearAnnotations();
        String parDBN = dbnStr.replace('(', '(').replace(')', ')').replace('[', ':').replace(']', ':').replace('{', ':').replace('}', ':').replace('<', ':').replace('>', ':');
        String braDBN = dbnStr.replace('(', ':').replace(')', ':').replace('[', '(').replace(']', ')').replace('{', ':').replace('}', ':').replace('<', ':').replace('>', ':');
        String accDBN = dbnStr.replace('(', ':').replace(')', ':').replace('[', ':').replace(']', ':').replace('{', '(').replace('}', ')').replace('<', ':').replace('>', ':');
        String cheDBN = dbnStr.replace('(', ':').replace(')', ':').replace('[', ':').replace(']', ':').replace('{', ':').replace('}', ':').replace('<', '(').replace('>', ')');
        int[] parStr = this.parseStruct(parDBN);
        int[] braStr = this.parseStruct(braDBN);
        int[] accStr = this.parseStruct(accDBN);
        int[] cheStr = this.parseStruct(cheDBN);
        int[] finStr = new int[parStr.length];
        int i = 0;
        while (i < parStr.length) {
            finStr[i] = -1;
            ++i;
        }
        i = 0;
        while (i < parStr.length) {
            if (parStr[i] > i) {
                finStr[i] = parStr[i];
                finStr[finStr[i]] = i;
            } else if (braStr[i] > i) {
                if (parStr[i] == -1 && parStr[braStr[i]] == -1) {
                    finStr[i] = braStr[i];
                    finStr[finStr[i]] = i;
                }
            } else if (accStr[i] > i) {
                if (parStr[i] == -1 && parStr[accStr[i]] == -1 && braStr[i] == -1 && braStr[accStr[i]] == -1) {
                    finStr[i] = accStr[i];
                    finStr[finStr[i]] = i;
                }
            } else if (cheStr[i] > i && parStr[i] == -1 && parStr[cheStr[i]] == -1 && braStr[i] == -1 && braStr[cheStr[i]] == -1 && accStr[i] == -1 && accStr[cheStr[i]] == -1) {
                finStr[i] = cheStr[i];
                finStr[cheStr[i]] = i;
            }
            ++i;
        }
        this.setRNA(seq, finStr);
    }

    public static ArrayList<String> explodeSequence(String seq) {
        ArrayList<String> analyzedSeq = new ArrayList<String>();
        int i = 0;
        while (i < seq.length()) {
            if (seq.charAt(i) == '{') {
                boolean found = false;
                String buf = "";
                ++i;
                while (!found & i < seq.length()) {
                    if (seq.charAt(i) != '}') {
                        buf = String.valueOf(buf) + seq.charAt(i);
                        ++i;
                        continue;
                    }
                    found = true;
                }
                analyzedSeq.add(buf);
            } else {
                analyzedSeq.add("" + seq.charAt(i));
            }
            ++i;
        }
        return analyzedSeq;
    }

    public int[] parseStruct(String str) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        int[] result = new int[str.length()];
        int unexpectedChar = -1;
        Stack<Integer> p = new Stack<Integer>();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '(') {
                p.push(new Integer(i));
            } else if (c == '.' || c == '-' || c == ':') {
                result[i] = -1;
            } else if (c == ')') {
                int j;
                if (p.size() == 0) {
                    throw new ExceptionUnmatchedClosingParentheses(i + 1);
                }
                result[i] = j = ((Integer)p.pop()).intValue();
                result[j] = i;
            } else {
                if (unexpectedChar != -1) break;
                unexpectedChar = i;
                break;
            }
            ++i;
        }
        if (p.size() != 0) {
            throw new ExceptionUnmatchedClosingParentheses((Integer)p.pop() + 1);
        }
        return result;
    }

    public Point getHelixInterval(int index) {
        if (index < 0 || index >= this._listeBases.size()) {
            return new Point(index, index);
        }
        int j = this._listeBases.get(index).getElementStructure();
        if (j != -1) {
            int minH = index;
            int maxH = index;
            if (j > index) {
                maxH = j;
            } else {
                minH = j;
            }
            boolean over = false;
            while (!over) {
                if (minH < 0 || maxH >= this._listeBases.size()) {
                    over = true;
                    continue;
                }
                if (this._listeBases.get(minH).getElementStructure() == maxH) {
                    --minH;
                    ++maxH;
                    continue;
                }
                over = true;
            }
            return new Point(++minH, --maxH);
        }
        return new Point(0, 0);
    }

    public ArrayList<Integer> getHelix(int index) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (index < 0 || index >= this._listeBases.size()) {
            return result;
        }
        Point p = this.getHelixInterval(index);
        int i = p.x;
        while (i <= p.y) {
            result.add(i);
            result.add(this._listeBases.get(i).getElementStructure());
            ++i;
        }
        return result;
    }

    public Point getMultiLoop(int index) {
        if (index < 0 || index >= this._listeBases.size()) {
            return new Point(index, index);
        }
        Point h = this.getHelixInterval(index);
        int minH = h.x - 1;
        int maxH = h.y + 1;
        boolean over = false;
        while (!over) {
            if (minH < 0) {
                over = true;
                minH = 0;
                continue;
            }
            if (this._listeBases.get(minH).getElementStructure() == -1) {
                --minH;
                continue;
            }
            if (this._listeBases.get(minH).getElementStructure() < minH) {
                minH = this._listeBases.get(minH).getElementStructure() - 1;
                continue;
            }
            over = true;
        }
        over = false;
        while (!over) {
            if (maxH > this._listeBases.size() - 1) {
                over = true;
                maxH = this._listeBases.size() - 1;
                continue;
            }
            if (this._listeBases.get(maxH).getElementStructure() == -1) {
                ++maxH;
                continue;
            }
            if (this._listeBases.get(maxH).getElementStructure() > maxH) {
                maxH = this._listeBases.get(maxH).getElementStructure() + 1;
                continue;
            }
            over = true;
        }
        return new Point(minH, maxH);
    }

    public Vector<Integer> getLoopBases(int startIndex) {
        Vector<Integer> result = new Vector<Integer>();
        if (startIndex < 0 || startIndex >= this._listeBases.size()) {
            return result;
        }
        int index = startIndex;
        result.add(startIndex);
        if (this._listeBases.get(index).getElementStructure() <= index) {
            index = (index + 1) % this._listeBases.size();
        } else {
            index = this._listeBases.get(index).getElementStructure();
            result.add(index);
            index = (index + 1) % this._listeBases.size();
        }
        while (index != startIndex) {
            result.add(index);
            if (this._listeBases.get(index).getElementStructure() == -1) {
                index = (index + 1) % this._listeBases.size();
                continue;
            }
            index = this._listeBases.get(index).getElementStructure();
            result.add(index);
            index = (index + 1) % this._listeBases.size();
        }
        return result;
    }

    public String getStructDBN() {
        String result = "";
        int i = 0;
        while (i < this._listeBases.size()) {
            int j = this._listeBases.get(i).getElementStructure();
            result = j == -1 ? String.valueOf(result) + "." : (i > j ? String.valueOf(result) + ")" : String.valueOf(result) + "(");
            ++i;
        }
        return result;
    }

    public ArrayList<int[]> paginateStructure() {
        ArrayList<int[]> result = new ArrayList<int[]>();
        ArrayList<ModeleBP> bps = this.getAllBPs();
        ModeleBP[] mt = new ModeleBP[bps.size()];
        bps.toArray(mt);
        Arrays.sort(mt, new Comparator<ModeleBP>(){

            @Override
            public int compare(ModeleBP arg0, ModeleBP arg1) {
                if (arg0.getIndex5() != arg1.getIndex5()) {
                    return arg0.getIndex5() - arg1.getIndex5();
                }
                return arg0.getIndex3() - arg1.getIndex3();
            }
        });
        bps = new ArrayList();
        int i = 0;
        while (i < mt.length) {
            bps.add(mt[i]);
            ++i;
        }
        while (bps.size() != 0) {
            ArrayList<ModeleBP> currentBPs = new ArrayList<ModeleBP>();
            Stack<Integer> pile = new Stack<Integer>();
            int[] ss = new int[this.getSize()];
            int i2 = 0;
            while (i2 < ss.length) {
                ss[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < bps.size()) {
                ModeleBP bp = bps.get(i2);
                boolean ok = true;
                if (!pile.empty()) {
                    int x = (Integer)pile.peek();
                    if (bp.getIndex5() <= x && bp.getIndex3() >= x || ss[bp.getIndex5()] != -1) {
                        ok = false;
                    }
                }
                if (ok) {
                    ss[bp.getIndex5()] = bp.getIndex3();
                    ss[bp.getIndex3()] = bp.getIndex5();
                    currentBPs.add(bp);
                    pile.add(bp.getIndex3());
                }
                if (!pile.empty() && i2 == (Integer)pile.peek()) {
                    pile.pop();
                }
                ++i2;
            }
            bps.removeAll(currentBPs);
            result.add(ss);
        }
        return result;
    }

    public String getStructDBN(boolean includeMostPKs) {
        String result = this.getStructDBN();
        if (includeMostPKs) {
            ArrayList<int[]> pages = this.paginateStructure();
            char[] res = new char[this.getSize()];
            int i = 0;
            while (i < res.length) {
                res[i] = 46;
                ++i;
            }
            System.out.println(pages.size());
            char[] open = new char[]{'(', '[', '{', '<'};
            char[] close = new char[]{')', ']', '}', '>'};
            int p = 0;
            while (p < Math.min(pages.size(), open.length)) {
                int[] page = pages.get(p);
                int i2 = 0;
                while (i2 < res.length) {
                    if (page[i2] != -1 && page[i2] > i2 && res[i2] == '.' && res[page[i2]] == '.') {
                        res[i2] = open[p];
                        res[page[i2]] = close[p];
                    }
                    ++i2;
                }
                ++p;
            }
            result = "";
            int i3 = 0;
            while (i3 < res.length) {
                result = String.valueOf(result) + res[i3];
                ++i3;
            }
        }
        return result;
    }

    public String getStructDBN(int[] str) {
        String result = "";
        int i = 0;
        while (i < str.length) {
            result = str[i] == -1 ? String.valueOf(result) + "." : (str[i] > i ? String.valueOf(result) + "(" : String.valueOf(result) + ")");
            ++i;
        }
        return result;
    }

    public String getSeq() {
        String result = "";
        int i = 0;
        while (i < this._listeBases.size()) {
            result = String.valueOf(result) + this._listeBases.get(i).getContent();
            ++i;
        }
        return result;
    }

    public String getStructBPSEQ() {
        String result = "";
        int[] str = this.getNonOverlappingStruct();
        int i = 0;
        while (i < this._listeBases.size()) {
            result = String.valueOf(result) + (i + 1) + " " + ((ModeleBaseNucleotide)this._listeBases.get(i)).getContent() + " " + (str[i] + 1) + "\n";
            ++i;
        }
        return result;
    }

    public int[] getNonCrossingStruct() {
        int[] result = new int[this._listeBases.size()];
        int i = 0;
        while (i < this._listeBases.size()) {
            result[i] = this._listeBases.get(i).getElementStructure();
            ++i;
        }
        return result;
    }

    public int[] getNonOverlappingStruct() {
        int[] result = this.getNonCrossingStruct();
        int i = 0;
        while (i < this._structureAux.size()) {
            ModeleBP msbp = this._structureAux.get(i);
            ModeleBase mb5 = msbp.getPartner5();
            ModeleBase mb3 = msbp.getPartner3();
            int j5 = mb5.getIndex();
            int j3 = mb3.getIndex();
            if (result[j3] == -1 && result[j5] == -1) {
                result[j3] = j5;
                result[j5] = j3;
            }
            ++i;
        }
        return result;
    }

    public String getStructCT() {
        String result = "";
        int i = 0;
        while (i < this._listeBases.size()) {
            result = String.valueOf(result) + (i + 1) + " " + this._listeBases.get(i).getContent() + " " + i + " " + (i + 2) + " " + (this._listeBases.get(i).getElementStructure() + 1) + " " + (i + 1) + "\n";
            ++i;
        }
        return result;
    }

    public void saveAsBPSEQ(String path, String title) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter f = new FileWriter(path);
            f.write("# " + title + "\n");
            f.write(String.valueOf(this.getStructBPSEQ()) + "\n");
            f.close();
        }
        catch (IOException e) {
            throw new ExceptionExportFailed(e.getMessage(), path);
        }
    }

    public void saveAsCT(String path, String title) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter f = new FileWriter(path);
            f.write(this._listeBases.size() + " " + title + "\n");
            f.write(String.valueOf(this.getStructCT()) + "\n");
            f.close();
        }
        catch (IOException e) {
            throw new ExceptionExportFailed(e.getMessage(), path);
        }
    }

    public void saveAsDBN(String path, String title) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter f = new FileWriter(path);
            f.write("> " + title + "\n");
            f.write(String.valueOf(this.getListeBasesToString()) + "\n");
            f.write(String.valueOf(this.getStructDBN()) + "\n");
            f.close();
        }
        catch (IOException e) {
            throw new ExceptionExportFailed(e.getMessage(), path);
        }
    }

    public String getListeBasesToString() {
        String s = new String();
        int i = 0;
        while (i < this._listeBases.size()) {
            s = String.valueOf(s) + ((ModeleBaseNucleotide)this._listeBases.get(i)).getContent();
            ++i;
        }
        return s;
    }

    public void applyBPs(ArrayList<ModeleBP> allbps) {
        ArrayList<ModeleBP> planar = new ArrayList<ModeleBP>();
        ArrayList<ModeleBP> others = new ArrayList<ModeleBP>();
        RNAMLParser.planarize(allbps, planar, others, this.getSize());
        for (ModeleBP mb : planar) {
            this.addBP(mb.getPartner5().getIndex(), mb.getPartner3().getIndex(), mb);
        }
        for (ModeleBP mb : others) {
            this.addBPAux(mb.getPartner5().getIndex(), mb.getPartner3().getIndex(), mb);
        }
    }

    public void set_listeBases(ArrayList<ModeleBase> _liste) {
        this._listeBases = _liste;
    }

    @Override
    public void addVARNAListener(InterfaceVARNAListener rl) {
        this._listeVARNAListener.add(rl);
    }

    public void warningEmition(String warningMessage) {
        int i = 0;
        while (i < this._listeVARNAListener.size()) {
            this._listeVARNAListener.get(i).onWarningEmitted(warningMessage);
            ++i;
        }
    }

    public void applyStyleOnBases(ArrayList<Integer> basesList, ModeleStyleBase style) {
        int i = 1;
        while (i < basesList.size()) {
            this._listeBases.get(basesList.get(i)).setStyleBase(style);
            ++i;
        }
    }

    private int[] correctReciprocity(int[] str) {
        int[] result = new int[str.length];
        int i = 0;
        while (i < str.length) {
            if (str[i] != -1) {
                if (i == str[str[i]]) {
                    result[i] = str[i];
                } else {
                    str[str[i]] = i;
                }
            } else {
                result[i] = -1;
            }
            ++i;
        }
        return result;
    }

    private void applyStruct(int[] str) throws ExceptionFileFormatOrSyntax {
        str = this.correctReciprocity(str);
        int[] planarSubset = RNAMLParser.planarize(str);
        this._structureAux.clear();
        int i = 0;
        while (i < planarSubset.length) {
            if (str[i] > i) {
                if (planarSubset[i] > i) {
                    this.addBP(i, planarSubset[i]);
                } else if (planarSubset[i] != str[i]) {
                    this.addBPAux(i, str[i]);
                }
            }
            ++i;
        }
    }

    public ArrayList<ModeleBase> get_listeBases() {
        return this._listeBases;
    }

    public int getSize() {
        return this._listeBases.size();
    }

    public ArrayList<Integer> findAll() {
        ArrayList<Integer> listAll = new ArrayList<Integer>();
        int i = 0;
        while (i < this.get_listeBases().size()) {
            listAll.add(i);
            ++i;
        }
        return listAll;
    }

    public ArrayList<Integer> findBulge(int index) {
        ArrayList<Integer> listUp = new ArrayList<Integer>();
        if (this.get_listeBases().get(index).getElementStructure() == -1) {
            int j;
            int i = index;
            boolean over = false;
            while (i < this.get_listeBases().size() && !over) {
                j = this.get_listeBases().get(i).getElementStructure();
                if (j == -1) {
                    listUp.add(i);
                    ++i;
                    continue;
                }
                over = true;
            }
            i = index - 1;
            over = false;
            while (i >= 0 && !over) {
                j = this.get_listeBases().get(i).getElementStructure();
                if (j == -1) {
                    listUp.add(i);
                    --i;
                    continue;
                }
                over = true;
            }
        }
        return listUp;
    }

    public ArrayList<Integer> findStem(int index) {
        int j;
        ArrayList<Integer> listUp = new ArrayList<Integer>();
        int i = index;
        do {
            listUp.add(i);
        } while ((i = (j = this.get_listeBases().get(i).getElementStructure()) == -1 ? (i + 1) % this.getSize() : (j < i && index <= i && j <= index ? j : (i + 1) % this.getSize())) != index);
        return listUp;
    }

    public int getHelixCountOnLoop(int indice) {
        int cptHelice = 0;
        if (indice < 0 || indice >= this.get_listeBases().size()) {
            return cptHelice;
        }
        int i = indice;
        int j = this.get_listeBases().get(i).getElementStructure();
        boolean justJumped = false;
        if (j != -1 && j < i) {
            indice = i = j + 1;
        }
        do {
            if ((j = this.get_listeBases().get(i).getElementStructure()) != -1 && !justJumped) {
                i = j;
                justJumped = true;
                ++cptHelice;
                continue;
            }
            i = (i + 1) % this.get_listeBases().size();
            justJumped = false;
        } while (i != indice);
        return cptHelice;
    }

    public ArrayList<Integer> findLoop(int indice) {
        return this.findLoopForward(indice);
    }

    public ArrayList<Integer> findLoopForward(int indice) {
        ArrayList<Integer> base = new ArrayList<Integer>();
        if (indice < 0 || indice >= this.get_listeBases().size()) {
            return base;
        }
        int i = indice;
        int j = this.get_listeBases().get(i).getElementStructure();
        boolean justJumped = false;
        if (j != -1) {
            indice = i = Math.min(i, j) + 1;
        }
        do {
            base.add(i);
            j = this.get_listeBases().get(i).getElementStructure();
            if (j != -1 && !justJumped) {
                i = j;
                justJumped = true;
                continue;
            }
            i = (i + 1) % this.get_listeBases().size();
            justJumped = false;
        } while (i != indice);
        return base;
    }

    public ArrayList<Integer> findPair(int indice) {
        ArrayList<Integer> base = new ArrayList<Integer>();
        int j = this.get_listeBases().get(indice).getElementStructure();
        if (j != -1) {
            base.add(Math.min(indice, j));
            base.add(Math.max(indice, j));
        }
        return base;
    }

    public ArrayList<Integer> findLoopBackward(int indice) {
        ArrayList<Integer> base = new ArrayList<Integer>();
        if (indice < 0 || indice >= this.get_listeBases().size()) {
            return base;
        }
        int i = indice;
        int j = this.get_listeBases().get(i).getElementStructure();
        boolean justJumped = false;
        if (j != -1) {
            indice = i = Math.min(i, j) - 1;
        }
        if (i < 0) {
            return base;
        }
        do {
            base.add(i);
            j = this.get_listeBases().get(i).getElementStructure();
            if (j != -1 && !justJumped) {
                i = j;
                justJumped = true;
                continue;
            }
            i = (i + this.get_listeBases().size() - 1) % this.get_listeBases().size();
            justJumped = false;
        } while (i != indice);
        return base;
    }

    public ArrayList<Integer> findHelix(int indice) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.get_listeBases().get(indice).getElementStructure() != -1) {
            list.add(indice);
            list.add(this.get_listeBases().get(indice).getElementStructure());
            int i = 1;
            int prec = this.get_listeBases().get(indice).getElementStructure();
            while (indice + i < this.get_listeBases().size() && this.get_listeBases().get(indice + i).getElementStructure() != -1 && this.get_listeBases().get(indice + i).getElementStructure() == prec - 1) {
                list.add(indice + i);
                list.add(this.get_listeBases().get(indice + i).getElementStructure());
                prec = this.get_listeBases().get(indice + i).getElementStructure();
                ++i;
            }
            i = -1;
            prec = this.get_listeBases().get(indice).getElementStructure();
            while (indice + i >= 0 && this.get_listeBases().get(indice + i).getElementStructure() != -1 && this.get_listeBases().get(indice + i).getElementStructure() == prec + 1) {
                list.add(indice + i);
                list.add(this.get_listeBases().get(indice + i).getElementStructure());
                prec = this.get_listeBases().get(indice + i).getElementStructure();
                --i;
            }
        }
        return list;
    }

    public ArrayList<Integer> find3Prime(int indice) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean over = false;
        while (indice >= 0 && !over) {
            over = this.get_listeBases().get(indice).getElementStructure() != -1;
            --indice;
        }
        ++indice;
        if (over) {
            ++indice;
        }
        int i = indice;
        while (i < this.get_listeBases().size()) {
            list.add(i);
            if (this.get_listeBases().get(i).getElementStructure() != -1) {
                return new ArrayList<Integer>();
            }
            ++i;
        }
        return list;
    }

    public ArrayList<Integer> find5Prime(int indice) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i <= indice) {
            list.add(i);
            if (this.get_listeBases().get(i).getElementStructure() != -1) {
                return new ArrayList<Integer>();
            }
            ++i;
        }
        return list;
    }

    public Double get_spaceBetweenBases() {
        return this._spaceBetweenBases;
    }

    public void set_spaceBetweenBases(Double betweenBases) {
        this._spaceBetweenBases = betweenBases;
    }

    public static Double angle(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3) {
        Double alpha = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        Double beta = Math.atan2(p3.y - p2.y, p3.x - p2.x);
        Double angle = beta - alpha;
        while (angle < 0.0 || angle > Math.PI * 2) {
            if (angle < 0.0) {
                angle = angle + Math.PI * 2;
                continue;
            }
            if (!(angle > Math.PI * 2)) continue;
            angle = angle - Math.PI * 2;
        }
        return angle;
    }

    public ArrayList<Integer> findNonPairedBaseGroup(Integer get_nearestBase) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int indice = get_nearestBase;
        boolean nonpairedUp = true;
        boolean nonpairedDown = true;
        while (indice < this.get_listeBases().size() && nonpairedUp) {
            if (this.get_listeBases().get(indice).getElementStructure() == -1) {
                list.add(indice);
                ++indice;
                continue;
            }
            nonpairedUp = false;
        }
        indice = get_nearestBase - 1;
        while (indice >= 0 && nonpairedDown) {
            if (this.get_listeBases().get(indice).getElementStructure() == -1) {
                list.add(indice);
                --indice;
                continue;
            }
            nonpairedDown = false;
        }
        return list;
    }

    public boolean getDrawn() {
        return this._drawn;
    }

    public ArrayList<ModeleBP> getStructureAux() {
        return this._structureAux;
    }

    public int getIndexFromBaseNumber(int num) {
        int i = 0;
        while (i < this._listeBases.size()) {
            if (this._listeBases.get(i).getBaseNumber() == num) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addBPToStructureUsingNumbers(int baseNumber5, int baseNumber3) {
        int i = this.getIndexFromBaseNumber(baseNumber5);
        int j = this.getIndexFromBaseNumber(baseNumber3);
        this.addBPToStructure(i, j);
    }

    public void addBPToStructureUsingNumbers(int number5, int number3, ModeleBP msbp) {
        this.addBPToStructure(this.getIndexFromBaseNumber(number5), this.getIndexFromBaseNumber(number5), msbp);
    }

    public void addBPToStructure(int index5, int index3) {
        int i = index5;
        int j = index3;
        ModeleBase part5 = this._listeBases.get(i);
        ModeleBase part3 = this._listeBases.get(j);
        ModeleBP msbp = new ModeleBP(part5, part3);
        this.addBPToStructure(i, j, msbp);
    }

    public void addBPToStructure(int index5, int index3, ModeleBP msbp) {
        int k;
        int j = index3;
        int i = index5;
        if (j < i) {
            k = j;
            j = i;
            i = k;
        }
        if (i != -1) {
            if (this._listeBases.get(i).getElementStructure() != -1 || this._listeBases.get(j).getElementStructure() != -1) {
                this.addBPAux(i, j, msbp);
                return;
            }
            k = i + 1;
            while (k < j) {
                ModeleBase tmp = this._listeBases.get(k);
                int l = tmp.getElementStructure();
                if (l != -1 && (l <= i || l >= j)) {
                    this.addBPAux(i, j, msbp);
                    return;
                }
                ++k;
            }
            this.addBP(i, j, msbp);
        }
    }

    public void removeBP(ModeleBP ms) {
        if (this._structureAux.contains(ms)) {
            this._structureAux.remove(ms);
        } else {
            ModeleBase m5 = ms.getPartner5();
            ModeleBase m3 = ms.getPartner3();
            int i = m5.getIndex();
            int j = m3.getIndex();
            if (m5.getElementStructure() == m3.getIndex() && m3.getElementStructure() == m5.getIndex()) {
                m5.removeElementStructure();
                m3.removeElementStructure();
            }
        }
    }

    public void addBP(int i, int j) {
        if (j < i) {
            int k = j;
            j = i;
            i = k;
        }
        ModeleBase part5 = this._listeBases.get(i);
        ModeleBase part3 = this._listeBases.get(j);
        ModeleBP msbp = new ModeleBP(part5, part3);
        this.addBP(i, j, msbp);
    }

    public void addBP(int i, int j, ModeleBP msbp) {
        if (j < i) {
            int k = j;
            j = i;
            i = k;
        }
        ModeleBase part5 = this._listeBases.get(i);
        ModeleBase part3 = this._listeBases.get(j);
        msbp.setPartner5(part5);
        msbp.setPartner3(part3);
        part5.setElementStructure(j, msbp);
        part3.setElementStructure(i, msbp);
    }

    public void addBPAux(int i, int j) {
        ModeleBase part5 = this._listeBases.get(i);
        ModeleBase part3 = this._listeBases.get(j);
        ModeleBP msbp = new ModeleBP(part5, part3);
        this.addBPAux(i, j, msbp);
    }

    public void addBPAux(int i, int j, ModeleBP msbp) {
        if (j < i) {
            int k = j;
            j = i;
            i = k;
        }
        ModeleBase part5 = this._listeBases.get(i);
        ModeleBase part3 = this._listeBases.get(j);
        msbp.setPartner5(part5);
        msbp.setPartner3(part3);
        this._structureAux.add(msbp);
    }

    public ArrayList<ModeleBP> getBPsAt(int i) {
        ArrayList<ModeleBP> result = new ArrayList<ModeleBP>();
        if (this._listeBases.get(i).getElementStructure() != -1) {
            result.add(this._listeBases.get(i).getStyleBP());
        }
        int k = 0;
        while (k < this._structureAux.size()) {
            ModeleBP bp = this._structureAux.get(k);
            if (bp.getPartner5().getIndex() == i || bp.getPartner3().getIndex() == i) {
                result.add(bp);
            }
            ++k;
        }
        return result;
    }

    public ModeleBP getBPStyle(int i, int j) {
        int k;
        ModeleBP result = null;
        if (i > j) {
            k = j;
            j = i;
            i = k;
        }
        if (this._listeBases.get(i).getElementStructure() == j) {
            result = this._listeBases.get(i).getStyleBP();
        }
        k = 0;
        while (k < this._structureAux.size()) {
            ModeleBP bp = this._structureAux.get(k);
            if (bp.getPartner5().getIndex() == i && bp.getPartner3().getIndex() == j) {
                result = bp;
            }
            ++k;
        }
        return result;
    }

    public ArrayList<ModeleBP> getSecStrBPs() {
        ArrayList<ModeleBP> result = new ArrayList<ModeleBP>();
        int i = 0;
        while (i < this.getSize()) {
            ModeleBase mb = this._listeBases.get(i);
            int k = mb.getElementStructure();
            if (k != -1 && k > i) {
                result.add(mb.getStyleBP());
            }
            ++i;
        }
        return result;
    }

    public ArrayList<ModeleBP> getAuxBPs() {
        ArrayList<ModeleBP> result = new ArrayList<ModeleBP>();
        for (ModeleBP bp : this._structureAux) {
            result.add(bp);
        }
        return result;
    }

    public ArrayList<ModeleBP> getAllBPs() {
        ArrayList<ModeleBP> result = new ArrayList<ModeleBP>();
        result.addAll(this.getSecStrBPs());
        result.addAll(this.getAuxBPs());
        return result;
    }

    public ArrayList<ModeleBP> getAuxBPs(int i) {
        ArrayList<ModeleBP> result = new ArrayList<ModeleBP>();
        for (ModeleBP bp : this._structureAux) {
            if (bp.getPartner5().getIndex() != i && bp.getPartner3().getIndex() != i) continue;
            result.add(bp);
        }
        return result;
    }

    public void setBaseInnerColor(Color c) {
        int i = 0;
        while (i < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(i);
            mb.getStyleBase().set_base_inner_color(c);
            ++i;
        }
    }

    public void setBaseNumbersColor(Color c) {
        int i = 0;
        while (i < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(i);
            mb.getStyleBase().set_base_number_color(c);
            ++i;
        }
    }

    public void setBaseNameColor(Color c) {
        int i = 0;
        while (i < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(i);
            mb.getStyleBase().set_base_name_color(c);
            ++i;
        }
    }

    public void setBaseOutlineColor(Color c) {
        int i = 0;
        while (i < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(i);
            mb.getStyleBase().set_base_outline_color(c);
            ++i;
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String n) {
        this._name = n;
    }

    public ArrayList<TextAnnotation> getAnnotations() {
        return this._listeAnnotations;
    }

    public boolean removeAnnotation(TextAnnotation t) {
        return this._listeAnnotations.remove(t);
    }

    public void addAnnotation(TextAnnotation t) {
        this._listeAnnotations.add(t);
    }

    public void removeAnnotation(String filter) {
        ArrayList<TextAnnotation> condamne = new ArrayList<TextAnnotation>();
        for (TextAnnotation t : this._listeAnnotations) {
            if (!t.getTexte().contains(filter)) continue;
            condamne.add(t);
        }
        for (TextAnnotation t : condamne) {
            this._listeAnnotations.remove(t);
        }
    }

    public void clearAnnotations() {
        this._listeAnnotations.clear();
    }

    public void autoAnnotateStrandEnds() {
        if (!this._strandEndsAnnotated) {
            int tailleListBases = this._listeBases.size();
            boolean endAnnotate = false;
            this.addAnnotation(new TextAnnotation("5'", this._listeBases.get(0)));
            int i = 0;
            while (i < this._listeBases.size() - 1) {
                int realposA = this._listeBases.get(i).getBaseNumber();
                int realposB = this._listeBases.get(i + 1).getBaseNumber();
                if (realposB - realposA != 1) {
                    this.addAnnotation(new TextAnnotation("3'", this._listeBases.get(i)));
                    this.addAnnotation(new TextAnnotation("5'", this._listeBases.get(i + 1)));
                    if (i + 1 == this._listeBases.size() - 1) {
                        endAnnotate = true;
                    }
                }
                ++i;
            }
            if (!endAnnotate) {
                this.addAnnotation(new TextAnnotation("3'", this._listeBases.get(tailleListBases - 1)));
            }
            this._strandEndsAnnotated = true;
        } else {
            this.removeAnnotation("3'");
            this.removeAnnotation("5'");
            this._strandEndsAnnotated = false;
        }
    }

    public void autoAnnotateHelices() {
        Stack<Integer> p = new Stack<Integer>();
        p.push(0);
        int nbH = 1;
        while (!p.empty()) {
            int i = (Integer)p.pop();
            if (i >= this._listeBases.size()) continue;
            ModeleBase mb = this._listeBases.get(i);
            int j = mb.getElementStructure();
            if (j == -1) {
                p.push(i + 1);
                continue;
            }
            if (j <= i) continue;
            ModeleBase mbp = this._listeBases.get(j);
            p.push(j + 1);
            ArrayList<ModeleBase> h = new ArrayList<ModeleBase>();
            int k = 1;
            while (mb.getElementStructure() == mbp.getIndex()) {
                h.add(mb);
                h.add(mbp);
                mb = this._listeBases.get(i + k);
                mbp = this._listeBases.get(j - k);
                ++k;
            }
            try {
                this.addAnnotation(new TextAnnotation("H" + nbH++, h, 2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            p.push(i + k);
        }
    }

    public void autoAnnotateTerminalLoops() {
        Stack<Integer> p = new Stack<Integer>();
        p.push(0);
        int nbT = 1;
        while (!p.empty()) {
            int i = (Integer)p.pop();
            if (i >= this._listeBases.size()) continue;
            ModeleBase mb = this._listeBases.get(i);
            int j = mb.getElementStructure();
            if (j == -1) {
                int k = 1;
                ArrayList<ModeleBase> t = new ArrayList<ModeleBase>();
                while (i + k < this.getSize() && mb.getElementStructure() == -1) {
                    t.add(mb);
                    mb = this._listeBases.get(i + k);
                    ++k;
                }
                if (mb.getElementStructure() == -1) continue;
                if (mb.getElementStructure() == i - 1) {
                    try {
                        t.add(this._listeBases.get(i - 1));
                        t.add(this._listeBases.get(i + k - 1));
                        this.addAnnotation(new TextAnnotation("T" + nbT++, t, 3));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                p.push(i + k - 1);
                continue;
            }
            if (j <= i) continue;
            p.push(j + 1);
            p.push(i + 1);
        }
    }

    public void autoAnnotateInteriorLoops() {
        Stack<Integer> p = new Stack<Integer>();
        p.push(0);
        int nbT = 1;
        while (!p.empty()) {
            int i = (Integer)p.pop();
            if (i >= this._listeBases.size()) continue;
            ModeleBase mb = this._listeBases.get(i);
            int j = mb.getElementStructure();
            if (j == -1) {
                int k = i + 1;
                ArrayList<ModeleBase> t = new ArrayList<ModeleBase>();
                boolean terminal = true;
                while (k < this.getSize() && (mb.getElementStructure() >= i || mb.getElementStructure() == -1)) {
                    t.add(mb);
                    mb = this._listeBases.get(k);
                    if (mb.getElementStructure() == -1 || mb.getElementStructure() < k) {
                        ++k;
                        continue;
                    }
                    p.push(k);
                    terminal = false;
                    k = mb.getElementStructure();
                }
                if (mb.getElementStructure() == -1 || mb.getElementStructure() != i - 1 || terminal) continue;
                try {
                    t.add(this._listeBases.get(i - 1));
                    t.add(this._listeBases.get(k - 1));
                    this.addAnnotation(new TextAnnotation("I" + nbT++, t, 3));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                p.push(k - 1);
                continue;
            }
            if (j <= i) continue;
            p.push(i + 1);
        }
    }

    public TextAnnotation getAnnotation(int type, ModeleBase base) {
        TextAnnotation result = null;
        for (TextAnnotation t : this._listeAnnotations) {
            if (t.getType() != type) continue;
            switch (type) {
                case 1: {
                    if (base != (ModeleBase)t.getAncrage()) break;
                    return t;
                }
                case 2: 
                case 3: {
                    ArrayList mbl = (ArrayList)t.getAncrage();
                    if (!mbl.contains(base)) break;
                    return t;
                }
            }
        }
        return result;
    }

    public void addChemProbAnnotation(ChemProbAnnotation cpa) {
        this._ChemProbAnnotations.add(cpa);
    }

    public ArrayList<ChemProbAnnotation> getChemProbAnnotations() {
        return this._ChemProbAnnotations;
    }

    public void setColorMapValues(Double[] values, ModeleColorMap cm) {
        this.setColorMapValues(values, cm, false);
    }

    public void adaptColorMapToValues(ModeleColorMap cm) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int i = 0;
        while (i < Math.min(this._listeBases.size(), this._listeBases.size())) {
            ModeleBase mb = this._listeBases.get(i);
            max = Math.max(max, mb.getValue());
            min = Math.min(min, mb.getValue());
            ++i;
        }
        cm.rescale(min, max);
    }

    public void readValues(Reader r, ModeleColorMap cm) {
        try {
            StreamTokenizer st = new StreamTokenizer(r);
            st.eolIsSignificant(true);
            ArrayList vals = new ArrayList();
            ArrayList<Double> curVals = new ArrayList<Double>();
            int type = st.nextToken();
            while (type != -1) {
                switch (type) {
                    case -2: {
                        curVals.add(st.nval);
                        break;
                    }
                    case 10: {
                        if (curVals.size() <= 0) break;
                        vals.add(curVals);
                        curVals = new ArrayList();
                    }
                }
                type = st.nextToken();
            }
            if (curVals.size() > 0) {
                vals.add(curVals);
            }
            Double[] v = new Double[vals.size()];
            int i = 0;
            while (i < Math.min(vals.size(), this.getSize())) {
                ArrayList tab = (ArrayList)vals.get(i);
                v[i] = (Double)tab.get(tab.size() - 1);
                ++i;
            }
            this.setColorMapValues(v, cm, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setColorMapValues(Double[] values, ModeleColorMap cm, boolean rescaleColorMap) {
        if (values.length > 0) {
            int i = 0;
            while (i < Math.min(values.length, this._listeBases.size())) {
                ModeleBase mb = this._listeBases.get(i);
                mb.setValue(values[i]);
                ++i;
            }
            if (rescaleColorMap) {
                this.adaptColorMapToValues(cm);
            }
        }
    }

    public Double[] getColorMapValues() {
        Double[] values = new Double[this._listeBases.size()];
        int i = 0;
        while (i < this._listeBases.size()) {
            values[i] = this._listeBases.get(i).getValue();
            ++i;
        }
        return values;
    }

    public void rescaleColorMap(ModeleColorMap cm) {
        Double max = Double.MIN_VALUE;
        Double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this._listeBases.size()) {
            Double value = this._listeBases.get(i).getValue();
            max = Math.max(max, value);
            min = Math.min(min, value);
            ++i;
        }
        cm.rescale(min, max);
    }

    public void setSequence(String s) {
        this.setSequence(RNA.explodeSequence(s));
    }

    public void setSequence(List<String> s) {
        int i = 0;
        int j = 0;
        while (i < s.size() && j < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(j);
            if (mb instanceof ModeleBaseNucleotide) {
                ((ModeleBaseNucleotide)mb).set_c(s.get(i));
                ++i;
                ++j;
                continue;
            }
            if (mb instanceof ModeleBasesComparison) {
                ((ModeleBasesComparison)mb).set_base1(Character.valueOf(s.get(i).length() > 0 ? s.get(i).charAt(0) : (char)' '));
                ((ModeleBasesComparison)mb).set_base2(Character.valueOf(s.get(i + 1).length() > 0 ? s.get(i + 1).charAt(0) : (char)' '));
                i += 2;
                ++j;
                continue;
            }
            ++j;
        }
    }

    public void eraseSequence() {
        int j = 0;
        while (j < this._listeBases.size()) {
            ModeleBase mb = this._listeBases.get(j);
            if (mb instanceof ModeleBaseNucleotide) {
                ((ModeleBaseNucleotide)mb).set_c("");
                ++j;
                continue;
            }
            if (mb instanceof ModeleBasesComparison) {
                ((ModeleBasesComparison)mb).set_base1(Character.valueOf(' '));
                ((ModeleBasesComparison)mb).set_base2(Character.valueOf(' '));
                ++j;
                continue;
            }
            ++j;
        }
    }

    public RNA clone() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(this);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
            return (RNA)in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot clone class [" + this.getClass().getName() + "] via serialization: " + e.toString());
        }
    }

    public ModeleBase getBaseAt(int index) {
        return this._listeBases.get(index);
    }

    public ArrayList<ModeleBase> getBasesAt(Collection<? extends Integer> indices) {
        ArrayList<ModeleBase> mbs = new ArrayList<ModeleBase>();
        Iterator<? extends Integer> iterator = indices.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            mbs.add(this.getBaseAt(i));
        }
        return mbs;
    }

    public ArrayList<ModeleBase> getBasesBetween(int from, int to) {
        ArrayList<ModeleBase> mbs = new ArrayList<ModeleBase>();
        int bck = Math.min(from, to);
        to = Math.max(from, to);
        int i = from = bck;
        while (i <= to) {
            mbs.add(this.getBaseAt(i));
            ++i;
        }
        return mbs;
    }

    public void addHighlightRegion(HighlightRegionAnnotation n) {
        this._listeRegionHighlights.add(n);
    }

    public void removeHighlightRegion(HighlightRegionAnnotation n) {
        this._listeRegionHighlights.remove(n);
    }

    public void removeChemProbAnnotation(ChemProbAnnotation a) {
        this._ChemProbAnnotations.remove(a);
    }

    public void addHighlightRegion(int from, int to, Color fill, Color outline, double radius) {
        this._listeRegionHighlights.add(new HighlightRegionAnnotation(this.getBasesBetween(from, to), fill, outline, radius));
    }

    public void addHighlightRegion(int from, int to) {
        this._listeRegionHighlights.add(new HighlightRegionAnnotation(this.getBasesBetween(from, to)));
    }

    public ArrayList<HighlightRegionAnnotation> getHighlightRegion() {
        return this._listeRegionHighlights;
    }

    public void globalRotation(Double angleDegres) {
        if (this._listeBases.size() > 0) {
            Double angle = angleDegres * Math.PI / 180.0;
            Double maxX = this._listeBases.get((int)0).getCoords().x;
            Double maxY = this._listeBases.get((int)0).getCoords().y;
            Double minX = this._listeBases.get((int)0).getCoords().x;
            Double minY = this._listeBases.get((int)0).getCoords().y;
            int i = 0;
            while (i < this._listeBases.size()) {
                if (this._listeBases.get(i).getCoords().getX() < minX) {
                    minX = this._listeBases.get(i).getCoords().getX();
                }
                if (this._listeBases.get(i).getCoords().getY() < minY) {
                    minY = this._listeBases.get(i).getCoords().getY();
                }
                if (this._listeBases.get(i).getCoords().getX() > maxX) {
                    maxX = this._listeBases.get(i).getCoords().getX();
                }
                if (this._listeBases.get(i).getCoords().getX() > maxY) {
                    maxY = this._listeBases.get(i).getCoords().getY();
                }
                ++i;
            }
            Point2D.Double centre = new Point2D.Double((maxX - minX) / 2.0, (maxY - minY) / 2.0);
            int i2 = 0;
            while (i2 < this._listeBases.size()) {
                Double x = Math.cos(angle) * (this._listeBases.get(i2).getCenter().getX() - centre.x) - Math.sin(angle) * (this._listeBases.get(i2).getCenter().getY() - centre.y) + centre.x;
                Double y = Math.sin(angle) * (this._listeBases.get(i2).getCenter().getX() - centre.x) + Math.cos(angle) * (this._listeBases.get(i2).getCenter().getY() - centre.y) + centre.y;
                this._listeBases.get(i2).setCenter(new Point2D.Double(x, y));
                x = Math.cos(angle) * (this._listeBases.get(i2).getCoords().getX() - centre.x) - Math.sin(angle) * (this._listeBases.get(i2).getCoords().getY() - centre.y) + centre.x;
                y = Math.sin(angle) * (this._listeBases.get(i2).getCoords().getX() - centre.x) + Math.cos(angle) * (this._listeBases.get(i2).getCoords().getY() - centre.y) + centre.y;
                this._listeBases.get(i2).setCoords(new Point2D.Double(x, y));
                ++i2;
            }
        }
    }

    public boolean testDirectionality(int i, int j, int k) {
        Point2D.Double pi = this.getCoords(i);
        Point2D.Double pj = this.getCoords(j);
        Point2D.Double pk = this.getCoords(k);
        return RNA.testDirectionality(pi, pj, pk);
    }

    public static boolean testDirectionality(Point2D.Double pi, Point2D.Double pj, Point2D.Double pk) {
        double test = (pj.x - pi.x) * (pk.y - pj.y) - (pj.y - pi.y) * (pk.x - pj.x);
        return test < 0.0;
    }

    public double getOrientation() {
        double maxDist = Double.MIN_VALUE;
        double angle = 0.0;
        int i = 0;
        while (i < this._listeBases.size()) {
            ModeleBase b1 = this._listeBases.get(i);
            int j = i + 1;
            while (j < this._listeBases.size()) {
                Point2D.Double p2;
                ModeleBase b2 = this._listeBases.get(j);
                Point2D.Double p1 = b1._coords.toPoint2D();
                double dist = p1.distance(p2 = b2._coords.toPoint2D());
                if (dist > maxDist) {
                    maxDist = dist;
                    angle = VueUI.computeAngle(p1, p2);
                }
                ++j;
            }
            ++i;
        }
        return angle;
    }

    public boolean hasVirtualLoops() {
        boolean consecutiveBPs = false;
        int i = 0;
        while (i < this._listeBases.size()) {
            int j = this._listeBases.get(i).getElementStructure();
            if (j == i + 1) {
                consecutiveBPs = true;
            }
            ++i;
        }
        return this._drawMode != 4 && this._drawMode != 1 && consecutiveBPs;
    }

    private static class ComputeArcCenter {
        private ComputeArcCenter() {
        }

        public static double computeArcCenter(double delta, double l) {
            double x_n = 0.0;
            int steps = 0;
            while (true) {
                double f_x_n = ComputeArcCenter.f(x_n, delta);
                double x_n_plus_1 = x_n - (f_x_n - l) / ComputeArcCenter.fprime(x_n, delta);
                double f_x_n_plus_1 = ComputeArcCenter.f(x_n_plus_1, delta);
                ++steps;
                if (x_n_plus_1 == Double.NEGATIVE_INFINITY || Math.abs(f_x_n_plus_1 - f_x_n) < 0.1) {
                    return x_n_plus_1;
                }
                x_n = x_n_plus_1;
                f_x_n = f_x_n_plus_1;
            }
        }

        public static double f(double c, double delta) {
            if (c < 0.0) {
                return 2.0 * Math.atan(delta / (-2.0 * c)) * Math.sqrt(delta * delta / 4.0 + c * c);
            }
            if (c != 0.0) {
                return (Math.PI * 2 - 2.0 * Math.atan(delta / (2.0 * c))) * Math.sqrt(delta * delta / 4.0 + c * c);
            }
            return Math.PI * Math.sqrt(delta * delta / 4.0 + c * c);
        }

        public static double fprime(double c, double delta) {
            if (c < 0.0) {
                return delta / (c * c + delta / 4.0) * Math.sqrt(delta * delta / 4.0 + c * c) + 2.0 * Math.atan(delta / (-2.0 * c)) * c / Math.sqrt(delta * delta / 4.0 + c * c);
            }
            if (c != 0.0) {
                return delta / (c * c + delta / 4.0) * Math.sqrt(delta * delta / 4.0 + c * c) + (Math.PI * 2 - 2.0 * Math.atan(delta / (-2.0 * c))) * c / Math.sqrt(delta * delta / 4.0 + c * c);
            }
            return 2.0;
        }
    }

    public static class DrawRNATemplateMethod {
        public static int NOADJUST = 0;
        public static int MAXSCALINGFACTOR = 1;
        public static int NOINTERSECT = 2;
        public static int HELIXTRANSLATE = 3;
    }
}

