/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.models.VARNAConfig;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;

public class ModeleStyleBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4331494086323517208L;
    private Color _base_outline_color;
    private Color _base_inner_color;
    private Color _base_number_color;
    private Color _base_name_color;
    private boolean _selected;
    public static final String PARAM_INNER_COLOR = "fill";
    public static final String PARAM_OUTLINE_COLOR = "outline";
    public static final String PARAM_TEXT_COLOR = "label";
    public static final String PARAM_NUMBER_COLOR = "number";

    public ModeleStyleBase clone() {
        ModeleStyleBase result = new ModeleStyleBase();
        result._base_inner_color = this._base_inner_color;
        result._base_name_color = this._base_name_color;
        result._base_number_color = this._base_number_color;
        result._base_outline_color = this._base_outline_color;
        result._selected = this._selected;
        return result;
    }

    public ModeleStyleBase() {
        this._base_outline_color = VARNAConfig.BASE_OUTLINE_COLOR_DEFAULT;
        this._base_inner_color = VARNAConfig.BASE_INNER_COLOR_DEFAULT;
        this._base_number_color = VARNAConfig.BASE_NUMBER_COLOR_DEFAULT;
        this._base_name_color = VARNAConfig.BASE_NAME_COLOR_DEFAULT;
        this._selected = false;
    }

    public ModeleStyleBase(Color outline, Color inner, Color number, Color name, Font font) {
        this._base_outline_color = outline;
        this._base_inner_color = inner;
        this._base_number_color = number;
        this._base_name_color = name;
    }

    public ModeleStyleBase(String parameterValue) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        this();
        this.assignParameters(parameterValue);
    }

    public ModeleStyleBase(ModeleStyleBase msb) {
        this._base_outline_color = msb.get_base_outline_color();
        this._base_inner_color = msb.get_base_inner_color();
        this._base_number_color = msb.get_base_number_color();
        this._base_name_color = msb.get_base_name_color();
    }

    public Color get_base_outline_color() {
        return this._base_outline_color;
    }

    public void set_base_outline_color(Color _base_outline_color) {
        this._base_outline_color = _base_outline_color;
    }

    public Color get_base_inner_color() {
        return this._base_inner_color;
    }

    public void set_base_inner_color(Color _base_inner_color) {
        this._base_inner_color = _base_inner_color;
    }

    public Color get_base_number_color() {
        return this._base_number_color;
    }

    public void set_base_number_color(Color _base_numbers_color) {
        this._base_number_color = _base_numbers_color;
    }

    public Color get_base_name_color() {
        return this._base_name_color;
    }

    public void set_base_name_color(Color _base_name_color) {
        this._base_name_color = _base_name_color;
    }

    public static Color getSafeColor(String col) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (NumberFormatException e) {
            result = Color.getColor(col, Color.green);
        }
        return result;
    }

    public void assignParameters(String parametersValue) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        if (parametersValue.equals("")) {
            return;
        }
        String[] parametersL = parametersValue.split(",");
        ArrayList<String> namesArray = new ArrayList<String>();
        ArrayList<String> valuesArray = new ArrayList<String>();
        int i = 0;
        while (i < parametersL.length) {
            String[] param = parametersL[i].split("=");
            if (param.length != 2) {
                throw new ExceptionModeleStyleBaseSyntaxError("Bad parameter: '" + param[0] + "' ...");
            }
            namesArray.add(param[0].replace(" ", ""));
            valuesArray.add(param[1].replace(" ", ""));
            ++i;
        }
        i = 0;
        while (i < namesArray.size()) {
            if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_INNER_COLOR)) {
                try {
                    this.set_base_inner_color(ModeleStyleBase.getSafeColor((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad inner color Syntax:" + (String)valuesArray.get(i));
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_TEXT_COLOR)) {
                try {
                    this.set_base_name_color(ModeleStyleBase.getSafeColor((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad name color Syntax:" + (String)valuesArray.get(i));
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_NUMBER_COLOR)) {
                try {
                    this.set_base_number_color(ModeleStyleBase.getSafeColor((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad numbers color Syntax:" + (String)valuesArray.get(i));
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_OUTLINE_COLOR)) {
                try {
                    this.set_base_outline_color(ModeleStyleBase.getSafeColor((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad outline color Syntax:" + (String)valuesArray.get(i));
                }
            } else {
                throw new ExceptionModeleStyleBaseSyntaxError("Unknown parameter:" + (String)namesArray.get(i));
            }
            ++i;
        }
    }

    public static Integer StyleToInteger(String s) {
        Integer style = s.toLowerCase().equals("italic") ? Integer.valueOf(2) : (s.toLowerCase().equals("bold") ? Integer.valueOf(1) : (s.toLowerCase().equals("plain") ? Integer.valueOf(0) : null));
        return style;
    }
}

