/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.models.rna.ModeleBPStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleStyleBase;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeleBP
implements Serializable,
Comparable<ModeleBP> {
    private static final long serialVersionUID = -1344722280822711931L;
    private ModeleBase _partner5;
    private Edge _edge5;
    private ModeleBase _partner3;
    private Edge _edge3;
    private Stericity _stericity;
    private ModeleBPStyle _style;
    public static final String PARAM_COLOR = "color";
    public static final String PARAM_THICKNESS = "thickness";
    public static final String PARAM_EDGE5 = "edge5";
    public static final String PARAM_EDGE3 = "edge3";
    public static final String PARAM_STERICITY = "stericity";
    public static final String VALUE_WATSON_CRICK = "wc";
    public static final String VALUE_HOOGSTEEN = "h";
    public static final String VALUE_SUGAR = "s";
    public static final String VALUE_CIS = "cis";
    public static final String VALUE_TRANS = "trans";

    public ModeleBP(ModeleBase part5, ModeleBase part3) {
        this(part5, part3, Edge.WATSON_CRICK, Edge.WATSON_CRICK, Stericity.CIS);
    }

    public ModeleBP(ModeleBase part5, ModeleBase part3, Edge edge5, Edge edge3, Stericity ster) {
        this._partner5 = part5;
        this._partner3 = part3;
        this._edge5 = edge5;
        this._edge3 = edge3;
        this._stericity = ster;
        this._style = new ModeleBPStyle();
    }

    public ModeleBP(String text) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        this._style = new ModeleBPStyle();
        this.assignParameters(text);
    }

    public void setStericity(Stericity s) {
        this._stericity = s;
    }

    public void setEdge5(Edge e) {
        this._edge5 = e;
    }

    public void setEdge3(Edge e) {
        this._edge3 = e;
    }

    public void setStyle(ModeleBPStyle e) {
        this._style = e;
    }

    public ModeleBPStyle getStyle() {
        return this._style;
    }

    public boolean isCanonicalGC() {
        String si = this._partner5.getContent();
        String sj = this._partner3.getContent();
        if (si.length() >= 1 && sj.length() >= 1) {
            char ci = si.toUpperCase().charAt(0);
            char cj = sj.toUpperCase().charAt(0);
            if (ci == 'G' && cj == 'C' || ci == 'C' && cj == 'G') {
                return this.isCanonical() && this.getStericity() == Stericity.CIS;
            }
        }
        return false;
    }

    public boolean isCanonicalAU() {
        String si = this._partner5.getContent();
        String sj = this._partner3.getContent();
        if (si.length() >= 1 && sj.length() >= 1) {
            char ci = si.toUpperCase().charAt(0);
            char cj = sj.toUpperCase().charAt(0);
            if (ci == 'A' && cj == 'U' || ci == 'U' && cj == 'A') {
                return this.isCanonical();
            }
        }
        return false;
    }

    public boolean isWobbleUG() {
        String si = this._partner5.getContent();
        String sj = this._partner3.getContent();
        if (si.length() >= 1 && sj.length() >= 1) {
            char ci = si.toUpperCase().charAt(0);
            char cj = sj.toUpperCase().charAt(0);
            if (ci == 'G' && cj == 'U' || ci == 'U' && cj == 'G') {
                return this.isCanonical();
            }
        }
        return false;
    }

    public boolean isCanonical() {
        return this._edge5 == Edge.WATSON_CRICK && this._edge3 == Edge.WATSON_CRICK && this._stericity == Stericity.CIS;
    }

    public Stericity getStericity() {
        return this._stericity;
    }

    public boolean isCIS() {
        return this._stericity == Stericity.CIS;
    }

    public boolean isTRANS() {
        return this._stericity == Stericity.TRANS;
    }

    public Edge getEdgePartner5() {
        return this._edge5;
    }

    public Edge getEdgePartner3() {
        return this._edge3;
    }

    public ModeleBase getPartner(ModeleBase mb) {
        if (mb == this._partner3) {
            return this._partner5;
        }
        return this._partner3;
    }

    public ModeleBase getPartner5() {
        return this._partner5;
    }

    public ModeleBase getPartner3() {
        return this._partner3;
    }

    public int getIndex5() {
        return this._partner5.getIndex();
    }

    public int getIndex3() {
        return this._partner3.getIndex();
    }

    public void setPartner5(ModeleBase mb) {
        this._partner5 = mb;
    }

    public void setPartner3(ModeleBase mb) {
        this._partner3 = mb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assignParameters(String parametersValue) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        if (parametersValue.equals("")) {
            return;
        }
        String[] parametersL = parametersValue.split(",");
        ArrayList<String> namesArray = new ArrayList<String>();
        ArrayList<String> valuesArray = new ArrayList<String>();
        int i = 0;
        while (i < parametersL.length) {
            String[] param = parametersL[i].split("=");
            if (param.length != 2) {
                throw new ExceptionModeleStyleBaseSyntaxError("Bad parameter: '" + param[0] + "' ...");
            }
            namesArray.add(param[0].replace(" ", ""));
            valuesArray.add(param[1].replace(" ", ""));
            ++i;
        }
        i = 0;
        while (i < namesArray.size()) {
            String s;
            if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_COLOR)) {
                try {
                    this._style.setCustomColor(ModeleStyleBase.getSafeColor((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad inner color Syntax:" + (String)valuesArray.get(i));
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_THICKNESS)) {
                try {
                    this._style.setThickness(Double.parseDouble((String)valuesArray.get(i)));
                }
                catch (NumberFormatException e) {
                    throw new ExceptionParameterError(e.getMessage(), "Bad value for bp thickness:" + (String)valuesArray.get(i));
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_EDGE5)) {
                s = (String)valuesArray.get(i);
                if (s.toLowerCase().equals(VALUE_WATSON_CRICK)) {
                    this.setEdge5(Edge.WATSON_CRICK);
                } else if (s.toLowerCase().equals(VALUE_HOOGSTEEN)) {
                    this.setEdge5(Edge.HOOGSTEEN);
                } else {
                    if (!s.toLowerCase().equals(VALUE_SUGAR)) throw new ExceptionParameterError("Bad value for edge:" + (String)valuesArray.get(i));
                    this.setEdge5(Edge.SUGAR);
                }
            } else if (((String)namesArray.get(i)).toLowerCase().equals(PARAM_EDGE3)) {
                s = (String)valuesArray.get(i);
                if (s.toLowerCase().equals(VALUE_WATSON_CRICK)) {
                    this.setEdge3(Edge.WATSON_CRICK);
                } else if (s.toLowerCase().equals(VALUE_HOOGSTEEN)) {
                    this.setEdge3(Edge.HOOGSTEEN);
                } else {
                    if (!s.toLowerCase().equals(VALUE_SUGAR)) throw new ExceptionParameterError("Bad value for edge:" + (String)valuesArray.get(i));
                    this.setEdge3(Edge.SUGAR);
                }
            } else {
                if (!((String)namesArray.get(i)).toLowerCase().equals(PARAM_STERICITY)) throw new ExceptionModeleStyleBaseSyntaxError("Unknown parameter:" + (String)namesArray.get(i));
                s = (String)valuesArray.get(i);
                if (s.toLowerCase().equals(VALUE_CIS)) {
                    this.setStericity(Stericity.CIS);
                } else {
                    if (!s.toLowerCase().equals(VALUE_TRANS)) throw new ExceptionParameterError("Bad value for stericity:" + (String)valuesArray.get(i));
                    this.setStericity(Stericity.TRANS);
                }
            }
            ++i;
        }
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "(" + this._partner5.getIndex() + "," + this._partner3.getIndex() + ")";
        return result;
    }

    @Override
    public int compareTo(ModeleBP mb) {
        if (this.getIndex5() != mb.getIndex5()) {
            return this.getIndex5() - mb.getIndex5();
        }
        return this.getIndex3() - mb.getIndex3();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        WATSON_CRICK,
        SUGAR,
        HOOGSTEEN;


        public String toString() {
            switch (this) {
                case WATSON_CRICK: {
                    return "Watson Crick";
                }
                case SUGAR: {
                    return "Sugar";
                }
                case HOOGSTEEN: {
                    return "Hoogsteen";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stericity {
        CIS,
        TRANS;


        public String toString() {
            switch (this) {
                case CIS: {
                    return "Cis";
                }
                case TRANS: {
                    return "Trans";
                }
            }
            return "";
        }
    }
}

