/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.MappingException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class Mapping
implements Serializable {
    private static final long serialVersionUID = -3031358968555310380L;
    public static final int UNKNOWN = -1;
    Hashtable<Integer, Integer> _mapping = new Hashtable();
    Hashtable<Integer, Integer> _invMapping = new Hashtable();

    public void addCouple(int i, int j) throws MappingException {
        if (this._mapping.containsKey(i) || this._invMapping.containsKey(j)) {
            throw new MappingException(1);
        }
        this._mapping.put(new Integer(i), new Integer(j));
        this._invMapping.put(new Integer(j), new Integer(i));
    }

    public int getPartner(int i) {
        if (!this._mapping.containsKey(i)) {
            return -1;
        }
        return this._mapping.get(i);
    }

    public int getAncestor(int j) {
        if (!this._invMapping.containsKey(j)) {
            return -1;
        }
        return this._invMapping.get(j);
    }

    public int[] getSourceElems() {
        int[] elems = new int[this._mapping.size()];
        Enumeration<Integer> en = this._mapping.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            int a;
            elems[i] = a = en.nextElement().intValue();
            ++i;
        }
        return elems;
    }

    public int[] getTargetElems() {
        int[] elems = new int[this._invMapping.size()];
        Enumeration<Integer> en = this._invMapping.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            int a;
            elems[i] = a = en.nextElement().intValue();
            ++i;
        }
        return elems;
    }

    public static Mapping readMappingFromAlignment(String m, String n) throws MappingException {
        Mapping map = new Mapping();
        if (m.length() != n.length()) {
            throw new MappingException(2);
        }
        int i = 0;
        int j = 0;
        int k = 0;
        while (k < m.length()) {
            char a = m.charAt(k);
            char b = n.charAt(k);
            if (a != '-' && a != ':' && b != '-' && b != ':') {
                map.addCouple(i, j);
            }
            if (a != '-' && a != ':') {
                ++j;
            }
            if (b != '-' && b != ':') {
                ++i;
            }
            ++k;
        }
        return map;
    }

    public static Mapping DefaultMapping(int n, int m) {
        Mapping map = new Mapping();
        try {
            int i = 0;
            while (i < Math.min(n, m)) {
                map.addCouple(i, i);
                ++i;
            }
        }
        catch (MappingException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Mapping DefaultOutermostMapping(int n, int m) {
        Mapping map = new Mapping();
        try {
            int k = Math.min(n, m);
            int i = 0;
            int j = 0;
            boolean pile = true;
            while (i <= k - 1 - j) {
                if (pile) {
                    map.addCouple(i, i);
                    ++i;
                } else {
                    map.addCouple(n - 1 - j, m - 1 - j);
                    ++j;
                }
                boolean bl = pile = !pile;
            }
        }
        catch (MappingException e) {
            e.printStackTrace();
        }
        return map;
    }

    public String toString() {
        Enumeration<Integer> en = this._mapping.keys();
        String tmp = "";
        int l1 = 0;
        int l2 = 0;
        int maxIndex = 0;
        while (en.hasMoreElements()) {
            Integer i = en.nextElement();
            Integer j = this._mapping.get(i);
            l1 = Math.max(l1, i);
            l2 = Math.max(l2, j);
            tmp = String.valueOf(tmp) + "(" + i + "," + j + ")";
        }
        maxIndex = Math.max(maxIndex, Math.max(l1, l2));
        String tmp1 = "";
        String tmp2 = "";
        en = this._mapping.keys();
        int i = l1;
        int j = l2;
        while (en.hasMoreElements()) {
            Integer a = en.nextElement();
            Integer b = this._mapping.get(a);
            while (a < i) {
                tmp1 = String.valueOf('x') + tmp1;
                tmp2 = String.valueOf('-') + tmp2;
                --i;
            }
            while (b < j) {
                tmp1 = String.valueOf('-') + tmp1;
                tmp2 = String.valueOf('x') + tmp2;
                --j;
            }
            tmp1 = String.valueOf('|') + tmp1;
            tmp2 = String.valueOf('|') + tmp2;
            --i;
            --j;
        }
        return String.valueOf(tmp) + "\n" + tmp1 + "\n" + tmp2;
    }
}

