/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.naView;

import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.naView.Base;
import fr.orsay.lri.varna.models.naView.Connection;
import fr.orsay.lri.varna.models.naView.Loop;
import fr.orsay.lri.varna.models.naView.Radloop;
import fr.orsay.lri.varna.models.naView.Region;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NAView {
    private final double ANUM = 9999.0;
    private final int MAXITER = 500;
    private ArrayList<Base> bases;
    private int nbase;
    private int nregion;
    private int loop_count;
    private Loop root = new Loop();
    private ArrayList<Loop> loops;
    private ArrayList<Region> regions;
    private Radloop rlphead = new Radloop();
    private double lencut = 0.8;
    private final double RADIUS_REDUCTION_FACTOR = 1.4;
    private boolean debug = false;
    private double angleinc;
    private double _h;
    private ArrayList<InterfaceVARNAListener> _listeVARNAListener = new ArrayList();
    private boolean noIterationFailureYet = true;
    double HELIX_FACTOR = 0.6;
    double BACKBONE_DISTANCE = 27.0;

    public int naview_xy_coordinates(ArrayList<Short> pair_table2, ArrayList<Double> x, ArrayList<Double> y) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("naview_xy_coordinates");
        }
        if (pair_table2.size() == 0) {
            return 0;
        }
        ArrayList<Integer> pair_table = new ArrayList<Integer>(pair_table2.size() + 1);
        pair_table.add(pair_table2.size());
        int j = 0;
        while (j < pair_table2.size()) {
            pair_table.add(pair_table2.get(j) + 1);
            ++j;
        }
        if (this.debug) {
            this.infoStructure(pair_table);
        }
        this.nbase = pair_table.get(0);
        this.bases = new ArrayList(this.nbase + 1);
        int index = 0;
        while (index < this.bases.size()) {
            this.bases.add(new Base());
            ++index;
        }
        this.regions = new ArrayList();
        index = 0;
        while (index < this.nbase + 1) {
            this.regions.add(new Region());
            ++index;
        }
        this.read_in_bases(pair_table);
        if (this.debug) {
            this.infoBasesMate();
        }
        this.rlphead = null;
        this.find_regions();
        if (this.debug) {
            this.infoRegions();
        }
        this.loop_count = 0;
        this.loops = new ArrayList(this.nbase + 1);
        index = 0;
        while (index < this.nbase + 1) {
            this.loops.add(new Loop());
            ++index;
        }
        this.construct_loop(0);
        if (this.debug) {
            this.infoBasesExtracted();
        }
        this.find_central_loop();
        if (this.debug) {
            this.infoRoot();
        }
        if (this.debug) {
            this.dump_loops();
        }
        this.traverse_loop(this.root, null);
        int i = 0;
        while (i < this.nbase) {
            x.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getX());
            y.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getY());
            ++i;
        }
        return this.nbase;
    }

    private void infoStructure(ArrayList<Integer> pair_table) {
        System.out.println("structure:");
        int j = 0;
        while (j < pair_table.size()) {
            System.out.print("#" + j + ":" + pair_table.get(j) + "\t");
            if (j % 10 == 0) {
                System.out.println();
            }
            ++j;
        }
        System.out.println();
    }

    private void infoBasesMate() {
        System.out.println("Bases mate:");
        int index = 0;
        while (index < this.bases.size()) {
            System.out.print("#" + index + ":" + this.bases.get(index).getMate() + "\t");
            if (index % 10 == 0) {
                System.out.println();
            }
            ++index;
        }
        System.out.println();
    }

    private void infoRegions() {
        System.out.println("regions:");
        int index = 0;
        while (index < this.regions.size()) {
            System.out.print("(" + this.regions.get(index).getStart1() + "," + this.regions.get(index).getStart2() + ";" + this.regions.get(index).getEnd1() + "," + this.regions.get(index).getEnd2() + ")\t\t");
            if (index % 5 == 0) {
                System.out.println();
            }
            ++index;
        }
        System.out.println();
    }

    private void infoBasesExtracted() {
        System.out.println("Bases extracted:");
        int index = 0;
        while (index < this.bases.size()) {
            System.out.print("i=" + index + ":" + this.bases.get(index).isExtracted() + "\t");
            if (index % 5 == 0) {
                System.out.println();
            }
            ++index;
        }
        System.out.println();
    }

    private void infoRoot() {
        System.out.println("root" + this.root.getNconnection() + ";" + this.root.getNumber());
        System.out.println("\troot : ");
        System.out.println("\tdepth=" + this.root.getDepth());
        System.out.println("\tmark=" + this.root.isMark());
        System.out.println("\tnumber=" + this.root.getNumber());
        System.out.println("\tradius=" + this.root.getRadius());
        System.out.println("\tx=" + this.root.getX());
        System.out.println("\ty=" + this.root.getY());
        System.out.println("\tnconnection=" + this.root.getNconnection());
    }

    private void read_in_bases(ArrayList<Integer> pair_table) {
        if (this.debug) {
            System.out.println("read_in_bases");
        }
        this.bases.add(new Base());
        this.bases.get(0).setMate(0);
        this.bases.get(0).setExtracted(false);
        this.bases.get(0).setX(9999.0);
        this.bases.get(0).setY(9999.0);
        int npairs = 0;
        int i = 1;
        while (i <= this.nbase) {
            this.bases.add(new Base());
            this.bases.get(i).setExtracted(false);
            this.bases.get(i).setX(9999.0);
            this.bases.get(i).setY(9999.0);
            this.bases.get(i).setMate(pair_table.get(i));
            if (pair_table.get(i) > i) {
                ++npairs;
            }
            ++i;
        }
        if (npairs == 0) {
            this.bases.get(1).setMate(this.nbase);
            this.bases.get(this.nbase).setMate(1);
        }
    }

    private void find_regions() {
        if (this.debug) {
            System.out.println("find_regions");
        }
        int nb1 = this.nbase + 1;
        ArrayList<Boolean> mark = new ArrayList<Boolean>(nb1);
        int i = 0;
        while (i < nb1) {
            mark.add(false);
            ++i;
        }
        this.nregion = 0;
        i = 0;
        while (i <= this.nbase) {
            int mate = this.bases.get(i).getMate();
            if (mate != 0 && !((Boolean)mark.get(i)).booleanValue()) {
                this.regions.get(this.nregion).setStart1(i);
                this.regions.get(this.nregion).setEnd2(mate);
                mark.set(i, true);
                mark.set(mate, true);
                this.bases.get(i).setRegion(this.regions.get(this.nregion));
                this.bases.get(mate).setRegion(this.regions.get(this.nregion));
                ++i;
                --mate;
                while (i < mate && this.bases.get(i).getMate() == mate) {
                    mark.set(mate, true);
                    mark.set(i, true);
                    this.bases.get(i).setRegion(this.regions.get(this.nregion));
                    this.bases.get(mate).setRegion(this.regions.get(this.nregion));
                    ++i;
                    --mate;
                }
                this.regions.get(this.nregion).setEnd1(--i);
                this.regions.get(this.nregion).setStart2(mate + 1);
                if (this.debug) {
                    if (this.nregion == 0) {
                        System.out.printf("\nRegions are:\n", new Object[0]);
                    }
                    System.out.printf("Region %d is %d-%d and %d-%d with gap of %d.\n", this.nregion + 1, this.regions.get(this.nregion).getStart1(), this.regions.get(this.nregion).getEnd1(), this.regions.get(this.nregion).getStart2(), this.regions.get(this.nregion).getEnd2(), this.regions.get(this.nregion).getStart2() - this.regions.get(this.nregion).getEnd1() + 1);
                }
                ++this.nregion;
            }
            ++i;
        }
    }

    private Loop construct_loop(int ibase) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("construct_loop");
        }
        Loop retloop = new Loop();
        Loop lp = new Loop();
        Connection cp = new Connection();
        Region rp = new Region();
        Radloop rlp = new Radloop();
        retloop = this.loops.get(this.loop_count++);
        retloop.setNconnection(0);
        retloop.setDepth(0);
        retloop.setNumber(this.loop_count);
        retloop.setRadius(0.0);
        rlp = this.rlphead;
        while (rlp != null) {
            if (rlp.getLoopnumber() == this.loop_count) {
                retloop.setRadius(rlp.getRadius());
            }
            rlp = rlp.getNext();
        }
        int i = ibase;
        do {
            int mate;
            if ((mate = this.bases.get(i).getMate()) != 0) {
                rp = this.bases.get(i).getRegion();
                if (!this.bases.get(rp.getStart1()).isExtracted()) {
                    if (i == rp.getStart1()) {
                        this.bases.get(rp.getStart1()).setExtracted(true);
                        this.bases.get(rp.getEnd1()).setExtracted(true);
                        this.bases.get(rp.getStart2()).setExtracted(true);
                        this.bases.get(rp.getEnd2()).setExtracted(true);
                        lp = this.construct_loop(rp.getEnd1() < this.nbase ? rp.getEnd1() + 1 : 0);
                    } else if (i == rp.getStart2()) {
                        this.bases.get(rp.getStart2()).setExtracted(true);
                        this.bases.get(rp.getEnd2()).setExtracted(true);
                        this.bases.get(rp.getStart1()).setExtracted(true);
                        this.bases.get(rp.getEnd1()).setExtracted(true);
                        lp = this.construct_loop(rp.getEnd2() < this.nbase ? rp.getEnd2() + 1 : 0);
                    } else {
                        throw new ExceptionNAViewAlgorithm("naview:Error detected in construct_loop. i = " + i + " not found in region table.\n");
                    }
                    retloop.setNconnection(retloop.getNconnection() + 1);
                    cp = new Connection();
                    retloop.setConnection(retloop.getNconnection() - 1, cp);
                    retloop.setConnection(retloop.getNconnection(), null);
                    cp.setLoop(lp);
                    cp.setRegion(rp);
                    if (i == rp.getStart1()) {
                        cp.setStart(rp.getStart1());
                        cp.setEnd(rp.getEnd2());
                    } else {
                        cp.setStart(rp.getStart2());
                        cp.setEnd(rp.getEnd1());
                    }
                    cp.setExtruded(false);
                    cp.setBroken(false);
                    lp.setNconnection(lp.getNconnection() + 1);
                    cp = new Connection();
                    lp.setConnection(lp.getNconnection() - 1, cp);
                    lp.setConnection(lp.getNconnection(), null);
                    cp.setLoop(retloop);
                    cp.setRegion(rp);
                    if (i == rp.getStart1()) {
                        cp.setStart(rp.getStart2());
                        cp.setEnd(rp.getEnd1());
                    } else {
                        cp.setStart(rp.getStart1());
                        cp.setEnd(rp.getEnd2());
                    }
                    cp.setExtruded(false);
                    cp.setBroken(false);
                }
                i = mate;
            }
            if (++i <= this.nbase) continue;
            i = 0;
        } while (i != ibase);
        return retloop;
    }

    private void dump_loops() {
        System.out.println("dump_loops");
        System.out.printf("\nRoot loop is #%d\n", this.loops.indexOf(this.root) + 1);
        int il = 0;
        while (il < this.loop_count) {
            Connection cp;
            Loop lp = this.loops.get(il);
            System.out.printf("Loop %d has %d connections:\n", il + 1, lp.getNconnection());
            int i = 0;
            while ((cp = lp.getConnection(i)) != null) {
                int ilp = this.loops.indexOf(cp.getLoop()) + 1;
                int irp = this.regions.indexOf(cp.getRegion()) + 1;
                System.out.printf("  Loop %d Region %d (%d-%d)\n", ilp, irp, cp.getStart(), cp.getEnd());
                ++i;
            }
            ++il;
        }
    }

    private void find_central_loop() {
        if (this.debug) {
            System.out.println("find_central_loop");
        }
        Loop lp = new Loop();
        this.determine_depths();
        int maxconn = 0;
        int maxdepth = -1;
        int i = 0;
        while (i < this.loop_count) {
            lp = this.loops.get(i);
            if (lp.getNconnection() > maxconn) {
                maxdepth = lp.getDepth();
                maxconn = lp.getNconnection();
                this.root = lp;
            } else if (lp.getDepth() > maxdepth && lp.getNconnection() == maxconn) {
                maxdepth = lp.getDepth();
                this.root = lp;
            }
            ++i;
        }
    }

    private void determine_depths() {
        if (this.debug) {
            System.out.println("determine_depths");
        }
        Loop lp = new Loop();
        int i = 0;
        while (i < this.loop_count) {
            lp = this.loops.get(i);
            int j = 0;
            while (j < this.loop_count) {
                this.loops.get(j).setMark(false);
                ++j;
            }
            lp.setDepth(this.depth(lp));
            ++i;
        }
    }

    private int depth(Loop lp) {
        if (this.debug) {
            System.out.println("depth");
        }
        if (lp.getNconnection() <= 1) {
            return 0;
        }
        if (lp.isMark()) {
            return -1;
        }
        lp.setMark(true);
        int count = 0;
        int ret = 0;
        int i = 0;
        while (lp.getConnection(i) != null) {
            int d = this.depth(lp.getConnection(i).getLoop());
            if (d >= 0) {
                if (++count == 1) {
                    ret = d;
                } else if (ret > d) {
                    ret = d;
                }
            }
            ++i;
        }
        lp.setMark(false);
        return ret + 1;
    }

    private void traverse_loop(Loop lp, Connection anchor_connection) throws ExceptionNAViewAlgorithm {
        int n;
        Connection cpnext;
        int j;
        Connection cp;
        if (this.debug) {
            System.out.println("  traverse_loop");
        }
        int imaxloop = 0;
        double angleinc = Math.PI * 2 / (double)(this.nbase + 1);
        Connection acp = null;
        int icroot = -1;
        int indice = 0;
        int ic = 0;
        while ((cp = lp.getConnection(indice)) != null) {
            double xs = -Math.sin(angleinc * (double)cp.getStart());
            double ys = Math.cos(angleinc * (double)cp.getStart());
            double xe = -Math.sin(angleinc * (double)cp.getEnd());
            double ye = Math.cos(angleinc * (double)cp.getEnd());
            double xn = ye - ys;
            double yn = xs - xe;
            double r = Math.sqrt(xn * xn + yn * yn);
            cp.setXrad(xn / r);
            cp.setYrad(yn / r);
            cp.setAngle(Math.atan2(yn, xn));
            if (cp.getAngle() < 0.0) {
                cp.setAngle(cp.getAngle() + Math.PI * 2);
            }
            if (anchor_connection != null && anchor_connection.getRegion() == cp.getRegion()) {
                acp = cp;
                icroot = ic;
            }
            ++indice;
            ++ic;
        }
        block1: while (true) {
            int i;
            double acn;
            double rr;
            double dy;
            double dx;
            int icend;
            double ac;
            double xc;
            double yc;
            this.determine_radius(lp, this.lencut);
            double radius = lp.getRadius() / 1.4;
            if (anchor_connection == null) {
                yc = 0.0;
                xc = 0.0;
            } else {
                double xo = (this.bases.get(acp.getStart()).getX() + this.bases.get(acp.getEnd()).getX()) / 2.0;
                double yo = (this.bases.get(acp.getStart()).getY() + this.bases.get(acp.getEnd()).getY()) / 2.0;
                xc = xo - radius * acp.getXrad();
                yc = yo - radius * acp.getYrad();
            }
            int icstart = icroot == -1 ? 0 : icroot;
            cp = lp.getConnection(icstart);
            int count = 0;
            if (this.debug) {
                System.out.printf("Now processing loop %d\n", lp.getNumber());
                System.out.println("  " + lp);
            }
            boolean done = false;
            do {
                Connection cpprev;
                if ((j = icstart - 1) < 0) {
                    j = lp.getNconnection() - 1;
                }
                if (!this.connected_connection(cpprev = lp.getConnection(j), cp)) {
                    done = true;
                } else {
                    icstart = j;
                    cp = cpprev;
                }
                if (++count <= lp.getNconnection()) continue;
                double maxang = -1.0;
                ic = 0;
                while (ic < lp.getNconnection()) {
                    j = ic + 1;
                    if (j >= lp.getNconnection()) {
                        j = 0;
                    }
                    cp = lp.getConnection(ic);
                    cpnext = lp.getConnection(j);
                    ac = cpnext.getAngle() - cp.getAngle();
                    if (ac < 0.0) {
                        ac += Math.PI * 2;
                    }
                    if (ac > maxang) {
                        maxang = ac;
                        imaxloop = ic;
                    }
                    ++ic;
                }
                icend = imaxloop;
                icstart = imaxloop + 1;
                if (icstart >= lp.getNconnection()) {
                    icstart = 0;
                }
                cp = lp.getConnection(icend);
                cp.setBroken(true);
                done = true;
            } while (!done);
            boolean done_all_connections = false;
            int icstart1 = icstart;
            if (this.debug) {
                System.out.printf("  Icstart1 = %d\n", icstart1);
            }
            while (!done_all_connections) {
                int icmiddle;
                int icdown;
                count = 0;
                done = false;
                icend = icstart;
                boolean rooted = false;
                while (!done) {
                    cp = lp.getConnection(icend);
                    if (icend == icroot) {
                        rooted = true;
                    }
                    if ((j = icend + 1) >= lp.getNconnection()) {
                        j = 0;
                    }
                    if (this.connected_connection(cp, cpnext = lp.getConnection(j))) {
                        if (++count >= lp.getNconnection()) break;
                        icend = j;
                        continue;
                    }
                    done = true;
                }
                int icup = icdown = (icmiddle = this.find_ic_middle(icstart, icend, anchor_connection, acp, lp));
                ic = icdown;
                if (this.debug) {
                    System.out.printf("  IC start = %d  middle = %d  end = %d\n", icstart, icmiddle, icend);
                }
                done = false;
                int direction = 0;
                while (!done) {
                    ic = direction < 0 ? icup : (direction == 0 ? icmiddle : icdown);
                    if (ic >= 0) {
                        cp = lp.getConnection(ic);
                        if (anchor_connection == null || acp != cp) {
                            double rl;
                            double da;
                            double lny;
                            double lnx;
                            double cny;
                            double cnx;
                            if (direction == 0) {
                                double astart = cp.getAngle() - Math.asin(0.5 / radius);
                                double aend = cp.getAngle() + Math.asin(0.5 / radius);
                                this.bases.get(cp.getStart()).setX(xc + radius * Math.cos(astart));
                                this.bases.get(cp.getStart()).setY(yc + radius * Math.sin(astart));
                                this.bases.get(cp.getEnd()).setX(xc + radius * Math.cos(aend));
                                this.bases.get(cp.getEnd()).setY(yc + radius * Math.sin(aend));
                            } else if (direction < 0) {
                                j = ic + 1;
                                if (j >= lp.getNconnection()) {
                                    j = 0;
                                }
                                cp = lp.getConnection(ic);
                                cpnext = lp.getConnection(j);
                                double cpx = cp.getXrad();
                                double cpy = cp.getYrad();
                                ac = (cp.getAngle() + cpnext.getAngle()) / 2.0;
                                if (cp.getAngle() > cpnext.getAngle()) {
                                    ac -= Math.PI;
                                }
                                cnx = Math.cos(ac);
                                lnx = cny = Math.sin(ac);
                                lny = -cnx;
                                da = cpnext.getAngle() - cp.getAngle();
                                if (da < 0.0) {
                                    da += Math.PI * 2;
                                }
                                rl = cp.isExtruded() ? (da <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                this.bases.get(cp.getEnd()).setX(this.bases.get(cpnext.getStart()).getX() + rl * lnx);
                                this.bases.get(cp.getEnd()).setY(this.bases.get(cpnext.getStart()).getY() + rl * lny);
                                this.bases.get(cp.getStart()).setX(this.bases.get(cp.getEnd()).getX() + cpy);
                                this.bases.get(cp.getStart()).setY(this.bases.get(cp.getEnd()).getY() - cpx);
                            } else {
                                j = ic - 1;
                                if (j < 0) {
                                    j = lp.getNconnection() - 1;
                                }
                                cp = lp.getConnection(j);
                                cpnext = lp.getConnection(ic);
                                double cpnextx = cpnext.getXrad();
                                double cpnexty = cpnext.getYrad();
                                ac = (cp.getAngle() + cpnext.getAngle()) / 2.0;
                                if (cp.getAngle() > cpnext.getAngle()) {
                                    ac -= Math.PI;
                                }
                                cnx = Math.cos(ac);
                                cny = Math.sin(ac);
                                lnx = -cny;
                                lny = cnx;
                                da = cpnext.getAngle() - cp.getAngle();
                                if (da < 0.0) {
                                    da += Math.PI * 2;
                                }
                                rl = cp.isExtruded() ? (da <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                this.bases.get(cpnext.getStart()).setX(this.bases.get(cp.getEnd()).getX() + rl * lnx);
                                this.bases.get(cpnext.getStart()).setY(this.bases.get(cp.getEnd()).getY() + rl * lny);
                                this.bases.get(cpnext.getEnd()).setX(this.bases.get(cpnext.getStart()).getX() - cpnexty);
                                this.bases.get(cpnext.getEnd()).setY(this.bases.get(cpnext.getStart()).getY() + cpnextx);
                            }
                        }
                    }
                    if (direction < 0) {
                        if (icdown == icend) {
                            icdown = -1;
                        } else if (icdown >= 0 && ++icdown >= lp.getNconnection()) {
                            icdown = 0;
                        }
                        direction = 1;
                    } else {
                        if (icup == icstart) {
                            icup = -1;
                        } else if (icup >= 0 && --icup < 0) {
                            icup = lp.getNconnection() - 1;
                        }
                        direction = -1;
                    }
                    boolean bl = done = icup == -1 && icdown == -1;
                }
                int icnext = icend + 1;
                if (icnext >= lp.getNconnection()) {
                    icnext = 0;
                }
                if (icend != icstart && (icstart != icstart1 || icnext != icstart1)) {
                    cp = lp.getConnection(icstart);
                    cpnext = lp.getConnection(icend);
                    dx = this.bases.get(cpnext.getEnd()).getX() - this.bases.get(cp.getStart()).getX();
                    dy = this.bases.get(cpnext.getEnd()).getY() - this.bases.get(cp.getStart()).getY();
                    double midx = this.bases.get(cp.getStart()).getX() + dx / 2.0;
                    double midy = this.bases.get(cp.getStart()).getY() + dy / 2.0;
                    rr = Math.sqrt(dx * dx + dy * dy);
                    double mx = dx / rr;
                    double my = dy / rr;
                    double vx = xc - midx;
                    double vy = yc - midy;
                    rr = Math.sqrt(dx * dx + dy * dy);
                    double dotmv = (vx /= rr) * mx + (vy /= rr) * my;
                    double nrx = dotmv * mx - vx;
                    double nry = dotmv * my - vy;
                    rr = Math.sqrt(nrx * nrx + nry * nry);
                    nrx /= rr;
                    nry /= rr;
                    dx = this.bases.get(cp.getStart()).getX() - xc;
                    dy = this.bases.get(cp.getStart()).getY() - yc;
                    ac = Math.atan2(dy, dx);
                    if (ac < 0.0) {
                        ac += Math.PI * 2;
                    }
                    dx = this.bases.get(cpnext.getEnd()).getX() - xc;
                    dy = this.bases.get(cpnext.getEnd()).getY() - yc;
                    acn = Math.atan2(dy, dx);
                    if (acn < 0.0) {
                        acn += Math.PI * 2;
                    }
                    if (acn < ac) {
                        acn += Math.PI * 2;
                    }
                    int sign = acn - ac > Math.PI ? -1 : 1;
                    double nmidx = xc + (double)sign * radius * nrx;
                    double nmidy = yc + (double)sign * radius * nry;
                    if (rooted) {
                        xc -= nmidx - midx;
                        yc -= nmidy - midy;
                    } else {
                        ic = icstart;
                        while (true) {
                            cp = lp.getConnection(ic);
                            i = cp.getStart();
                            this.bases.get(i).setX(this.bases.get(i).getX() + nmidx - midx);
                            this.bases.get(i).setY(this.bases.get(i).getY() + nmidy - midy);
                            i = cp.getEnd();
                            this.bases.get(i).setX(this.bases.get(i).getX() + nmidx - midx);
                            this.bases.get(i).setY(this.bases.get(i).getY() + nmidy - midy);
                            if (ic == icend) break;
                            if (++ic < lp.getNconnection()) continue;
                            ic = 0;
                        }
                    }
                }
                boolean bl = done_all_connections = (icstart = icnext) == icstart1;
            }
            ic = 0;
            while (ic < lp.getNconnection()) {
                cp = lp.getConnection(ic);
                j = ic + 1;
                if (j >= lp.getNconnection()) {
                    j = 0;
                }
                cpnext = lp.getConnection(j);
                dx = this.bases.get(cp.getEnd()).getX() - xc;
                dy = this.bases.get(cp.getEnd()).getY() - yc;
                double rc = Math.sqrt(dx * dx + dy * dy);
                ac = Math.atan2(dy, dx);
                if (ac < 0.0) {
                    ac += Math.PI * 2;
                }
                dx = this.bases.get(cpnext.getStart()).getX() - xc;
                dy = this.bases.get(cpnext.getStart()).getY() - yc;
                double rcn = Math.sqrt(dx * dx + dy * dy);
                acn = Math.atan2(dy, dx);
                if (acn < 0.0) {
                    acn += Math.PI * 2;
                }
                if (acn < ac) {
                    acn += Math.PI * 2;
                }
                double dan = acn - ac;
                double dcp = cpnext.getAngle() - cp.getAngle();
                if (dcp <= 0.0) {
                    dcp += Math.PI * 2;
                }
                if (Math.abs(dan - dcp) > Math.PI) {
                    if (cp.isExtruded()) {
                        this.warningEmition("Warning from traverse_loop. Loop " + lp.getNumber() + " has crossed regions\n");
                    } else if (cpnext.getStart() - cp.getEnd() != 1) {
                        cp.setExtruded(true);
                        continue block1;
                    }
                }
                if (cp.isExtruded()) {
                    this.construct_extruded_segment(cp, cpnext);
                } else {
                    n = cpnext.getStart() - cp.getEnd();
                    if (n < 0) {
                        n += this.nbase + 1;
                    }
                    angleinc = dan / (double)n;
                    j = 1;
                    while (j < n) {
                        i = cp.getEnd() + j;
                        if (i > this.nbase) {
                            i -= this.nbase + 1;
                        }
                        double a = ac + (double)j * angleinc;
                        rr = rc + (rcn - rc) * (a - ac) / dan;
                        this.bases.get(i).setX(xc + rr * Math.cos(a));
                        this.bases.get(i).setY(yc + rr * Math.sin(a));
                        ++j;
                    }
                }
                ++ic;
            }
            break;
        }
        ic = 0;
        while (ic < lp.getNconnection()) {
            if (icroot != ic) {
                cp = lp.getConnection(ic);
                this.generate_region(cp);
                this.traverse_loop(cp.getLoop(), cp);
            }
            ++ic;
        }
        n = 0;
        double sx = 0.0;
        double sy = 0.0;
        ic = 0;
        while (ic < lp.getNconnection()) {
            j = ic + 1;
            if (j >= lp.getNconnection()) {
                j = 0;
            }
            cp = lp.getConnection(ic);
            cpnext = lp.getConnection(j);
            n += 2;
            sx += this.bases.get(cp.getStart()).getX() + this.bases.get(cp.getEnd()).getX();
            sy += this.bases.get(cp.getStart()).getY() + this.bases.get(cp.getEnd()).getY();
            if (!cp.isExtruded()) {
                j = cp.getEnd() + 1;
                while (j != cpnext.getStart()) {
                    if (j > this.nbase) {
                        j -= this.nbase + 1;
                    }
                    ++n;
                    sx += this.bases.get(j).getX();
                    sy += this.bases.get(j).getY();
                    ++j;
                }
            }
            ++ic;
        }
        lp.setX(sx / (double)n);
        lp.setY(sy / (double)n);
    }

    private void determine_radius(Loop lp, double lencut) {
        double radius;
        double mindit;
        if (this.debug) {
            System.out.println("  Determine_radius");
        }
        int imindit = 0;
        Connection cp = new Connection();
        Connection cpnext = new Connection();
        double rt2_2 = 0.7071068;
        do {
            mindit = 1.0E10;
            double sumd = 0.0;
            double sumn = 0.0;
            int i = 0;
            while (i < lp.getNconnection()) {
                double dt;
                cp = lp.getConnection(i);
                int j = i + 1;
                if (j >= lp.getNconnection()) {
                    j = 0;
                }
                cpnext = lp.getConnection(j);
                int end = cp.getEnd();
                int start = cpnext.getStart();
                if (start < end) {
                    start += this.nbase + 1;
                }
                if ((dt = cpnext.getAngle() - cp.getAngle()) <= 0.0) {
                    dt += Math.PI * 2;
                }
                double ci = !cp.isExtruded() ? (double)(start - end) : (dt <= 1.5707963267948966 ? 2.0 : 1.5);
                sumn += dt * (1.0 / ci + 1.0);
                sumd += dt * dt / ci;
                double dit = dt / ci;
                if (dit < mindit && !cp.isExtruded() && ci > 1.0) {
                    mindit = dit;
                    imindit = i;
                }
                ++i;
            }
            radius = sumn / sumd;
            if (radius < rt2_2) {
                radius = rt2_2;
            }
            if (!(mindit * radius < lencut)) continue;
            lp.getConnection(imindit).setExtruded(true);
        } while (mindit * radius < lencut);
        if (lp.getRadius() > 0.0) {
            radius = lp.getRadius();
        } else {
            lp.setRadius(radius);
        }
    }

    private boolean connected_connection(Connection cp, Connection cpnext) {
        if (this.debug) {
            System.out.println("  Connected_connection");
        }
        if (cp.isExtruded()) {
            return true;
        }
        return cp.getEnd() + 1 == cpnext.getStart();
    }

    private int find_ic_middle(int icstart, int icend, Connection anchor_connection, Connection acp, Loop lp) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("  Find_ic_middle");
        }
        int count = 0;
        int ret = -1;
        int ic = icstart;
        boolean done = false;
        while (!done) {
            if (count++ > lp.getNconnection() * 2) {
                throw new ExceptionNAViewAlgorithm("Infinite loop detected in find_ic_middle");
            }
            if (anchor_connection != null && lp.getConnection(ic) == acp) {
                ret = ic;
            }
            boolean bl = done = ic == icend;
            if (++ic < lp.getNconnection()) continue;
            ic = 0;
        }
        if (ret == -1) {
            int i = 1;
            ic = icstart;
            while (i < (count + 1) / 2) {
                if (++ic >= lp.getNconnection()) {
                    ic = 0;
                }
                ++i;
            }
            ret = ic;
        }
        return ret;
    }

    private void generate_region(Connection cp) throws ExceptionNAViewAlgorithm {
        int end;
        int start;
        if (this.debug) {
            System.out.println("  Generate_region");
        }
        Region rp = cp.getRegion();
        int l = 0;
        if (cp.getStart() == rp.getStart1()) {
            start = rp.getStart1();
            end = rp.getEnd1();
        } else {
            start = rp.getStart2();
            end = rp.getEnd2();
        }
        if (this.bases.get(cp.getStart()).getX() > 9899.0 || this.bases.get(cp.getEnd()).getX() > 9899.0) {
            throw new ExceptionNAViewAlgorithm("Bad region passed to generate_region. Coordinates not defined.");
        }
        int i = start + 1;
        while (i <= end) {
            this.bases.get(i).setX(this.bases.get(cp.getStart()).getX() + this.HELIX_FACTOR * (double)(++l) * cp.getXrad());
            this.bases.get(i).setY(this.bases.get(cp.getStart()).getY() + this.HELIX_FACTOR * (double)l * cp.getYrad());
            int mate = this.bases.get(i).getMate();
            this.bases.get(mate).setX(this.bases.get(cp.getEnd()).getX() + this.HELIX_FACTOR * (double)l * cp.getXrad());
            this.bases.get(mate).setY(this.bases.get(cp.getEnd()).getY() + this.HELIX_FACTOR * (double)l * cp.getYrad());
            ++i;
        }
    }

    private void construct_circle_segment(int start, int end) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("  Construct_circle_segment");
        }
        double dx = this.bases.get(end).getX() - this.bases.get(start).getX();
        double dy = this.bases.get(end).getY() - this.bases.get(start).getY();
        double rr = Math.sqrt(dx * dx + dy * dy);
        int l = end - start;
        if (l < 0) {
            l += this.nbase + 1;
        }
        if (rr >= (double)l) {
            dx /= rr;
            dy /= rr;
            int j = 1;
            while (j < l) {
                int i = start + j;
                if (i > this.nbase) {
                    i -= this.nbase + 1;
                }
                this.bases.get(i).setX(this.bases.get(start).getX() + dx * (double)j / (double)l);
                this.bases.get(i).setY(this.bases.get(start).getY() + dy * (double)j / (double)l);
                ++j;
            }
        } else {
            this.find_center_for_arc(l - 1, rr);
            double midx = this.bases.get(start).getX() + (dx /= rr) * rr / 2.0;
            double midy = this.bases.get(start).getY() + (dy /= rr) * rr / 2.0;
            double xn = dy;
            double yn = -dx;
            double nrx = midx + this._h * xn;
            double nry = midy + this._h * yn;
            double mx = this.bases.get(start).getX() - nrx;
            double my = this.bases.get(start).getY() - nry;
            rr = Math.sqrt(mx * mx + my * my);
            double a = Math.atan2(my, mx);
            int j = 1;
            while (j < l) {
                int i = start + j;
                if (i > this.nbase) {
                    i -= this.nbase + 1;
                }
                this.bases.get(i).setX(nrx + rr * Math.cos(a + (double)j * this.angleinc));
                this.bases.get(i).setY(nry + rr * Math.sin(a + (double)j * this.angleinc));
                ++j;
            }
        }
    }

    private void construct_extruded_segment(Connection cp, Connection cpnext) throws ExceptionNAViewAlgorithm {
        double da;
        if (this.debug) {
            System.out.println("  Construct_extruded_segment");
        }
        double astart = cp.getAngle();
        double aend1 = cpnext.getAngle();
        double aend2 = aend1;
        if (aend2 < astart) {
            aend2 += Math.PI * 2;
        }
        double aave = (astart + aend2) / 2.0;
        int start = cp.getEnd();
        int end = cpnext.getStart();
        int n = end - start;
        if (n < 0) {
            n += this.nbase + 1;
        }
        if ((da = cpnext.getAngle() - cp.getAngle()) < 0.0) {
            da += Math.PI * 2;
        }
        if (n == 2) {
            this.construct_circle_segment(start, end);
        } else {
            boolean collision;
            int nend;
            int nstart;
            double dx = this.bases.get(end).getX() - this.bases.get(start).getX();
            double dy = this.bases.get(end).getY() - this.bases.get(start).getY();
            double rr = Math.sqrt(dx * dx + dy * dy);
            dx /= rr;
            dy /= rr;
            if (rr >= 1.5 && da <= 1.5707963267948966) {
                nstart = start + 1;
                if (nstart > this.nbase) {
                    nstart -= this.nbase + 1;
                }
                if ((nend = end - 1) < 0) {
                    nend += this.nbase + 1;
                }
                this.bases.get(nstart).setX(this.bases.get(start).getX() + 0.5 * dx);
                this.bases.get(nstart).setY(this.bases.get(start).getY() + 0.5 * dy);
                this.bases.get(nend).setX(this.bases.get(end).getX() - 0.5 * dx);
                this.bases.get(nend).setY(this.bases.get(end).getY() - 0.5 * dy);
                start = nstart;
                end = nend;
            }
            do {
                double dac;
                collision = false;
                this.construct_circle_segment(start, end);
                nstart = start + 1;
                if (nstart > this.nbase) {
                    nstart -= this.nbase + 1;
                }
                dx = this.bases.get(nstart).getX() - this.bases.get(start).getX();
                dy = this.bases.get(nstart).getY() - this.bases.get(start).getY();
                double a1 = Math.atan2(dy, dx);
                if (a1 < 0.0) {
                    a1 += Math.PI * 2;
                }
                if ((dac = a1 - astart) < 0.0) {
                    dac += Math.PI * 2;
                }
                if (dac > Math.PI) {
                    collision = true;
                }
                if ((nend = end - 1) < 0) {
                    nend += this.nbase + 1;
                }
                dx = this.bases.get(nend).getX() - this.bases.get(end).getX();
                dy = this.bases.get(nend).getY() - this.bases.get(end).getY();
                double a2 = Math.atan2(dy, dx);
                if (a2 < 0.0) {
                    a2 += Math.PI * 2;
                }
                if ((dac = aend1 - a2) < 0.0) {
                    dac += Math.PI * 2;
                }
                if (dac > Math.PI) {
                    collision = true;
                }
                if (!collision) continue;
                double ac = this.minf2(aave, astart + 0.5);
                this.bases.get(nstart).setX(this.bases.get(start).getX() + Math.cos(ac));
                this.bases.get(nstart).setY(this.bases.get(start).getY() + Math.sin(ac));
                start = nstart;
                ac = this.maxf2(aave, aend2 - 0.5);
                this.bases.get(nend).setX(this.bases.get(end).getX() + Math.cos(ac));
                this.bases.get(nend).setY(this.bases.get(end).getY() + Math.sin(ac));
                end = nend;
                n -= 2;
            } while (collision && n > 1);
        }
    }

    private void find_center_for_arc(double n, double b) throws ExceptionNAViewAlgorithm {
        double theta;
        double h;
        double e;
        if (this.debug) {
            System.out.println("  Find_center_for_arc");
        }
        double hhi = (n + 1.0) / Math.PI;
        double hlow = -hhi - b / (n + 1.000001 - b);
        if (b < 1.0) {
            hlow = 0.0;
        }
        int iter = 0;
        do {
            double phi;
            double r;
            double disc;
            if (Math.abs(disc = 1.0 - 0.5 / ((r = Math.sqrt((h = (hhi + hlow) / 2.0) * h + b * b / 4.0)) * r)) > 1.0) {
                throw new ExceptionNAViewAlgorithm("Unexpected large magnitude discriminant = " + disc + " " + r);
            }
            theta = Math.acos(disc);
            e = theta * (n + 1.0) + 2.0 * (phi = Math.acos(h / r)) - Math.PI * 2;
            if (e > 0.0) {
                hlow = h;
                continue;
            }
            hhi = h;
        } while (Math.abs(e) > 1.0E-4 && ++iter < 500);
        if (iter >= 500) {
            if (this.noIterationFailureYet) {
                this.warningEmition("Iteration failed in find_center_for_arc");
                this.noIterationFailureYet = false;
            }
            h = 0.0;
            theta = 0.0;
        }
        this._h = h;
        this.angleinc = theta;
    }

    private double minf2(double x1, double x2) {
        return x1 < x2 ? x1 : x2;
    }

    private double maxf2(double x1, double x2) {
        return x1 > x2 ? x1 : x2;
    }

    public void warningEmition(String warningMessage) throws ExceptionNAViewAlgorithm {
        throw new ExceptionNAViewAlgorithm(warningMessage);
    }
}

