/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;

public class XFIGExport
extends SecStrDrawingProducer {
    private int _font = 0;
    private StringBuffer buf = new StringBuffer();
    private Hashtable<Color, Integer> _definedCols = new Hashtable();
    private int _nextColCode = 32;
    private static final int UPPER_BOUND_COLOR_CODE = 543;

    public XFIGExport() {
        super.setScale(20.0);
    }

    private String ensureColorDefinition(Color col) {
        if (!this._definedCols.containsKey(col) && this._nextColCode < 543) {
            String RGBB;
            String RGBG;
            int curColorCode = this._nextColCode++;
            this._definedCols.put(col, curColorCode);
            String RGBR = Integer.toHexString(col.getRed());
            if (RGBR.length() < 2) {
                RGBR = "0" + RGBR;
            }
            if ((RGBG = Integer.toHexString(col.getGreen())).length() < 2) {
                RGBG = "0" + RGBG;
            }
            if ((RGBB = Integer.toHexString(col.getBlue())).length() < 2) {
                RGBB = "0" + RGBB;
            }
            String RGBHex = "#" + RGBR + RGBG + RGBB;
            RGBHex = RGBHex.toUpperCase();
            return "0 " + curColorCode + " " + RGBHex + "\n";
        }
        return "";
    }

    private int getColorCode(Color col) {
        if (this._definedCols.containsKey(col)) {
            return this._definedCols.get(col);
        }
        return 0;
    }

    private int getCurColorCode() {
        if (this._definedCols.containsKey(this._curColor)) {
            return this._definedCols.get(this._curColor);
        }
        return 0;
    }

    private String XFIGHeader() {
        return "#FIG 3.2\nLandscape\nCenter\nInches\nLetter  \n100.00\nSingle\n-2\n1200 2\n";
    }

    public String drawCircleS(Point2D.Double p, double radius, double thickness) {
        return "1 3 0 " + (long)thickness + " " + this.getCurColorCode() + " 7 50 -1 -1 0.000 1 0.0000 " + (long)p.x + " " + (long)(-p.y) + " " + (long)radius + " " + (long)radius + " 1 1 1 1\n";
    }

    public String drawLineS(Point2D.Double p0, Point2D.Double p1, double thickness) {
        return "2 1 0 " + (long)thickness + " " + this.getCurColorCode() + " 7 60 -1 -1 0.000 0 0 -1 0 0 2\n" + " " + (long)p0.x + " " + (long)(-p0.y) + " " + (long)p1.x + " " + (long)(-p1.y) + "\n";
    }

    public String drawRectangleS(Point2D.Double p, Point2D.Double dims, double thickness) {
        return "2 2 0 " + (long)thickness + " " + this.getCurColorCode() + " 7 50 -1 -1 0.000 0 0 -1 0 0 5\n" + "\t " + (long)p.x + " " + (long)(-p.y) + " " + (long)(p.x + dims.x) + " " + (long)(-p.y) + " " + (long)(p.x + dims.x) + " " + (long)(-(p.y + dims.y)) + " " + (long)p.x + " " + (long)(-(p.y + dims.y)) + " " + (long)p.x + " " + (long)(-p.y) + "\n";
    }

    public String drawTextS(Point2D.Double p, String txt) {
        return "4 1 " + this.getCurColorCode() + " 40 -1 " + this._font + " " + (long)this._fontsize + " 0.0000 6 " + 4.0 * this._fontsize + " " + (long)(2.0 * this._fontsize) + " " + (long)p.x + " " + (long)(-(p.y - 6.0 * this._fontsize)) + " " + txt + "\\001\n";
    }

    public String fillCircleS(Point2D.Double p, double radius, double thickness, Color col) {
        String coldef = this.ensureColorDefinition(col);
        return String.valueOf(coldef) + "1 3 0 " + (long)thickness + " 0 " + this.getColorCode(col) + " 50 0 20 0.000 1 0.0000 " + (long)p.x + " " + (long)(-p.y) + " " + (long)radius + " " + (long)radius + " 1 1 1 1\n";
    }

    public String setFontS(int font, double size) {
        this._font = font;
        this._fontsize = 1.2 * size;
        return "";
    }

    public String setColorS(Color col) {
        super.setColorS(col);
        return this.ensureColorDefinition(col);
    }

    public String footerS() {
        return "";
    }

    public String headerS(Rectangle2D.Double bb) {
        return this.XFIGHeader();
    }

    public String drawArcS(Point2D.Double origine, double width, double height, double startAngle, double endAngle) {
        double p1x = origine.x;
        double p1y = -origine.y;
        double p2x = origine.x + width / 2.0;
        double p2y = -origine.y - height / 2.0;
        double p3x = origine.x + width;
        double p3y = p1y;
        double cx = (p1x + p3x) / 2.0;
        double cy = p3y + height / 2.0;
        return "5 1 0 1 " + this.getCurColorCode() + " 7 50 0 -1 4.000 0 0 0 0 " + cx + " " + cy + " " + (int)p1x + " " + (int)p1y + " " + (int)p2x + " " + (int)p2y + " " + (int)p3x + " " + (int)p3y + "\n";
    }

    public String drawPolygonS(Point2D.Double[] points, double thickness) {
        if (points.length > 0) {
            String result = "2 3 0 1 " + this.getCurColorCode() + " 7 40 0 -1 4.000 0 0 0 0 0 " + (points.length + 1) + "\n";
            int i = 0;
            while (i < points.length) {
                result = String.valueOf(result) + (int)Math.round(points[i].x) + " " + (int)Math.round(-points[i].y) + " ";
                ++i;
            }
            result = String.valueOf(result) + (int)Math.round(points[0].x) + " " + (int)Math.round(-points[0].y) + " ";
            result = String.valueOf(result) + "\n";
            return result;
        }
        return "";
    }

    public String fillPolygonS(Point2D.Double[] points, Color col) {
        if (points.length > 0) {
            String coldef = this.ensureColorDefinition(col);
            String result = "2 3 0 1 0 " + this.getColorCode(col) + " 35 0 0 4.000 0 0 0 0 0 " + (points.length + 1) + "\n";
            int i = 0;
            while (i < points.length) {
                result = String.valueOf(result) + (int)Math.round(points[i].x) + " " + (int)Math.round(-points[i].y) + " ";
                ++i;
            }
            result = String.valueOf(result) + (int)Math.round(points[0].x) + " " + (int)Math.round(-points[0].y) + " ";
            result = String.valueOf(result) + "\n";
            return String.valueOf(coldef) + result;
        }
        return "";
    }
}

