/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.VueVARNAGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class SwingGraphics
implements VueVARNAGraphics {
    private BasicStroke _dashedStroke;
    private BasicStroke _plainStroke;
    Graphics2D _g2d;
    private boolean _debug = false;

    public SwingGraphics(Graphics2D g2d) {
        this._g2d = g2d;
        float[] dash = new float[]{5.0f, 5.0f};
        this._dashedStroke = new BasicStroke(1.0f, 1, 1, 3.0f, dash, 0.0f);
        this._plainStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
    }

    public Dimension getStringDimension(String s) {
        FontMetrics fm = this._g2d.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(s, this._g2d);
        return new Dimension((int)r.getWidth(), fm.getAscent() - fm.getDescent());
    }

    public void drawStringCentered(String res, double x, double y) {
        Dimension d = this.getStringDimension(res);
        x -= (double)d.width / 2.0;
        y += (double)d.height / 2.0;
        if (this._debug) {
            Stroke bck = this._g2d.getStroke();
            this._g2d.setStroke(this._plainStroke);
            this._g2d.draw(new Rectangle2D.Double(x, y - (double)d.height, d.width, d.height));
            this._g2d.setStroke(bck);
        }
        this._g2d.drawString(res, (float)x, (float)y);
    }

    public void draw(GeneralPath s) {
        this._g2d.draw(s);
    }

    public void drawArc(double x, double y, double rx, double ry, double angleStart, double angleEnd) {
        this._g2d.drawArc((int)(x - rx / 2.0), (int)(y - ry / 2.0), (int)rx, (int)ry, (int)angleStart, (int)angleEnd);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this._g2d.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawCircle(double x, double y, double r) {
        this._g2d.draw(new Ellipse2D.Double(x, y, r, r));
    }

    public void drawRect(double x, double y, double w, double h) {
        this._g2d.drawRect((int)x, (int)y, (int)w, (int)h);
    }

    public void drawRoundRect(double x, double y, double w, double h, double rx, double ry) {
        this._g2d.drawRoundRect((int)x, (int)y, (int)w, (int)h, (int)rx, (int)ry);
    }

    public void drawString(String s, double x, double y) {
        this._g2d.drawString(s, (float)x, (float)y);
    }

    public void fill(GeneralPath s) {
        this._g2d.fill(s);
    }

    public void fillCircle(double x, double y, double r) {
        this._g2d.fill(new Ellipse2D.Double(x, y, r, r));
    }

    public void fillRect(double x, double y, double w, double h) {
        this._g2d.fillRect((int)x, (int)y, (int)w, (int)h);
    }

    public void fillRoundRect(double x, double y, double w, double h, double rx, double ry) {
        this._g2d.fillRoundRect((int)x, (int)y, (int)w, (int)h, (int)rx, (int)ry);
    }

    public Color getColor() {
        return this._g2d.getColor();
    }

    public void setColor(Color c) {
        this._g2d.setColor(c);
    }

    public void setDashedStroke() {
        this._g2d.setStroke(this._dashedStroke);
    }

    public void setFont(Font f) {
        this._g2d.setFont(f);
    }

    public void setPlainStroke() {
        this._g2d.setStroke(this._plainStroke);
    }

    private BasicStroke deriveStroke(BasicStroke s, double t) {
        return new BasicStroke((float)t, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
    }

    public void setStrokeThickness(double t) {
        boolean dashed = this._g2d.getStroke() == this._dashedStroke;
        this._plainStroke = this.deriveStroke(this._plainStroke, t);
        this._dashedStroke = this.deriveStroke(this._dashedStroke, t);
        if (dashed) {
            this._g2d.setStroke(this._dashedStroke);
        } else {
            this._g2d.setStroke(this._plainStroke);
        }
    }
}

