/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAnnotation
implements Serializable {
    private static final long serialVersionUID = 465236085501860747L;
    public static final int POSITION = 0;
    public static final int BASE = 1;
    public static final int HELIX = 2;
    public static final int LOOP = 3;
    public static final Color DEFAULTCOLOR = Color.black;
    public static final Font DEFAULTFONT = new Font("Arial", 0, 12);
    private String _texte;
    private Font _font;
    private Object _ancrage;
    private int _typeAncrage;
    private Color _color;
    private double _angle;

    public TextAnnotation(String texte) {
        this._texte = texte;
        this._color = DEFAULTCOLOR;
        this._font = DEFAULTFONT;
        this._angle = 0.0;
    }

    public TextAnnotation(String texte, double x, double y) {
        this(texte);
        this._ancrage = new VARNAPoint(x, y);
        this._typeAncrage = 0;
    }

    public TextAnnotation(String texte, ModeleBase mb) {
        this(texte);
        this._ancrage = mb;
        this._typeAncrage = 1;
    }

    public TextAnnotation(String texte, ArrayList<ModeleBase> listeBase, int type) throws Exception {
        this(texte);
        this._ancrage = listeBase;
        if (type == 2) {
            this._typeAncrage = 2;
        } else if (type == 3) {
            this._typeAncrage = 3;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public TextAnnotation(TextAnnotation textAnnotation) {
        this._ancrage = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._texte = textAnnotation.getTexte();
        this._typeAncrage = textAnnotation.getType();
    }

    public String getTexte() {
        return this._texte;
    }

    public void setTexte(String _texte) {
        this._texte = _texte;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font _font) {
        this._font = _font;
    }

    public Object getAncrage() {
        return this._ancrage;
    }

    public void setAncrage(ModeleBase mb) {
        this._ancrage = mb;
        this._typeAncrage = 1;
    }

    public void setAncrage(double x, double y) {
        this._ancrage = new VARNAPoint(x, y);
        this._typeAncrage = 0;
    }

    public void setAncrage(ArrayList<ModeleBase> list, int type) throws Exception {
        this._ancrage = list;
        if (type == 2) {
            this._typeAncrage = 2;
        } else if (type == 3) {
            this._typeAncrage = 3;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public int getType() {
        return this._typeAncrage;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public String getHelixDescription() {
        ArrayList listeBase = (ArrayList)this._ancrage;
        int minA = Integer.MAX_VALUE;
        int maxA = Integer.MIN_VALUE;
        int minB = Integer.MAX_VALUE;
        int maxB = Integer.MIN_VALUE;
        for (ModeleBase mb : listeBase) {
            int i = mb.getBaseNumber();
            if (mb.getElementStructure() > i) {
                minA = Math.min(minA, i);
                maxA = Math.max(maxA, i);
                continue;
            }
            minB = Math.min(minB, i);
            maxB = Math.max(maxB, i);
        }
        return "[" + minA + "," + maxA + "] [" + minB + "," + maxB + "]";
    }

    public String getLoopDescription() {
        ArrayList listeBase = (ArrayList)this._ancrage;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (ModeleBase mb : listeBase) {
            int i = mb.getBaseNumber();
            min = Math.min(min, i);
            max = Math.max(max, i);
        }
        return "[" + min + "," + max + "]";
    }

    public String toString() {
        String tmp = "[" + this._texte + "] ";
        switch (this._typeAncrage) {
            case 0: {
                DecimalFormat formatter = new DecimalFormat(".00");
                return String.valueOf(tmp) + " at (" + formatter.format(this.getCenterPosition().x) + "," + formatter.format(this.getCenterPosition().y) + ")";
            }
            case 1: {
                return String.valueOf(tmp) + " on base " + ((ModeleBase)this._ancrage).getBaseNumber();
            }
            case 2: {
                return String.valueOf(tmp) + " on helix " + this.getHelixDescription();
            }
            case 3: {
                return String.valueOf(tmp) + " on loop " + this.getLoopDescription();
            }
        }
        return tmp;
    }

    public Point2D.Double getCenterPosition() {
        switch (this._typeAncrage) {
            case 0: {
                return ((VARNAPoint)this._ancrage).toPoint2D();
            }
            case 1: {
                return ((ModeleBase)this._ancrage).getCoords();
            }
            case 2: {
                return this.calculLoopHelix();
            }
            case 3: {
                return this.calculLoop();
            }
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D.Double calculLoop() {
        ArrayList<ModeleBase> liste = this.extractedArrayListModeleBaseFromAncrage();
        double totalX = 0.0;
        double totalY = 0.0;
        for (ModeleBase base : liste) {
            totalX += base.getCoords().x;
            totalY += base.getCoords().y;
        }
        return new Point2D.Double(totalX / (double)liste.size(), totalY / (double)liste.size());
    }

    private Point2D.Double calculLoopHelix() {
        ArrayList<ModeleBase> liste = this.extractedArrayListModeleBaseFromAncrage();
        Collections.sort(liste);
        double totalX = 0.0;
        double totalY = 0.0;
        double num = 0.0;
        int i = 0;
        while (i < liste.size()) {
            ModeleBase base = liste.get(i);
            if (i > 0 && i < liste.size() - 1 || liste.size() <= 2) {
                totalX += base.getCoords().x;
                totalY += base.getCoords().y;
                num += 1.0;
            }
            ++i;
        }
        return new Point2D.Double(totalX / num, totalY / num);
    }

    private ArrayList<ModeleBase> extractedArrayListModeleBaseFromAncrage() {
        return (ArrayList)this._ancrage;
    }

    public TextAnnotation clone() {
        TextAnnotation textAnnot = null;
        try {
            switch (this._typeAncrage) {
                case 1: {
                    textAnnot = new TextAnnotation(this._texte, (ModeleBase)this._ancrage);
                    break;
                }
                case 0: {
                    textAnnot = new TextAnnotation(this._texte, ((VARNAPoint)this._ancrage).x, ((VARNAPoint)this._ancrage).y);
                    break;
                }
                case 3: {
                    textAnnot = new TextAnnotation(this._texte, this.extractedArrayListModeleBaseFromAncrage(), 3);
                    break;
                }
                case 2: {
                    textAnnot = new TextAnnotation(this._texte, this.extractedArrayListModeleBaseFromAncrage(), 2);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        textAnnot.setFont(this._font);
        textAnnot.setColor(this._color);
        return textAnnot;
    }

    public void copy(TextAnnotation textAnnotation) {
        this._ancrage = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._texte = textAnnotation.getTexte();
        this._typeAncrage = textAnnotation.getType();
        this._color = textAnnotation.getColor();
        this._angle = textAnnotation.getAngleInDegres();
    }

    public double getAngleInDegres() {
        return this._angle;
    }

    public double getAngleInRadians() {
        return this.getAngleInDegres() * Math.PI / 180.0;
    }

    public void setAngleInDegres(double _angle) {
        this._angle = _angle;
    }

    public void setAngleInRadians(double _angle) {
        this._angle = _angle * 180.0 / Math.PI;
    }
}

