/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightRegionAnnotation
implements Serializable {
    private static final long serialVersionUID = 7087014168028684775L;
    public static final Color DEFAULT_OUTLINE_COLOR = Color.decode("#6ed86e");
    public static final Color DEFAULT_FILL_COLOR = Color.decode("#bcffdd");
    public static final double DEFAULT_RADIUS = 16.0;
    private ArrayList<ModeleBase> _bases;
    private Color _outlineColor = DEFAULT_OUTLINE_COLOR;
    private Color _fillColor = DEFAULT_FILL_COLOR;
    private double _radius = 16.0;
    public static final int NUM_STEPS_ROUNDED_CORNERS = 10;

    public HighlightRegionAnnotation(RNA r, int startIndex, int stopIndex) {
        this(r.getBasesBetween(startIndex, stopIndex));
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> b) {
        this(b, DEFAULT_FILL_COLOR, DEFAULT_OUTLINE_COLOR, 16.0);
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> b, Color fill, Color outline, double radius) {
        this._bases = b;
        this._fillColor = fill;
        this._outlineColor = outline;
        this._radius = radius;
    }

    public HighlightRegionAnnotation clone() {
        return new HighlightRegionAnnotation(this._bases, this._fillColor, this._outlineColor, this._radius);
    }

    public int getMinIndex() {
        int min = Integer.MAX_VALUE;
        for (ModeleBase mb : this._bases) {
            min = Math.min(min, mb.getIndex());
        }
        return min;
    }

    public int getMaxIndex() {
        int max = Integer.MIN_VALUE;
        for (ModeleBase mb : this._bases) {
            max = Math.max(max, mb.getIndex());
        }
        return max;
    }

    public void setOutlineColor(Color c) {
        this._outlineColor = c;
    }

    public ArrayList<ModeleBase> getBases() {
        return this._bases;
    }

    public void setBases(ArrayList<ModeleBase> b) {
        this._bases = b;
    }

    public void setFillColor(Color c) {
        this._fillColor = c;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public Color getOutlineColor() {
        return this._outlineColor;
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double v) {
        this._radius = v;
    }

    public GeneralPath getShape(Point2D.Double[] realCoords, Point2D.Double[] realCenters, double scaleFactor) {
        Point2D.Double interForward;
        Point2D.Double nvn;
        double angle;
        Point2D.Double vn;
        Point2D.Double p3;
        int j;
        GeneralPath p = new GeneralPath();
        LinkedList<Point2D.Double> pointList = new LinkedList<Point2D.Double>();
        boolean isDirect = true;
        if (this.getBases().size() >= 2) {
            j = this.getBases().get(0).getIndex();
            Point2D.Double p1 = realCoords[j];
            Point2D.Double p2 = realCoords[j + 1];
            p3 = realCenters[j];
            isDirect = RNA.testDirectionality(p1, p3, p2);
        }
        if (this.getBases().size() > 0) {
            j = this.getBases().get(0).getIndex();
            Point2D.Double point = realCoords[j];
            Point2D.Double centerBck = realCenters[j];
            double dist = point.distance(centerBck);
            vn = new Point2D.Double((centerBck.x - point.x) / dist, (centerBck.y - point.y) / dist);
            int k = 1;
            while (k <= 10) {
                angle = (double)k * Math.PI / 11.0;
                if (isDirect) {
                    angle += Math.PI;
                }
                nvn = new Point2D.Double(Math.cos(angle) * vn.x + Math.sin(angle) * vn.y, -Math.sin(angle) * vn.x + Math.cos(angle) * vn.y);
                interForward = new Point2D.Double(point.x + scaleFactor * this.getRadius() * nvn.x, point.y + scaleFactor * this.getRadius() * nvn.y);
                pointList.addLast(interForward);
                ++k;
            }
        }
        int i = 0;
        while (i < this.getBases().size()) {
            int j1 = this.getBases().get(i).getIndex();
            if (j1 > 0 && j1 < realCoords.length - 1) {
                double nnorm;
                int j0 = j1 - 1;
                int j2 = j1 + 1;
                Point2D.Double p0 = realCoords[j0];
                Point2D.Double p1 = realCoords[j1];
                Point2D.Double p2 = realCoords[j2];
                double dist1 = p2.distance(p1);
                Point2D.Double v1 = new Point2D.Double((p2.x - p1.x) / dist1, (p2.y - p1.y) / dist1);
                Point2D.Double vn1 = new Point2D.Double(v1.y, -v1.x);
                double dist2 = p1.distance(p0);
                Point2D.Double v2 = new Point2D.Double((p1.x - p0.x) / dist2, (p1.y - p0.y) / dist2);
                Point2D.Double vn2 = new Point2D.Double(v2.y, -v2.x);
                double h = new Point2D.Double(vn2.x - vn1.x, vn2.y - vn1.y).distance(new Point2D.Double(0.0, 0.0)) / 2.0;
                Point2D.Double vn3 = new Point2D.Double((vn1.x + vn2.x) / 2.0, (vn1.y + vn2.y) / 2.0);
                double D = vn3.distance(new Point2D.Double(0.0, 0.0));
                vn3.x /= D;
                vn3.y /= D;
                double nnormF = nnorm = D + h * h / D;
                double nnormB = nnorm;
                Point2D.Double interForward2 = new Point2D.Double(p1.x + nnormF * scaleFactor * this.getRadius() * vn3.x, p1.y + nnormF * scaleFactor * this.getRadius() * vn3.y);
                Point2D.Double interBackward = new Point2D.Double(p1.x - nnormB * scaleFactor * this.getRadius() * vn3.x, p1.y - nnormB * scaleFactor * this.getRadius() * vn3.y);
                if (pointList.size() > 0) {
                    Point2D.Double prev1 = (Point2D.Double)pointList.getLast();
                    Point2D.Double prev2 = (Point2D.Double)pointList.getFirst();
                    if (interForward2.distance(prev1) + interBackward.distance(prev2) < interForward2.distance(prev2) + interBackward.distance(prev1)) {
                        pointList.addLast(interForward2);
                        pointList.addFirst(interBackward);
                    } else {
                        pointList.addFirst(interForward2);
                        pointList.addLast(interBackward);
                    }
                } else {
                    pointList.addLast(interForward2);
                    pointList.addFirst(interBackward);
                }
            }
            ++i;
        }
        if (this.getBases().size() >= 2) {
            j = this.getBases().get(this.getBases().size() - 1).getIndex();
            Point2D.Double p1 = realCoords[j];
            Point2D.Double p2 = realCoords[j - 1];
            p3 = realCenters[j];
            isDirect = RNA.testDirectionality(p1, p2, p3);
        }
        if (this.getBases().size() > 0) {
            j = this.getBases().get(this.getBases().size() - 1).getIndex();
            Point2D.Double point = realCoords[j];
            Point2D.Double centerBck = realCenters[j];
            double dist = point.distance(centerBck);
            vn = new Point2D.Double((centerBck.x - point.x) / dist, (centerBck.y - point.y) / dist);
            int k = 1;
            while (k <= 10) {
                angle = (double)k * Math.PI / 11.0;
                if (!isDirect) {
                    angle += Math.PI;
                }
                nvn = new Point2D.Double(Math.cos(angle) * vn.x + Math.sin(angle) * vn.y, -Math.sin(angle) * vn.x + Math.cos(angle) * vn.y);
                interForward = new Point2D.Double(point.x + scaleFactor * this.getRadius() * nvn.x, point.y + scaleFactor * this.getRadius() * nvn.y);
                pointList.addLast(interForward);
                ++k;
            }
        }
        if (pointList.size() > 0) {
            Point2D.Double point = (Point2D.Double)pointList.get(0);
            p.moveTo((float)point.x, (float)point.y);
            int i2 = 1;
            while (i2 < pointList.size()) {
                point = (Point2D.Double)pointList.get(i2);
                p.lineTo((float)point.x, (float)point.y);
                ++i2;
            }
            p.closePath();
        }
        return p;
    }

    public static HighlightRegionAnnotation parseHighlightRegionAnnotation(String txt, VARNAPanel vp) {
        try {
            String[] parts = txt.split(":");
            String[] coords = parts[0].split("-");
            int from = Integer.parseInt(coords[0]);
            int to = Integer.parseInt(coords[1]);
            int i = vp.getRNA().getIndexFromBaseNumber(from);
            int j = vp.getRNA().getIndexFromBaseNumber(to);
            Color fill = DEFAULT_FILL_COLOR;
            Color outline = DEFAULT_OUTLINE_COLOR;
            double radius = 16.0;
            ArrayList<ModeleBase> bases = vp.getRNA().getBasesBetween(i, j);
            try {
                String[] options = parts[1].split(",");
                int k = 0;
                while (k < options.length) {
                    try {
                        String[] data = options[k].split("=");
                        String lhs = data[0].toLowerCase();
                        String rhs = data[1];
                        if (lhs.equals("fill")) {
                            fill = VARNAConfigLoader.getSafeColor(rhs, fill);
                        } else if (lhs.equals("outline")) {
                            outline = VARNAConfigLoader.getSafeColor(rhs, outline);
                        } else if (lhs.equals("radius")) {
                            radius = Double.parseDouble(rhs);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++k;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new HighlightRegionAnnotation(bases, fill, outline, radius);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        String result = "Highlighted region " + this.getMinIndex() + "-" + this.getMaxIndex();
        return result;
    }
}

