/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class ChemProbAnnotation
implements Serializable {
    private static final long serialVersionUID = 5833315460145031242L;
    public static double DEFAULT_INTENSITY = 1.0;
    public static ChemProbAnnotationType DEFAULT_TYPE = ChemProbAnnotationType.ARROW_TYPE;
    public static Color DEFAULT_COLOR = Color.blue.darker();
    private ModeleBase _mbfst;
    private ModeleBase _mbsnd;
    private Color _color;
    private double _intensity;
    private ChemProbAnnotationType _type;
    private boolean _out;

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, String styleDesc) {
        this(mbfst, mbsnd);
        this.applyStyle(styleDesc);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd) {
        this(mbfst, mbsnd, DEFAULT_TYPE, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, double intensity) {
        this(mbfst, mbsnd, DEFAULT_TYPE, intensity);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, ChemProbAnnotationType type) {
        this(mbfst, mbsnd, type, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase mbfst, ModeleBase mbsnd, ChemProbAnnotationType type, double intensity) {
        if (mbfst.getIndex() > mbsnd.getIndex()) {
            ModeleBase tmp = mbsnd;
            mbsnd = mbfst;
            mbfst = tmp;
        }
        this._mbfst = mbfst;
        this._mbsnd = mbsnd;
        this._type = type;
        this._intensity = intensity;
        this._color = DEFAULT_COLOR;
        this._out = true;
    }

    public boolean isOut() {
        return this._out;
    }

    public void setOut(boolean b) {
        this._out = b;
    }

    public Color getColor() {
        return this._color;
    }

    public double getIntensity() {
        return this._intensity;
    }

    public ChemProbAnnotationType getType() {
        return this._type;
    }

    public void setColor(Color c) {
        this._color = c;
    }

    public void setIntensity(double d) {
        this._intensity = d;
    }

    public Point2D.Double getAnchorPosition() {
        Point2D.Double result = new Point2D.Double((this._mbfst.getCoords().x + this._mbsnd.getCoords().x) / 2.0, (this._mbfst.getCoords().y + this._mbsnd.getCoords().y) / 2.0);
        return result;
    }

    public Point2D.Double getDirVector() {
        Point2D.Double norm = this.getNormalVector();
        Point2D.Double result = new Point2D.Double(-norm.y, norm.x);
        Point2D.Double anchor = this.getAnchorPosition();
        Point2D.Double center = new Point2D.Double((this._mbfst.getCenter().x + this._mbsnd.getCenter().x) / 2.0, (this._mbfst.getCenter().y + this._mbsnd.getCenter().y) / 2.0);
        Point2D.Double vradius = new Point2D.Double((center.x - anchor.x) / 2.0, (center.y - anchor.y) / 2.0);
        if (this._out ? result.x * vradius.x + result.y * vradius.y > 0.0 : result.x * vradius.x + result.y * vradius.y < 0.0) {
            return new Point2D.Double(-result.x, -result.y);
        }
        return result;
    }

    public Point2D.Double getNormalVector() {
        Point2D.Double tmp = new Point2D.Double((this._mbsnd.getCoords().x - this._mbfst.getCoords().x) / 2.0, (this._mbsnd.getCoords().y - this._mbfst.getCoords().y) / 2.0);
        double norm = tmp.distance(0.0, 0.0);
        Point2D.Double result = new Point2D.Double(tmp.x / norm, tmp.y / norm);
        return result;
    }

    public void applyStyle(String styleDesc) {
        String[] chemProbs = styleDesc.split(",");
        int i = 0;
        while (i < chemProbs.length) {
            String thisStyle = chemProbs[i];
            String[] data = thisStyle.split("=");
            if (data.length == 2) {
                String name = data[0];
                String value = data[1];
                if (name.toLowerCase().equals("color")) {
                    Color c = Color.decode(value);
                    if (c == null) {
                        c = this._color;
                    }
                    this.setColor(c);
                } else if (name.toLowerCase().equals("intensity")) {
                    this._intensity = Double.parseDouble(value);
                } else if (name.toLowerCase().equals("dir")) {
                    this._out = value.toLowerCase().equals("out");
                } else if (name.toLowerCase().equals("glyph")) {
                    if (value.toLowerCase().equals("arrow")) {
                        this._type = ChemProbAnnotationType.ARROW_TYPE;
                    } else if (value.toLowerCase().equals("triangle")) {
                        this._type = ChemProbAnnotationType.TRIANGLE_TYPE;
                    } else if (value.toLowerCase().equals("pin")) {
                        this._type = ChemProbAnnotationType.PIN_TYPE;
                    } else if (value.toLowerCase().equals("dot")) {
                        this._type = ChemProbAnnotationType.DOT_TYPE;
                    }
                }
            }
            ++i;
        }
    }

    public void setType(ChemProbAnnotationType s) {
        this._type = s;
    }

    public ChemProbAnnotation clone() {
        ChemProbAnnotation result = new ChemProbAnnotation(this._mbfst, this._mbsnd);
        result._intensity = this._intensity;
        result._type = this._type;
        result._color = this._color;
        result._out = this._out;
        return result;
    }

    public String toString() {
        return "Chem. prob. " + (Object)((Object)this._type) + " Base#" + this._mbfst.getBaseNumber() + "-" + this._mbsnd.getBaseNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChemProbAnnotationType {
        TRIANGLE_TYPE,
        ARROW_TYPE,
        PIN_TYPE,
        DOT_TYPE;


        public String toString() {
            switch (this) {
                case TRIANGLE_TYPE: {
                    return "Triangle";
                }
                case ARROW_TYPE: {
                    return "Arrow";
                }
                case DOT_TYPE: {
                    return "Dot";
                }
                case PIN_TYPE: {
                    return "Pin";
                }
            }
            return "Unknown";
        }
    }
}

