/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.views.VueAnnotation;
import fr.orsay.lri.varna.views.VueChemProbAnnotation;
import fr.orsay.lri.varna.views.VueHighlightRegionEdit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;

public class ControleurTableAnnotations
implements MouseListener,
MouseMotionListener {
    public static final int REMOVE = 0;
    public static final int EDIT = 1;
    private JTable _table;
    private VARNAPanel _vp;
    private int _type;

    public ControleurTableAnnotations(JTable table, VARNAPanel vp, int type) {
        this._table = table;
        this._vp = vp;
        this._type = type;
    }

    public void mouseClicked(MouseEvent arg0) {
        switch (this._type) {
            case 1: {
                this.edit();
                break;
            }
            case 0: {
                this.remove();
                break;
            }
        }
    }

    private void remove() {
        this._vp.set_selectedAnnotation(null);
        Object o = this._table.getValueAt(this._table.getSelectedRow(), 0);
        if (o instanceof TextAnnotation) {
            if (!this._vp.removeAnnotation((TextAnnotation)o)) {
                this._vp.errorDialog(new Exception("Impossible de supprimer"));
            }
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        } else if (o instanceof ChemProbAnnotation) {
            this._vp.getRNA().removeChemProbAnnotation((ChemProbAnnotation)o);
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        } else if (o instanceof HighlightRegionAnnotation) {
            this._vp.getRNA().removeHighlightRegion((HighlightRegionAnnotation)o);
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        }
        this._vp.repaint();
    }

    private void edit() {
        Object o = this._table.getValueAt(this._table.getSelectedRow(), 0);
        if (o instanceof TextAnnotation) {
            TextAnnotation textAnnot = (TextAnnotation)o;
            VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnot, false);
            vueAnnotation.show();
        } else if (o instanceof HighlightRegionAnnotation) {
            HighlightRegionAnnotation annot = (HighlightRegionAnnotation)o;
            HighlightRegionAnnotation an = annot.clone();
            VueHighlightRegionEdit vueAnnotation = new VueHighlightRegionEdit(this._vp, annot);
            if (!vueAnnotation.show()) {
                annot.setBases(an.getBases());
                annot.setFillColor(an.getFillColor());
                annot.setOutlineColor(an.getOutlineColor());
                annot.setRadius(an.getRadius());
            }
        } else if (o instanceof ChemProbAnnotation) {
            ChemProbAnnotation annot = (ChemProbAnnotation)o;
            ChemProbAnnotation an = annot.clone();
            VueChemProbAnnotation vueAnnotation = new VueChemProbAnnotation(this._vp, annot);
            if (!vueAnnotation.show()) {
                annot.setColor(an.getColor());
                annot.setIntensity(an.getIntensity());
                annot.setType(an.getType());
                annot.setOut(an.isOut());
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
        this._vp.set_selectedAnnotation(null);
        this._vp.repaint();
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
        if (this._table.rowAtPoint(arg0.getPoint()) < 0) {
            return;
        }
        Object o = this._table.getValueAt(this._table.rowAtPoint(arg0.getPoint()), 0);
        if (o.getClass().equals(TextAnnotation.class) && o != this._vp.get_selectedAnnotation()) {
            this._vp.set_selectedAnnotation((TextAnnotation)o);
            this._vp.repaint();
        }
    }
}

