/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.applications.VARNAOnlineDemo;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class ControleurDemoTextField
implements CaretListener {
    private VARNAOnlineDemo _vod;
    private String _oldSeq;
    private String _oldStruct;
    private Highlighter _hilit;
    private Highlighter.HighlightPainter _painter;
    private final Color COLORERROR = Color.RED;
    private final Color COLORWARNING = Color.ORANGE;

    public ControleurDemoTextField(VARNAOnlineDemo VOD) {
        this._vod = VOD;
        this._oldSeq = this._vod.get_seq().getText();
        this._oldStruct = this._vod.get_struct().getText();
        this._hilit = new DefaultHighlighter();
        this._painter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        this._vod.get_struct().setHighlighter(this._hilit);
    }

    public void caretUpdate(CaretEvent e) {
        if (this._oldStruct != this._vod.get_struct().getText() || this._oldSeq != this._vod.get_seq().getText()) {
            ArrayList<String> infos = new ArrayList<String>();
            this._vod.get_info().removeAll();
            this._hilit.removeAllHighlights();
            this._oldStruct = this._vod.get_struct().getText();
            this._oldSeq = this._vod.get_seq().getText();
            int nbPO = 0;
            int nbPF = 0;
            Stack<Integer> p = new Stack<Integer>();
            boolean pb = false;
            int i = 0;
            while (i < this._vod.get_struct().getText().length()) {
                if (this._vod.get_struct().getText().charAt(i) == '(') {
                    ++nbPO;
                    p.push(i);
                } else if (this._vod.get_struct().getText().charAt(i) == ')') {
                    ++nbPF;
                    if (p.size() == 0) {
                        try {
                            this._hilit.addHighlight(i, i + 1, this._painter);
                        }
                        catch (BadLocationException e1) {
                            this._vod.get_varnaPanel().errorDialog(e1);
                        }
                        pb = true;
                    } else {
                        p.pop();
                    }
                }
                ++i;
            }
            if (pb || p.size() > 0) {
                if (pb) {
                    infos.add("too many closing parentheses");
                }
                if (p.size() > 0) {
                    while (!p.isEmpty()) {
                        int indice = (Integer)p.pop();
                        try {
                            this._hilit.addHighlight(indice, indice + 1, this._painter);
                        }
                        catch (BadLocationException e1) {
                            this._vod.get_varnaPanel().errorDialog(e1);
                        }
                    }
                    infos.add("too many opening parentheses");
                }
                this._vod.get_info().setForeground(this.COLORERROR);
                this._vod.get_seq().setForeground(this.COLORERROR);
                this._vod.get_struct().setForeground(this.COLORERROR);
            } else {
                try {
                    this._vod.get_varnaPanel().drawRNA(this._vod.get_seq().getText(), this._vod.get_struct().getText(), this._vod.get_varnaPanel().getRNA().get_drawMode());
                }
                catch (ExceptionNonEqualLength e1) {
                    this._vod.get_varnaPanel().errorDialog(e1);
                }
                if (this._vod.get_seq().getText().length() != this._vod.get_struct().getText().length()) {
                    infos.add("different lenghts");
                    this._vod.get_seq().setForeground(this.COLORWARNING);
                    this._vod.get_struct().setForeground(this.COLORWARNING);
                } else {
                    this._vod.get_seq().setForeground(Color.black);
                    this._vod.get_struct().setForeground(Color.black);
                }
            }
            this._vod.get_varnaPanel().getVARNAUI().UIReset();
            String info = new String();
            if (infos.size() != 0) {
                info = String.valueOf(info) + (String)infos.get(0);
                int i2 = 1;
                while (i2 < infos.size()) {
                    info = String.valueOf(info) + ", " + (String)infos.get(i2);
                    ++i2;
                }
                info = String.valueOf(info) + ".";
            }
            this._vod.get_info().setText(info);
        }
    }
}

