/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurSelectionHighlight;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ControleurClicMovement
implements MouseListener,
MouseMotionListener,
PopupMenuListener {
    private VARNAPanel _vp;
    private boolean _presenceMenuSelection;
    private JMenu _submenuSelection;
    public Point _spawnPoint;
    public Point _initialPoint;
    public Point _prevPoint;
    public Point _currentPoint;
    public static final double MIN_SELECTION_DISTANCE = 40.0;
    public static final double HYSTERESIS_DISTANCE = 10.0;
    private ModeleBase _selectedBase = null;
    private MouseStates _currentState = MouseStates.NONE;

    public ControleurClicMovement(VARNAPanel _vuep) {
        this._vp = _vuep;
        this._vp.getPopup().addPopupMenuListener(this);
        this._presenceMenuSelection = false;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        this._vp.requestFocus();
        boolean button1 = arg0.getButton() == 1;
        boolean button2 = arg0.getButton() == 2;
        boolean button3 = arg0.getButton() == 3;
        boolean shift = arg0.isShiftDown();
        boolean ctrl = arg0.isControlDown();
        boolean alt = arg0.isAltDown();
        this._vp.removeSelectedAnnotation();
        if (button1 && !ctrl && !alt && !shift) {
            if (this._vp.isModifiable()) {
                this._currentState = MouseStates.MOVE_OR_SELECT_ELEMENT;
                if (this._vp.getRealCoords() != null && this._vp.getRealCoords().length != 0 && this._vp.getRNA().get_listeBases().size() != 0) {
                    this._selectedBase = this.getNearestBase(arg0, false, false);
                    TextAnnotation selectedAnnotation = this.getNearestAnnotation(arg0);
                    this._initialPoint = new Point(arg0.getX(), arg0.getY());
                    this._currentPoint = new Point(this._initialPoint);
                    this._prevPoint = new Point(this._initialPoint);
                    if (this._selectedBase != null) {
                        if (this._vp.getRNA().get_drawMode() == 2) {
                            this._vp.highlightSelectedBase(this._selectedBase);
                        } else if (!this._vp.getSelectionIndices().contains(this._selectedBase.getIndex())) {
                            this._vp.highlightSelectedBase(this._selectedBase);
                        }
                    } else if (selectedAnnotation != null) {
                        this._currentState = MouseStates.MOVE_ANNOTATION;
                        this._vp.set_selectedAnnotation(selectedAnnotation);
                        this._vp.highlightSelectedAnnotation();
                    } else {
                        this._vp.clearSelection();
                        this._selectedBase = null;
                        this._currentState = MouseStates.SELECT_REGION_OR_UNSELECT;
                        this._initialPoint = new Point(arg0.getX(), arg0.getY());
                        this._prevPoint = new Point(this._initialPoint);
                        this._currentPoint = new Point(this._initialPoint);
                    }
                }
            }
        } else if (button1 && ctrl && !alt && !shift) {
            this._selectedBase = this.getNearestBase(arg0, false, false);
            if (this._selectedBase != null) {
                this._vp.clearSelection();
                this._currentState = MouseStates.CREATE_BP;
                this._vp.highlightSelectedBase(this._selectedBase);
                this._vp.setOriginLink(this._vp.logicToPanel(this._selectedBase.getCoords()));
                this._initialPoint = new Point(arg0.getX(), arg0.getY());
                this._currentPoint = new Point(this._initialPoint);
            }
        } else if (button1 && !ctrl && !alt && shift) {
            this._currentState = MouseStates.SELECT_ELEMENT;
            this._initialPoint = new Point(arg0.getX(), arg0.getY());
            this._currentPoint = new Point(this._initialPoint);
        } else if (button3) {
            this._currentState = MouseStates.POPUP_MENU;
            if (this._presenceMenuSelection) {
                this._vp.getPopupMenu().removeSelectionMenu();
            }
            if (this._vp.getRealCoords() != null && this._vp.getRNA().get_listeBases().size() != 0) {
                this.updateNearestBase(arg0);
                this.addMenu(arg0);
                if (this._vp.get_selectedAnnotation() != null) {
                    this._vp.highlightSelectedAnnotation();
                }
            }
            if (this._vp.getRNA().get_drawMode() == 4) {
                this._vp.getPopup().get_rotation().setEnabled(false);
            } else {
                this._vp.getPopup().get_rotation().setEnabled(true);
            }
            this._vp.getPopup().updateDialog();
            this._vp.getPopup().show(this._vp, arg0.getX(), arg0.getY());
        }
        this._vp.repaint();
    }

    public void mouseDragged(MouseEvent me) {
        if (this._currentState == MouseStates.MOVE_OR_SELECT_ELEMENT || this._currentState == MouseStates.MOVE_ELEMENT) {
            this._vp.lockScrolling();
            this._currentState = MouseStates.MOVE_ELEMENT;
            if (this._selectedBase != null) {
                if (this._vp.getRNA().get_drawMode() == 2) {
                    this._vp.highlightSelectedStem(this._selectedBase);
                    this._vp.getVARNAUI().UIMoveHelixAtom(this._selectedBase.getIndex(), this._vp.panelToLogicPoint(new Point2D.Double(me.getX(), me.getY())));
                } else {
                    this._currentPoint = new Point(me.getX(), me.getY());
                    this.moveSelection(this._prevPoint, this._currentPoint);
                    this._prevPoint = new Point(this._currentPoint);
                }
                this._vp.repaint();
            }
        } else if (this._currentState == MouseStates.MOVE_ANNOTATION) {
            if (this._vp.get_selectedAnnotation() != null) {
                Point2D.Double p = this._vp.panelToLogicPoint(new Point2D.Double(me.getX(), me.getY()));
                this._vp.get_selectedAnnotation().setAncrage(p.x, p.y);
                this._vp.repaint();
            }
        } else if (this._currentState == MouseStates.SELECT_ELEMENT || this._currentState == MouseStates.SELECT_REGION_OR_UNSELECT) {
            if (this._initialPoint.distance(me.getX(), me.getY()) > 10.0) {
                this._currentState = MouseStates.SELECT_REGION;
            }
        } else if (this._currentState == MouseStates.SELECT_REGION) {
            this._currentPoint = new Point(me.getX(), me.getY());
            int minx = Math.min(this._currentPoint.x, this._initialPoint.x);
            int miny = Math.min(this._currentPoint.y, this._initialPoint.y);
            int maxx = Math.max(this._currentPoint.x, this._initialPoint.x);
            int maxy = Math.max(this._currentPoint.y, this._initialPoint.y);
            this._vp.setSelectionRectangle(new Rectangle(minx, miny, maxx - minx, maxy - miny));
        } else if (this._currentState == MouseStates.CREATE_BP && this._initialPoint.distance(me.getX(), me.getY()) > 10.0) {
            ModeleBase newSelectedBase = this.getNearestBase(me, false, false);
            this._vp.setHoverBase(newSelectedBase);
            if (newSelectedBase == null) {
                this._vp.setDestinationLink(new Point2D.Double(me.getX(), me.getY()));
                this._vp.clearSelection();
                this._vp.addToSelection(this._selectedBase.getIndex());
            } else {
                ModeleBase mborig = this._selectedBase;
                this._vp.clearSelection();
                this._vp.addToSelection(newSelectedBase.getIndex());
                this._vp.addToSelection(mborig.getIndex());
                this._vp.setDestinationLink(this._vp.logicToPanel(newSelectedBase.getCoords()));
            }
            this._vp.repaint();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (arg0.getButton() == 1) {
            if (this._currentState == MouseStates.MOVE_ELEMENT) {
                this._vp.clearSelection();
                this._selectedBase = null;
                this._vp.unlockScrolling();
                this._vp.removeSelectedAnnotation();
            } else if (this._currentState == MouseStates.SELECT_REGION_OR_UNSELECT) {
                this._vp.clearSelection();
                this._selectedBase = null;
                this._vp.removeSelectedAnnotation();
            } else if (this._currentState == MouseStates.SELECT_ELEMENT) {
                int selectedIndex;
                if (this._vp.getRealCoords() != null && this._vp.getRealCoords().length != 0 && this._vp.getRNA().get_listeBases().size() != 0 && (selectedIndex = this.getNearestBaseIndex(arg0, false, false)) != -1) {
                    this._vp.toggleSelection(selectedIndex);
                }
                this._selectedBase = null;
            } else if (this._currentState == MouseStates.SELECT_REGION) {
                this._vp.removeSelectionRectangle();
            } else if (this._currentState == MouseStates.CREATE_BP) {
                int selectedIndex;
                if (this._initialPoint.distance(arg0.getX(), arg0.getY()) > 10.0 && (selectedIndex = this.getNearestBaseIndex(arg0, false, false)) >= 0) {
                    ModeleBase mb = this.getNearestBase(arg0, false, false);
                    ModeleBase mborig = this._selectedBase;
                    ModeleBP msbp = new ModeleBP(mb, mborig);
                    if (mb != mborig) {
                        this._vp.getVARNAUI().UIAddBP(mb.getIndex(), mborig.getIndex(), msbp);
                    }
                }
                this._vp.removeLink();
                this._vp.clearSelection();
                this._vp.repaint();
            }
        }
        this._vp.removeSelectedAnnotation();
        this._currentState = MouseStates.NONE;
        this._vp.repaint();
    }

    private void addMenu(MouseEvent arg0) {
        this._submenuSelection = new JMenu("Selection");
        this.addCurrent();
        this.addMenuBase();
        if (this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase()).getElementStructure() != -1) {
            this.addMenuBasePair();
        }
        this.detectBulge();
        this.detect3Prime();
        this.detect5Prime();
        this.detectLoop();
        this.detectHelix();
        this.detectStem();
        this.addAllBase();
        this.detectAnnotation(arg0);
        this._vp.getPopup().addSelectionMenu(this._submenuSelection);
        this._presenceMenuSelection = true;
    }

    private void detectAnnotation(MouseEvent arg0) {
        if (this._vp.getListeAnnotations().size() != 0) {
            double dist = Double.MAX_VALUE;
            for (TextAnnotation textAnnot : this._vp.getListeAnnotations()) {
                Point2D.Double position = textAnnot.getCenterPosition();
                position = this._vp.transformCoord(position);
                double d2 = Math.sqrt(Math.pow(position.x - (double)arg0.getX(), 2.0) + Math.pow(position.y - (double)arg0.getY(), 2.0));
                if (!(dist > d2)) continue;
                this._vp.set_selectedAnnotation(textAnnot);
                dist = d2;
            }
            this._submenuSelection.addSeparator();
            this._vp.getPopup().addAnnotationMenu(this._submenuSelection, true);
        }
    }

    private void detectBulge() {
        int indiceB = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().findBulge(indiceB);
        if (indices.size() > 0 && this._vp.getRNA().getHelixCountOnLoop(this._vp.getNearestBase()) == 2) {
            JMenu submenuBulge = new JMenu("Bulge");
            submenuBulge.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenuBulge));
            submenuBulge.setActionCommand("bulge");
            if (!this._vp.isModifiable()) {
                submenuBulge.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenuBulge);
            this._submenuSelection.add(submenuBulge);
        }
    }

    private void detectHelix() {
        int indiceH = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().findHelix(indiceH);
        if (indices.size() != 0) {
            JMenu submenuHelix = new JMenu("Helix");
            submenuHelix.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenuHelix));
            submenuHelix.setActionCommand("helix");
            if (!this._vp.isModifiable()) {
                submenuHelix.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenuHelix);
            submenuHelix.addSeparator();
            this._vp.getPopupMenu().addAnnotationMenu(submenuHelix);
            this._submenuSelection.add(submenuHelix);
        }
    }

    private void detectStem() {
        int indiceS = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().findStem(indiceS);
        if (indices.size() > 0) {
            JMenu submenuStem = new JMenu("Stem");
            submenuStem.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenuStem));
            submenuStem.setActionCommand("stem");
            if (!this._vp.isModifiable()) {
                submenuStem.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenuStem);
            this._submenuSelection.add(submenuStem);
        }
    }

    private void detect3Prime() {
        int indice3 = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().find3Prime(indice3);
        if (indices.size() != 0) {
            JMenu submenu3Prime = new JMenu("3'");
            submenu3Prime.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenu3Prime));
            submenu3Prime.setActionCommand("3'");
            if (!this._vp.isModifiable()) {
                submenu3Prime.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenu3Prime);
            this._submenuSelection.add(submenu3Prime);
        }
    }

    private void detect5Prime() {
        int indice5 = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().find5Prime(indice5);
        if (indices.size() != 0) {
            JMenu submenu5Prime = new JMenu("5'");
            submenu5Prime.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenu5Prime));
            submenu5Prime.setActionCommand("5'");
            if (!this._vp.isModifiable()) {
                submenu5Prime.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenu5Prime);
            this._submenuSelection.add(submenu5Prime);
        }
    }

    private void detectLoop() {
        int indexL = this._vp.getNearestBase();
        if (this._vp.getRNA().get_listeBases().get(indexL).getElementStructure() == -1) {
            ArrayList<Integer> listLoop = this._vp.getRNA().findLoop(indexL);
            JMenu submenuLoop = new JMenu("Loop");
            submenuLoop.addChangeListener(new ControleurSelectionHighlight(listLoop, this._vp, (JMenuItem)submenuLoop));
            submenuLoop.setActionCommand("loop1");
            if (!this._vp.isModifiable()) {
                submenuLoop.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenuLoop);
            submenuLoop.addSeparator();
            this._vp.getPopupMenu().addAnnotationMenu(submenuLoop);
            this._submenuSelection.add(submenuLoop);
        } else {
            ArrayList<Integer> listLoop2;
            ArrayList<Integer> listLoop1 = this._vp.getRNA().findLoopForward(indexL);
            if (listLoop1.size() > 0) {
                JMenu submenuLoop1 = new JMenu("Forward loop");
                submenuLoop1.addChangeListener(new ControleurSelectionHighlight(listLoop1, this._vp, (JMenuItem)submenuLoop1));
                submenuLoop1.setActionCommand("loop1");
                if (!this._vp.isModifiable()) {
                    submenuLoop1.setEnabled(false);
                }
                this._vp.getPopupMenu().addColorOptions(submenuLoop1);
                submenuLoop1.addSeparator();
                this._vp.getPopupMenu().addAnnotationMenu(submenuLoop1);
                this._submenuSelection.add(submenuLoop1);
            }
            if ((listLoop2 = this._vp.getRNA().findLoopBackward(indexL)).size() > 0) {
                JMenu submenuLoop2 = new JMenu("Backward loop");
                submenuLoop2.addChangeListener(new ControleurSelectionHighlight(listLoop2, this._vp, (JMenuItem)submenuLoop2));
                submenuLoop2.setActionCommand("loop2");
                if (!this._vp.isModifiable()) {
                    submenuLoop2.setEnabled(false);
                }
                this._vp.getPopupMenu().addColorOptions(submenuLoop2);
                submenuLoop2.addSeparator();
                this._vp.getPopupMenu().addAnnotationMenu(submenuLoop2);
                this._submenuSelection.add(submenuLoop2);
            }
        }
    }

    private void addCurrent() {
        ArrayList<ModeleBase> mbs = this._vp.getSelection().getBases();
        if (mbs.size() > 0) {
            JMenu submenuAll = new JMenu("Current");
            submenuAll.addChangeListener(new ControleurSelectionHighlight((Collection<? extends ModeleBase>)mbs, this._vp, (JMenuItem)submenuAll));
            submenuAll.setActionCommand("current");
            if (!this._vp.isModifiable()) {
                submenuAll.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(submenuAll);
            this._submenuSelection.add(submenuAll);
        }
    }

    private void addMenuBase() {
        JMenu submenuBase = new JMenu();
        ModeleBase mb = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase());
        if (mb instanceof ModeleBasesComparison) {
            submenuBase.setText("Base #" + mb.getBaseNumber() + ":" + ((ModeleBasesComparison)mb).getBases());
        } else {
            submenuBase.setText("Base #" + mb.getBaseNumber() + ":" + ((ModeleBaseNucleotide)mb).get_c());
        }
        submenuBase.addChangeListener(new ControleurSelectionHighlight(mb.getIndex(), this._vp, (JMenuItem)submenuBase));
        submenuBase.setActionCommand("base");
        if (!this._vp.isModifiable()) {
            submenuBase.setEnabled(false);
        }
        JMenuItem baseChar = new JMenuItem("Edit base");
        baseChar.setActionCommand("baseChar");
        baseChar.addActionListener(this._vp.getPopupMenu().get_controleurMenu());
        submenuBase.add(baseChar);
        this._vp.getPopupMenu().addColorOptions(submenuBase);
        submenuBase.addSeparator();
        this._vp.getPopupMenu().addAnnotationMenu(submenuBase);
        this._submenuSelection.add(submenuBase);
    }

    private void addAllBase() {
        ArrayList<Integer> indices = this._vp.getRNA().findAll();
        JMenu submenuAll = new JMenu("All");
        submenuAll.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(indices), this._vp, (JMenuItem)submenuAll));
        submenuAll.setActionCommand("all");
        if (!this._vp.isModifiable()) {
            submenuAll.setEnabled(false);
        }
        this._vp.getPopupMenu().addColorOptions(submenuAll);
        this._submenuSelection.add(submenuAll);
    }

    private void addMenuBasePair() {
        int indiceBP = this._vp.getNearestBase();
        ArrayList<Integer> indices = this._vp.getRNA().findPair(indiceBP);
        ModeleBase base = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase());
        if (base.getElementStructure() != -1) {
            JMenu submenuBasePair = new JMenu();
            ModeleBase partner = this._vp.getRNA().get_listeBases().get(base.getElementStructure());
            submenuBasePair.addChangeListener(new ControleurSelectionHighlight(indices, this._vp, (JMenuItem)submenuBasePair));
            submenuBasePair.setText("Base pair #(" + Math.min(base.getBaseNumber(), partner.getBaseNumber()) + "," + Math.max(base.getBaseNumber(), partner.getBaseNumber()) + ")");
            submenuBasePair.setActionCommand("bp");
            if (!this._vp.isModifiable()) {
                submenuBasePair.setEnabled(false);
            }
            JMenuItem basepair = new JMenuItem("Edit BP");
            basepair.setActionCommand("basepair");
            basepair.addActionListener(this._vp.getPopupMenu().get_controleurMenu());
            this._vp.getPopupMenu().addColorOptions(submenuBasePair);
            Component[] comps = submenuBasePair.getMenuComponents();
            int offset = -1;
            int i = 0;
            while (i < comps.length) {
                JMenuItem jmi;
                Component c = comps[i];
                if (c instanceof JMenuItem && (jmi = (JMenuItem)c).getActionCommand().contains(",BPColor")) {
                    offset = i;
                }
                ++i;
            }
            if (offset != -1) {
                submenuBasePair.insert(basepair, offset);
            } else {
                submenuBasePair.add(basepair);
            }
            this._submenuSelection.add(submenuBasePair);
        }
    }

    private ModeleBase getNearestBase(MouseEvent arg0, boolean always, boolean onlyPaired) {
        int i = this.getNearestBaseIndex(arg0, always, onlyPaired);
        if (i == -1) {
            return null;
        }
        return this._vp.getRNA().get_listeBases().get(i);
    }

    private ModeleBase getNearestBase(MouseEvent arg0) {
        return this.getNearestBase(arg0, false, false);
    }

    private int getNearestBaseIndex(MouseEvent arg0, boolean always, boolean onlyPaired) {
        double dist = Double.MAX_VALUE;
        int mb = -1;
        int i = 0;
        while (i < this._vp.getRealCoords().length) {
            double d2;
            if ((!onlyPaired || this._vp.getRNA().get_listeBases().get(i).getElementStructure() != -1) && dist > (d2 = Math.sqrt(Math.pow(this._vp.getRealCoords()[i].x - (double)arg0.getX(), 2.0) + Math.pow(this._vp.getRealCoords()[i].y - (double)arg0.getY(), 2.0))) && (d2 < this._vp.getScaleFactor() * 40.0 || always)) {
                dist = d2;
                mb = i;
            }
            ++i;
        }
        return mb;
    }

    private void updateNearestBase(MouseEvent arg0) {
        int i = this.getNearestBaseIndex(arg0, true, false);
        if (i != -1) {
            this._vp.setNearestBase(i);
        }
    }

    private TextAnnotation getNearestAnnotation(MouseEvent arg0) {
        TextAnnotation t = null;
        if (this._vp.getListeAnnotations().size() != 0) {
            double dist = Double.MAX_VALUE;
            for (TextAnnotation textAnnot : this._vp.getListeAnnotations()) {
                Point2D.Double position = textAnnot.getCenterPosition();
                position = this._vp.transformCoord(position);
                double d2 = Math.sqrt(Math.pow(position.x - (double)arg0.getX(), 2.0) + Math.pow(position.y - (double)arg0.getY(), 2.0));
                if (!(dist > d2) || !(d2 < this._vp.getScaleFactor() * 40.0)) continue;
                t = textAnnot;
                dist = d2;
            }
        }
        return t;
    }

    public void mouseMoved(MouseEvent arg0) {
        this._selectedBase = this.getNearestBase(arg0);
        TextAnnotation selectedAnnotation = this.getNearestAnnotation(arg0);
        this._vp.setHoverBase(this._selectedBase);
        if (this._selectedBase == null && selectedAnnotation != null) {
            this._vp.set_selectedAnnotation(selectedAnnotation);
            this._vp.highlightSelectedAnnotation();
            this._vp.repaint();
        }
        this._vp.setLastSelectedPosition(new Point2D.Double(arg0.getX(), arg0.getY()));
    }

    private void moveSelection(Point prev, Point cur) {
        Point2D.Double p1 = this._vp.panelToLogicPoint(new Point2D.Double(prev.x, prev.y));
        Point2D.Double p2 = this._vp.panelToLogicPoint(new Point2D.Double(cur.x, cur.y));
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        if (this._vp.isModifiable()) {
            double ndx = dx;
            double ndy = dy;
            if (this._vp.getRNA().get_drawMode() == 4) {
                ndy = 0.0;
            }
            this._vp.getVARNAUI().UIShiftBaseCoord(this._vp.getSelectionIndices(), ndx, ndy);
            this._vp.fireLayoutChanged();
        }
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this._vp.resetAnnotationHighlight();
        this._selectedBase = null;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MouseStates {
        NONE,
        MOVE_ELEMENT,
        MOVE_OR_SELECT_ELEMENT,
        SELECT_ELEMENT,
        SELECT_REGION_OR_UNSELECT,
        SELECT_REGION,
        CREATE_BP,
        POPUP_MENU,
        MOVE_ANNOTATION;

    }
}

