/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class GradientEditorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    ModeleColorMap _mcm;
    private static final int TRIGGERS_SEMI_WIDTH = 2;
    private static final int PALETTE_HEIGHT = 11;
    private static final int REMOVE_HEIGHT = 11;
    private static final int TOLERANCE = 5;
    private static final int GAP = 4;
    private final Color EDGES = Color.gray.brighter();
    private final Color BUTTONS = Color.LIGHT_GRAY.brighter();
    private int _selectedIndex = -1;

    public GradientEditorPanel(ModeleColorMap mcm) {
        this._mcm = mcm;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColorMap(ModeleColorMap mcm) {
        this._mcm = mcm;
    }

    public ModeleColorMap getColorMap() {
        return this._mcm;
    }

    public int getStartChoose() {
        return this.getHeight() - 11 - 11 - 4 - 1;
    }

    public int getEndChoose() {
        return this.getStartChoose() + 11;
    }

    public int getStartRemove() {
        return this.getEndChoose() + 4;
    }

    public int getEndRemove() {
        return this.getStartRemove() + 11;
    }

    private int getStripeHeight() {
        return this.getHeight() - 11 - 11 - 8 - 1;
    }

    private Color alterColor(Color c, int inc) {
        int nr = Math.min(Math.max(c.getRed() + inc, 0), 255);
        int ng = Math.min(Math.max(c.getGreen() + inc, 0), 255);
        int nb = Math.min(Math.max(c.getBlue() + inc, 0), 255);
        return new Color(nr, ng, nb);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getStripeHeight();
        double v1 = this._mcm.getMinValue();
        double v2 = this._mcm.getMaxValue();
        int i = 0;
        while (i <= this.getWidth()) {
            double ratio = (double)i / (double)this.getWidth();
            double val = v1 + (v2 - v1) * ratio;
            g2d.setColor(this._mcm.getColorForValue(val));
            g2d.drawLine(i, 0, i, height);
            ++i;
        }
        i = 0;
        while (i < this._mcm.getNumColors()) {
            double val = this._mcm.getValueAt(i);
            Color c = this._mcm.getColorAt(i);
            double norm = (val - this._mcm.getMinValue()) / (this._mcm.getMaxValue() - this._mcm.getMinValue());
            int x = (int)(norm * (double)(this.getWidth() - 1));
            g2d.setColor(c);
            g2d.fillRect(x - 2 + 1, 0, 3, this.getHeight() - 1);
            g2d.setColor(this.EDGES);
            g2d.drawLine(x - 2, 0, x - 2, this.getHeight());
            g2d.drawLine(x + 2, 0, x + 2, this.getHeight());
            if (i == 0) {
                g2d.setColor(this.EDGES);
                g2d.drawRect(x, height + 4, 11, 26);
                g2d.setColor(c);
                g2d.fillRect(x + 1, height + 4 + 1, 10, 25);
            } else if (i == this._mcm.getNumColors() - 1) {
                g2d.setColor(this.EDGES);
                g2d.drawRect(x - 11, height + 4, 11, 26);
                g2d.setColor(c);
                g2d.fillRect(x - 11 + 1, height + 4 + 1, 10, 25);
            } else {
                g2d.setColor(this.EDGES);
                g2d.drawRect(x - 5, height + 4, 11, 11);
                g2d.setColor(this.alterColor(c, -15));
                g2d.fillRect(x - 5 + 1, height + 4 + 1, 10, 10);
                g2d.setColor(c);
                g2d.fillOval(x - 5 + 1, height + 4 + 1, 10, 10);
                g2d.setColor(this.alterColor(c, 10));
                g2d.fillOval(x - 5 + 1 + 2, height + 4 + 1 + 2, 6, 6);
                g2d.setColor(this.EDGES);
                g2d.drawRect(x - 5, height + 8 + 11, 11, 11);
                g2d.setColor(this.BUTTONS);
                g2d.fillRect(x - 5 + 1, height + 8 + 1 + 11, 10, 10);
                int xcross1 = x - 5 + 2;
                int ycross1 = height + 8 + 11 + 2;
                int xcross2 = xcross1 + 11 - 4;
                int ycross2 = ycross1 + 11 - 4;
                g2d.setColor(Color.red);
                g2d.drawLine(xcross1, ycross1, xcross2, ycross2);
                g2d.drawLine(xcross1, ycross2, xcross2, ycross1);
            }
            ++i;
        }
    }

    private boolean isChooseColor(int x, int y) {
        if (this._selectedIndex != -1) {
            if (this._selectedIndex == 0 || this._selectedIndex == this._mcm.getNumColors() - 1) {
                return y <= this.getEndRemove() && y >= this.getStartChoose() && Math.abs(this.getXPos(this._selectedIndex) - x) <= 11;
            }
            if (y <= this.getEndChoose() && y >= this.getStartChoose()) {
                return Math.abs(this.getXPos(this._selectedIndex) - x) <= 5;
            }
        }
        return false;
    }

    private boolean isRemove(int x, int y) {
        if (this._selectedIndex != -1) {
            if (this._selectedIndex == 0 || this._selectedIndex == this._mcm.getNumColors() - 1) {
                return false;
            }
            if (y <= this.getEndRemove() && y >= this.getStartRemove()) {
                return Math.abs(this.getXPos(this._selectedIndex) - x) <= 5;
            }
        }
        return false;
    }

    private int getXPos(int i) {
        double val = this._mcm.getValueAt(i);
        double norm = (val - this._mcm.getMinValue()) / (this._mcm.getMaxValue() - this._mcm.getMinValue());
        return (int)(norm * (double)(this.getWidth() - 1));
    }

    private int locateSelectedIndex(int x, int y) {
        double dist = Double.MAX_VALUE;
        int index = -1;
        int i = 0;
        while (i < this._mcm.getNumColors()) {
            int xp = this.getXPos(i);
            double tmpDist = Math.abs(x - xp);
            if (tmpDist < dist) {
                index = i;
                dist = tmpDist;
            }
            ++i;
        }
        return index;
    }

    public void mouseClicked(MouseEvent arg0) {
        this._selectedIndex = this.locateSelectedIndex(arg0.getX(), arg0.getY());
        if (this._selectedIndex != -1) {
            if (this.isRemove(arg0.getX(), arg0.getY())) {
                this.removeEntry(this._selectedIndex);
            } else if (Math.abs(this.getXPos(this._selectedIndex) - arg0.getX()) > 5) {
                double val = this._mcm.getMinValue() + (double)arg0.getX() * (this._mcm.getMaxValue() - this._mcm.getMinValue()) / (double)(this.getWidth() - 1);
                Color nc = JColorChooser.showDialog(this, "Choose new color", this._mcm.getColorAt(this._selectedIndex));
                if (nc != null) {
                    this._mcm.addColor(val, nc);
                    this.repaint();
                    this.firePropertyChange("PaletteChanged", "a", "b");
                }
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        Color nc;
        this.requestFocus();
        this._selectedIndex = this.locateSelectedIndex(arg0.getX(), arg0.getY());
        if (this._selectedIndex != -1 && this.isChooseColor(arg0.getX(), arg0.getY()) && (nc = JColorChooser.showDialog(this, "Choose new color", this._mcm.getColorAt(this._selectedIndex))) != null) {
            double nv = this._mcm.getValueAt(this._selectedIndex);
            this.replaceEntry(this._selectedIndex, nc, nv);
            this._selectedIndex = -1;
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        this._selectedIndex = -1;
    }

    private void replaceEntry(int index, Color nc, double nv) {
        ModeleColorMap cm = new ModeleColorMap();
        int i = 0;
        while (i < this._mcm.getNumColors()) {
            if (i != index) {
                double val = this._mcm.getValueAt(i);
                Color c = this._mcm.getColorAt(i);
                cm.addColor(val, c);
            } else {
                cm.addColor(nv, nc);
            }
            ++i;
        }
        this._mcm = cm;
        this.repaint();
        this.firePropertyChange("PaletteChanged", "a", "b");
    }

    private void removeEntry(int index) {
        ModeleColorMap cm = new ModeleColorMap();
        int i = 0;
        while (i < this._mcm.getNumColors()) {
            if (i != index) {
                double val = this._mcm.getValueAt(i);
                Color c = this._mcm.getColorAt(i);
                cm.addColor(val, c);
            }
            ++i;
        }
        this._mcm = cm;
        this.repaint();
        this.firePropertyChange("PaletteChanged", "a", "b");
    }

    public void mouseDragged(MouseEvent arg0) {
        if (this._selectedIndex != -1 && this._selectedIndex != 0 && this._selectedIndex != this._mcm.getNumColors() - 1) {
            Color c = this._mcm.getColorAt(this._selectedIndex);
            double val = this._mcm.getMinValue() + (double)arg0.getX() * (this._mcm.getMaxValue() - this._mcm.getMinValue()) / (double)(this.getWidth() - 1);
            this.replaceEntry(this._selectedIndex, c, val);
        }
    }

    public void mouseMoved(MouseEvent arg0) {
        Cursor c = Cursor.getPredefinedCursor(0);
        this._selectedIndex = this.locateSelectedIndex(arg0.getX(), arg0.getY());
        if (this._selectedIndex != -1) {
            if (this.isChooseColor(arg0.getX(), arg0.getY())) {
                c = Cursor.getPredefinedCursor(12);
            } else if (this._selectedIndex != 0 && this._selectedIndex != this._mcm.getNumColors() - 1) {
                if (this.isRemove(arg0.getX(), arg0.getY())) {
                    c = Cursor.getPredefinedCursor(12);
                } else if (Math.abs(this.getXPos(this._selectedIndex) - arg0.getX()) <= 5) {
                    c = Cursor.getPredefinedCursor(11);
                } else if (arg0.getY() < this.getHeight() - this.getStripeHeight()) {
                    c = Cursor.getPredefinedCursor(12);
                } else {
                    Cursor.getPredefinedCursor(0);
                }
            }
        }
        this.setCursor(c);
    }
}

