/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{"Numbers", "Base", "Outline Color", "Inner Color", "Name Color", "Number Color"};
    private ArrayList<ArrayList<Object>> data = new ArrayList();
    private ArrayList<BaseList> _bases;
    private boolean _singleBases = true;

    public BaseTableModel(ArrayList<BaseList> bases) {
        this._bases = bases;
        int i = 0;
        while (i < bases.size()) {
            ArrayList<Object> ligne = new ArrayList<Object>();
            BaseList bl = bases.get(i);
            if (bl.size() != 1) {
                this._singleBases = false;
            }
            ligne.add(bl.getNumbers());
            ligne.add(bl.getContents());
            ligne.add(bl.getAverageOutlineColor());
            ligne.add(bl.getAverageInnerColor());
            ligne.add(bl.getAverageNameColor());
            ligne.add(bl.getAverageNumberColor());
            this.data.add(ligne);
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data.get(row).get(col);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data.get(row).set(col, value);
        if (col == 1 && this._singleBases) {
            ModeleBase mb = this._bases.get(row).getBases().get(0);
            mb.setContent(value.toString());
        }
        this.fireTableCellUpdated(row, col);
    }
}

