/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.CubicBezierCurve;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnpairedRegion
extends GraphicalTemplateElement {
    private RNATemplate.RNATemplateUnpairedSequence _e;
    public static final double DEFAULT_VECTOR_LENGTH = 35.0;
    public static final double DEFAULT_VECTOR_DISTANCE = 35.0;
    public static final double MAX_UNPAIRED_CONTROL_DISTANCE = 10.0;
    public static final double UNPAIRED_ARROW_WIDTH = 6.0;

    public UnpairedRegion(double x, double y, RNATemplate tmp) {
        RNATemplate rNATemplate = tmp;
        rNATemplate.getClass();
        this._e = new RNATemplate.RNATemplateUnpairedSequence(rNATemplate, "");
        this._e.setVertex5(new Point2D.Double(x, y));
        this._e.setVertex3(new Point2D.Double(x + 35.0, y));
        this._e.setInTangentVectorLength(35.0);
        this._e.setInTangentVectorAngle(-1.5707963267948966);
        this._e.setOutTangentVectorLength(35.0);
        this._e.setOutTangentVectorAngle(-1.5707963267948966);
        this.updateLength();
    }

    public UnpairedRegion(RNATemplate.RNATemplateUnpairedSequence templateSequence) {
        this._e = templateSequence;
    }

    public Point2D.Double getEdge5() {
        GraphicalTemplateElement.RelativePosition r = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
        Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> c = this.getAttachedElement(r);
        return this.isAnchored5() ? ((GraphicalTemplateElement)c.second).getEdgePosition((GraphicalTemplateElement.RelativePosition)((Object)c.first)) : this._e.getVertex5();
    }

    public Point2D.Double getEdge3() {
        GraphicalTemplateElement.RelativePosition r = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
        Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> c = this.getAttachedElement(r);
        return this.isAnchored3() ? ((GraphicalTemplateElement)c.second).getEdgePosition((GraphicalTemplateElement.RelativePosition)((Object)c.first)) : this._e.getVertex3();
    }

    public void setEdge5(Point2D.Double d) {
        this._e.setVertex5(d);
        this.updateLength();
    }

    public void setEdge3(Point2D.Double d) {
        this._e.setVertex3(d);
        this.updateLength();
    }

    public boolean isAnchored5() {
        return this._e.getIn().getOtherElement() != null;
    }

    public boolean isAnchored3() {
        return this._e.getOut().getOtherElement() != null;
    }

    public static Shape bezToShape(CubicBezierCurve c) {
        GeneralPath p = new GeneralPath();
        int nb = 9;
        double[] tab = new double[nb];
        int i = 0;
        while (i < nb) {
            tab[i] = c.getApproxCurveLength() * (double)i / (double)nb;
            ++i;
        }
        Point2D.Double[] points = c.uniformParam(tab);
        System.out.println(points.length);
        p.moveTo((float)points[0].x, (float)points[0].y);
        int i2 = 1;
        while (i2 < nb) {
            Point2D.Double a = points[i2];
            System.out.println(a);
            p.lineTo((float)a.x, (float)a.y);
            ++i2;
        }
        p.lineTo((float)c.getP3().x, (float)c.getP3().y);
        return p;
    }

    public Shape getCurve() {
        Point2D.Double p5 = this.getEdge5();
        Point2D.Double p3 = this.getEdge3();
        Point2D.Double t5 = this.getControl5();
        Point2D.Double t3 = this.getControl3();
        return new CubicCurve2D.Double(p5.x, p5.y, t5.x, t5.y, t3.x, t3.y, p3.x, p3.y);
    }

    private int estimateNumberOfBases() {
        Point2D.Double p5 = this.getEdge5();
        Point2D.Double p3 = this.getEdge3();
        Point2D.Double t5 = this.getControl5();
        Point2D.Double t3 = this.getControl3();
        CubicBezierCurve c = new CubicBezierCurve(p5, t5, t3, p3, 30);
        return Math.max((int)Math.round(c.getApproxCurveLength() / 40.0) - 1, 1);
    }

    private void updateLength() {
        this._e.setLength(this.estimateNumberOfBases());
    }

    @Override
    public void draw(Graphics2D g2d, boolean selected) {
        Point2D.Double p5 = this.getEdge5();
        Point2D.Double p3 = this.getEdge3();
        Point2D.Double t5 = this.getControl5();
        Point2D.Double t3 = this.getControl3();
        if (selected) {
            g2d.setStroke(this._dashedStroke);
            g2d.setColor(BACKBONE_COLOR);
            g2d.draw(this.getBoundingPolygon());
            g2d.setStroke(this._solidStroke);
            this.drawAnchor(g2d, t5);
            this.drawAnchor(g2d, t3);
            double d5x = (t5.x - p5.x) / t5.distance(p5);
            double d5y = (t5.y - p5.y) / t5.distance(p5);
            double d3x = (t3.x - p3.x) / t3.distance(p3);
            double d3y = (t3.y - p3.y) / t3.distance(p3);
            double shift = -3.5;
            Point2D.Double tp5 = new Point2D.Double(t5.x - shift * d5x, t5.y - shift * d5y);
            Point2D.Double tp3 = new Point2D.Double(t3.x - shift * d3x, t3.y - shift * d3y);
            this.drawArrow(g2d, p5, tp5, 6.0);
            this.drawArrow(g2d, p3, tp3, 6.0);
        }
        g2d.setColor(BACKBONE_COLOR);
        g2d.setStroke(this._solidStroke);
        g2d.draw(this.getCurve());
        int n = this._e.getLength();
        CubicBezierCurve bezier = new CubicBezierCurve(p5, t5, t3, p3, 10 * n);
        double curveLength = bezier.getApproxCurveLength();
        double delta_t = curveLength / (double)(n + 1);
        double[] t = new double[n];
        int k = 0;
        while (k < n) {
            t[k] = (double)(k + 1) * delta_t;
            ++k;
        }
        Point2D.Double[] sequenceBasesCoords = bezier.uniformParam(t);
        int k2 = 0;
        while (k2 < n) {
            this.drawBase(g2d, sequenceBasesCoords[k2]);
            ++k2;
        }
        if (!this.isAnchored5()) {
            this.drawAnchor5(g2d, p5);
        } else {
            this.drawMagnet(g2d, p5);
        }
        if (!this.isAnchored3()) {
            this.drawAnchor3(g2d, p3);
        } else {
            this.drawMagnet(g2d, p3);
        }
    }

    public Point2D.Double getControl5() {
        Point2D.Double p5 = this.getEdge5();
        double angle = this._e.getInTangentVectorAngle();
        return new Point2D.Double(p5.x + Math.cos(angle) * this._e.getInTangentVectorLength(), p5.y + Math.sin(angle) * this._e.getInTangentVectorLength());
    }

    public Point2D.Double getControl3() {
        Point2D.Double p3 = this.getEdge3();
        double angle = this._e.getOutTangentVectorAngle();
        return new Point2D.Double(p3.x + Math.cos(angle) * this._e.getOutTangentVectorLength(), p3.y + Math.sin(angle) * this._e.getOutTangentVectorLength());
    }

    @Override
    public Polygon getBoundingPolygon() {
        Point2D.Double p5 = this.getEdge5();
        Point2D.Double p3 = this.getEdge3();
        Point2D.Double t5 = this.getControl5();
        Point2D.Double t3 = this.getControl3();
        double minx = Math.min(p5.x, Math.min(p3.x, Math.min(t5.x, t3.x)));
        double maxx = Math.max(p5.x, Math.max(p3.x, Math.max(t5.x, t3.x)));
        double miny = Math.min(p5.y, Math.min(p3.y, Math.min(t5.y, t3.y)));
        double maxy = Math.max(p5.y, Math.max(p3.y, Math.max(t5.y, t3.y)));
        int[] x = new int[]{(int)(minx -= 10.0), (int)(maxx += 10.0), (int)maxx, (int)minx};
        int[] y = new int[]{(int)(miny -= 10.0), (int)miny, (int)(maxy += 10.0), (int)maxy};
        return new Polygon(x, y, 4);
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getClosestEdge(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D.Double p5 = this.getEdge5();
        Point2D.Double p3 = this.getEdge3();
        Point2D.Double t5 = this.getControl5();
        Point2D.Double t3 = this.getControl3();
        ArrayList<Couple<Double, GraphicalTemplateElement.RelativePosition>> v = new ArrayList<Couple<Double, GraphicalTemplateElement.RelativePosition>>();
        v.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(p.distance(p5), GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5));
        v.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(p.distance(p3), GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3));
        v.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(p.distance(t5), GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_5));
        v.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(p.distance(t3), GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_3));
        double dist = Double.MAX_VALUE;
        GraphicalTemplateElement.RelativePosition r = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        for (Couple couple : v) {
            if (!((Double)couple.first < dist)) continue;
            dist = (Double)couple.first;
            r = (GraphicalTemplateElement.RelativePosition)((Object)couple.second);
        }
        return r;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getConnectedEdge(GraphicalTemplateElement.RelativePosition edge) {
        switch (edge) {
            case RP_CONNECT_START5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            case RP_CONNECT_END3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public Point2D.Double getEdgePosition(GraphicalTemplateElement.RelativePosition edge) {
        switch (edge) {
            case RP_CONNECT_START5: {
                return this.getEdge5();
            }
            case RP_CONNECT_END3: {
                return this.getEdge3();
            }
            case RP_EDIT_TANGENT_5: {
                return this.getControl5();
            }
            case RP_EDIT_TANGENT_3: {
                return this.getControl3();
            }
        }
        return this.getEdge5();
    }

    double v2a(Point2D.Double p) {
        return Math.atan2(p.y, p.x);
    }

    public void updateControl5(Point2D.Double p) {
        Point2D.Double p5 = this.getEdge5();
        this._e.setInTangentVectorLength(p5.distance(p));
        Point2D.Double x = new Point2D.Double(p.x - p5.x, p.y - p5.y);
        this._e.setInTangentVectorAngle(this.v2a(x));
        this.updateLength();
    }

    public void updateControl3(Point2D.Double p) {
        Point2D.Double p3 = this.getEdge3();
        this._e.setOutTangentVectorLength(p3.distance(p));
        Point2D.Double x = new Point2D.Double(p.x - p3.x, p.y - p3.y);
        this._e.setOutTangentVectorAngle(this.v2a(x));
        this.updateLength();
    }

    @Override
    public void translate(double x, double y) {
        this._e.getVertex5().x += x;
        this._e.getVertex5().y += y;
        this._e.getVertex3().x += x;
        this._e.getVertex3().y += y;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getRelativePosition(double x, double y) {
        GraphicalTemplateElement.RelativePosition rp = this.getClosestEdge(x, y);
        double d = this.getEdgePosition(rp).distance(new Point2D.Double(x, y));
        if (d < 10.0) {
            return rp;
        }
        if (this.getCurve().contains(new Point2D.Double(x, y))) {
            return GraphicalTemplateElement.RelativePosition.RP_INNER_GENERAL;
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public Shape getArea() {
        return this.getCurve();
    }

    @Override
    public void attach(GraphicalTemplateElement e, GraphicalTemplateElement.RelativePosition edgeOrig, GraphicalTemplateElement.RelativePosition edgeDest) throws ExceptionInvalidRNATemplate {
        super.attach(e, edgeOrig, edgeDest);
        if (e instanceof Helix) {
            RNATemplate.RNATemplateElement.EdgeEndPoint e1 = this.getEndPoint(edgeOrig);
            RNATemplate.RNATemplateElement.EdgeEndPoint e2 = e.getEndPoint(edgeDest);
            boolean parity1 = this.isIn(edgeOrig);
            boolean parity2 = e.isIn(edgeDest);
            if (e1 != null && e2 != null && parity1 != parity2) {
                e1.disconnect();
                e2.disconnect();
                e1.connectTo(e2);
            }
        }
    }

    @Override
    public RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(GraphicalTemplateElement.RelativePosition r) {
        switch (r) {
            case RP_CONNECT_START5: {
                return this._e.getIn();
            }
            case RP_CONNECT_END3: {
                return this._e.getOut();
            }
        }
        return null;
    }

    @Override
    public boolean isIn(GraphicalTemplateElement.RelativePosition r) {
        switch (r) {
            case RP_CONNECT_START5: {
                return true;
            }
            case RP_CONNECT_END3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void detach(GraphicalTemplateElement.RelativePosition edge) {
        if (this.getEndPoint(edge).isConnected()) {
            Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> c = this.getAttachedElement(edge);
            this.getEndPoint(edge).disconnect();
        }
        super.detach(edge);
    }

    @Override
    public void setEdgePosition(GraphicalTemplateElement.RelativePosition edge, Point2D.Double pos) {
        switch (edge) {
            case RP_CONNECT_START5: {
                this.setEdge5(pos);
                break;
            }
            case RP_CONNECT_END3: {
                this.setEdge3(pos);
                break;
            }
            case RP_EDIT_TANGENT_5: {
                this.updateControl5(pos);
                break;
            }
            case RP_EDIT_TANGENT_3: {
                this.updateControl3(pos);
            }
        }
    }

    @Override
    public ArrayList<GraphicalTemplateElement.RelativePosition> getConnectedEdges() {
        ArrayList<GraphicalTemplateElement.RelativePosition> result = new ArrayList<GraphicalTemplateElement.RelativePosition>();
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5);
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3);
        return result;
    }

    @Override
    public RNATemplate.RNATemplateElement getTemplateElement() {
        return this._e;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition pos) {
        switch (pos) {
            case IN1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case OUT1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
        }
        return null;
    }
}

