/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEdits;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class TemplateEditorPanelUI {
    private UndoableEditSupport _undoableEditSupport;
    private TemplatePanel _tp;

    public TemplateEditorPanelUI(TemplatePanel tp) {
        this._tp = tp;
        this._undoableEditSupport = new UndoableEditSupport(tp);
    }

    public void undoableEdgeMove(GraphicalTemplateElement h, GraphicalTemplateElement.RelativePosition edge, double nx, double ny) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementEdgeMoveTemplateEdit(h, edge, nx, ny, this._tp));
        h.setEdgePosition(edge, new Point2D.Double(nx, ny));
        this._tp.repaint();
    }

    public void setEdge5UI(GraphicalTemplateElement h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5, nx, ny);
    }

    public void setEdge3UI(UnpairedRegion h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3, nx, ny);
    }

    public void setEdge5TangentUI(UnpairedRegion h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_5, nx, ny);
    }

    public void setEdge3TangentUI(UnpairedRegion h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_3, nx, ny);
    }

    public void moveHelixUI(Helix h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE, nx, ny);
    }

    public void setHelixPosUI(Helix h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_EDIT_START, nx, ny);
    }

    public void setHelixExtentUI(Helix h, double nx, double ny) {
        this.undoableEdgeMove(h, GraphicalTemplateElement.RelativePosition.RP_EDIT_END, nx, ny);
    }

    public void addElementUI(GraphicalTemplateElement h) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementAddTemplateEdit(h, this._tp));
        this._tp.addElement(h);
    }

    public void removeElementUI(GraphicalTemplateElement h) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementRemoveTemplateEdit(h, this._tp));
        this._tp.removeElement(h);
    }

    public void addUndoableEditListener(UndoManager manager) {
        this._undoableEditSupport.addUndoableEditListener(manager);
    }

    public void addConnectionUI(GraphicalTemplateElement h1, GraphicalTemplateElement.RelativePosition e1, GraphicalTemplateElement h2, GraphicalTemplateElement.RelativePosition e2) {
        if (GraphicalTemplateElement.canConnect(h1, e1, h2, e2)) {
            Connection c = this._tp.addConnection(h1, e1, h2, e2);
            this._undoableEditSupport.postEdit(new TemplateEdits.ElementAttachTemplateEdit(c, this._tp));
        }
    }

    public void removeConnectionUI(Connection c) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementDetachTemplateEdit(c, this._tp));
        this._tp.removeConnection(c);
    }

    public void flipHelixUI(Helix h) {
        this._undoableEditSupport.postEdit(new TemplateEdits.HelixFlipTemplateEdit(h, this._tp));
        this._tp.flip(h);
        this._tp.repaint();
    }

    public RNATemplate getTemplate() {
        return this._tp.getTemplate();
    }
}

