/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.FileNameExtensionFilter;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionXMLGeneration;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.undo.UndoManager;

public class TemplateEditor
extends JFrame
implements KeyListener,
ActionListener,
DropTargetListener {
    private TemplatePanel _sk;
    private VARNAPanel _vp;
    private File currentFilePath;
    private JButton saveButton;
    private UndoManager manager;
    private static final long serialVersionUID = -5942729520783690050L;

    public TemplateEditor() {
        super("VARNA Template Editor: New file");
        this.init();
    }

    private void init() {
        try {
            this._vp = new VARNAPanel(" ", ".");
        }
        catch (ExceptionNonEqualLength e) {
            e.printStackTrace();
        }
        this._vp.setNumPeriod(0);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 2));
        JToolBar systemBar = new JToolBar();
        JButton loadButton = new JButton("Open...", UIManager.getIcon("FileView.directoryIcon"));
        loadButton.setActionCommand("open");
        loadButton.addActionListener(this);
        loadButton.addKeyListener(this);
        this.saveButton = new JButton("Save", UIManager.getIcon("FileView.floppyDriveIcon"));
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        this.saveButton.addKeyListener(this);
        this.saveButton.setEnabled(false);
        JButton saveAsButton = new JButton("Save As...", UIManager.getIcon("FileView.floppyDriveIcon"));
        saveAsButton.setActionCommand("save as");
        saveAsButton.addActionListener(this);
        saveAsButton.addKeyListener(this);
        JButton undoButton = new JButton("Undo");
        undoButton.setActionCommand("undo");
        undoButton.addActionListener(this);
        undoButton.addKeyListener(this);
        JButton redoButton = new JButton("Redo");
        redoButton.setActionCommand("redo");
        redoButton.addActionListener(this);
        redoButton.addKeyListener(this);
        JButton[] applyButtons = new JButton[4];
        String[] applyMethods = new String[]{"no helix length adjustment", "max increase factor", "min non-intersect factor", "helix translate"};
        int i = 0;
        while (i < applyButtons.length) {
            applyButtons[i] = new JButton("Apply (" + applyMethods[i] + ")");
            applyButtons[i].setActionCommand("apply" + i);
            applyButtons[i].addActionListener(this);
            applyButtons[i].addKeyListener(this);
            ++i;
        }
        JButton flipButton = new JButton("Flip");
        flipButton.setActionCommand("flip");
        flipButton.addActionListener(this);
        flipButton.addKeyListener(this);
        systemBar.add(loadButton);
        systemBar.add(this.saveButton);
        systemBar.add(saveAsButton);
        systemBar.addSeparator();
        systemBar.add(undoButton);
        systemBar.add(redoButton);
        systemBar.addSeparator();
        systemBar.add(flipButton);
        systemBar.addSeparator();
        int i2 = 0;
        while (i2 < applyButtons.length) {
            systemBar.add(applyButtons[i2]);
            ++i2;
        }
        systemBar.addKeyListener(this);
        JToolBar toolBar = new JToolBar();
        ButtonGroup bg = new ButtonGroup();
        toolBar.setOrientation(1);
        JToggleButton selectButton = new JToggleButton("Select");
        selectButton.setActionCommand("select");
        selectButton.addActionListener(this);
        selectButton.addKeyListener(this);
        JToggleButton helixButton = new JToggleButton("Helix");
        helixButton.setActionCommand("helix");
        helixButton.addActionListener(this);
        helixButton.addKeyListener(this);
        JToggleButton unpairedButton = new JToggleButton("Unpaired");
        unpairedButton.setActionCommand("unpaired");
        unpairedButton.addActionListener(this);
        unpairedButton.addKeyListener(this);
        bg.add(selectButton);
        bg.add(helixButton);
        bg.add(unpairedButton);
        toolBar.add(selectButton);
        toolBar.add(helixButton);
        toolBar.add(unpairedButton);
        systemBar.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this._sk = new TemplatePanel();
        this._sk.setPreferredSize(new Dimension(800, 600));
        this.manager = new UndoManager();
        this.manager.setLimit(2000);
        this._sk.addUndoableEditListener(this.manager);
        this._sk.addKeyListener(this);
        JScrollPane jp = new JScrollPane(this._sk, 22, 32);
        p.add(jp);
        p.add(this._vp);
        this.getContentPane().add((Component)systemBar, "First");
        this.getContentPane().add((Component)toolBar, "West");
        this.getContentPane().add((Component)p, "Center");
        this.addKeyListener(this);
        new DropTarget(this._vp, this);
        new DropTarget(this._sk, this);
        this._sk.requestFocusInWindow();
    }

    private File getCurrentFilePath() {
        return this.currentFilePath;
    }

    private void setCurrentFilePath(File currentFilePath) {
        this.currentFilePath = currentFilePath;
        this.saveButton.setEnabled(true);
        this.setTitle("VARNA Template Editor: " + currentFilePath);
    }

    public static void main(String[] argv) {
        TemplateEditor frame = new TemplateEditor();
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public void keyPressed(KeyEvent e) {
        System.out.println(e);
        switch (e.getKeyCode()) {
            case 127: {
                GraphicalTemplateElement h = this._sk.getSelected();
                this._sk.Unselect();
                this._sk.getTemplateUI().removeElementUI(h);
                this._sk.repaint();
                break;
            }
            case 90: {
                if (!e.isControlDown()) break;
                this.undo();
                break;
            }
            case 89: {
                if (!e.isControlDown()) break;
                this.redo();
            }
        }
    }

    public void undo() {
        if (this.manager.canUndo()) {
            System.out.println("Undo: " + this.manager.getUndoPresentationName());
            this.manager.undo();
        }
    }

    public void redo() {
        if (this.manager.canRedo()) {
            System.out.println("Redo: " + this.manager.getRedoPresentationName());
            this.manager.redo();
        }
    }

    public void keyReleased(KeyEvent e) {
        System.out.println(e);
    }

    public void keyTyped(KeyEvent e) {
        System.out.println(e);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("undo")) {
            this.undo();
        } else if (e.getActionCommand().equals("redo")) {
            this.redo();
        } else if (e.getActionCommand().equals("flip")) {
            GraphicalTemplateElement gr = this._sk.getSelected();
            if (gr != null && gr instanceof Helix) {
                this._sk.getTemplateUI().flipHelixUI((Helix)gr);
            }
        } else if (e.getActionCommand().startsWith("apply")) {
            try {
                int method = Integer.parseInt(e.getActionCommand().substring(e.getActionCommand().length() - 1));
                RNATemplateMapping map = this._vp.getRNA().drawRNATemplate(this._sk.getTemplate(), method);
                for (int i : map.getSourceElemsAsSet()) {
                    RNATemplate.RNATemplateElement t = map.getPartner(i);
                    Color c = this._sk.getElement(t).getDominantColor();
                    this._vp.getRNA().getBaseAt(i).getStyleBase().set_base_inner_color(c);
                }
                this._vp.repaint();
            }
            catch (RNATemplateDrawingAlgorithmException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, e1.getMessage(), "Template-based RNA drawing error", 0);
            }
        } else if (e.getActionCommand().equals("save")) {
            try {
                this._sk.getTemplate().toXMLFile(this.getCurrentFilePath());
                System.out.println("Template saved in " + this.getCurrentFilePath().toString());
            }
            catch (ExceptionXMLGeneration e1) {
                e1.printStackTrace();
            }
            catch (ExceptionInvalidRNATemplate e1) {
                e1.printStackTrace();
            }
        } else if (e.getActionCommand().equals("save as")) {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("VARNA RNA template (.xml)", "xml");
            chooser.setFileFilter(filter);
            if (chooser.showSaveDialog(this._sk) == 0) {
                String path = chooser.getSelectedFile().getAbsolutePath();
                if (!path.toLowerCase().endsWith(".xml")) {
                    path = String.valueOf(path) + ".xml";
                }
                try {
                    this._sk.getTemplate().toXMLFile(new File(path));
                    System.out.println("Template saved in " + path);
                    this.setCurrentFilePath(new File(path));
                }
                catch (ExceptionXMLGeneration e1) {
                    e1.printStackTrace();
                }
                catch (ExceptionInvalidRNATemplate e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getActionCommand().equals("open")) {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("VARNA RNA template (.xml)", "xml");
            chooser.setFileFilter(filter);
            if (chooser.showOpenDialog(this._sk) == 0) {
                File templatePath = chooser.getSelectedFile();
                this._sk.loadFromXmlFile(templatePath);
                this.setCurrentFilePath(templatePath);
                this.manager.discardAllEdits();
            }
        }
    }

    public void dragEnter(DropTargetDragEvent arg0) {
    }

    public void dragExit(DropTargetEvent arg0) {
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(3);
                    List list = (List)tr.getTransferData(flavors[i]);
                    int j = 0;
                    while (j < list.size()) {
                        Object o = list.get(j);
                        if (dtde.getSource() instanceof DropTarget) {
                            String path;
                            DropTarget dt = (DropTarget)dtde.getSource();
                            Component c = dt.getComponent();
                            if (c instanceof VARNAPanel) {
                                VARNAPanel vp = (VARNAPanel)c;
                                path = o.toString();
                                vp.loadFile(path, true);
                                vp.repaint();
                            } else if (c instanceof TemplatePanel) {
                                TemplatePanel sk = (TemplatePanel)c;
                                path = o.toString();
                                sk.loadFromXmlFile(new File(path));
                                sk.repaint();
                            }
                        }
                        ++j;
                    }
                    dtde.dropComplete(true);
                    return;
                }
                ++i;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }
}

