/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditorPanelUI;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class MouseControler
implements MouseListener,
MouseMotionListener {
    private int _granularity = 8;
    private final int HYSTERESIS_DISTANCE = 10;
    TemplatePanel _sp;
    GraphicalTemplateElement _elem;
    TemplateEditorPanelUI _ui;
    private GraphicalTemplateElement.RelativePosition _currentMode = GraphicalTemplateElement.RelativePosition.RP_OUTER;
    private Point2D.Double _clickedPos = new Point2D.Double();

    public MouseControler(TemplatePanel sp, TemplateEditorPanelUI ui) {
        this._sp = sp;
        this._elem = null;
        this._ui = ui;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        GraphicalTemplateElement elem = this._sp.getElementAt(arg0.getX(), arg0.getY());
        this._clickedPos = new Point2D.Double(arg0.getX(), arg0.getY());
        this._sp.Unselect();
        if (elem == null) {
            if (arg0.getButton() == 1) {
                this._currentMode = GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
            } else if (arg0.getButton() == 3) {
                UnpairedRegion n = new UnpairedRegion(arg0.getX(), arg0.getY(), this._sp.getTemplate());
                n.setDominantColor(this._sp.nextBackgroundColor());
                this._ui.addElementUI(n);
                this._sp.setSelected(n);
                this._sp.repaint();
                this._elem = n;
                this._currentMode = GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
            }
        } else {
            this._currentMode = elem.getRelativePosition(arg0.getX(), arg0.getY());
            this._sp.setSelected(elem);
            this._elem = elem;
            switch (this._currentMode) {
                case RP_EDIT_START: 
                case RP_EDIT_END: 
                case RP_EDIT_TANGENT_3: 
                case RP_EDIT_TANGENT_5: {
                    break;
                }
                case RP_INNER_MOVE: {
                    break;
                }
                case RP_INNER_GENERAL: {
                    this._currentMode = GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE;
                    break;
                }
                case RP_CONNECT_START5: 
                case RP_CONNECT_START3: 
                case RP_CONNECT_END5: 
                case RP_CONNECT_END3: {
                    boolean isConnected;
                    Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> al = this._sp.getPartner(elem, this._currentMode);
                    boolean bl = isConnected = al != null;
                    if (isConnected) {
                        boolean p1StillAttached;
                        Connection c = this._sp.getConnection(elem, this._currentMode);
                        this._ui.removeConnectionUI(c);
                        GraphicalTemplateElement p1 = c._h1;
                        GraphicalTemplateElement p2 = c._h2;
                        boolean p1IsHelix = p1 instanceof Helix;
                        boolean p1IsUnpaired = p1 instanceof UnpairedRegion;
                        boolean p2IsHelix = p2 instanceof Helix;
                        boolean p2IsUnpaired = p2 instanceof UnpairedRegion;
                        boolean bl2 = p1StillAttached = p1 == elem;
                        if (p1IsUnpaired && p2IsHelix) {
                            p1StillAttached = false;
                        }
                        if (p1StillAttached) {
                            this._elem = p2;
                            this._currentMode = c._edge2;
                        } else if (!p1StillAttached) {
                            this._elem = p1;
                            this._currentMode = c._edge1;
                        }
                    }
                    if (this._elem instanceof Helix) {
                        this._sp.setPointerPos(new Point2D.Double(arg0.getX(), arg0.getY()));
                        this._sp.setSelectedEdge(this._currentMode);
                    }
                    this._sp.setSelected(this._elem);
                    break;
                }
                case RP_OUTER: {
                    this._sp.Unselect();
                    this._elem = null;
                }
            }
            this._sp.repaint();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this._elem != null) {
            switch (this._currentMode) {
                case RP_EDIT_START: 
                case RP_EDIT_END: {
                    Helix h;
                    if (!(this._elem instanceof Helix) || !((h = (Helix)this._elem).getPos().distance(h.getExtent()) < 10.0)) break;
                    this._ui.removeElementUI(this._elem);
                    this._sp.Unselect();
                    break;
                }
                case RP_INNER_MOVE: {
                    break;
                }
                case RP_CONNECT_START5: 
                case RP_CONNECT_START3: 
                case RP_CONNECT_END5: 
                case RP_CONNECT_END3: {
                    GraphicalTemplateElement t = this._sp.getElementAt(arg0.getX(), arg0.getY(), this._elem);
                    if (t != null) {
                        GraphicalTemplateElement.RelativePosition edge = t.getClosestEdge(arg0.getX(), arg0.getY());
                        this._ui.addConnectionUI(this._elem, this._currentMode, t, edge);
                    }
                    this._sp.setSelectedEdge(GraphicalTemplateElement.RelativePosition.RP_OUTER);
                }
            }
            this._elem = null;
        }
        this._sp.setSelectedEdge(GraphicalTemplateElement.RelativePosition.RP_OUTER);
        this._currentMode = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        this._sp.repaint();
    }

    private Point2D.Double projectPoint(int x, int y, Point2D.Double ref) {
        Point2D.Double result = new Point2D.Double();
        double nx = (double)x - ref.x;
        double ny = (double)y - ref.y;
        double tmp = Double.MIN_VALUE;
        int i = 0;
        while (i < this._granularity) {
            double dy;
            double angle = Math.PI * 2 * ((double)i / (double)this._granularity);
            double dx = Math.cos(angle);
            double norm = nx * dx + ny * (dy = Math.sin(angle));
            if (norm > tmp) {
                tmp = norm;
                result.x = ref.x + dx * norm;
                result.y = ref.y + dy * norm;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseDragged(MouseEvent arg0) {
        if (this._elem == null) {
            switch (this._currentMode) {
                case RP_EDIT_START: {
                    if (!(this._clickedPos.distance(arg0.getX(), arg0.getY()) > 10.0)) return;
                    System.out.println("Creating Helix...");
                    Helix h1 = new Helix((double)arg0.getX(), (double)arg0.getY(), this._sp.getTemplate(), this._sp.getRNAComponents());
                    h1.setDominantColor(this._sp.nextBackgroundColor());
                    this._ui.addElementUI(h1);
                    this._sp.setSelected(h1);
                    this._sp.repaint();
                    this._elem = h1;
                }
                default: {
                    return;
                }
            }
        } else if (this._elem instanceof Helix) {
            Helix h = (Helix)this._elem;
            switch (this._currentMode) {
                case RP_EDIT_START: {
                    Point2D.Double d = this.projectPoint(arg0.getX(), arg0.getY(), h.getPos());
                    this._ui.setHelixExtentUI(h, d.x, d.y);
                    return;
                }
                case RP_EDIT_END: {
                    Point2D.Double d = this.projectPoint(arg0.getX(), arg0.getY(), h.getExtent());
                    this._ui.setHelixPosUI(h, d.x, d.y);
                    return;
                }
                case RP_INNER_MOVE: {
                    this._ui.moveHelixUI(h, arg0.getX(), arg0.getY());
                    return;
                }
                case RP_CONNECT_START5: 
                case RP_CONNECT_START3: 
                case RP_CONNECT_END5: 
                case RP_CONNECT_END3: {
                    this._sp.setPointerPos(new Point2D.Double(arg0.getX(), arg0.getY()));
                    this._sp.repaint();
                }
                default: {
                    return;
                }
            }
        } else {
            if (!(this._elem instanceof UnpairedRegion)) return;
            UnpairedRegion ur = (UnpairedRegion)this._elem;
            Point2D.Double p = new Point2D.Double(arg0.getX(), arg0.getY());
            switch (this._currentMode) {
                case RP_EDIT_TANGENT_5: {
                    this._ui.setEdge5TangentUI(ur, arg0.getX(), arg0.getY());
                    this._sp.repaint();
                    break;
                }
                case RP_EDIT_TANGENT_3: {
                    this._ui.setEdge3TangentUI(ur, arg0.getX(), arg0.getY());
                    this._sp.repaint();
                    break;
                }
                case RP_CONNECT_START5: {
                    this._ui.setEdge5UI(ur, arg0.getX(), arg0.getY());
                    break;
                }
                case RP_CONNECT_END3: {
                    this._ui.setEdge3UI(ur, arg0.getX(), arg0.getY());
                }
            }
            this._sp.repaint();
        }
    }

    public void mouseMoved(MouseEvent arg0) {
    }
}

