/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helix
extends GraphicalTemplateElement {
    RNATemplate.RNATemplateHelix _h;
    public static final double BASE_PAIR_DISTANCE = 65.0;
    public static final double LOOP_DISTANCE = 40.0;
    public static final double SELECTION_RADIUS = 15.0;
    public static final double EDIT_RADIUS = 10.0;
    public static final double MOVE_RADIUS = 13.0;
    public static final double BASE_RADIUS = 3.0;
    public static final double EDGE_BASE_RADIUS = 7.0;

    public Helix(double x, double y, RNATemplate tmp, List<GraphicalTemplateElement> existingRNAElements) {
        this(x, y, Helix.getNextAutomaticCaption(existingRNAElements), tmp);
    }

    public Helix(double x, double y, String cap, RNATemplate tmp) {
        RNATemplate rNATemplate = tmp;
        rNATemplate.getClass();
        this._h = new RNATemplate.RNATemplateHelix(rNATemplate, cap);
        this._h.setStartPosition(new Point2D.Double(x, y));
        this._h.setEndPosition(new Point2D.Double(x, y));
        this._h.setLength(1);
        this._h.setCaption(cap);
    }

    public Helix(RNATemplate.RNATemplateHelix templateHelix) {
        this._h = templateHelix;
    }

    private static String getNextAutomaticCaption(List<GraphicalTemplateElement> existingRNAElements) {
        HashSet<String> captions = new HashSet<String>();
        for (GraphicalTemplateElement element : existingRNAElements) {
            Helix helix;
            if (!(element instanceof Helix) || (helix = (Helix)element).getCaption() == null) continue;
            captions.add(helix.getCaption());
        }
        int i = 1;
        String candidateCaption;
        while (captions.contains(candidateCaption = "H" + i)) {
            ++i;
        }
        return candidateCaption;
    }

    public void toggleFlipped() {
        this._h.setFlipped(!this._h.isFlipped());
        this.updateAttachedUnpairedRegions();
    }

    public void updateAttachedUnpairedRegions() {
        for (GraphicalTemplateElement.RelativePosition rpos : this.getConnectedEdges()) {
            Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> c = this.getAttachedElement(rpos);
            if (c == null || !(c.second instanceof UnpairedRegion)) continue;
            UnpairedRegion unpairedRegion = (UnpairedRegion)c.second;
            Point2D.Double pos = this.getEdgePosition(rpos);
            if (c.first == GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5) {
                unpairedRegion.setEdge5(pos);
                continue;
            }
            if (c.first != GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3) continue;
            unpairedRegion.setEdge3(pos);
        }
    }

    public double getPosX() {
        return this._h.getStartPosition().x;
    }

    public String getCaption() {
        return this._h.getCaption();
    }

    public double getPosY() {
        return this._h.getStartPosition().y;
    }

    @Override
    public RNATemplate.RNATemplateHelix getTemplateElement() {
        return this._h;
    }

    public void setX(double x) {
        this._h.getStartPosition().x = x;
    }

    public void setY(double y) {
        this._h.getStartPosition().y = y;
    }

    public void setPos(Point2D.Double p) {
        this._h.setStartPosition(p);
        this.updateLength();
    }

    public void setPos(double x, double y) {
        this.setPos(new Point2D.Double(x, y));
    }

    public Point2D.Double getPos() {
        return this._h.getStartPosition();
    }

    public void moveCenter(double x, double y) {
        Point2D.Double center = new Point2D.Double((this._h.getStartPosition().x + this._h.getEndPosition().x) / 2.0, (this._h.getStartPosition().y + this._h.getEndPosition().y) / 2.0);
        double dx = x - center.x;
        double dy = y - center.y;
        this._h.setStartPosition(new Point2D.Double(this._h.getStartPosition().x + dx, this._h.getStartPosition().y + dy));
        this._h.setEndPosition(new Point2D.Double(this._h.getEndPosition().x + dx, this._h.getEndPosition().y + dy));
    }

    public void setExtent(double x, double y) {
        this.setExtent(new Point2D.Double(x, y));
    }

    private void updateLength() {
        this._h.setLength(this.getNbBP());
    }

    public void setExtent(Point2D.Double p) {
        this._h.setEndPosition(p);
        this.updateLength();
    }

    public double getExtentX() {
        return this._h.getEndPosition().x;
    }

    public Point2D.Double getExtent() {
        return this._h.getEndPosition();
    }

    public double getExtentY() {
        return this._h.getEndPosition().y;
    }

    public Point2D.Double getAbsStart5() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Point2D.Double start5 = new Point2D.Double(this.getPosX() - 65.0 * nx / 2.0, this.getPosY() - 65.0 * ny / 2.0);
        return start5;
    }

    public Point2D.Double getAbsStart3() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Point2D.Double start3 = new Point2D.Double(this.getPosX() + 65.0 * nx / 2.0, this.getPosY() + 65.0 * ny / 2.0);
        return start3;
    }

    public Point2D.Double getAbsEnd5() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Point2D.Double end5 = new Point2D.Double(this.getExtentX() - 65.0 * nx / 2.0, this.getExtentY() - 65.0 * ny / 2.0);
        return end5;
    }

    public Point2D.Double getAbsEnd3() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Point2D.Double end3 = new Point2D.Double(this.getExtentX() + 65.0 * nx / 2.0, this.getExtentY() + 65.0 * ny / 2.0);
        return end3;
    }

    public Point2D.Double getStart5() {
        if (this._h.isFlipped()) {
            return this.getAbsStart3();
        }
        return this.getAbsStart5();
    }

    public Point2D.Double getStart3() {
        if (this._h.isFlipped()) {
            return this.getAbsStart5();
        }
        return this.getAbsStart3();
    }

    public Point2D.Double getEnd5() {
        if (this._h.isFlipped()) {
            return this.getAbsEnd3();
        }
        return this.getAbsEnd5();
    }

    public Point2D.Double getEnd3() {
        if (this._h.isFlipped()) {
            return this.getAbsEnd5();
        }
        return this.getAbsEnd3();
    }

    @Override
    public Polygon getBoundingPolygon() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Point2D.Double start5 = new Point2D.Double(this.getPosX() + 65.0 * nx / 2.0, this.getPosY() + 65.0 * ny / 2.0);
        Point2D.Double end5 = new Point2D.Double(this.getExtentX() + 65.0 * nx / 2.0, this.getExtentY() + 65.0 * ny / 2.0);
        Point2D.Double start3 = new Point2D.Double(this.getPosX() - 65.0 * nx / 2.0, this.getPosY() - 65.0 * ny / 2.0);
        Point2D.Double end3 = new Point2D.Double(this.getExtentX() - 65.0 * nx / 2.0, this.getExtentY() - 65.0 * ny / 2.0);
        Polygon p = new Polygon();
        p.addPoint((int)start5.x, (int)start5.y);
        p.addPoint((int)end5.x, (int)end5.y);
        p.addPoint((int)end3.x, (int)end3.y);
        p.addPoint((int)start3.x, (int)start3.y);
        return p;
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double((int)((this._h.getStartPosition().x + this._h.getEndPosition().x) / 2.0), (int)((this._h.getStartPosition().y + this._h.getEndPosition().y) / 2.0));
    }

    public Point2D.Double getCenterEditStart() {
        double dist = this._h.getStartPosition().distance(this._h.getEndPosition());
        double dx = (this._h.getEndPosition().x - this._h.getStartPosition().x) / dist;
        double dy = (this._h.getEndPosition().y - this._h.getStartPosition().y) / dist;
        return new Point2D.Double((int)(this._h.getStartPosition().x + (dist - 10.0) * dx), (int)(this._h.getStartPosition().y + (dist - 10.0) * dy));
    }

    public Point2D.Double getCenterEditEnd() {
        double dist = this._h.getStartPosition().distance(this._h.getEndPosition());
        double dx = (this._h.getEndPosition().x - this._h.getStartPosition().x) / dist;
        double dy = (this._h.getEndPosition().y - this._h.getStartPosition().y) / dist;
        return new Point2D.Double((int)(this._h.getStartPosition().x + 10.0 * dx), (int)(this._h.getStartPosition().y + 10.0 * dy));
    }

    public Shape getSelectionBox() {
        double dy;
        double dx = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double nx = dy = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double ny = -dx;
        Polygon hbox = this.getBoundingPolygon();
        Polygon p = new Polygon();
        Point2D.Double start5 = new Point2D.Double((double)hbox.xpoints[0] + 15.0 * (dx + nx), (double)hbox.ypoints[0] + 15.0 * (dy + ny));
        Point2D.Double end5 = new Point2D.Double((double)hbox.xpoints[1] + 15.0 * (-dx + nx), (double)hbox.ypoints[1] + 15.0 * (-dy + ny));
        Point2D.Double end3 = new Point2D.Double((double)hbox.xpoints[2] + 15.0 * (-dx - nx), (double)hbox.ypoints[2] + 15.0 * (-dy - ny));
        Point2D.Double start3 = new Point2D.Double((double)hbox.xpoints[3] + 15.0 * (dx - nx), (double)hbox.ypoints[3] + 15.0 * (dy - ny));
        p.addPoint((int)start5.x, (int)start5.y);
        p.addPoint((int)end5.x, (int)end5.y);
        p.addPoint((int)end3.x, (int)end3.y);
        p.addPoint((int)start3.x, (int)start3.y);
        return p;
    }

    @Override
    public Shape getArea() {
        return this.getSelectionBox();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getRelativePosition(double x, double y) {
        Point2D.Double current = new Point2D.Double(x, y);
        Shape p = this.getSelectionBox();
        if (p.contains(current)) {
            if (this.getCenterEditStart().distance(current) < 10.0) {
                return GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
            }
            if (this.getCenterEditEnd().distance(current) < 10.0) {
                return GraphicalTemplateElement.RelativePosition.RP_EDIT_END;
            }
            if (this.getCenter().distance(current) < 13.0) {
                return GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE;
            }
            if (this.getEnd3().distance(current) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            if (this.getEnd5().distance(current) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            if (this.getStart3().distance(current) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
            if (this.getStart5().distance(current) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            return GraphicalTemplateElement.RelativePosition.RP_INNER_GENERAL;
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getClosestEdge(double x, double y) {
        GraphicalTemplateElement.RelativePosition result = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        double dist = Double.MAX_VALUE;
        Point2D.Double current = new Point2D.Double(x, y);
        double dcand = this.getStart5().distance(current);
        if (dcand < dist) {
            dist = dcand;
            result = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
        }
        if ((dcand = this.getStart3().distance(current)) < dist) {
            dist = dcand;
            result = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
        }
        if ((dcand = this.getEnd5().distance(current)) < dist) {
            dist = dcand;
            result = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
        }
        if ((dcand = this.getEnd3().distance(current)) < dist) {
            dist = dcand;
            result = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
        }
        return result;
    }

    @Override
    public Point2D.Double getEdgePosition(GraphicalTemplateElement.RelativePosition edge) {
        switch (edge) {
            case RP_CONNECT_END3: {
                return this.getEnd3();
            }
            case RP_CONNECT_END5: {
                return this.getEnd5();
            }
            case RP_CONNECT_START5: {
                return this.getStart5();
            }
            case RP_CONNECT_START3: {
                return this.getStart3();
            }
            case RP_EDIT_START: {
                return this.getPos();
            }
            case RP_EDIT_END: {
                return this.getExtent();
            }
            case RP_INNER_MOVE: {
                return this.getCenter();
            }
        }
        return this.getCenter();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getConnectedEdge(GraphicalTemplateElement.RelativePosition edge) {
        switch (edge) {
            case RP_CONNECT_END3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
            case RP_CONNECT_END5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case RP_CONNECT_START5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            case RP_CONNECT_START3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    public boolean isAnchored5Start() {
        return this._h.getIn1().getOtherElement() != null;
    }

    public boolean isAnchored5End() {
        return this._h.getOut1().getOtherElement() != null;
    }

    public boolean isAnchored3Start() {
        return this._h.getOut2().getOtherElement() != null;
    }

    public boolean isAnchored3End() {
        return this._h.getIn2().getOtherElement() != null;
    }

    public int getNbBP() {
        Point2D.Double pos = this.getPos();
        Point2D.Double extent = this.getExtent();
        double helLength = pos.distance(extent);
        return Math.max((int)Math.round(helLength / 40.0) + 1, 2);
    }

    @Override
    public void draw(Graphics2D g2d, boolean isSelected) {
        g2d.setStroke(this._solidStroke);
        Point2D.Double pos = this.getPos();
        Point2D.Double extent = this.getExtent();
        double dx = (pos.x - extent.x) / pos.distance(extent);
        double dy = (pos.y - extent.y) / pos.distance(extent);
        double nx = 65.0 * dy / 2.0;
        double ny = -65.0 * dx / 2.0;
        Point2D.Double start5 = this.getStart5();
        Point2D.Double end5 = this.getEnd5();
        Point2D.Double start3 = this.getStart3();
        Point2D.Double end3 = this.getEnd3();
        for (GraphicalTemplateElement.RelativePosition e : this.getConnectedEdges()) {
            g2d.setStroke(this._solidStroke);
            g2d.setColor(BACKBONE_COLOR);
            Point2D.Double p1 = this.getEdgePosition(e);
            Point2D.Double p2 = this.getEdgePosition(this.getConnectedEdge(e));
            if (this._mainColors.containsKey((Object)e)) {
                g2d.setColor((Color)this._mainColors.get((Object)e));
                g2d.setStroke(this._boldStroke);
            }
            g2d.drawLine((int)p1.x, (int)p1.y, (int)(p1.x + p2.x) / 2, (int)(p1.y + p2.y) / 2);
        }
        g2d.setColor(NUMBER_COLOR);
        double captionx = (this._h.isFlipped() ? -1.0 : 1.0) * 1.5 * nx + (start3.x + end3.x) / 2.0;
        double captiony = (this._h.isFlipped() ? -1.0 : 1.0) * 1.5 * ny + (start3.y + end3.y) / 2.0;
        this.drawStringCentered(g2d, this.getCaption(), captionx, captiony);
        int nbBasePairs = this._h.getLength();
        g2d.setStroke(this._solidStroke);
        int i = 0;
        while (i < nbBasePairs) {
            g2d.setColor(BASE_PAIR_COLOR);
            Point2D.Double p5 = new Point2D.Double(((double)i * start5.x + (double)(nbBasePairs - 1 - i) * end5.x) / (double)(nbBasePairs - 1), ((double)i * start5.y + (double)(nbBasePairs - 1 - i) * end5.y) / (double)(nbBasePairs - 1));
            Point2D.Double p3 = new Point2D.Double(((double)i * start3.x + (double)(nbBasePairs - 1 - i) * end3.x) / (double)(nbBasePairs - 1), ((double)i * start3.y + (double)(nbBasePairs - 1 - i) * end3.y) / (double)(nbBasePairs - 1));
            g2d.drawLine((int)p3.x, (int)p3.y, (int)p5.x, (int)p5.y);
            if (i == 0) {
                if (this.isAnchored5End()) {
                    this.drawMagnet(g2d, p5);
                } else {
                    this.drawAnchor3(g2d, p5);
                }
                if (this.isAnchored3End()) {
                    this.drawMagnet(g2d, p3);
                } else {
                    this.drawAnchor5(g2d, p3);
                }
            } else if (i == nbBasePairs - 1) {
                if (this.isAnchored5Start()) {
                    this.drawMagnet(g2d, p5);
                } else {
                    this.drawAnchor5(g2d, p5);
                }
                if (this.isAnchored3Start()) {
                    this.drawMagnet(g2d, p3);
                } else {
                    this.drawAnchor3(g2d, p3);
                }
            } else {
                this.drawBase(g2d, p3);
                this.drawBase(g2d, p5);
            }
            ++i;
        }
        if (isSelected) {
            nx = dy;
            ny = -dx;
            Shape p = this.getSelectionBox();
            g2d.setColor(BACKBONE_COLOR);
            g2d.setStroke(this._dashedStroke);
            g2d.draw(p);
            Point2D.Double center = this.getCenter();
            g2d.setStroke(this._solidStroke);
            this.drawMove(g2d, center);
            this.drawEditStart(g2d, this, -dx, -dy, nx, ny);
            this.drawEditEnd(g2d, this, -dx, -dy, nx, ny);
        }
    }

    @Override
    public void translate(double x, double y) {
        Point2D.Double pos = this.getPos();
        Point2D.Double extent = this.getExtent();
        this.setPos(pos.x + x, pos.y + y);
        this.setExtent(extent.x + x, extent.y + y);
    }

    public RNATemplate.RNATemplateHelix getHelix() {
        return this._h;
    }

    @Override
    public RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(GraphicalTemplateElement.RelativePosition r) {
        switch (r) {
            case RP_CONNECT_START5: {
                return this._h.getIn1();
            }
            case RP_CONNECT_START3: {
                return this._h.getOut2();
            }
            case RP_CONNECT_END3: {
                return this._h.getIn2();
            }
            case RP_CONNECT_END5: {
                return this._h.getOut1();
            }
        }
        return null;
    }

    @Override
    public boolean isIn(GraphicalTemplateElement.RelativePosition r) {
        switch (r) {
            case RP_CONNECT_START5: {
                return true;
            }
            case RP_CONNECT_START3: {
                return false;
            }
            case RP_CONNECT_END3: {
                return true;
            }
            case RP_CONNECT_END5: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void attach(GraphicalTemplateElement e, GraphicalTemplateElement.RelativePosition edgeOrig, GraphicalTemplateElement.RelativePosition edgeDest) throws ExceptionInvalidRNATemplate {
        super.attach(e, edgeOrig, edgeDest);
        RNATemplate.RNATemplateElement.EdgeEndPoint e1 = this.getEndPoint(edgeOrig);
        RNATemplate.RNATemplateElement.EdgeEndPoint e2 = e.getEndPoint(edgeDest);
        boolean parity1 = this.isIn(edgeOrig);
        boolean parity2 = e.isIn(edgeDest);
        if (e1 != null && e2 != null && parity1 != parity2) {
            e1.disconnect();
            e2.disconnect();
            e1.connectTo(e2);
        }
    }

    @Override
    public void detach(GraphicalTemplateElement.RelativePosition edge) {
        if (this.getEndPoint(edge).isConnected()) {
            this.getEndPoint(edge).disconnect();
        }
        super.detach(edge);
    }

    @Override
    public void setEdgePosition(GraphicalTemplateElement.RelativePosition edge, Point2D.Double pos) {
        switch (edge) {
            case RP_EDIT_START: {
                this.setPos(pos);
                break;
            }
            case RP_EDIT_END: {
                this.setExtent(pos);
                break;
            }
            case RP_INNER_MOVE: {
                this.moveCenter(pos.x, pos.y);
            }
        }
        this.updateAttachedUnpairedRegions();
    }

    @Override
    public ArrayList<GraphicalTemplateElement.RelativePosition> getConnectedEdges() {
        ArrayList<GraphicalTemplateElement.RelativePosition> result = new ArrayList<GraphicalTemplateElement.RelativePosition>();
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5);
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3);
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5);
        result.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3);
        return result;
    }

    public String toString() {
        return "Helix " + this.getCaption();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition pos) {
        switch (pos) {
            case IN1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case OUT1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            case IN2: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            case OUT2: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
        }
        return null;
    }
}

