/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurDemoTextField;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VARNAOnlineDemo
extends JApplet {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE = "CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA";
    private static final String DEFAULT_STRUCTURE = "..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..";
    private VARNAPanel _vp;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _structPanel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _struct = new JTextField();
    private JTextField _seq = new JTextField();
    private JLabel _structLabel = new JLabel(" Str:");
    private JLabel _seqLabel = new JLabel(" Seq:");
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private int _algoCode;

    public VARNAOnlineDemo() {
        try {
            this._vp = new VARNAPanel(this._seq.getText(), this._struct.getText());
            this._vp.setErrorsOn(false);
        }
        catch (ExceptionNonEqualLength e) {
            this._vp.errorDialog(e);
        }
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int marginTools = 40;
        this.setBackground(this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        try {
            this._vp.getRNA().setRNA(this._seq.getText(), this._struct.getText());
            this._vp.setErrorsOn(false);
        }
        catch (Exception e1) {
            this._vp.errorDialog(e1);
        }
        Font textFieldsFont = Font.decode("MonoSpaced-PLAIN-12");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._seq.setFont(textFieldsFont);
        this._seq.setText(this._vp.getRNA().getSeq());
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq, "Center");
        this._structLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._structLabel.setHorizontalTextPosition(2);
        this._struct.setFont(textFieldsFont);
        this._struct.setText(this._vp.getRNA().getStructDBN());
        this._structPanel.setLayout(new BorderLayout());
        this._structPanel.add((Component)this._structLabel, "West");
        this._structPanel.add((Component)this._struct, "Center");
        ControleurDemoTextField controleurTextField = new ControleurDemoTextField(this);
        this._seq.addCaretListener(controleurTextField);
        this._struct.addCaretListener(controleurTextField);
        this._input.setLayout(new GridLayout(3, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._structPanel);
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._vp, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vp.getVARNAUI().UIRadiate();
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return info;
    }

    public void init() {
        this.retrieveParametersValues();
        this._vp.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String col, Color def) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (Exception e) {
            try {
                result = Color.getColor(col, def);
            }
            catch (Exception e2) {
                return def;
            }
        }
        return result;
    }

    private String getParameterValue(String key, String def) {
        String tmp = this.getParameter(key);
        if (tmp == null) {
            return def;
        }
        return tmp;
    }

    private void retrieveParametersValues() {
        this._error = Boolean.parseBoolean(this.getParameterValue(errorOpt, "false"));
        this._vp.setErrorsOn(this._error);
        this._backgroundColor = this.getSafeColor(this.getParameterValue("background", this._backgroundColor.toString()), this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        this._seq.setText(this.getParameterValue("sequenceDBN", ""));
        this._struct.setText(this.getParameterValue("structureDBN", ""));
        String _algo = this.getParameterValue("algorithm", "radiate");
        this._algoCode = _algo.equals("circular") ? 1 : (_algo.equals("naview") ? 3 : (_algo.equals("line") ? 4 : 2));
        if (this._seq.getText().equals("") && this._struct.getText().equals("")) {
            this._seq.setText(DEFAULT_SEQUENCE);
            this._struct.setText(DEFAULT_STRUCTURE);
        }
        try {
            this._vp.drawRNA(this._seq.getText(), this._struct.getText(), this._algoCode);
        }
        catch (ExceptionNonEqualLength e) {
            e.printStackTrace();
        }
    }

    public VARNAPanel get_varnaPanel() {
        return this._vp;
    }

    public void set_varnaPanel(VARNAPanel surface) {
        this._vp = surface;
    }

    public JTextField get_struct() {
        return this._struct;
    }

    public void set_struct(JTextField _struct) {
        this._struct = _struct;
    }

    public JTextField get_seq() {
        return this._seq;
    }

    public void set_seq(JTextField _seq) {
        this._seq = _seq;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel _info) {
        this._info = _info;
    }
}

