/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ReorderableJList;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNASelectionListener;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class VARNAGUI
extends JFrame
implements DropTargetListener,
InterfaceVARNAListener,
MouseListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE = "CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA";
    private static final String DEFAULT_STRUCTURE1 = "..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..";
    private static final String DEFAULT_STRUCTURE2 = "..(((((...(((((...(((((........(((((...(((((.....)))))...)))))..................))))).....)))))...)))))..";
    private VARNAPanel _vp;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _strPanel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _str = new JTextField("..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..");
    Object _hoverHighlightStr = null;
    ArrayList<Object> _selectionHighlightStr = new ArrayList();
    private JTextField _seq = new JTextField("CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA");
    Object _hoverHighlightSeq = null;
    ArrayList<Object> _selectionHighlightSeq = new ArrayList();
    private JLabel _strLabel = new JLabel(" Str:");
    private JLabel _seqLabel = new JLabel(" Seq:");
    private JButton _createButton = new JButton("Create");
    private JButton _deleteButton = new JButton("Delete");
    private JButton _duplicateButton = new JButton("Snapshot");
    private JPanel _listPanel = new JPanel();
    private ReorderableJList _sideList = null;
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private static int _nextID = 1;
    private int _algoCode;
    private BackupHolder _rnaList;

    public VARNAGUI() {
        super("VARNA GUI");
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        DefaultListModel dlm = new DefaultListModel();
        int marginTools = 40;
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setSelectionMode(0);
        m.setLeadAnchorNotificationEnabled(false);
        this._sideList = new ReorderableJList();
        this._sideList.setModel(dlm);
        this._sideList.addMouseListener(this);
        this._sideList.setSelectionModel(m);
        this._sideList.setPreferredSize(new Dimension(100, 0));
        this._sideList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!VARNAGUI.this._sideList.isSelectionEmpty() && !arg0.getValueIsAdjusting()) {
                    FullBackup sel = (FullBackup)VARNAGUI.this._sideList.getSelectedValue();
                    Mapping map = Mapping.DefaultOutermostMapping(VARNAGUI.this._vp.getRNA().getSize(), sel.rna.getSize());
                    VARNAGUI.this._vp.showRNAInterpolated(sel.rna, sel.config, map);
                    VARNAGUI.this._seq.setText(sel.rna.getSeq());
                    VARNAGUI.this._str.setText(sel.rna.getStructDBN(true));
                }
            }
        });
        this._rnaList = new BackupHolder(dlm, this._sideList);
        RNA _RNA1 = new RNA("User defined 1");
        RNA _RNA2 = new RNA("User defined 2");
        try {
            this._vp = new VARNAPanel("0", ".");
            _RNA1.setRNA(DEFAULT_SEQUENCE, DEFAULT_STRUCTURE1);
            _RNA1.drawRNARadiate(this._vp.getConfig());
            _RNA2.setRNA(DEFAULT_SEQUENCE, DEFAULT_STRUCTURE2);
            _RNA2.drawRNARadiate(this._vp.getConfig());
        }
        catch (ExceptionNonEqualLength e) {
            this._vp.errorDialog(e);
        }
        catch (ExceptionUnmatchedClosingParentheses e2) {
            e2.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e3) {
            e3.printStackTrace();
        }
        this._vp.setPreferredSize(new Dimension(400, 400));
        this._rnaList.add(this._vp.getConfig().clone(), _RNA2, VARNAGUI.generateDefaultName());
        this._rnaList.add(this._vp.getConfig().clone(), _RNA1, VARNAGUI.generateDefaultName(), true);
        JScrollPane listScroller = new JScrollPane(this._sideList);
        listScroller.setPreferredSize(new Dimension(150, 0));
        this.setBackground(this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        Font textFieldsFont = Font.decode("MonoSpaced-PLAIN-12");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._seq.setFont(textFieldsFont);
        this._seq.setText(DEFAULT_SEQUENCE);
        this._createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    RNA nRNA = new RNA(VARNAGUI.generateDefaultName());
                    nRNA.setRNA(VARNAGUI.this._seq.getText(), VARNAGUI.this._str.getText());
                    nRNA.drawRNARadiate(VARNAGUI.this._vp.getConfig());
                    VARNAGUI.this._rnaList.add(new VARNAConfig(), nRNA, true);
                }
                catch (ExceptionUnmatchedClosingParentheses e1) {
                    JOptionPane.showMessageDialog(VARNAGUI.this._vp, e1.getMessage(), "Error", 0);
                }
                catch (ExceptionFileFormatOrSyntax e1) {
                    JOptionPane.showMessageDialog(VARNAGUI.this._vp, e1.getMessage(), "Error", 0);
                }
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq, "Center");
        this._strLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._strLabel.setHorizontalTextPosition(2);
        this._str.setFont(textFieldsFont);
        this._strPanel.setLayout(new BorderLayout());
        this._strPanel.add((Component)this._strLabel, "West");
        this._strPanel.add((Component)this._str, "Center");
        this._input.setLayout(new GridLayout(2, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._strPanel);
        JPanel goPanel = new JPanel();
        goPanel.setLayout(new BorderLayout());
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this._tools.add((Component)goPanel, "East");
        this._deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VARNAGUI.this._rnaList.removeSelected();
            }
        });
        this._duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VARNAGUI.this._rnaList.add(VARNAGUI.this._vp.getConfig().clone(), VARNAGUI.this._vp.getRNA().clone(), String.valueOf(VARNAGUI.this._vp.getRNA().getName()) + "-" + DateFormat.getTimeInstance(1).format(new Date()), true);
            }
        });
        JPanel ops = new JPanel();
        ops.setLayout(new GridLayout(1, 2));
        ops.add(this._deleteButton);
        ops.add(this._duplicateButton);
        JLabel j = new JLabel("Structures Manager", 0);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)ops, "South");
        this._listPanel.add((Component)j, "North");
        this._listPanel.add((Component)listScroller, "Center");
        goPanel.add((Component)this._createButton, "Center");
        JSplitPane split = new JSplitPane(1, true, this._listPanel, this._vp);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)split, "Center");
        this.getContentPane().add((Component)this._tools, "North");
        this.setVisible(true);
        DropTarget dt = new DropTarget(this._vp, this);
        this._vp.addRNAListener(new InterfaceVARNARNAListener(){

            @Override
            public void onSequenceChanged(int index, String oldseq, String newseq) {
                System.out.println("Sequence changed: Index:" + index + " [" + oldseq + "]=>[" + newseq + "]");
            }

            @Override
            public void onStructureChanged(Set<ModeleBP> current, Set<ModeleBP> addedBasePairs, Set<ModeleBP> removedBasePairs) {
                String result = "";
                System.out.println("Structure changed: ");
                for (ModeleBP s : addedBasePairs) {
                    result = String.valueOf(result) + s;
                }
                System.out.println("     Added: " + result);
                result = "";
                for (ModeleBP s : removedBasePairs) {
                    result = String.valueOf(result) + s;
                }
                System.out.println("   Removed: " + result);
            }

            @Override
            public void onLayoutChanged(Hashtable<Integer, Point2D.Double> previousPositions) {
                System.out.print("Layout changed, bases#: ");
                String result = "";
                for (Integer s : previousPositions.keySet()) {
                    result = String.valueOf(result) + s + " ";
                }
                System.out.println(result);
            }
        });
        this._vp.addSelectionListener(new InterfaceVARNASelectionListener(){

            public void onHoverChanged(ModeleBase oldbase, ModeleBase newBase) {
                if (VARNAGUI.this._hoverHighlightSeq != null) {
                    VARNAGUI.this._seq.getHighlighter().removeHighlight(VARNAGUI.this._hoverHighlightSeq);
                    VARNAGUI.this._hoverHighlightSeq = null;
                }
                if (VARNAGUI.this._hoverHighlightStr != null) {
                    VARNAGUI.this._str.getHighlighter().removeHighlight(VARNAGUI.this._hoverHighlightStr);
                    VARNAGUI.this._hoverHighlightStr = null;
                }
                if (newBase != null) {
                    try {
                        VARNAGUI.this._hoverHighlightSeq = VARNAGUI.this._seq.getHighlighter().addHighlight(newBase.getIndex(), newBase.getIndex() + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.green));
                        VARNAGUI.this._hoverHighlightStr = VARNAGUI.this._str.getHighlighter().addHighlight(newBase.getIndex(), newBase.getIndex() + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.green));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onSelectionChanged(BaseList selection, BaseList addedBases, BaseList removedBases) {
                for (Object tag : VARNAGUI.this._selectionHighlightSeq) {
                    VARNAGUI.this._seq.getHighlighter().removeHighlight(tag);
                }
                VARNAGUI.this._selectionHighlightSeq.clear();
                for (Object tag : VARNAGUI.this._selectionHighlightStr) {
                    VARNAGUI.this._str.getHighlighter().removeHighlight(tag);
                }
                VARNAGUI.this._selectionHighlightStr.clear();
                for (ModeleBase m : selection.getBases()) {
                    try {
                        VARNAGUI.this._selectionHighlightSeq.add(VARNAGUI.this._seq.getHighlighter().addHighlight(m.getIndex(), m.getIndex() + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.orange)));
                        VARNAGUI.this._selectionHighlightStr.add(VARNAGUI.this._str.getHighlighter().addHighlight(m.getIndex(), m.getIndex() + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.orange)));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this._vp.addVARNAListener(this);
    }

    public static String generateDefaultName() {
        return "User file #" + _nextID++;
    }

    public RNA getRNA() {
        return (RNA)this._sideList.getSelectedValue();
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return info;
    }

    public void init() {
        this._vp.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String col, Color def) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (Exception e) {
            try {
                result = Color.getColor(col, def);
            }
            catch (Exception e2) {
                return def;
            }
        }
        return result;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vp;
    }

    public void set_varnaPanel(VARNAPanel surface) {
        this._vp = surface;
    }

    public JTextField get_seq() {
        return this._seq;
    }

    public void set_seq(JTextField _seq) {
        this._seq = _seq;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel _info) {
        this._info = _info;
    }

    public static void main(String[] args) {
        VARNAGUI d = new VARNAGUI();
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    public void dragEnter(DropTargetDragEvent arg0) {
    }

    public void dragExit(DropTargetEvent arg0) {
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    /*
     * Unable to fully structure code
     */
    public void drop(DropTargetDropEvent dtde) {
        try {
            tr = dtde.getTransferable();
            flavors = tr.getTransferDataFlavors();
            i = 0;
            while (i < flavors.length) {
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(3);
                    ob = tr.getTransferData(flavors[i]);
                    if (ob instanceof List) {
                        list = (List)ob;
                        j = 0;
                        while (j < list.size()) {
                            block13: {
                                o = list.get(j);
                                if (dtde.getSource() instanceof DropTarget && (c = (dt = (DropTarget)dtde.getSource()).getComponent()) instanceof VARNAPanel) {
                                    path = o.toString();
                                    vp = (VARNAPanel)c;
                                    try {
                                        bck = VARNAPanel.importSession(path);
                                        this._rnaList.add(bck.config, bck.rna, bck.name, true);
                                        break block13;
                                    }
                                    catch (ExceptionLoadingFailed e3) {
                                        rnas = RNAFactory.loadSecStr(path);
                                        if (rnas.isEmpty()) {
                                            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
                                        }
                                        id = 1;
                                        ** for (r : rnas)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        r.drawRNA(vp.getConfig());
                                        name = r.getName();
                                        if (name.equals("")) {
                                            name = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                                        }
                                        if (rnas.size() > 1) {
                                            name = String.valueOf(name) + " - Molecule# " + id++;
                                        }
                                        this._rnaList.add(vp.getConfig().clone(), r, name, true);
                                        continue;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    dtde.dropComplete(true);
                    return;
                }
                ++i;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public void onStructureRedrawn() {
    }

    public void onUINewStructure(VARNAConfig v, RNA r) {
        this._rnaList.add(v, r, "", true);
    }

    public void onWarningEmitted(String s) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int index = this._sideList.locationToIndex(e.getPoint());
            ListModel dlm = this._sideList.getModel();
            FullBackup item = (FullBackup)dlm.getElementAt(index);
            this._sideList.ensureIndexIsVisible(index);
            Object newName = JOptionPane.showInputDialog(this, "Specify a new name for this RNA", "Rename RNA", 3, null, null, item.toString());
            if (newName != null) {
                item.name = newName.toString();
                this._sideList.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    private class BackupHolder {
        private DefaultListModel _rnaList;
        private ArrayList<RNA> _rnas = new ArrayList();
        JList _l;

        public BackupHolder(DefaultListModel rnaList, JList l) {
            this._rnaList = rnaList;
            this._l = l;
        }

        public void add(VARNAConfig c, RNA r) {
            this.add(c, r, r.getName(), false);
        }

        public void add(VARNAConfig c, RNA r, boolean select) {
            this.add(c, r, r.getName(), select);
        }

        public void add(VARNAConfig c, RNA r, String name) {
            this.add(c, r, name, false);
        }

        public void add(VARNAConfig c, RNA r, String name, boolean select) {
            if (select) {
                this._l.removeSelectionInterval(0, this._rnaList.size());
            }
            if (name.equals("")) {
                name = VARNAGUI.generateDefaultName();
            }
            FullBackup bck = new FullBackup(c, r, name);
            this._rnas.add(0, r);
            this._rnaList.add(0, bck);
            if (select) {
                this._l.setSelectedIndex(0);
            }
        }

        public void remove(int i) {
            this._rnas.remove(i);
            this._rnaList.remove(i);
        }

        public DefaultListModel getModel() {
            return this._rnaList;
        }

        public boolean contains(RNA r) {
            return this._rnas.contains(r);
        }

        public FullBackup getElementAt(int i) {
            return (FullBackup)this._rnaList.getElementAt(i);
        }

        public void removeSelected() {
            int i = this._l.getSelectedIndex();
            if (i != -1) {
                if (this._rnaList.getSize() == 1) {
                    RNA r = new RNA();
                    try {
                        r.setRNA(" ", ".");
                    }
                    catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    }
                    catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                        // empty catch block
                    }
                    VARNAGUI.this._vp.showRNA(r);
                    VARNAGUI.this._vp.repaint();
                } else {
                    int newi = i + 1;
                    if (newi == this._rnaList.getSize()) {
                        newi = this._rnaList.getSize() - 2;
                    }
                    FullBackup bck = (FullBackup)this._rnaList.getElementAt(newi);
                    this._l.setSelectedValue(bck, true);
                }
                this._rnaList.remove(i);
            }
        }
    }
}

