/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.jmol.export.history.HistoryFile;
import org.jmol.i18n.GT;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.Molecules;
import org.openscience.jmol.app.webexport.Orbitals;
import org.openscience.jmol.app.webexport.PopInJmol;
import org.openscience.jmol.app.webexport.ScriptButtons;
import org.openscience.jmol.app.webexport.WebPanel;

public class WebExport
extends JPanel
implements WindowListener {
    private static boolean showMoleculesAndOrbitals = false;
    private static final int STAND_ALONE = 0;
    private static final int IN_JMOL = 1;
    private static int runStatus = 1;
    private static HistoryFile historyFile;
    private static WebPanel[] webPanels;
    static WebExport webExport;
    private static JFrame webFrame;
    private static String windowName;
    static String remoteAppletPath;
    static String localAppletPath;
    static Properties prop;
    static String pageAuthorName;
    static int popInWidth;
    static int popInHeight;
    static int scriptButtonPercent;
    private static String[] translations;

    private WebExport(JmolViewer jmolViewer, HistoryFile historyFile) {
        super(new BorderLayout());
        WebExport.historyFile = historyFile;
        remoteAppletPath = WebExport.historyFile.getProperty("webMakerAppletPath", "..");
        localAppletPath = WebExport.historyFile.getProperty("webMakerLocalAppletPath", "..");
        pageAuthorName = WebExport.historyFile.getProperty("webMakerPageAuthorName", GT._("Jmol Web Page Maker"));
        popInWidth = Parser.parseInt(WebExport.historyFile.getProperty("webMakerPopInWidth", "300"));
        popInHeight = Parser.parseInt(WebExport.historyFile.getProperty("webMakerPopInHeight", "300"));
        scriptButtonPercent = Parser.parseInt(WebExport.historyFile.getProperty("webMakerScriptButtonPercent", "60"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JFileChooser jFileChooser = new JFileChooser();
        webPanels = new WebPanel[2];
        WebExport.setTranslations();
        if (runStatus != 0) {
            JPanel jPanel = new JPanel();
            String string = "WebExportIntro";
            URL uRL = WebExport.getHtmlResource(this, string);
            if (uRL == null) {
                System.err.println(GT._("Couldn't find file: {0}", string + ".html"));
            }
            JEditorPane jEditorPane = new JEditorPane();
            if (uRL != null) {
                try {
                    jEditorPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    System.err.println("Attempted to read a bad URL: " + uRL);
                }
            }
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jScrollPane.setMaximumSize(new Dimension(450, 350));
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jScrollPane);
            jPanel.setMaximumSize(new Dimension(450, 350));
            jPanel.setPreferredSize(new Dimension(400, 300));
            jTabbedPane.add(GT._("Introduction"), jPanel);
            WebExport.webPanels[0] = new PopInJmol(jmolViewer, jFileChooser, webPanels, 0);
            WebExport.webPanels[1] = new ScriptButtons(jmolViewer, jFileChooser, webPanels, 1);
            int n = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoWidth", "300"));
            int n2 = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoHeight", "350"));
            jTabbedPane.addTab(GT._("Pop-In Jmol"), webPanels[0].getPanel(n, n2));
            jTabbedPane.addTab(GT._("ScriptButton Jmol"), webPanels[1].getPanel(n, n2));
        }
        boolean bl = showMoleculesAndOrbitals = runStatus == 0 || JmolViewer.checkOption(jmolViewer, "webMakerAllTabs");
        if (showMoleculesAndOrbitals) {
            jTabbedPane.addTab("Orbitals", new Orbitals().getPanel());
            jTabbedPane.addTab("Molecules", new Molecules().getPanel());
        }
        jTabbedPane.addTab(GT._("Log"), LogPanel.getPanel());
        this.add(jTabbedPane);
        this.add((Component)LogPanel.getMiniPanel(), "South");
    }

    static String TimeStamp_WebLink() {
        return " <small>" + GT._("Page skeleton and JavaScript generated by export to web function using {0} on {1}.", new String[]{" <a href=\"http://jmol.sourceforge.net\">Jmol " + JmolViewer.getJmolVersion() + "</a> ", DateFormat.getDateInstance().format(new Date())}) + "</small><br />";
    }

    public static void dispose() {
        webFrame.dispose();
        webFrame = null;
    }

    public static WebExport createAndShowGUI(JmolViewer jmolViewer, HistoryFile historyFile, String string) {
        if (jmolViewer == null) {
            runStatus = 0;
        }
        if (webFrame != null) {
            webFrame.setVisible(true);
            webFrame.toFront();
            return webExport;
        }
        webFrame = new JFrame(GT._("Jmol Web Page Maker"));
        String string2 = "org/openscience/jmol/app/images/icon.png";
        URL uRL = jmolViewer.getClass().getClassLoader().getResource(string2);
        ImageIcon imageIcon = new ImageIcon(uRL);
        webFrame.setIconImage(imageIcon.getImage());
        windowName = string;
        historyFile.repositionWindow(windowName, webFrame, 700, 400, true);
        if (runStatus == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            webFrame.setDefaultCloseOperation(3);
        } else {
            webFrame.setDefaultCloseOperation(2);
        }
        webExport = new WebExport(jmolViewer, historyFile);
        webExport.setOpaque(true);
        webFrame.setContentPane(webExport);
        webFrame.addWindowListener(webExport);
        webFrame.pack();
        webFrame.setVisible(true);
        if (runStatus == 0) {
            // empty if block
        }
        return webExport;
    }

    public static void saveHistory() {
        if (historyFile == null) {
            return;
        }
        historyFile.addWindowInfo(windowName, webFrame, null);
        prop.setProperty("webMakerAppletPath", remoteAppletPath);
        prop.setProperty("webMakerLocalAppletPath", localAppletPath);
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static String getAppletPath(boolean bl) {
        return bl ? remoteAppletPath : localAppletPath;
    }

    static void setAppletPath(String string, boolean bl) {
        if (string == null) {
            string = "..";
        }
        if (bl) {
            remoteAppletPath = string;
            prop.setProperty("webMakerAppletPath", remoteAppletPath);
            historyFile.addProperties(prop);
        } else {
            localAppletPath = string;
            prop.setProperty("webMakerLocalAppletPath", localAppletPath);
            historyFile.addProperties(prop);
        }
    }

    static String getPageAuthorName() {
        return pageAuthorName;
    }

    static void setWebPageAuthor(String string) {
        if (string == null) {
            string = GT._("Jmol Web Page Maker");
        }
        pageAuthorName = string;
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static void setPopInDim(int n, int n2) {
        if (n < 25 || n > 3000) {
            n = 300;
        }
        if (n2 < 25 || n2 > 3000) {
            n2 = 300;
        }
        popInWidth = n;
        popInHeight = n2;
        prop.setProperty("webMakerPopInWidth", "" + n);
        prop.setProperty("webMakerPopInHeight", "" + n2);
        historyFile.addProperties(prop);
    }

    static int getPopInWidth() {
        return popInWidth;
    }

    static int getPopInHeight() {
        return popInHeight;
    }

    static void setScriptButtonPercent(int n) {
        if (n < 10 || n > 90) {
            n = 60;
        }
        scriptButtonPercent = n;
        prop.setProperty("webMakerScriptButtonPercent", "" + n);
        historyFile.addProperties(prop);
    }

    static int getScriptButtonPercent() {
        return scriptButtonPercent;
    }

    static JFrame getFrame() {
        return webFrame;
    }

    static URL getResource(Object object, String string) {
        return WebExport.getResource(object, string, true);
    }

    static URL getHtmlResource(Object object, String string) {
        String string2 = GT.getLanguage();
        String string3 = string + "_" + string2 + ".html";
        URL uRL = WebExport.getResource(object, string3, false);
        if (uRL == null && string2.length() == 5) {
            string3 = string + "_" + string2.substring(0, 2) + ".html";
            uRL = WebExport.getResource(object, string3, false);
        }
        if (uRL == null) {
            string3 = string + ".html";
            uRL = WebExport.getResource(object, string3, true);
        }
        return uRL;
    }

    static URL getResource(Object object, String string, boolean bl) {
        URL uRL = null;
        if (!string.contains("/")) {
            string = "org/openscience/jmol/app/webexport/html/" + string;
        }
        try {
            uRL = ClassLoader.getSystemResource(string);
            if (uRL == null && bl) {
                System.err.println("Couldn't find file: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
        }
        return uRL;
    }

    private static void setTranslations() {
        translations = new String[]{"GT_JmolPopIn.js_TOGETA3DMODEL", GT.escapeHTML(GT._("To get a 3-D model you can manipulate, click {0}here{1}. Download time may be significant the first time the applet is loaded.", new String[]{"<a href=\"HREF\">", "</a>"})), "GT_pop_in_template.html_INSERTTITLE", GT.escapeHTML(GT._("Insert the page TITLE here.")), "GT_pop_in_template.html_INSERTINTRO", GT.escapeHTML(GT._("Insert the page INTRODUCTION here.")), "GT_pop_in_template2.html_INSERTCAPTION", GT.escapeHTML(GT._("Insert a caption for {0} here.", "@NAME@")), "GT_pop_in_template2.html_INSERTADDITIONAL", GT.escapeHTML(GT._("Insert additional explanatory text here. Long text will wrap around Jmol model {0}.", "@NAME@")), "GT_script_button_template.html_INSERT", GT.escapeHTML(GT._("Insert your TITLE and INTRODUCTION here.")), "GT_script_button_template2.html_BUTTONINFO", GT.escapeHTML(GT._("The button {0} will appear in the box below.  Insert information for {0} here and below.", "@NAME@")), "GT_script_button_template2.html_MORE", GT.escapeHTML(GT._("Insert more information for {0} here.", "@NAME@"))};
    }

    private static String translate(String string) {
        for (int i = 0; i < translations.length; i += 2) {
            string = TextFormat.simpleReplace(string, translations[i], translations[i + 1]);
        }
        return string;
    }

    static String getResourceString(Object object, String string) throws IOException {
        URL uRL;
        URL uRL2 = uRL = string.indexOf(".") >= 0 ? WebExport.getResource(object, string) : WebExport.getHtmlResource(object, string);
        if (uRL == null) {
            throw new FileNotFoundException("Error loading resource " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
        }
        return WebExport.translate(stringBuffer.toString());
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public static void cleanUp() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getHomeDirectory();
        String string = file.getPath();
        String string2 = string + "/.jmol_WPM";
        File file2 = new File(string2);
        if (file2.exists()) {
            File[] fileArray = null;
            fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        WebExport.saveHistory();
    }

    static {
        prop = new Properties();
    }
}

