/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.api.JmolViewer;
import org.jmol.console.KeyJMenuItem;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDialog
extends JDialog
implements ActionListener {
    private boolean autoBond;
    boolean showHydrogens;
    boolean showMeasurements;
    boolean perspectiveDepth;
    boolean showAxes;
    boolean showBoundingBox;
    boolean axesOrientationRasmol;
    boolean openFilePreview;
    boolean clearHistory;
    float minBondDistance;
    float bondTolerance;
    short marBond;
    int percentVdwAtom;
    JButton bButton;
    JButton pButton;
    JButton tButton;
    JButton eButton;
    JButton vButton;
    private JRadioButton abYes;
    private JRadioButton abNo;
    private JSlider vdwPercentSlider;
    private JSlider bdSlider;
    private JSlider bwSlider;
    private JSlider btSlider;
    private JCheckBox cH;
    private JCheckBox cM;
    private JCheckBox cbPerspectiveDepth;
    private JCheckBox cbShowAxes;
    private JCheckBox cbShowBoundingBox;
    private JCheckBox cbAxesOrientationRasmol;
    private JCheckBox cbOpenFilePreview;
    private JCheckBox cbClearHistory;
    private Properties originalSystemProperties;
    private Properties jmolDefaultProperties;
    Properties currentProperties;
    private PrefsAction prefsAction = new PrefsAction();
    private Map<String, Action> commands;
    static final String[] jmolDefaults = new String[]{"jmolDefaults", "true", "showHydrogens", "true", "showMeasurements", "true", "perspectiveDepth", "true", "showAxes", "false", "showBoundingBox", "false", "axesOrientationRasmol", "false", "openFilePreview", "true", "percentVdwAtom", "23", "autoBond", "true", "marBond", "150", "minBondDistance", "0.40", "bondTolerance", "0.45"};
    static final String[] rasmolOverrides = new String[]{"jmolDefaults", "false", "percentVdwAtom", "0", "marBond", "1", "axesOrientationRasmol", "true"};
    JmolPanel jmol;
    JmolViewer viewer;
    GuiMap guimap;
    ItemListener checkBoxListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            String string;
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            String string2 = KeyJMenuItem.getKey(jCheckBox);
            boolean bl = jCheckBox.isSelected();
            String string3 = string = bl ? "true" : "false";
            if (string2.equals("Prefs.showHydrogens")) {
                PreferencesDialog.this.showHydrogens = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("showHydrogens", PreferencesDialog.this.showHydrogens);
                PreferencesDialog.this.currentProperties.put("showHydrogens", string);
            } else if (string2.equals("Prefs.showMeasurements")) {
                PreferencesDialog.this.showMeasurements = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("showMeasurements", PreferencesDialog.this.showMeasurements);
                PreferencesDialog.this.currentProperties.put("showMeasurements", string);
            } else if (string2.equals("Prefs.perspectiveDepth")) {
                PreferencesDialog.this.perspectiveDepth = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("perspectiveDepth", PreferencesDialog.this.perspectiveDepth);
                PreferencesDialog.this.currentProperties.put("perspectiveDepth", string);
            } else if (string2.equals("Prefs.showAxes")) {
                PreferencesDialog.this.showAxes = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("showAxes", bl);
                PreferencesDialog.this.viewer.refresh(3, "pref.showAxes");
                PreferencesDialog.this.currentProperties.put("showAxes", string);
            } else if (string2.equals("Prefs.showBoundingBox")) {
                PreferencesDialog.this.showBoundingBox = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("showBoundBox", bl);
                PreferencesDialog.this.viewer.refresh(3, "pref.showBoundingBox");
                PreferencesDialog.this.currentProperties.put("showBoundingBox", string);
            } else if (string2.equals("Prefs.axesOrientationRasmol")) {
                PreferencesDialog.this.axesOrientationRasmol = bl;
                PreferencesDialog.this.viewer.setBooleanProperty("axesOrientationRasmol", bl);
                PreferencesDialog.this.currentProperties.put("axesOrientationRasmol", string);
            } else if (string2.equals("Prefs.openFilePreview")) {
                PreferencesDialog.this.openFilePreview = bl;
                PreferencesDialog.this.currentProperties.put("openFilePreview", string);
            } else if (string2.equals("Prefs.clearHistory")) {
                PreferencesDialog.this.clearHistory = bl;
                PreferencesDialog.this.currentProperties.put("clearHistory", string);
                if (JmolPanel.historyFile != null) {
                    JmolPanel.historyFile.addProperty("clearHistory", string);
                }
            }
        }
    };
    private JButton applyButton;
    private JButton jmolDefaultsButton;
    private JButton rasmolDefaultsButton;
    private JButton cancelButton;
    private JButton okButton;

    public PreferencesDialog(JmolPanel jmolPanel, JFrame jFrame, GuiMap guiMap, JmolViewer jmolViewer) {
        super((Frame)jFrame, false);
        Object object;
        Object object2;
        this.jmol = jmolPanel;
        this.guimap = guiMap;
        this.viewer = jmolViewer;
        this.initializeProperties();
        this.setTitle(GT._("Preferences"));
        this.initVariables();
        this.commands = new Hashtable<String, Action>();
        Action[] actionArray = this.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            object2 = actionArray[i];
            object = object2.getValue("Name");
            this.commands.put(object != null ? object.toString() : null, (Action)object2);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        object2 = new JTabbedPane();
        object = this.buildDispPanel();
        JPanel jPanel2 = this.buildAtomsPanel();
        JPanel jPanel3 = this.buildBondPanel();
        ((JTabbedPane)object2).addTab(GT._("Display"), null, (Component)object);
        ((JTabbedPane)object2).addTab(GT._("Atoms"), null, jPanel2);
        ((JTabbedPane)object2).addTab(GT._("Bonds"), null, jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this.jmolDefaultsButton = new JButton(GT._("Jmol Defaults"));
        this.jmolDefaultsButton.addActionListener(this);
        jPanel4.add(this.jmolDefaultsButton);
        this.rasmolDefaultsButton = new JButton(GT._("RasMol Defaults"));
        this.rasmolDefaultsButton.addActionListener(this);
        jPanel4.add(this.rasmolDefaultsButton);
        this.cancelButton = new JButton(GT._("Cancel"));
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        this.applyButton = new JButton(GT._("Apply"));
        this.applyButton.addActionListener(this);
        jPanel4.add(this.applyButton);
        this.okButton = new JButton(GT._("OK"));
        this.okButton.addActionListener(this);
        jPanel4.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        jPanel.add((Component)object2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.updateComponents();
        this.pack();
        this.centerDialog();
    }

    public JPanel buildDispPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        jPanel2.setBorder(new TitledBorder(GT._("Show All")));
        this.cH = this.guimap.newJCheckBox("Prefs.showHydrogens", this.viewer.getShowHydrogens());
        this.cH.addItemListener(this.checkBoxListener);
        this.cM = this.guimap.newJCheckBox("Prefs.showMeasurements", this.viewer.getShowMeasurements());
        this.cM.addItemListener(this.checkBoxListener);
        jPanel2.add(this.cH);
        jPanel2.add(this.cM);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(""));
        jPanel3.setLayout(new GridLayout(2, 1));
        this.cbPerspectiveDepth = this.guimap.newJCheckBox("Prefs.perspectiveDepth", this.viewer.getPerspectiveDepth());
        this.cbPerspectiveDepth.addItemListener(this.checkBoxListener);
        jPanel3.add(this.cbPerspectiveDepth);
        this.cbShowAxes = this.guimap.newJCheckBox("Prefs.showAxes", this.viewer.getShowAxes());
        this.cbShowAxes.addItemListener(this.checkBoxListener);
        jPanel3.add(this.cbShowAxes);
        this.cbShowBoundingBox = this.guimap.newJCheckBox("Prefs.showBoundingBox", this.viewer.getShowBbcage());
        this.cbShowBoundingBox.addItemListener(this.checkBoxListener);
        jPanel3.add(this.cbShowBoundingBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(""));
        jPanel4.setLayout(new GridLayout(1, 1));
        this.cbAxesOrientationRasmol = this.guimap.newJCheckBox("Prefs.axesOrientationRasmol", this.viewer.getAxesOrientationRasmol());
        this.cbAxesOrientationRasmol.addItemListener(this.checkBoxListener);
        jPanel4.add(this.cbAxesOrientationRasmol);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(""));
        jPanel5.setLayout(new GridLayout(2, 1));
        this.cbOpenFilePreview = this.guimap.newJCheckBox("Prefs.openFilePreview", this.openFilePreview);
        this.cbOpenFilePreview.addItemListener(this.checkBoxListener);
        jPanel5.add(this.cbOpenFilePreview);
        this.cbClearHistory = this.guimap.newJCheckBox("Prefs.clearHistory", this.clearHistory);
        this.cbClearHistory.addItemListener(this.checkBoxListener);
        jPanel5.add(this.cbClearHistory);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JLabel jLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    public JPanel buildAtomsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(GT._("Default atom size")));
        JLabel jLabel = new JLabel(GT._("(percentage of vanDerWaals radius)"), 0);
        jPanel2.add((Component)jLabel, "North");
        this.vdwPercentSlider = new JSlider(0, 0, 100, this.viewer.getPercentVdwAtom());
        this.vdwPercentSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.vdwPercentSlider.setPaintTicks(true);
        this.vdwPercentSlider.setMajorTickSpacing(20);
        this.vdwPercentSlider.setMinorTickSpacing(10);
        this.vdwPercentSlider.setPaintLabels(true);
        this.vdwPercentSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                PreferencesDialog.this.percentVdwAtom = jSlider.getValue();
                PreferencesDialog.this.viewer.setIntProperty("PercentVdwAtom", PreferencesDialog.this.percentVdwAtom);
                PreferencesDialog.this.currentProperties.put("percentVdwAtom", "" + PreferencesDialog.this.percentVdwAtom);
            }
        });
        jPanel2.add((Component)this.vdwPercentSlider, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        return jPanel;
    }

    private Dictionary<Object, Object> getJSliderLabelTable(JSlider jSlider) {
        return jSlider.getLabelTable();
    }

    public JPanel buildBondPanel() {
        Dictionary<Object, Object> dictionary;
        Object object;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new TitledBorder(GT._("Compute Bonds")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.abYes = new JRadioButton(GT._("Automatically"));
        this.abNo = new JRadioButton(GT._("Don't Compute Bonds"));
        buttonGroup.add(this.abYes);
        buttonGroup.add(this.abNo);
        jPanel2.add(this.abYes);
        jPanel2.add(this.abNo);
        jPanel2.add(Box.createVerticalGlue());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.abYes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.viewer.setBooleanProperty("autoBond", true);
                PreferencesDialog.this.currentProperties.put("autoBond", "true");
            }
        });
        this.abNo.setSelected(!this.viewer.getAutoBond());
        this.abNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.viewer.setBooleanProperty("autoBond", false);
                PreferencesDialog.this.currentProperties.put("autoBond", "false");
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(GT._("Default Bond Radius")));
        JLabel jLabel = new JLabel(GT._("(Angstroms)"), 0);
        jPanel3.add((Component)jLabel, "North");
        this.bwSlider = new JSlider(0, 250, this.viewer.getMadBond() / 2);
        this.bwSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bwSlider.setPaintTicks(true);
        this.bwSlider.setMajorTickSpacing(50);
        this.bwSlider.setMinorTickSpacing(25);
        this.bwSlider.setPaintLabels(true);
        for (int i = 0; i <= 250; i += 50) {
            object = "" + (1000 + i);
            object = "0." + ((String)object).substring(1);
            dictionary = this.getJSliderLabelTable(this.bwSlider);
            dictionary.put(i, new JLabel((String)object, 0));
            this.bwSlider.setLabelTable(dictionary);
        }
        this.bwSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                PreferencesDialog.this.marBond = (short)jSlider.getValue();
                PreferencesDialog.this.viewer.setIntProperty("bondRadiusMilliAngstroms", PreferencesDialog.this.marBond);
                PreferencesDialog.this.currentProperties.put("marBond", "" + PreferencesDialog.this.marBond);
            }
        });
        jPanel3.add((Component)this.bwSlider, "South");
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(GT._("Bond Tolerance - sum of two covalent radii + this value")));
        object = new JLabel(GT._("(Angstroms)"), 0);
        jPanel4.add((Component)object, "North");
        this.btSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getBondTolerance()));
        this.btSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.btSlider.setPaintTicks(true);
        this.btSlider.setMajorTickSpacing(20);
        this.btSlider.setMinorTickSpacing(10);
        this.btSlider.setPaintLabels(true);
        dictionary = this.getJSliderLabelTable(this.btSlider);
        dictionary.put(0, new JLabel("0.0", 0));
        this.btSlider.setLabelTable(dictionary);
        dictionary.put(20, new JLabel("0.2", 0));
        this.btSlider.setLabelTable(dictionary);
        dictionary.put(40, new JLabel("0.4", 0));
        this.btSlider.setLabelTable(dictionary);
        dictionary.put(60, new JLabel("0.6", 0));
        this.btSlider.setLabelTable(dictionary);
        dictionary.put(80, new JLabel("0.8", 0));
        this.btSlider.setLabelTable(dictionary);
        dictionary.put(100, new JLabel("1.0", 0));
        this.btSlider.setLabelTable(dictionary);
        this.btSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                PreferencesDialog.this.bondTolerance = (float)jSlider.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setFloatProperty("bondTolerance", PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.currentProperties.put("bondTolerance", "" + PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        jPanel4.add(this.btSlider);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(new TitledBorder(GT._("Minimum Bonding Distance")));
        JLabel jLabel2 = new JLabel(GT._("(Angstroms)"), 0);
        jPanel5.add((Component)jLabel2, "North");
        this.bdSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getMinBondDistance()));
        this.bdSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bdSlider.setPaintTicks(true);
        this.bdSlider.setMajorTickSpacing(20);
        this.bdSlider.setMinorTickSpacing(10);
        this.bdSlider.setPaintLabels(true);
        dictionary = this.getJSliderLabelTable(this.bdSlider);
        dictionary.put(0, new JLabel("0.0", 0));
        this.bdSlider.setLabelTable(dictionary);
        dictionary.put(20, new JLabel("0.2", 0));
        this.bdSlider.setLabelTable(dictionary);
        dictionary.put(40, new JLabel("0.4", 0));
        this.bdSlider.setLabelTable(dictionary);
        dictionary.put(60, new JLabel("0.6", 0));
        this.bdSlider.setLabelTable(dictionary);
        dictionary.put(80, new JLabel("0.8", 0));
        this.bdSlider.setLabelTable(dictionary);
        dictionary.put(100, new JLabel("1.0", 0));
        this.bdSlider.setLabelTable(dictionary);
        this.bdSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                PreferencesDialog.this.minBondDistance = (float)jSlider.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setFloatProperty("minBondDistance", PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.currentProperties.put("minBondDistance", "" + PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        jPanel5.add(this.bdSlider);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        return jPanel;
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public void ok() {
        this.save();
        this.dispose();
    }

    public void cancel() {
        this.updateComponents();
        this.dispose();
    }

    private void updateComponents() {
        this.cH.setSelected(this.viewer.getShowHydrogens());
        this.cM.setSelected(this.viewer.getShowMeasurements());
        this.cbPerspectiveDepth.setSelected(this.viewer.getPerspectiveDepth());
        this.cbShowAxes.setSelected(this.viewer.getShowAxes());
        this.cbShowBoundingBox.setSelected(this.viewer.getShowBbcage());
        this.cbAxesOrientationRasmol.setSelected(this.viewer.getAxesOrientationRasmol());
        this.cbOpenFilePreview.setSelected(this.openFilePreview);
        this.cbClearHistory.setSelected(this.clearHistory);
        this.vdwPercentSlider.setValue(this.viewer.getPercentVdwAtom());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.bwSlider.setValue(this.viewer.getMadBond() / 2);
        this.bdSlider.setValue((int)(100.0f * this.viewer.getMinBondDistance()));
        this.btSlider.setValue((int)(100.0f * this.viewer.getBondTolerance()));
    }

    private void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.jmol.jmolApp.userPropsFile);
            this.currentProperties.store(fileOutputStream, "Jmol");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Logger.error("Error saving preferences", exception);
        }
        this.viewer.refresh(3, "PreferencesDialog:save()");
    }

    void initializeProperties() {
        this.originalSystemProperties = System.getProperties();
        this.jmolDefaultProperties = new Properties(this.originalSystemProperties);
        int n = jmolDefaults.length;
        while ((n -= 2) >= 0) {
            this.jmolDefaultProperties.put(jmolDefaults[n], jmolDefaults[n + 1]);
        }
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.jmol.jmolApp.userPropsFile), 1024);
            this.currentProperties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(this.currentProperties);
    }

    void resetDefaults(String[] stringArray) {
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        System.setProperties(this.currentProperties);
        if (stringArray != null) {
            int n = stringArray.length;
            while ((n -= 2) >= 0) {
                this.currentProperties.put(stringArray[n], stringArray[n + 1]);
            }
        }
        this.initVariables();
        this.viewer.refresh(3, "PreferencesDialog:resetDefaults()");
        this.updateComponents();
    }

    void initVariables() {
        this.autoBond = Boolean.getBoolean("autoBond");
        this.showHydrogens = Boolean.getBoolean("showHydrogens");
        this.showMeasurements = Boolean.getBoolean("showMeasurements");
        this.perspectiveDepth = Boolean.getBoolean("perspectiveDepth");
        this.showAxes = Boolean.getBoolean("showAxes");
        this.showBoundingBox = Boolean.getBoolean("showBoundingBox");
        this.axesOrientationRasmol = Boolean.getBoolean("axesOrientationRasmol");
        this.openFilePreview = Boolean.valueOf(System.getProperty("openFilePreview", "true"));
        this.clearHistory = Boolean.getBoolean("clearHistory");
        this.minBondDistance = new Float(this.currentProperties.getProperty("minBondDistance")).floatValue();
        this.bondTolerance = new Float(this.currentProperties.getProperty("bondTolerance")).floatValue();
        this.marBond = Short.parseShort(this.currentProperties.getProperty("marBond"));
        this.percentVdwAtom = Integer.parseInt(this.currentProperties.getProperty("percentVdwAtom"));
        if (Boolean.getBoolean("jmolDefaults")) {
            this.viewer.setStringProperty("defaults", "Jmol");
        } else {
            this.viewer.setStringProperty("defaults", "RasMol");
        }
        this.viewer.setIntProperty("percentVdwAtom", this.percentVdwAtom);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", this.marBond);
        this.viewer.setFloatProperty("minBondDistance", this.minBondDistance);
        this.viewer.setFloatProperty("BondTolerance", this.bondTolerance);
        this.viewer.setBooleanProperty("autoBond", this.autoBond);
        this.viewer.setBooleanProperty("showHydrogens", this.showHydrogens);
        this.viewer.setBooleanProperty("showMeasurements", this.showMeasurements);
        this.viewer.setBooleanProperty("perspectiveDepth", this.perspectiveDepth);
        this.viewer.setBooleanProperty("showAxes", this.showAxes);
        this.viewer.setBooleanProperty("showBoundBox", this.showBoundingBox);
        this.viewer.setBooleanProperty("axesOrientationRasmol", this.axesOrientationRasmol);
    }

    public Action[] getActions() {
        Action[] actionArray = new Action[]{this.prefsAction};
        return actionArray;
    }

    protected Action getAction(String string) {
        return this.commands.get(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.applyButton) {
            this.save();
        } else if (actionEvent.getSource() == this.jmolDefaultsButton) {
            this.resetDefaults(null);
        } else if (actionEvent.getSource() == this.rasmolDefaultsButton) {
            this.resetDefaults(rasmolOverrides);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancel();
        } else if (actionEvent.getSource() == this.okButton) {
            this.ok();
        }
    }

    class PrefsAction
    extends AbstractAction {
        public PrefsAction() {
            super("prefs");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PreferencesDialog.this.setVisible(true);
        }
    }
}

