/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import com.json.JSONException;
import com.json.JSONObject;
import com.json.JSONTokener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Calendar;
import javax.vecmath.Point3f;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOSocket;
import naga.ServerSocketObserverAdapter;
import naga.SocketObserver;
import naga.SocketObserverAdapter;
import naga.packetreader.AsciiLinePacketReader;
import naga.packetwriter.RawPacketWriter;
import org.jmol.api.JmolViewer;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.jmolpanel.JsonNioClient;

public class JsonNioService
extends NIOService {
    protected String myName;
    protected boolean halt;
    protected boolean isPaused;
    protected long lastMoveTime;
    protected int port;
    private Thread thread;
    private Thread serverThread;
    private NIOSocket inSocket;
    protected NIOSocket outSocket;
    private NIOServerSocket serverSocket;
    private JmolViewer jmolViewer;
    private JsonNioClient client;
    private boolean wasSpinOn;
    private String contentPath = "./%ID%.json";
    private String terminatorMessage = "NEXT_SCRIPT";

    void scriptCallback(String string) {
        if (string.equals(this.terminatorMessage)) {
            this.sendMessage(null, "!script_terminated!", null);
        }
    }

    int getPort() {
        return this.port;
    }

    void send(int n, String string) {
        try {
            if (n != this.port) {
                if (this.inSocket != null) {
                    this.inSocket.close();
                    this.outSocket.close();
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.startService(n, this.client, this.jmolViewer, this.myName);
            }
            if (string.startsWith("Mouse:")) {
                string = "{\"type\":\"move\",\"style\":\"sync\", \"sync\":\"" + string.substring(6) + "\"}";
            }
            this.sendMessage(null, string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startService(int n, JsonNioClient jsonNioClient, JmolViewer jmolViewer, String string) throws IOException {
        this.port = Math.abs(n);
        this.client = jsonNioClient;
        this.jmolViewer = jmolViewer;
        String string2 = this.myName = string == null ? "" : string;
        if (n < 0) {
            this.startServerService();
            return;
        }
        if (string != null) {
            jmolViewer.script(";sync on;sync slave");
            String string3 = this.getJmolValue("NIOcontentPath");
            if (string3 != null) {
                this.contentPath = string3;
            }
            if ((string3 = this.getJmolValue("NIOterminatorMessage")) != null) {
                this.terminatorMessage = string3;
            }
            Logger.info("contentPath=" + this.contentPath);
            Logger.info("terminatorMessage=" + this.terminatorMessage);
        }
        Logger.info("JsonNioService" + this.myName + " using port " + n);
        this.inSocket = this.openSocket("127.0.0.1", n);
        this.inSocket.setPacketReader(new AsciiLinePacketReader());
        this.inSocket.setPacketWriter(new RawPacketWriter());
        this.inSocket.listen(new SocketObserver(){

            public void connectionOpened(NIOSocket nIOSocket) {
                JsonNioService.this.initialize("out", nIOSocket);
            }

            public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                JsonNioService.this.processMessage(byArray, null);
            }

            public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                JsonNioService.this.halt = true;
                Logger.info(Thread.currentThread().getName() + " inSocket connectionBroken");
            }
        });
        this.outSocket = this.openSocket("127.0.0.1", n);
        this.outSocket.setPacketReader(new AsciiLinePacketReader());
        this.outSocket.setPacketWriter(new RawPacketWriter());
        this.outSocket.listen(new SocketObserver(){

            public void connectionOpened(NIOSocket nIOSocket) {
                JsonNioService.this.initialize("in", nIOSocket);
            }

            public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                System.out.println("outpacketreceived");
            }

            public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                JsonNioService.this.halt = true;
                Logger.info(Thread.currentThread().getName() + " outSocket connectionBroken");
            }
        });
        this.thread = new Thread((Runnable)new JsonNioThread(), "JsonNiosThread" + this.myName);
        this.thread.start();
    }

    public void close() {
        try {
            this.halt = true;
            super.close();
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
                this.serverThread = null;
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.client != null) {
            this.client.nioClosed(this);
        }
    }

    protected void initialize(String string, NIOSocket nIOSocket) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("magic", "JmolApp");
            jSONObject.put("role", string);
            this.sendMessage(jSONObject, null, nIOSocket);
        }
        catch (JSONException jSONException) {
            this.close();
        }
    }

    private void startServerService() {
        try {
            this.serverSocket = this.openServerSocket(this.port);
            this.serverSocket.listen(new ServerSocketObserverAdapter(){

                public void newConnection(NIOSocket nIOSocket) {
                    Logger.info(Thread.currentThread().getName() + " Received connection: " + nIOSocket);
                    nIOSocket.setPacketReader(new AsciiLinePacketReader());
                    nIOSocket.setPacketWriter(new RawPacketWriter());
                    nIOSocket.listen(new SocketObserverAdapter(){

                        public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
                            JsonNioService.this.processMessage(byArray, nIOSocket);
                        }

                        public void connectionOpened(NIOSocket nIOSocket) {
                        }

                        public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
                            if (nIOSocket == JsonNioService.this.outSocket) {
                                JsonNioService.this.outSocket = null;
                            }
                        }
                    });
                }
            });
            this.serverSocket.setConnectionAcceptor(new ConnectionAcceptor(){

                public boolean acceptConnection(InetSocketAddress inetSocketAddress) {
                    boolean bl = inetSocketAddress.getAddress().isLoopbackAddress();
                    return bl;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
        this.serverThread = new Thread((Runnable)new JsonNioServerThread(), "JsonNioServerThread" + this.myName);
        this.serverThread.start();
    }

    protected void processMessage(byte[] byArray, NIOSocket nIOSocket) {
        try {
            String string = new String(byArray);
            if (this.jmolViewer == null) {
                Logger.info("JNIOS " + Thread.currentThread().getName() + " received " + string);
                return;
            }
            JSONObject jSONObject = new JSONObject(string);
            if (nIOSocket != null && jSONObject.has("magic") && jSONObject.getString("magic").equals("JmolApp") && jSONObject.getString("role").equals("out")) {
                this.outSocket = nIOSocket;
            }
            if (!jSONObject.has("type")) {
                return;
            }
            block1 : switch ("banner....command...content...move......quit......sync......touch.....".indexOf(jSONObject.getString("type"))) {
                case 0: {
                    this.setBanner((String)(jSONObject.has("text") ? jSONObject.getString("text") : (jSONObject.getString("visibility").equalsIgnoreCase("off") ? null : "")), false);
                    break;
                }
                case 10: {
                    this.jmolViewer.evalStringQuiet(jSONObject.getString("command"));
                    break;
                }
                case 20: {
                    String string2 = jSONObject.getString("id");
                    String string3 = TextFormat.simpleReplace(this.contentPath, "%ID%", string2).replace('\\', '/');
                    File file = new File(string3);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Logger.info("JsonNiosService Setting path to " + file.getAbsolutePath());
                    int n = string3.lastIndexOf(47);
                    string3 = n >= 0 ? string3.substring(0, n) : ".";
                    JSONObject jSONObject2 = new JSONObject(new JSONTokener(fileInputStream));
                    String string4 = jSONObject2.getString("startup_script");
                    Logger.info("JsonNiosService startup_script=" + string4);
                    this.setBanner("", false);
                    this.jmolViewer.script("exit");
                    this.jmolViewer.script("zap;cd \"" + string3 + "\";script " + string4);
                    this.setBanner(jSONObject2.getString("banner").equals("off") ? null : jSONObject2.getString("banner_text"), true);
                    break;
                }
                case 30: {
                    int n = "rotate....translate.zoom......".indexOf(jSONObject.getString("style"));
                    if (n != 0 && !this.isPaused) {
                        this.pauseScript(true);
                    }
                    this.lastMoveTime = Calendar.getInstance().getTimeInMillis();
                    switch (n) {
                        case 0: {
                            this.jmolViewer.syncScript("Mouse: rotateXYBy " + jSONObject.getString("x") + " " + jSONObject.getString("y"), "~", 0);
                            break block1;
                        }
                        case 10: {
                            this.jmolViewer.syncScript("Mouse: translateXYBy " + jSONObject.getString("x") + " " + jSONObject.getString("y"), "~", 0);
                            break block1;
                        }
                        case 20: {
                            float f = (float)(jSONObject.getDouble("scale") / (double)(this.jmolViewer.getZoomPercentFloat() / 100.0f));
                            this.jmolViewer.syncScript("Mouse: zoomByFactor " + f, "~", 0);
                        }
                    }
                    break;
                }
                case 40: {
                    this.halt = true;
                    Logger.info("JsonNiosService quitting");
                    break;
                }
                case 50: {
                    this.jmolViewer.syncScript("Mouse: " + jSONObject.getString("sync"), "~", 0);
                    break;
                }
                case 60: {
                    this.jmolViewer.processEvent(0, jSONObject.getInt("eventType"), jSONObject.getInt("touchID"), jSONObject.getInt("iData"), new Point3f((float)jSONObject.getDouble("x"), (float)jSONObject.getDouble("y"), (float)jSONObject.getDouble("z")), jSONObject.getLong("time"));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setBanner(String string, boolean bl) {
        if (string == null) {
            this.client.setBannerLabel(null);
        } else {
            if (bl) {
                string = "<center>" + string + "</center>";
            }
            this.client.setBannerLabel("<html>" + string + "</html>");
        }
    }

    protected void pauseScript(boolean bl) {
        String string;
        if (bl) {
            this.wasSpinOn = this.jmolViewer.getBooleanProperty("spinOn");
            string = "pause; save orientation 'JsonNios-save'; spin off";
            this.isPaused = true;
        } else {
            string = "restore rotation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
            this.wasSpinOn = false;
        }
        this.isPaused = bl;
        this.jmolViewer.evalStringQuiet(string);
    }

    private String getJmolValue(String string) {
        if (this.jmolViewer == null) {
            return "";
        }
        String string2 = (String)this.jmolViewer.scriptWaitStatus("print " + string, "output");
        return string2.indexOf("\n") <= 1 ? null : string2.substring(0, string2.lastIndexOf("\n"));
    }

    private void sendMessage(JSONObject jSONObject, String string, NIOSocket nIOSocket) {
        try {
            if (jSONObject != null) {
                string = jSONObject.toString();
            } else if (jSONObject == null && string != null && string.indexOf("{") != 0) {
                jSONObject = new JSONObject();
                if (string.equalsIgnoreCase("!script_terminated!")) {
                    jSONObject.put("type", "script");
                    jSONObject.put("event", "done");
                } else {
                    jSONObject.put("type", "command");
                    jSONObject.put("command", string);
                }
                string = jSONObject.toString();
            }
            string = string + "\r\n";
            if (nIOSocket == null) {
                nIOSocket = this.outSocket;
            }
            Logger.info(Thread.currentThread().getName() + " sending " + string + " to " + nIOSocket);
            if (nIOSocket != null) {
                nIOSocket.write(string.getBytes("UTF-8"));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class JsonNioServerThread
    implements Runnable {
        JsonNioServerThread() {
        }

        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioServerSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectBlocking();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JsonNioService.this.close();
        }
    }

    class JsonNioThread
    implements Runnable {
        JsonNioThread() {
        }

        public void run() {
            Logger.info(Thread.currentThread().getName() + " JsonNioSocket on " + JsonNioService.this.port);
            try {
                while (!JsonNioService.this.halt) {
                    JsonNioService.this.selectNonBlocking();
                    long l = Calendar.getInstance().getTimeInMillis();
                    if (JsonNioService.this.isPaused && l - JsonNioService.this.lastMoveTime > 5000L) {
                        JsonNioService.this.pauseScript(false);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            JsonNioService.this.close();
        }
    }
}

