/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.constant.EnumPalette;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorEncoder {
    private static final int GRAY = -8355712;
    public static final String BYELEMENT_PREFIX = "byelement";
    public static final String BYRESIDUE_PREFIX = "byresidue";
    private static final String BYELEMENT_JMOL = "byelement_jmol";
    private static final String BYELEMENT_RASMOL = "byelement_rasmol";
    private static final String BYRESIDUE_SHAPELY = "byresidue_shapely";
    private static final String BYRESIDUE_AMINO = "byresidue_amino";
    public static final int CUSTOM = -1;
    public static final int ROYGB = 0;
    public static final int BGYOR = 1;
    public static final int JMOL = 2;
    public static final int RASMOL = 3;
    public static final int SHAPELY = 4;
    public static final int AMINO = 5;
    public static final int RWB = 6;
    public static final int BWR = 7;
    public static final int LOW = 8;
    public static final int HIGH = 9;
    public static final int BW = 10;
    public static final int WB = 11;
    public static final int USER = -12;
    public static final int RESU = -13;
    public static final int ALT = 14;
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "byelement_jmol", "byelement_rasmol", "byresidue_shapely", "byresidue_amino", "rwb", "bwr", "low", "high", "bw", "wb", "user", "resu", "rgb", "bgr", "jmol", "rasmol", "byresidue"};
    private int[] paletteBW;
    private int[] paletteWB;
    private int[] argbsCpk;
    private int[] argbsRoygb;
    private int[] argbsRwb;
    private int[] argbsShapely;
    private int[] argbsAmino;
    private int ihalf;
    private static int[] rasmolScale;
    public Map<String, int[]> schemes;
    public int currentPalette = 0;
    public int currentSegmentCount = 1;
    public boolean isTranslucent = false;
    public float lo;
    public float hi;
    public boolean isReversed;
    int[] userScale = new int[]{-8355712};
    int[] thisScale = new int[]{-8355712};
    String thisName = "scheme";
    boolean isColorIndex;
    ColorEncoder propertyColorEncoder;

    public ColorEncoder(ColorEncoder colorEncoder) {
        if (colorEncoder == null) {
            this.schemes = new Hashtable<String, int[]>();
            this.argbsCpk = EnumPalette.argbsCpk;
            this.argbsRoygb = JmolConstants.argbsRoygbScale;
            this.argbsRwb = JmolConstants.argbsRwbScale;
            this.argbsShapely = JmolConstants.argbsShapely;
            this.argbsAmino = JmolConstants.argbsAmino;
            this.ihalf = JmolConstants.argbsRoygbScale.length / 3;
            this.propertyColorEncoder = this;
        } else {
            this.propertyColorEncoder = colorEncoder;
            this.schemes = colorEncoder.schemes;
        }
    }

    private static final int getSchemeIndex(String string) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(string)) continue;
            return i >= 14 ? i - 14 : (i < 12 ? i : -i);
        }
        return -1;
    }

    private static final String fixName(String string) {
        if (string.equalsIgnoreCase(BYELEMENT_PREFIX)) {
            return BYELEMENT_JMOL;
        }
        int n = ColorEncoder.getSchemeIndex(string);
        return n >= 0 ? colorSchemes[n] : string.toLowerCase();
    }

    private synchronized int makeColorScheme(String string, int[] nArray, boolean bl) {
        string = ColorEncoder.fixName(string);
        if (nArray == null) {
            this.schemes.remove(string);
            int n = this.getColorScheme(string, false, bl);
            if (bl) {
                switch (n) {
                    case 10: {
                        this.paletteBW = this.getPaletteBW();
                        break;
                    }
                    case 11: {
                        this.paletteWB = this.getPaletteWB();
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.argbsRoygb = JmolConstants.argbsRoygbScale;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.argbsRwb = JmolConstants.argbsRwbScale;
                        break;
                    }
                    case 2: {
                        this.argbsCpk = EnumPalette.argbsCpk;
                        break;
                    }
                    case 3: {
                        ColorEncoder.getRasmolScale();
                        break;
                    }
                    case 5: {
                        this.argbsAmino = JmolConstants.argbsAmino;
                        break;
                    }
                    case 4: {
                        this.argbsShapely = JmolConstants.argbsShapely;
                    }
                }
            }
            return n == Integer.MAX_VALUE ? 0 : n;
        }
        this.schemes.put(string, nArray);
        this.setThisScheme(string, nArray);
        int n = this.getColorScheme(string, false, bl);
        if (bl) {
            switch (n) {
                case 10: {
                    this.paletteBW = this.thisScale;
                    break;
                }
                case 11: {
                    this.paletteWB = this.thisScale;
                    break;
                }
                case 0: 
                case 1: {
                    this.argbsRoygb = this.thisScale;
                    this.ihalf = this.argbsRoygb.length / 3;
                    break;
                }
                case 6: 
                case 7: {
                    this.argbsRwb = this.thisScale;
                    break;
                }
                case 2: {
                    this.argbsCpk = this.thisScale;
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    this.argbsAmino = this.thisScale;
                    break;
                }
                case 4: {
                    this.argbsShapely = this.thisScale;
                }
            }
        }
        return -1;
    }

    public int getColorScheme(String string, boolean bl, boolean bl2) {
        int n = Math.max((string = string.toLowerCase()).indexOf("="), string.indexOf("["));
        if (n >= 0) {
            String string2 = TextFormat.replaceAllCharacters(string.substring(0, n), " =", "");
            if (string2.length() > 0) {
                bl2 = true;
            }
            int n2 = 0;
            n = -1;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                ++n2;
            }
            if (n2 == 0) {
                return this.makeColorScheme(string2, null, bl2);
            }
            int[] nArray = new int[n2];
            n = -1;
            n2 = 0;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                int n3;
                int n4 = string.indexOf("]", n);
                if (n4 < 0) {
                    n4 = string.length() - 1;
                }
                nArray[n2++] = n3 = Graphics3D.getArgbFromString(string.substring(n, n4 + 1));
                if (n3 != 0) continue;
                Logger.error("error in color value: " + string.substring(n, n4 + 1));
                return 0;
            }
            if (string2.equals("user")) {
                this.setUserScale(nArray);
                return -12;
            }
            return this.makeColorScheme(string2, nArray, bl2);
        }
        string = ColorEncoder.fixName(string);
        int n5 = ColorEncoder.getSchemeIndex(string);
        if (this.schemes.containsKey(string)) {
            this.setThisScheme(string, this.schemes.get(string));
            return n5;
        }
        return n5 != -1 ? n5 : (bl ? 0 : Integer.MAX_VALUE);
    }

    public void setUserScale(int[] nArray) {
        this.propertyColorEncoder.userScale = nArray;
        this.makeColorScheme("user", nArray, false);
    }

    public int[] getColorSchemeArray(int n) {
        switch (n) {
            case -1: {
                return this.thisScale;
            }
            case 0: {
                return this.propertyColorEncoder.argbsRoygb;
            }
            case 1: {
                return ArrayUtil.arrayCopy(this.propertyColorEncoder.argbsRoygb, 0, -1, true);
            }
            case 8: {
                return ArrayUtil.arrayCopy(this.propertyColorEncoder.argbsRoygb, 0, this.propertyColorEncoder.ihalf, false);
            }
            case 9: {
                int[] nArray = ArrayUtil.arrayCopy(this.propertyColorEncoder.argbsRoygb, this.propertyColorEncoder.argbsRoygb.length - 2 * this.propertyColorEncoder.ihalf, -1, false);
                int[] nArray2 = new int[this.propertyColorEncoder.ihalf];
                int n2 = nArray2.length;
                int n3 = nArray.length;
                while (--n2 >= 0 && --n3 >= 0) {
                    nArray2[n2] = nArray[n3--];
                }
                return nArray2;
            }
            case 10: {
                return this.getPaletteBW();
            }
            case 11: {
                return this.getPaletteWB();
            }
            case 6: {
                return this.propertyColorEncoder.argbsRwb;
            }
            case 7: {
                return ArrayUtil.arrayCopy(this.propertyColorEncoder.argbsRwb, 0, -1, true);
            }
            case 2: {
                return this.propertyColorEncoder.argbsCpk;
            }
            case 3: {
                return ColorEncoder.getRasmolScale();
            }
            case 4: {
                return this.propertyColorEncoder.argbsShapely;
            }
            case 5: {
                return this.propertyColorEncoder.argbsAmino;
            }
            case -12: {
                return this.propertyColorEncoder.userScale;
            }
            case -13: {
                return ArrayUtil.arrayCopy(this.propertyColorEncoder.userScale, 0, -1, true);
            }
        }
        return null;
    }

    public short getColorIndexFromPalette(float f, float f2, float f3, int n, boolean bl) {
        short s = Graphics3D.getColix(this.getArgbFromPalette(f, f2, f3, n));
        if (bl) {
            float f4 = (f3 - f) / (f3 - f2);
            if (f4 > 1.0f) {
                f4 = 1.0f;
            } else if (f4 < 0.125f) {
                f4 = 0.125f;
            }
            s = Graphics3D.getColixTranslucent(s, true, f4);
        }
        return s;
    }

    public int getPaletteColorCount(int n) {
        switch (n) {
            case -1: {
                return this.thisScale.length;
            }
            case 10: 
            case 11: {
                this.getPaletteBW();
                return this.propertyColorEncoder.paletteBW.length;
            }
            case 0: 
            case 1: {
                return this.propertyColorEncoder.argbsRoygb.length;
            }
            case 8: 
            case 9: {
                return this.propertyColorEncoder.ihalf;
            }
            case 6: 
            case 7: {
                return this.propertyColorEncoder.argbsRwb.length;
            }
            case -13: 
            case -12: {
                return this.propertyColorEncoder.userScale.length;
            }
            case 2: {
                return this.argbsCpk.length;
            }
            case 3: {
                return ColorEncoder.getRasmolScale().length;
            }
            case 4: {
                return this.propertyColorEncoder.argbsShapely.length;
            }
            case 5: {
                return this.propertyColorEncoder.argbsAmino.length;
            }
        }
        return 0;
    }

    public int getArgbFromPalette(float f, float f2, float f3, int n) {
        if (Float.isNaN(f)) {
            return -8355712;
        }
        int n2 = this.getPaletteColorCount(n);
        switch (n) {
            case -1: {
                if (this.isColorIndex) {
                    f2 = 0.0f;
                    f3 = this.thisScale.length;
                }
                return this.thisScale[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 10: {
                return this.getPaletteBW()[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 11: {
                return this.getPaletteWB()[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 0: {
                return this.propertyColorEncoder.argbsRoygb[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 1: {
                return this.propertyColorEncoder.argbsRoygb[ColorEncoder.quantize(-f, -f3, -f2, n2)];
            }
            case 8: {
                return this.propertyColorEncoder.argbsRoygb[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 9: {
                return this.propertyColorEncoder.argbsRoygb[this.propertyColorEncoder.ihalf + ColorEncoder.quantize(f, f2, f3, n2) * 2];
            }
            case 6: {
                return this.propertyColorEncoder.argbsRwb[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case 7: {
                return this.propertyColorEncoder.argbsRwb[ColorEncoder.quantize(-f, -f3, -f2, n2)];
            }
            case -12: {
                return this.propertyColorEncoder.userScale.length == 0 ? -8355712 : this.propertyColorEncoder.userScale[ColorEncoder.quantize(f, f2, f3, n2)];
            }
            case -13: {
                return this.propertyColorEncoder.userScale.length == 0 ? -8355712 : this.propertyColorEncoder.userScale[ColorEncoder.quantize(-f, -f3, -f2, n2)];
            }
            case 2: {
                return this.propertyColorEncoder.argbsCpk[ColorEncoder.colorIndex((int)f, n2)];
            }
            case 3: {
                return ColorEncoder.getRasmolScale()[ColorEncoder.colorIndex((int)f, n2)];
            }
            case 4: {
                return this.propertyColorEncoder.argbsShapely[ColorEncoder.colorIndex((int)f, n2)];
            }
            case 5: {
                return this.propertyColorEncoder.argbsAmino[ColorEncoder.colorIndex((int)f, n2)];
            }
        }
        return -8355712;
    }

    private void setThisScheme(String string, int[] nArray) {
        this.thisName = string;
        this.thisScale = nArray;
        if (string.equals("user")) {
            this.userScale = nArray;
        }
        this.isColorIndex = string.indexOf(BYELEMENT_PREFIX) == 0 || string.indexOf(BYRESIDUE_PREFIX) == 0;
    }

    public int getArgb(float f) {
        return this.isReversed ? this.getArgbFromPalette(-f, -this.hi, -this.lo, this.currentPalette) : this.getArgbFromPalette(f, this.lo, this.hi, this.currentPalette);
    }

    public short getColorIndex(float f) {
        return this.isReversed ? this.getColorIndexFromPalette(-f, -this.hi, -this.lo, this.currentPalette, this.isTranslucent) : this.getColorIndexFromPalette(f, this.lo, this.hi, this.currentPalette, this.isTranslucent);
    }

    public Map<String, Object> getColorKey() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = this.getPaletteColorCount(this.currentPalette);
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>(n);
        float[] fArray = new float[n + 1];
        float f = (this.hi - this.lo) / (float)n;
        float f2 = f * (this.isReversed ? -0.5f : 0.5f);
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.isReversed ? this.hi - (float)i * f : this.lo + (float)i * f;
            arrayList.add(Graphics3D.colorPointFromInt2(this.getArgb(fArray[i] + f2)));
        }
        fArray[n] = this.isReversed ? this.lo : this.hi;
        hashtable.put("values", fArray);
        hashtable.put("colors", arrayList);
        hashtable.put("min", Float.valueOf(this.lo));
        hashtable.put("max", Float.valueOf(this.hi));
        hashtable.put("reversed", this.isReversed);
        hashtable.put("name", this.getColorSchemeName());
        return hashtable;
    }

    public void setColorScheme(String string, boolean bl) {
        this.isTranslucent = bl;
        if (string != null) {
            this.currentPalette = this.getColorScheme(string, true, false);
        }
    }

    public void setRange(float f, float f2, boolean bl) {
        if (f2 == Float.MAX_VALUE) {
            f = 1.0f;
            f2 = this.getPaletteColorCount(this.currentPalette) + 1;
        }
        this.lo = Math.min(f, f2);
        this.hi = Math.max(f, f2);
        this.isReversed = bl;
    }

    public String getColorSchemeName() {
        return this.getColorSchemeName(this.currentPalette);
    }

    public String getColorSchemeName(int n) {
        int n2 = Math.abs(n);
        return n == -1 ? this.thisName : (n2 < colorSchemes.length && n2 >= 0 ? colorSchemes[n2] : null);
    }

    public static final String getColorSchemeList(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + Escape.escapeColor(nArray[i]);
        }
        return string;
    }

    public static final synchronized int[] getRasmolScale() {
        if (rasmolScale != null) {
            return rasmolScale;
        }
        rasmolScale = new int[EnumPalette.argbsCpk.length];
        int n = EnumPalette.argbsCpkRasmol[0] | 0xFF000000;
        int n2 = rasmolScale.length;
        while (--n2 >= 0) {
            ColorEncoder.rasmolScale[n2] = n;
        }
        n2 = EnumPalette.argbsCpkRasmol.length;
        while (--n2 >= 0) {
            n = EnumPalette.argbsCpkRasmol[n2];
            ColorEncoder.rasmolScale[n >> 24] = n | 0xFF000000;
        }
        return rasmolScale;
    }

    private int[] getPaletteWB() {
        if (this.propertyColorEncoder.paletteWB != null) {
            return this.propertyColorEncoder.paletteWB;
        }
        int[] nArray = new int[JmolConstants.argbsRoygbScale.length];
        for (int i = 0; i < nArray.length; ++i) {
            float f = 1.0f / (float)nArray.length * (float)(nArray.length - i);
            nArray[i] = Graphics3D.colorTriadToInt(f, f, f);
        }
        this.propertyColorEncoder.paletteWB = nArray;
        return nArray;
    }

    public static int[] getPaletteAtoB(int n, int n2, int n3) {
        if (n3 < 2) {
            n3 = JmolConstants.argbsRoygbScale.length;
        }
        int[] nArray = new int[n3];
        float f = (float)((n & 0xFF0000) >> 16 & 0xFF) / 255.0f;
        float f2 = (float)((n & 0xFF00) >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        float f4 = (float)((n2 & 0xFF0000) >> 16 & 0xFF) / 255.0f;
        float f5 = (float)((n2 & 0xFF00) >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(n2 & 0xFF) / 255.0f;
        float f7 = (f4 - f) / (float)(n3 - 1);
        float f8 = (f5 - f2) / (float)(n3 - 1);
        float f9 = (f6 - f3) / (float)(n3 - 1);
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Graphics3D.colorTriadToInt(f + f7 * (float)i, f2 + f8 * (float)i, f3 + f9 * (float)i);
        }
        return nArray;
    }

    private int[] getPaletteBW() {
        if (this.propertyColorEncoder.paletteBW != null) {
            return this.propertyColorEncoder.paletteBW;
        }
        int[] nArray = new int[JmolConstants.argbsRoygbScale.length];
        for (int i = 0; i < nArray.length; ++i) {
            float f = 1.0f / (float)nArray.length * (float)i;
            nArray[i] = Graphics3D.colorTriadToInt(f, f, f);
        }
        this.propertyColorEncoder.paletteBW = nArray;
        return nArray;
    }

    public float quantize(float f, boolean bl) {
        int n = this.getPaletteColorCount(this.currentPalette);
        return (f = ((float)((int)(f * (float)n)) + (bl ? 0.0f : 1.0f)) / (float)n) <= 0.0f ? this.lo : (f >= 1.0f ? this.hi : this.lo + (this.hi - this.lo) * f);
    }

    public static final int quantize(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        if (f4 <= 0.0f || Float.isNaN(f)) {
            return n / 2;
        }
        float f5 = f - f2;
        if (f5 <= 0.0f) {
            return 0;
        }
        float f6 = f4 / (float)n;
        int n2 = (int)(f5 / f6 + 1.0E-4f);
        if (n2 >= n) {
            n2 = n - 1;
        }
        return n2;
    }

    private static final int colorIndex(int n, int n2) {
        return n <= 0 | n >= n2 ? 0 : n;
    }

    public int getState(StringBuffer stringBuffer) {
        int n = 0;
        for (Map.Entry<String, int[]> entry : this.schemes.entrySet()) {
            String string = entry.getKey();
            if (!(string.length() > 0 & n++ >= 0)) continue;
            stringBuffer.append("color \"" + string + "=" + ColorEncoder.getColorSchemeList(entry.getValue()) + "\";\n");
        }
        return n;
    }

    public String getColorScheme() {
        return (this.isTranslucent ? "translucent " : "") + (this.currentPalette < 0 ? ColorEncoder.getColorSchemeList(this.getColorSchemeArray(this.currentPalette)) : this.getColorSchemeName(this.currentPalette));
    }

    public static void RGBtoHSL(float f, float f2, float f3, float[] fArray) {
        f /= 255.0f;
        f2 /= 255.0f;
        f3 /= 255.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        float f4 = Math.min(f, Math.min(f2, f3));
        float f5 = Math.max(f, Math.max(f2, f3));
        float f6 = 0.0f;
        if (f5 == f4) {
            f6 = 0.0f;
        } else if (f5 == f) {
            f6 = (60.0f * (f2 - f3) / (f5 - f4) + 360.0f) % 360.0f;
        } else if (f5 == f2) {
            f6 = 60.0f * (f3 - f) / (f5 - f4) + 120.0f;
        } else if (f5 == f3) {
            f6 = 60.0f * (f - f2) / (f5 - f4) + 240.0f;
        }
        float f7 = (f5 + f4) / 2.0f;
        float f8 = 0.0f;
        f8 = f5 == f4 ? 0.0f : (f7 <= 0.5f ? (f5 - f4) / (f5 + f4) : (f5 - f4) / (2.0f - f5 - f4));
        fArray[0] = f6 / 360.0f;
        fArray[1] = f8;
        fArray[2] = f7;
    }
}

