/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.script.Token;
import org.jmol.shape.Mesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.Parser;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsosurfaceMesh
extends Mesh {
    JvxlData jvxlData = new JvxlData();
    int vertexIncrement = 1;
    int firstRealVertex = -1;
    int dataType;
    boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    Object info;
    private Map<Integer, Integer> assocGridPointMap;
    private Map<Integer, Vector3f> assocGridPointNormals;
    int thisSet = -1;
    private int mergeAssociatedNormalCount;
    Point3f[] centers;
    float[] contourValues;
    short[] contourColixes;
    ColorEncoder colorEncoder;
    float volumeRenderPointSize = 0.15f;
    BitSet bsVdw;

    IsosurfaceMesh(String string, Graphics3D graphics3D, short s, int n) {
        super(string, graphics3D, s, n);
        this.checkByteCount = 2;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clear(String string, boolean bl) {
        super.clear(string);
        this.jvxlData.clear();
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.bsVdw = null;
        this.mergeAssociatedNormalCount = 0;
        this.centers = null;
        this.colorEncoder = null;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.isColorSolid = true;
        this.nSets = 0;
        this.polygonColixes = null;
        this.showPoints = bl;
        this.surfaceSet = null;
        this.thisSet = -1;
        this.vertexColixes = null;
        this.vertexColorMap = null;
        this.vertexIncrement = 1;
        this.vertexSets = null;
        this.vertexValues = null;
        this.volumeRenderPointSize = 0.15f;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(Point3f point3f, float f, int n, boolean bl) {
        int n2 = this.addVertexCopy(point3f, f);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable<Integer, Integer>();
                }
                this.assocGridPointMap.put(n2, n + this.mergeAssociatedNormalCount);
            }
        }
        return n2;
    }

    @Override
    public void setTranslucent(boolean bl, float f) {
        super.setTranslucent(bl, f);
        if (this.vertexColixes != null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = Graphics3D.getColixTranslucent(this.vertexColixes[n], bl, f);
            }
        }
    }

    public void setMerged(boolean bl) {
        this.isMerged = bl;
        this.mergePolygonCount0 = bl ? this.polygonCount : 0;
        int n = this.mergeVertexCount0 = bl ? this.vertexCount : 0;
        if (bl) {
            this.mergeAssociatedNormalCount += this.jvxlData.nPointsX * this.jvxlData.nPointsY * this.jvxlData.nPointsZ;
            this.assocGridPointNormals = null;
        }
    }

    @Override
    protected void sumVertexNormals(Point3f[] point3fArray, Vector3f[] vector3fArray) {
        super.sumVertexNormals(point3fArray, vector3fArray);
        if (this.assocGridPointMap != null && vector3fArray.length > 0 && !this.isMerged) {
            if (this.assocGridPointNormals == null) {
                this.assocGridPointNormals = new Hashtable<Integer, Vector3f>();
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                Integer n = entry.getValue();
                if (!this.assocGridPointNormals.containsKey(n)) {
                    this.assocGridPointNormals.put(n, new Vector3f(0.0f, 0.0f, 0.0f));
                }
                this.assocGridPointNormals.get(n).add(vector3fArray[entry.getKey()]);
            }
            for (Map.Entry<Integer, Integer> entry : this.assocGridPointMap.entrySet()) {
                vector3fArray[entry.getKey().intValue()] = this.assocGridPointNormals.get(entry.getValue());
            }
        }
    }

    Point3f[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new Point3f[this.polygonCount];
        for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            Point3f point3f = this.centers[i] = new Point3f();
            point3f.add(this.vertices[nArray[0]]);
            point3f.add(this.vertices[nArray[1]]);
            point3f.add(this.vertices[nArray[2]]);
            point3f.scale(0.33333334f);
        }
        return this.centers;
    }

    Point4f getFacePlane(int n, Vector3f vector3f) {
        Point4f point4f = new Point4f();
        Measure.getPlaneThroughPoints(this.vertices[this.polygonIndexes[n][0]], this.vertices[this.polygonIndexes[n][1]], this.vertices[this.polygonIndexes[n][2]], vector3f, this.vAB, this.vAC, point4f);
        return point4f;
    }

    List<Object>[] getContours() {
        int n;
        List<Object>[] listArray;
        int n2 = this.jvxlData.nContours;
        if (n2 == 0 || this.polygonIndexes == null) {
            return null;
        }
        boolean bl = this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n2 < 0) {
            n2 = -1 - n2;
        }
        if ((listArray = this.jvxlData.vContours) != null) {
            for (int i = 0; i < n2; ++i) {
                if (listArray[i].size() > 6) {
                    return this.jvxlData.vContours;
                }
                JvxlCoder.set3dContourVector(listArray[i], this.polygonIndexes, this.vertices);
            }
            return this.jvxlData.vContours;
        }
        listArray = new List[n2];
        for (n = 0; n < n2; ++n) {
            listArray[n] = new ArrayList<Object>();
        }
        if (this.jvxlData.contourValuesUsed == null) {
            float f = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n2 + 1);
            for (int i = 0; i < n2; ++i) {
                float f2 = this.jvxlData.valueMappedToRed + (float)(i + 1) * f;
                this.get3dContour(listArray[i], f2, this.jvxlData.contourColixes[i]);
            }
            Logger.info(n2 + " contour lines; separation = " + f);
        } else {
            for (n = 0; n < n2; ++n) {
                float f = this.jvxlData.contourValuesUsed[n];
                this.get3dContour(listArray[n], f, this.jvxlData.contourColixes[n]);
            }
        }
        this.jvxlData.contourColixes = new short[n2];
        this.jvxlData.contourValues = new float[n2];
        for (int i = 0; i < n2; ++i) {
            this.jvxlData.contourValues[i] = ((Float)listArray[i].get(2)).floatValue();
            this.jvxlData.contourColixes[i] = ((short[])listArray[i].get(3))[0];
        }
        this.jvxlData.vContours = listArray;
        return listArray;
    }

    private void get3dContour(List<Object> list, float f, short s) {
        BitSet bitSet = new BitSet(this.polygonCount);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Graphics3D.getArgb(s);
        IsosurfaceMesh.setContourVector(list, this.polygonCount, bitSet, f, s, n, stringBuffer);
        for (int i = 0; i < this.polygonCount; ++i) {
            if (!this.setABC(i)) continue;
            IsosurfaceMesh.addContourPoints(list, bitSet, i, stringBuffer, this.vertices, this.vertexValues, this.iA, this.iB, this.iC, f);
        }
    }

    public static void setContourVector(List<Object> list, int n, BitSet bitSet, float f, short s, int n2, StringBuffer stringBuffer) {
        list.add(0, n);
        list.add(1, bitSet);
        list.add(2, new Float(f));
        list.add(3, new short[]{s});
        list.add(4, new int[]{n2});
        list.add(5, stringBuffer);
    }

    public static void addContourPoints(List<Object> list, BitSet bitSet, int n, StringBuffer stringBuffer, Point3f[] point3fArray, float[] fArray, int n2, int n3, int n4, float f) {
        float f2;
        Point3f point3f = null;
        Point3f point3f2 = null;
        int n5 = 0;
        float f3 = IsosurfaceMesh.checkPt(fArray, n2, n3, f);
        if (!Float.isNaN(f3)) {
            point3f = IsosurfaceMesh.getContourPoint(point3fArray, n2, n3, f3);
            n5 |= 1;
        }
        float f4 = f2 = f3 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n3, n4, f);
        if (!Float.isNaN(f2)) {
            point3f2 = IsosurfaceMesh.getContourPoint(point3fArray, n3, n4, f2);
            if (n5 == 0) {
                point3f = point3f2;
                f3 = f2;
            }
            n5 |= 2;
        }
        switch (n5) {
            case 0: {
                return;
            }
            case 1: {
                if (f3 == 0.0f) {
                    return;
                }
            }
            case 2: {
                float f5 = f2 = f2 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n4, n2, f);
                if (Float.isNaN(f2)) break;
                point3f2 = IsosurfaceMesh.getContourPoint(point3fArray, n4, n2, f2);
                n5 |= 4;
            }
        }
        switch (n5) {
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        bitSet.set(n);
        JvxlCoder.appendContourTriangleIntersection(n5, f3, f2, stringBuffer);
        list.add(point3f);
        list.add(point3f2);
    }

    private static float checkPt(float[] fArray, int n, int n2, float f) {
        float f2;
        float f3 = fArray[n];
        return f == f3 ? 0.0f : (f == (f2 = fArray[n2]) ? 1.0f : (f3 < f == f < f2 ? (f - f3) / (f2 - f3) : Float.NaN));
    }

    private static Point3f getContourPoint(Point3f[] point3fArray, int n, int n2, float f) {
        Point3f point3f = new Point3f();
        point3f.set(point3fArray[n2]);
        point3f.sub(point3fArray[n]);
        point3f.scale(f);
        point3f.add(point3fArray[n]);
        return point3f;
    }

    public void setDiscreteColixes(float[] fArray, short[] sArray) {
        if (fArray != null) {
            this.jvxlData.contourValues = fArray;
        }
        if (fArray == null || fArray.length == 0) {
            this.jvxlData.contourValues = this.jvxlData.contourValuesUsed;
            fArray = this.jvxlData.contourValuesUsed;
        }
        if (sArray == null && this.jvxlData.contourColixes != null) {
            sArray = this.jvxlData.contourColixes;
        } else {
            this.jvxlData.contourColixes = sArray;
            this.jvxlData.contourColors = Graphics3D.getHexCodes(sArray);
        }
        if (this.vertices == null || this.vertexValues == null || fArray == null) {
            return;
        }
        int n = fArray.length;
        float f = fArray[n - 1];
        this.colorCommand = null;
        boolean bl = sArray != null && sArray.length > 0;
        boolean bl2 = this.isColorSolid = bl && this.jvxlData.jvxlPlane != null;
        if (this.jvxlData.vContours != null) {
            if (bl) {
                for (int i = 0; i < this.jvxlData.vContours.length; ++i) {
                    short s;
                    ((short[])this.jvxlData.vContours[i].get((int)3))[0] = s = sArray[i % sArray.length];
                    ((int[])this.jvxlData.vContours[i].get((int)4))[0] = Graphics3D.getArgb(s);
                }
            }
            return;
        }
        short s = 0;
        this.polygonColixes = new short[this.polygonCount];
        block1: for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            this.polygonColixes[i] = s;
            float f2 = (this.vertexValues[nArray[0]] + this.vertexValues[nArray[1]] + this.vertexValues[nArray[2]]) / 3.0f;
            int n2 = n;
            while (--n2 >= 0) {
                if (!(f2 >= fArray[n2]) || !(f2 < f)) continue;
                this.polygonColixes[i] = bl ? sArray[n2 % sArray.length] : (short)0;
                continue block1;
            }
        }
    }

    Map<String, Object> getContourList(Viewer viewer) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("values", this.jvxlData.contourValuesUsed == null ? this.jvxlData.contourValues : this.jvxlData.contourValuesUsed);
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        if (this.jvxlData.contourColixes != null) {
            for (int i = 0; i < this.jvxlData.contourColixes.length; ++i) {
                arrayList.add(Graphics3D.colorPointFromInt2(Graphics3D.getArgb(this.jvxlData.contourColixes[i])));
            }
            hashtable.put("colors", arrayList);
        }
        return hashtable;
    }

    void deleteContours() {
        this.jvxlData.contourValuesUsed = null;
        this.jvxlData.contourValues = null;
        this.jvxlData.contourColixes = null;
        this.jvxlData.vContours = null;
    }

    void colorAtoms(short s, BitSet bitSet) {
        this.colorVertices(s, bitSet, true);
    }

    void colorVertices(short s, BitSet bitSet) {
        this.colorVertices(s, bitSet, false);
    }

    private void colorVertices(short s, BitSet bitSet, boolean bl) {
        int n;
        BitSet bitSet2;
        if (this.vertexSource == null) {
            return;
        }
        s = Graphics3D.copyColixTranslucency(this.colix, s);
        BitSet bitSet3 = bitSet2 = bl ? new BitSet() : bitSet;
        if (this.vertexColixes == null || this.vertexColorMap == null && this.isColorSolid) {
            this.vertexColixes = new short[this.vertexCount];
            for (n = 0; n < this.vertexCount; ++n) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
        if (bl) {
            for (n = 0; n < this.vertexCount; ++n) {
                if (!bitSet.get(this.vertexSource[n])) continue;
                this.vertexColixes[n] = s;
                bitSet2.set(n);
            }
        } else {
            for (n = 0; n < this.vertexCount; ++n) {
                if (!bitSet2.get(n)) continue;
                this.vertexColixes[n] = s;
            }
        }
        if (!bl) {
            return;
        }
        String string = Graphics3D.getHexCode(s);
        if (this.vertexColorMap == null) {
            this.vertexColorMap = new Hashtable();
        }
        IsosurfaceMesh.addColorToMap(this.vertexColorMap, string, bitSet);
    }

    private static void addColorToMap(Map<String, BitSet> map, String string, BitSet bitSet) {
        BitSet bitSet2 = null;
        for (Map.Entry<String, BitSet> entry : map.entrySet()) {
            if (entry.getKey() == string) {
                bitSet2 = entry.getValue();
                bitSet2.or(bitSet);
                continue;
            }
            entry.getValue().andNot(bitSet);
        }
        if (bitSet2 == null) {
            map.put(string, bitSet);
        }
    }

    void setJvxlColorMap(boolean bl) {
        this.jvxlData.diameter = this.diameter;
        this.jvxlData.color = Graphics3D.getHexCode(this.colix);
        this.jvxlData.meshColor = this.meshColix == 0 ? null : Graphics3D.getHexCode(this.meshColix);
        this.jvxlData.translucency = Graphics3D.getColixTranslucencyFractional(this.colix);
        this.jvxlData.rendering = this.getRendering().substring(1);
        this.jvxlData.colorScheme = this.colorEncoder == null ? null : this.colorEncoder.getColorScheme();
        int n = this.jvxlData.nVertexColors = this.vertexColorMap == null ? 0 : this.vertexColorMap.size();
        if (this.vertexColorMap == null || this.vertexSource == null || !bl) {
            return;
        }
        if (this.jvxlData.vertexColorMap == null) {
            this.jvxlData.vertexColorMap = new Hashtable<String, BitSet>();
        }
        for (Map.Entry entry : this.vertexColorMap.entrySet()) {
            BitSet bitSet = (BitSet)entry.getValue();
            if (bitSet.isEmpty()) continue;
            String string = (String)entry.getKey();
            BitSet bitSet2 = new BitSet();
            for (int i = 0; i < this.vertexCount; ++i) {
                if (!bitSet.get(this.vertexSource[i])) continue;
                bitSet2.set(i);
            }
            IsosurfaceMesh.addColorToMap(this.jvxlData.vertexColorMap, string, bitSet2);
        }
        this.jvxlData.nVertexColors = this.jvxlData.vertexColorMap.size();
        if (this.jvxlData.vertexColorMap.size() == 0) {
            this.jvxlData.vertexColorMap = null;
        }
    }

    void setColorCommand() {
        if (this.colorEncoder == null) {
            return;
        }
        this.colorCommand = this.colorEncoder.getColorScheme();
        if (this.colorCommand == null) {
            return;
        }
        this.colorCommand = "color $" + (Character.isLetter(this.thisID.charAt(0)) && this.thisID.indexOf(" ") < 0 ? this.thisID : "\"" + this.thisID + "\"") + " \"" + this.colorCommand + "\" range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    /*
     * WARNING - void declaration
     */
    void setColorsFromJvxlData(int n) {
        Object object;
        this.diameter = this.jvxlData.diameter;
        if (n != -1) {
            if (n != Integer.MIN_VALUE) {
                this.colix = Graphics3D.getColix(n);
            } else if (this.jvxlData.color != null) {
                this.colix = Graphics3D.getColix(this.jvxlData.color);
            }
        }
        if (this.colix == 0) {
            this.colix = (short)5;
        }
        this.colix = Graphics3D.getColixTranslucent(this.colix, this.jvxlData.translucency != 0.0f, this.jvxlData.translucency);
        if (this.jvxlData.meshColor != null) {
            this.meshColix = Graphics3D.getColix(this.jvxlData.meshColor);
        }
        if (this.jvxlData.rendering != null) {
            void entry;
            object = Parser.getTokens(this.jvxlData.rendering);
            boolean bl = false;
            while (entry < ((String[])object).length) {
                this.setTokenProperty(Token.getTokFromName(object[entry]), true);
                ++entry;
            }
        }
        boolean bl = this.isColorSolid = !this.jvxlData.isBicolorMap;
        if (this.colorEncoder != null) {
            if (this.jvxlData.colorScheme != null) {
                object = this.jvxlData.colorScheme;
                boolean bl2 = ((String)object).startsWith("translucent ");
                if (bl2) {
                    object = ((String)object).substring(12);
                }
                this.colorEncoder.setColorScheme((String)object, bl2);
                this.remapColors(null, Float.NaN);
            }
            if (this.jvxlData.vertexColorMap != null) {
                for (Map.Entry entry : this.jvxlData.vertexColorMap.entrySet()) {
                    BitSet bitSet = (BitSet)entry.getValue();
                    short s = Graphics3D.copyColixTranslucency(this.colix, Graphics3D.getColix((String)entry.getKey()));
                    int n2 = bitSet.nextSetBit(0);
                    while (n2 >= 0) {
                        this.vertexColixes[n2] = s;
                        n2 = bitSet.nextSetBit(n2 + 1);
                    }
                }
            }
        }
    }

    void remapColors(ColorEncoder colorEncoder, float f) {
        int n;
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder;
        }
        if (colorEncoder == null) {
            colorEncoder = this.colorEncoder = new ColorEncoder(null);
        }
        if (Float.isNaN(f)) {
            f = Graphics3D.getColixTranslucencyLevel(this.colix);
        } else {
            this.colix = Graphics3D.getColixTranslucent(this.colix, true, f);
        }
        float f2 = colorEncoder.lo;
        float f3 = colorEncoder.hi;
        this.vertexColorMap = null;
        this.polygonColixes = null;
        this.jvxlData.vertexCount = this.vertexCount;
        if (this.vertexValues == null || this.jvxlData.vertexCount == 0) {
            return;
        }
        if (this.vertexColixes == null || this.vertexColixes.length != this.vertexCount) {
            this.vertexColixes = new short[this.vertexCount];
        }
        if (this.jvxlData.isBicolorMap) {
            for (int i = this.mergeVertexCount0; i < this.vertexCount; ++i) {
                this.vertexColixes[i] = Graphics3D.copyColixTranslucency(this.colix, this.vertexValues[i] < 0.0f ? this.jvxlData.minColorIndex : this.jvxlData.maxColorIndex);
            }
            return;
        }
        this.jvxlData.isColorReversed = colorEncoder.isReversed;
        if (f3 != Float.MAX_VALUE) {
            this.jvxlData.valueMappedToRed = f2;
            this.jvxlData.valueMappedToBlue = f3;
        }
        colorEncoder.setRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue, this.jvxlData.isColorReversed);
        boolean bl = Graphics3D.isColixTranslucent(this.colix);
        if (colorEncoder.isTranslucent) {
            if (!bl) {
                this.colix = Graphics3D.getColixTranslucent(this.colix, true, 0.5f);
            }
            bl = false;
        }
        int n2 = this.vertexCount;
        while (--n2 >= this.mergeVertexCount0) {
            this.vertexColixes[n2] = colorEncoder.getColorIndex(this.vertexValues[n2]);
        }
        this.setTranslucent(bl, f);
        this.colorEncoder = colorEncoder;
        List<Object>[] listArray = this.getContours();
        if (listArray != null) {
            n = listArray.length;
            while (--n >= 0) {
                float f4 = ((Float)listArray[n].get(2)).floatValue();
                short[] sArray = (short[])listArray[n].get(3);
                sArray[0] = colorEncoder.getColorIndex(f4);
                int[] nArray = (int[])listArray[n].get(4);
                nArray[0] = Graphics3D.getArgb(sArray[0]);
            }
        }
        if (this.contourValues != null) {
            this.contourColixes = new short[this.contourValues.length];
            for (n = 0; n < this.contourValues.length; ++n) {
                this.contourColixes[n] = colorEncoder.getColorIndex(this.contourValues[n]);
            }
            this.setDiscreteColixes(null, null);
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        JvxlCoder.jvxlCreateColorData(this.jvxlData, this.vertexValues);
        this.setColorCommand();
        this.isColorSolid = false;
    }

    public void reinitializeLightingAndColor() {
        this.initialize(this.lighting, null, null);
        if (this.colorEncoder != null || this.jvxlData.isBicolorMap) {
            this.vertexColixes = null;
            this.remapColors(null, Float.NaN);
        }
    }

    @Override
    public Point3f[] getBoundingBox() {
        return this.jvxlData.boundingBox;
    }

    protected void merge(MeshData meshData) {
        int n = this.vertexCount + (meshData == null ? 0 : meshData.vertexCount);
        if (this.polygonIndexes == null) {
            this.polygonIndexes = new int[0][];
        }
        if (meshData != null && meshData.polygonIndexes == null) {
            meshData.polygonIndexes = new int[0][];
        }
        int n2 = (this.bsSlabDisplay == null || this.polygonCount == 0 ? this.polygonCount : this.bsSlabDisplay.cardinality()) + (meshData == null || meshData.polygonCount == 0 ? 0 : (meshData.bsSlabDisplay == null ? meshData.polygonCount : meshData.bsSlabDisplay.cardinality()));
        if (this.vertices == null) {
            this.vertices = new Point3f[0];
        }
        this.vertices = (Point3f[])ArrayUtil.ensureLength(this.vertices, n);
        this.vertexValues = ArrayUtil.ensureLength(this.vertexValues, n);
        boolean bl = this.vertexSource != null && (meshData == null || meshData.vertexSource != null);
        this.vertexSource = ArrayUtil.ensureLength(this.vertexSource, n);
        int[][] nArrayArray = new int[n2][];
        int n3 = IsosurfaceMesh.mergePolygons(this, 0, 0, nArrayArray);
        if (meshData != null) {
            n3 = IsosurfaceMesh.mergePolygons(meshData, n3, this.vertexCount, nArrayArray);
            int n4 = 0;
            while (n4 < meshData.vertexCount) {
                this.vertices[this.vertexCount] = meshData.vertices[n4];
                this.vertexValues[this.vertexCount] = meshData.vertexValues[n4];
                if (bl) {
                    this.vertexSource[this.vertexCount] = meshData.vertexSource[n4];
                }
                ++n4;
                ++this.vertexCount;
            }
        }
        this.polygonCount = this.polygonCount0 = n2;
        this.vertexCount = this.vertexCount0 = n;
        if (n2 > 0) {
            this.resetSlab();
        }
        this.polygonIndexes = nArrayArray;
    }

    private static int mergePolygons(MeshSurface meshSurface, int n, int n2, int[][] nArray) {
        for (int i = 0; i < meshSurface.polygonCount; ++i) {
            int[] nArray2 = meshSurface.polygonIndexes[i];
            if (nArray2 == null || meshSurface.bsSlabDisplay != null && !meshSurface.bsSlabDisplay.get(i)) continue;
            nArray[n++] = meshSurface.polygonIndexes[i];
            if (n2 <= 0) continue;
            int n3 = 0;
            while (n3 < 3) {
                int n4 = n3++;
                nArray2[n4] = nArray2[n4] + n2;
            }
        }
        System.out.println("isosurfaceMesh mergePolygons " + meshSurface.polygonCount + " " + meshSurface.polygonIndexes.length);
        return n;
    }
}

