/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeRenderer;

public class RocketsRenderer
extends BioShapeRenderer {
    private static final float MIN_CONE_HEIGHT = 0.05f;
    protected boolean renderArrowHeads;
    protected Point3f[] cordMidPoints;
    protected boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private Point3f screenA = new Point3f();
    private Point3f screenB = new Point3f();
    private Point3f screenC = new Point3f();
    private static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    private final Point3f[] corners = new Point3f[8];
    private final Point3f[] screenCorners = new Point3f[8];
    private final Point3f pointTipOffset;
    private final Vector3f scaledWidthVector;
    private final Vector3f scaledHeightVector;
    private static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    private final Vector3f lengthVector;
    private final Point3f pointCorner;

    public RocketsRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.screenCorners[n] = new Point3f();
            this.corners[n] = new Point3f();
        }
        this.pointTipOffset = new Point3f();
        this.scaledWidthVector = new Vector3f();
        this.scaledHeightVector = new Vector3f();
        this.lengthVector = new Vector3f();
        this.pointCorner = new Point3f();
    }

    protected void renderBioShape(BioShape bioShape) {
        boolean bl;
        if (!(bioShape.bioPolymer instanceof AminoPolymer)) {
            return;
        }
        boolean bl2 = bl = !this.viewer.getRocketBarrelFlag();
        if (this.renderArrowHeads != bl) {
            bioShape.falsifyMesh();
            this.renderArrowHeads = bl;
        }
        this.calcRopeMidPoints(false);
        this.calcScreenControlPoints(this.cordMidPoints);
        this.controlPoints = this.cordMidPoints;
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
    }

    protected boolean isSheet(int n) {
        return this.structureTypes[n] == EnumStructure.SHEET;
    }

    protected void calcRopeMidPoints(boolean bl) {
        Point3f point3f;
        int n = this.monomerCount + 1;
        this.cordMidPoints = this.viewer.allocTempPoints(n);
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            point3f = this.cordMidPoints[i];
            Monomer monomer = this.monomers[i];
            if (bl && this.renderArrowHeads) {
                point3f.set(this.controlPoints[i]);
                continue;
            }
            if (this.isHelix(i) || !bl && this.isSheet(i)) {
                ProteinStructure proteinStructure2 = monomer.getProteinStructure();
                point3f.set(i - 1 != proteinStructure2.getMonomerIndex() ? proteinStructure2.getAxisStartPoint() : proteinStructure2.getAxisEndPoint());
                proteinStructure = proteinStructure2;
                continue;
            }
            if (proteinStructure != null) {
                point3f.set(proteinStructure.getAxisEndPoint());
            } else {
                point3f.set(this.controlPoints[i]);
            }
            proteinStructure = null;
        }
        point3f = this.cordMidPoints[this.monomerCount];
        if (proteinStructure != null) {
            point3f.set(proteinStructure.getAxisEndPoint());
        } else {
            point3f.set(this.controlPoints[this.monomerCount]);
        }
    }

    protected void render1() {
        this.tPending = false;
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            Monomer monomer = this.monomers[n];
            if (this.isHelix(n) || this.isSheet(n)) {
                this.renderSpecialSegment(monomer, this.getLeadColix(n), this.mads[n]);
            } else {
                this.renderPending();
                this.renderHermiteConic(n, true);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    protected void renderSpecialSegment(Monomer monomer, short s, short s2) {
        ProteinStructure proteinStructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinStructure == this.proteinstructurePending && s2 == this.mad && s == this.colix && proteinStructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinStructure;
        this.startIndexPending = this.endIndexPending = proteinStructure.getIndex(monomer);
        this.colix = s;
        this.mad = s2;
        this.tPending = true;
    }

    protected void renderPending() {
        boolean bl;
        if (!this.tPending) {
            return;
        }
        Point3f[] point3fArray = this.proteinstructurePending.getSegments();
        boolean bl2 = bl = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, point3fArray[this.startIndexPending], point3fArray[this.endIndexPending], point3fArray[this.endIndexPending + 1], bl);
        } else if (this.proteinstructurePending instanceof Sheet) {
            this.renderPendingSheet(point3fArray[this.startIndexPending], point3fArray[this.endIndexPending], point3fArray[this.endIndexPending + 1], bl);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int n, Point3f point3f, Point3f point3f2, Point3f point3f3, boolean bl) {
        this.viewer.transformPoint(point3f, this.screenA);
        this.viewer.transformPoint(point3f3, this.screenB);
        int n2 = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
        short s = this.viewer.scaleToScreen(n2, this.mad);
        if (bl && this.renderArrowHeads) {
            this.viewer.transformPoint(point3f2, this.screenC);
            if (this.g3d.setColix(this.colix)) {
                if (point3f2.distance(point3f3) <= 0.05f) {
                    this.g3d.fillCylinderBits((byte)2, s, this.screenB, this.screenC);
                } else {
                    this.renderCone(n, point3f2, point3f3, this.screenC, this.screenB);
                }
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            Point3f point3f4 = this.screenB;
            this.screenB = this.screenC;
            this.screenC = point3f4;
        }
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinderBits((byte)2, s, this.screenA, this.screenB);
        }
    }

    private void renderPendingSheet(Point3f point3f, Point3f point3f2, Point3f point3f3, boolean bl) {
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (bl && this.renderArrowHeads) {
            this.drawArrowHeadBox(point3f2, point3f3);
            this.drawBox(point3f, point3f2);
        } else {
            this.drawBox(point3f, point3f3);
        }
    }

    void buildBox(Point3f point3f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        int n = 8;
        while (--n >= 0) {
            Point3f point3f2 = this.corners[n];
            point3f2.set(point3f);
            if ((n & 1) != 0) {
                point3f2.add(vector3f);
            }
            if ((n & 2) != 0) {
                point3f2.add(vector3f2);
            }
            if ((n & 4) != 0) {
                point3f2.add(vector3f3);
            }
            this.viewer.transformPoint(point3f2, this.screenCorners[n]);
        }
    }

    void buildArrowHeadBox(Point3f point3f, Vector3f vector3f, Vector3f vector3f2, Point3f point3f2) {
        int n = 4;
        while (--n >= 0) {
            Point3f point3f3 = this.corners[n];
            point3f3.set(point3f);
            if ((n & 1) != 0) {
                point3f3.add(vector3f);
            }
            if ((n & 2) != 0) {
                point3f3.add(vector3f2);
            }
            this.viewer.transformPoint(point3f3, this.screenCorners[n]);
        }
        this.corners[4].set(point3f2);
        this.viewer.transformPoint(point3f2, this.screenCorners[4]);
        this.corners[5].add(point3f2, vector3f2);
        this.viewer.transformPoint(this.corners[5], this.screenCorners[5]);
    }

    void drawBox(Point3f point3f, Point3f point3f2) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float f = (float)this.mad / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(f);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(f / 4.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, point3f);
        this.lengthVector.sub(point3f2, point3f);
        this.buildBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.lengthVector);
        for (int i = 0; i < 6; ++i) {
            byte by = boxFaces[i * 4];
            byte by2 = boxFaces[i * 4 + 1];
            byte by3 = boxFaces[i * 4 + 2];
            byte by4 = boxFaces[i * 4 + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[by], this.screenCorners[by2], this.screenCorners[by3], this.screenCorners[by4]);
        }
    }

    void drawArrowHeadBox(Point3f point3f, Point3f point3f2) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float f = (float)this.mad / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(f * 1.25f);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(f / 3.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, point3f);
        this.pointTipOffset.set(this.scaledHeightVector);
        this.pointTipOffset.scaleAdd(-0.5f, point3f2);
        this.buildArrowHeadBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.pointTipOffset);
        this.g3d.fillTriangle(this.screenCorners[0], this.screenCorners[1], this.screenCorners[4]);
        this.g3d.fillTriangle(this.screenCorners[2], this.screenCorners[3], this.screenCorners[5]);
        for (int i = 0; i < 12; i += 4) {
            byte by = arrowHeadFaces[i];
            byte by2 = arrowHeadFaces[i + 1];
            byte by3 = arrowHeadFaces[i + 2];
            byte by4 = arrowHeadFaces[i + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[by], this.screenCorners[by2], this.screenCorners[by3], this.screenCorners[by4]);
        }
    }
}

