/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import java.util.Map;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BioShape {
    int modelIndex;
    int modelVisibilityFlags = 0;
    BioShapeCollection shape;
    BioPolymer bioPolymer;
    Mesh[] meshes;
    boolean[] meshReady;
    short[] mads;
    short[] colixes;
    byte[] paletteIDs;
    BitSet bsColixSet;
    BitSet bsSizeSet;
    BitSet bsSizeDefault = new BitSet();
    boolean isActive;
    int monomerCount;
    Monomer[] monomers;
    Vector3f[] wingVectors;
    int[] leadAtomIndices;
    boolean hasBfactorRange = false;
    int bfactorMin;
    int bfactorMax;
    int range;
    float floatRange;
    public static final int ALPHA_CARBON_VISIBILITY_FLAG = NucleicMonomer.CARTOON_VISIBILITY_FLAG | Atom.BACKBONE_VISIBILITY_FLAG | JmolConstants.getShapeVisibilityFlag(10) | JmolConstants.getShapeVisibilityFlag(12) | JmolConstants.getShapeVisibilityFlag(13) | JmolConstants.getShapeVisibilityFlag(14);
    private static final double eightPiSquared100 = 7895.6835208714865;

    BioShape(BioShapeCollection bioShapeCollection, int n, BioPolymer bioPolymer) {
        this.shape = bioShapeCollection;
        this.modelIndex = n;
        this.bioPolymer = bioPolymer;
        this.isActive = bioShapeCollection.isActive;
        this.monomerCount = bioPolymer.monomerCount;
        if (this.monomerCount > 0) {
            this.colixes = new short[this.monomerCount];
            this.paletteIDs = new byte[this.monomerCount];
            this.mads = new short[this.monomerCount + 1];
            this.monomers = (Monomer[])bioPolymer.getGroups();
            this.meshReady = new boolean[this.monomerCount];
            this.meshes = new Mesh[this.monomerCount];
            this.wingVectors = bioPolymer.getWingVectors();
            this.leadAtomIndices = bioPolymer.getLeadAtomIndices();
        }
    }

    void calcBfactorRange() {
        this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
        int n = this.monomerCount;
        while (--n > 0) {
            int n2 = this.monomers[n].getLeadAtom().getBfactor100();
            if (n2 < this.bfactorMin) {
                this.bfactorMin = n2;
                continue;
            }
            if (n2 <= this.bfactorMax) continue;
            this.bfactorMax = n2;
        }
        this.range = this.bfactorMax - this.bfactorMin;
        this.floatRange = this.range;
        this.hasBfactorRange = true;
    }

    short calcMeanPositionalDisplacement(int n) {
        return (short)(Math.sqrt((double)n / 7895.6835208714865) * 1000.0);
    }

    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, BitSet bitSet) {
        this.bioPolymer.findNearestAtomIndex(n, n2, atomArray, this.mads, this.shape.myVisibilityFlag, bitSet);
    }

    void setMad(short s, BitSet bitSet, float[] fArray) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int n = this.shape.myVisibilityFlag;
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            int n3 = this.leadAtomIndices[n2];
            if (!bitSet.get(n3)) continue;
            if (fArray != null) {
                if (Float.isNaN(fArray[n3])) continue;
                s = (short)(fArray[n3] * 2000.0f);
            }
            boolean bl = (this.mads[n2] = this.setMad(n2, s)) > 0;
            this.bsSizeSet.set(n2, bl);
            this.monomers[n2].setShapeVisibility(n, bl);
            this.shape.atoms[n3].setShapeVisibility(n, bl);
            this.falsifyNearbyMesh(n2);
        }
        if (this.monomerCount > 1) {
            this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
        }
    }

    private short setMad(int n, short s) {
        this.bsSizeDefault.set(n, s == -1 || s == -2);
        if (s >= 0) {
            return s;
        }
        switch (s) {
            case -2: 
            case -1: {
                if (s == -1 && this.shape.madOn >= 0) {
                    return this.shape.madOn;
                }
                switch (this.monomers[n].getProteinStructureType()) {
                    case SHEET: 
                    case HELIX: {
                        return this.shape.madHelixSheet;
                    }
                    case DNA: 
                    case RNA: {
                        return this.shape.madDnaRna;
                    }
                }
                return this.shape.madTurnRandom;
            }
            case -3: {
                if (!this.hasBfactorRange) {
                    this.calcBfactorRange();
                }
                Atom atom = this.monomers[n].getLeadAtom();
                int n2 = atom.getBfactor100();
                int n3 = n2 - this.bfactorMin;
                if (this.range == 0) {
                    return 0;
                }
                float f = (float)n3 / this.floatRange;
                if (f < 0.0f || f > 1.0f) {
                    Logger.error("Que ha ocurrido? " + f);
                }
                return (short)(1750.0f * f + 250.0f);
            }
            case -4: {
                Atom atom = this.monomers[n].getLeadAtom();
                return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
            }
        }
        Logger.error("unrecognized setMad(" + s + ")");
        return 0;
    }

    void falsifyMesh() {
        if (this.meshReady == null) {
            return;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.meshReady[i] = false;
        }
    }

    private void falsifyNearbyMesh(int n) {
        if (this.meshReady == null) {
            return;
        }
        this.meshReady[n] = false;
        if (n > 0) {
            this.meshReady[n - 1] = false;
        }
        if (n < this.monomerCount - 1) {
            this.meshReady[n + 1] = false;
        }
    }

    void setColix(short s, byte by, BitSet bitSet) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            int n2 = this.leadAtomIndices[n];
            if (!bitSet.get(n2)) continue;
            this.colixes[n] = this.shape.setColix(s, by, n2);
            this.paletteIDs[n] = by;
            this.bsColixSet.set(n, this.colixes[n] != 0);
        }
    }

    void setTranslucent(boolean bl, BitSet bitSet, float f) {
        this.isActive = true;
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            if (!bitSet.get(this.leadAtomIndices[n])) continue;
            this.colixes[n] = Graphics3D.getColixTranslucent(this.colixes[n], bl, f);
            this.bsColixSet.set(n, this.colixes[n] != 0);
        }
    }

    void setShapeState(Map<String, BitSet> map, Map<String, BitSet> map2) {
        if (!this.isActive || this.bsSizeSet == null && this.bsColixSet == null) {
            return;
        }
        String string = JmolConstants.shapeClassBases[this.shape.shapeID];
        for (int i = 0; i < this.monomerCount; ++i) {
            int n = this.monomers[i].firstAtomIndex;
            int n2 = this.monomers[i].lastAtomIndex;
            if (this.bsSizeSet != null && (this.bsSizeSet.get(i) || this.bsColixSet != null && this.bsColixSet.get(i))) {
                if (this.bsSizeDefault.get(i)) {
                    Shape.setStateInfo(map, n, n2, string + (this.bsSizeSet.get(i) ? " on" : " off"));
                } else {
                    Shape.setStateInfo(map, n, n2, string + " " + (float)this.mads[i] / 2000.0f);
                }
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            Shape.setStateInfo(map2, n, n2, this.shape.getColorCommand(string, this.paletteIDs[i], this.colixes[i]));
        }
    }

    void setModelClickability() {
        if (!this.isActive || this.wingVectors == null) {
            return;
        }
        boolean bl = this.bioPolymer instanceof NucleicPolymer;
        int n = this.monomerCount;
        while (--n >= 0) {
            if (this.mads[n] <= 0) continue;
            int n2 = this.leadAtomIndices[n];
            if (this.monomers[n].getModel().isAtomHidden(n2)) continue;
            this.shape.atoms[n2].setClickable(ALPHA_CARBON_VISIBILITY_FLAG);
            if (!bl) continue;
            ((NucleicMonomer)this.monomers[n]).setModelClickability();
        }
    }
}

