/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.CageRenderer;
import org.jmol.shape.Uccage;
import org.jmol.util.BoxInfo;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.TextFormat;

public class UccageRenderer
extends CageRenderer {
    NumberFormat nf;
    byte fid;
    boolean doLocalize;
    private final Point3f[] verticesT = new Point3f[8];
    private Point3f fset0;
    private Point3f cell0;
    private Point3f cell1;
    private Point3f offset;
    private Point3f offsetT;

    public UccageRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.verticesT[n] = new Point3f();
        }
        this.fset0 = new Point3f(555.0f, 555.0f, 1.0f);
        this.cell0 = new Point3f();
        this.cell1 = new Point3f();
        this.offset = new Point3f();
        this.offsetT = new Point3f();
    }

    protected void setEdges() {
        this.tickEdges = BoxInfo.uccageTickEdges;
    }

    protected void initRenderer() {
        super.initRenderer();
        this.draw000 = false;
    }

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        this.font3d = this.g3d.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int n = this.viewer.getObjectMad(5);
        this.colix = this.viewer.getObjectColix(5);
        if (n == 0 || !this.g3d.setColix(this.colix) || this.viewer.isJmolDataFrame() || this.viewer.isNavigating() && this.viewer.getNavigationPeriodic()) {
            return;
        }
        this.doLocalize = this.viewer.getUseNumberLocalization();
        this.render1(n);
    }

    void render1(int n) {
        boolean bl;
        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        this.isPolymer = symmetryInterface.isPolymer();
        this.isSlab = symmetryInterface.isSlab();
        Point3f[] point3fArray = symmetryInterface.getUnitCellVertices();
        this.offset.set(symmetryInterface.getCartesianOffset());
        Point3f point3f = symmetryInterface.getUnitCellMultiplier();
        boolean bl2 = bl = point3f != null;
        if (!bl) {
            point3f = this.fset0;
        }
        SimpleUnitCell.ijkToPoint3f((int)point3f.x, this.cell0, 0);
        SimpleUnitCell.ijkToPoint3f((int)point3f.y, this.cell1, 1);
        if (point3f.z < 0.0f) {
            this.cell0.scale(-1.0f / point3f.z);
            this.cell1.scale(-1.0f / point3f.z);
        }
        Point3f[] point3fArray2 = this.viewer.getAxisPoints();
        boolean bl3 = this.viewer.getObjectMad(1) == 0 || this.viewer.getAxesScale() < 2.0f || point3fArray2 == null;
        Point3f[] point3fArray3 = point3fArray2;
        int n2 = (int)this.cell0.x;
        while ((float)n2 < this.cell1.x) {
            int n3 = (int)this.cell0.y;
            while ((float)n3 < this.cell1.y) {
                int n4 = (int)this.cell0.z;
                while ((float)n4 < this.cell1.z) {
                    int n5;
                    int n6;
                    int n7;
                    if (bl) {
                        this.offsetT.set(n2, n3, n4);
                        this.offsetT.scale(Math.abs(point3f.z));
                        symmetryInterface.toCartesian(this.offsetT, true);
                        this.offsetT.add(this.offset);
                        point3fArray3 = n2 == 0 && n3 == 0 && n4 == 0 ? point3fArray2 : null;
                        n7 = bl3 || point3fArray3 == null ? 0 : 3;
                        n6 = 255;
                        n5 = 255;
                    } else {
                        this.offsetT.set(this.offset);
                        n7 = bl3 ? 0 : 3;
                        n6 = 255;
                        n5 = 255;
                    }
                    int n8 = 8;
                    while (--n8 >= 0) {
                        this.verticesT[n8].add(point3fArray[n8], this.offsetT);
                    }
                    this.render(n, this.verticesT, point3fArray3, n7, n6, n5, Math.abs(point3f.z));
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (this.viewer.getDisplayCellParameters() && !this.viewer.isPreviewOnly() && !symmetryInterface.isPeriodic()) {
            this.renderInfo(symmetryInterface);
        }
    }

    private String nfformat(float f) {
        return this.doLocalize && this.nf != null ? this.nf.format(f) : TextFormat.formatDecimal(f, 3);
    }

    private void renderInfo(SymmetryInterface symmetryInterface) {
        if (this.isExport || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
        }
        this.fid = this.g3d.getFontFid("Monospaced", 14.0f * this.imageFontScaling);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int n = (int)(15.0f * this.imageFontScaling);
        int n2 = (int)(5.0f * this.imageFontScaling);
        int n3 = n;
        String string = symmetryInterface.getSpaceGroupName();
        if (this.isPolymer) {
            string = "polymer";
        } else if (this.isSlab) {
            string = "slab";
        }
        if (string != null & !string.equals("-- [--]")) {
            this.g3d.drawStringNoSlab(string, null, n2, n3 += n, 0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(symmetryInterface.getUnitCellInfo(0)) + "\u00c5", null, n2, n3 += n, 0);
        if (!this.isPolymer) {
            this.g3d.drawStringNoSlab("b=" + this.nfformat(symmetryInterface.getUnitCellInfo(1)) + "\u00c5", null, n2, n3 += n, 0);
        }
        if (!this.isPolymer && !this.isSlab) {
            this.g3d.drawStringNoSlab("c=" + this.nfformat(symmetryInterface.getUnitCellInfo(2)) + "\u00c5", null, n2, n3 += n, 0);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        if (!this.isPolymer) {
            if (!this.isSlab) {
                this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(symmetryInterface.getUnitCellInfo(3)) + "\u00b0", null, n2, n3 += n, 0);
                this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(symmetryInterface.getUnitCellInfo(4)) + "\u00b0", null, n2, n3 += n, 0);
            }
            this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(symmetryInterface.getUnitCellInfo(5)) + "\u00b0", null, n2, n3 += n, 0);
        }
    }
}

