/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.script.ContextToken;
import org.jmol.script.ParallelProcessor;
import org.jmol.script.ScriptCompilationTokenParser;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptFlowContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptCompiler
extends ScriptCompilationTokenParser {
    private String filename;
    private boolean isSilent;
    private Map<String, ScriptVariable> contextVariables;
    private Token[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private List<Token> ltoken;
    private List<Token[]> lltoken;
    private List<Token> vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private int tokLastMath;
    private boolean checkImpliedScriptCmd;
    private List<ScriptFunction> vFunctionStack;
    private boolean isShowCommand;
    private boolean isUserToken;
    private int tokInitialPlusPlus;
    List<Token> vPush = new ArrayList<Token>();
    int pushCount;
    char chFirst;

    public ScriptCompiler(Viewer viewer) {
        this.viewer = viewer;
    }

    public ScriptCompiler(ScriptCompiler scriptCompiler) {
        this.viewer = scriptCompiler.viewer;
    }

    ScriptContext parseScriptForTokens(String string) {
        this.script = string;
        this.filename = null;
        this.isCheckOnly = true;
        this.isSilent = true;
        this.logMessages = false;
        this.preDefining = false;
        return this.parseScript(false);
    }

    private ScriptContext parseScript(boolean bl) {
        if (!this.compile0(bl)) {
            this.handleError();
        }
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.script = this.script;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.errorType = this.errorType;
        if (this.errorType != null) {
            scriptContext.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        scriptContext.aatoken = this.aatokenCompiled;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.contextVariables = this.contextVariables;
        return scriptContext;
    }

    ScriptContext compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = string2;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        return this.parseScript(true);
    }

    private void addContextVariable(String string) {
        this.theToken = new Token(0x40000000, string);
        if (this.pushCount > 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(this.pushCount - 1);
            contextToken.addName(string);
            if (contextToken.tok != 364558) {
                return;
            }
        }
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable<String, ScriptVariable>();
            }
            ScriptCompiler.addContextVariable(this.contextVariables, string);
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    static void addContextVariable(Map<String, ScriptVariable> map, String string) {
        map.put(string, new ScriptVariable(4, "").setName(string));
    }

    private boolean isContextVariable(String string) {
        int n = this.vPush.size();
        while (--n >= 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(n);
            if (contextToken.contextVariables == null || !contextToken.contextVariables.containsKey(string)) continue;
            return true;
        }
        return this.thisFunction != null ? this.thisFunction.isVariable(string) : this.contextVariables != null && this.contextVariables.containsKey(string);
    }

    private String cleanScriptComments(String string) {
        int n = string.indexOf("\u0001##");
        if (n >= 0) {
            this.scriptExtensions = string.substring(n + 1);
            string = string.substring(0, n);
        }
        this.haveComments = string.indexOf("#") >= 0;
        return ScriptCompiler.getEmbeddedScript(string);
    }

    public static String getEmbeddedScript(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf((string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        if (n2 >= 0 && n3 >= n) {
            string = string.substring(n + "**** Jmol Embedded Script ****".length(), n3) + "\n";
        }
        while ((n2 = string.indexOf(" #Jmol...\u0000")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + " #Jmol...\u0000".length() + 4);
        }
        if (Logger.debugging) {
            Logger.info(string);
        }
        return string;
    }

    private void addTokenToPrefix(Token token) {
        if (this.logMessages) {
            Logger.info("addTokenToPrefix" + token);
        }
        this.ltoken.add(token);
        this.lastToken = token;
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean var1_1) {
        this.vFunctionStack = new ArrayList<ScriptFunction>();
        this.htUserFunctions = new Hashtable<K, V>();
        this.script = this.script.replace('\u201c', '\"').replace('\u201d', '\"');
        this.script = this.cleanScriptComments(this.script);
        this.ichToken = this.script.indexOf("# Jmol state version ");
        v0 = this.isStateScript = this.ichToken >= 0;
        if (this.isStateScript) {
            this.ptSemi = this.script.indexOf(";", this.ichToken);
            if (this.ptSemi >= this.ichToken) {
                this.viewer.setStateScriptVersion(this.script.substring(this.ichToken + "# Jmol state version ".length(), this.ptSemi).trim());
            }
        }
        this.cchScript = this.script.length();
        this.contextVariables = null;
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.thisFunction = null;
        this.flowContext = null;
        this.errorType = null;
        this.errorMessage = null;
        this.errorMessageUntranslated = null;
        this.errorLine = null;
        this.nSemiSkip = 0;
        this.ichToken = 0;
        this.ichCurrentCommand = 0;
        this.ichComment = 0;
        this.ichBrace = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        this.tokLastMath = 0;
        this.lastToken = Token.tokenOff;
        this.vBraces = new ArrayList<Token>();
        this.vPush = new ArrayList<Token>();
        this.pushCount = 0;
        this.iBrace = 0;
        this.braceCount = 0;
        this.parenCount = 0;
        this.ptSemi = -10;
        this.cchToken = 0;
        this.lnLength = 8;
        this.lineNumbers = new short[this.lnLength];
        this.lineIndices = new int[this.lnLength][2];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        this.iHaveQuotedString = false;
        this.checkImpliedScriptCmd = false;
        this.lltoken = new ArrayList<Token[]>();
        this.ltoken = new ArrayList<Token>();
        this.tokCommand = 0;
        this.lastFlowCommand = null;
        this.tokenAndEquals = null;
        this.tokInitialPlusPlus = 0;
        this.setBraceCount = 0;
        this.bracketCount = 0;
        this.forPoint3 = -1;
        this.setEqualPt = 0x7FFFFFFF;
        this.endOfLine = false;
        this.comment = null;
        this.isEndOfCommand = false;
        this.needRightParen = false;
        this.theTok = 0;
        var2_2 = 1;
        while (true) {
            block32: {
                block34: {
                    block33: {
                        if ((this.nTokens = this.ltoken.size()) == 0) {
                            if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                this.thisFunction.chpt0 = this.ichToken;
                            }
                            this.ichCurrentCommand = this.ichToken;
                            var2_2 = this.lineCurrent;
                        }
                        if (this.lookingAtLeadingWhitespace()) break block32;
                        this.endOfLine = false;
                        if (this.isEndOfCommand) break block33;
                        this.endOfLine = this.lookingAtEndOfLine();
                        switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                            case 2: {
                                break block32;
                            }
                            case 3: {
                                this.isEndOfCommand = true;
                                break block32;
                            }
                            case 1: {
                                this.isEndOfCommand = true;
                                this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                            }
                            default: {
                                v1 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtEndOfStatement() != false;
                            }
                        }
                    }
                    if (!this.isEndOfCommand) break block34;
                    this.isEndOfCommand = false;
                    switch (this.processTokenList(var2_2, var1_1)) {
                        case 2: {
                            break block32;
                        }
                        case 4: {
                            return false;
                        }
                        default: {
                            this.checkImpliedScriptCmd = false;
                            if (this.ichToken >= this.cchScript) {
                                this.setAaTokenCompiled();
                                return this.flowContext == null || this.error(11, Token.nameOf(this.flowContext.token.tok)) != false;
                            }
                            break block32;
                        }
                    }
                }
                if (this.nTokens <= 0) ** GOTO lbl-1000
                block9 : switch (this.checkSpecialParameterSyntax()) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        return false;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (this.lookingAtLookupToken(this.ichToken)) {
                            var3_3 = this.getPrefixToken();
                            switch (this.parseKnownToken(var3_3)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            switch (this.parseCommandParameter(var3_3)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            this.addTokenToPrefix(this.theToken);
                            break;
                        }
                        if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                            if (this.nTokens == 0) {
                                if (this.lookingAtString(true)) {
                                    this.addTokenToPrefix(this.setCommand(Token.tokenScript));
                                    this.cchToken = 0;
                                    break;
                                }
                                if (this.lookingAtImpliedString(true, true)) {
                                    this.ichEnd = this.ichToken + this.cchToken;
                                }
                            }
                            return this.commandExpected();
                        }
                        return this.error(19, this.script.substring(this.ichToken, this.ichToken + 1));
                    }
                }
            }
            this.ichToken += this.cchToken;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = new Token[this.lltoken.size()][];
        int n = this.lltoken.size();
        while (--n >= 0) {
            this.aatokenCompiled[n] = this.lltoken.get(n);
        }
    }

    private boolean lookingAtLeadingWhitespace() {
        int n;
        for (n = this.ichToken; n < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(n)); ++n) {
        }
        if (this.isLineContinuation(n, true)) {
            n += 1 + this.nCharNewLine(n + 1);
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean isLineContinuation(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n + 2 < this.cchScript && this.script.charAt(n) == '\\' && this.nCharNewLine(n + 1) > 0 || bl && this.lookingAtMathContinuation(n);
        if (bl2) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return bl2;
    }

    private boolean lookingAtMathContinuation(int n) {
        int n2;
        if (n >= this.cchScript || (n2 = this.nCharNewLine(n)) == 0 || this.lastToken.tok == 0x10000A) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        if (!(this.tokCommand == 1085443 && this.isNewSet || this.tokCommand == 36865 || this.tokCommand == 36869)) {
            return false;
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        n += n2;
        while (n < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(n))) {
            ++n;
        }
        return this.lookingAtLookupToken(n) && this.tokLastMath == 1;
    }

    private boolean lookingAtEndOfLine() {
        int n = this.ichEnd = this.ichToken;
        if (this.ichToken >= this.cchScript) {
            this.ichEnd = this.cchScript;
            return true;
        }
        int n2 = this.nCharNewLine(n);
        if (n2 == 0) {
            return false;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = n2;
        return true;
    }

    private int nCharNewLine(int n) {
        char c;
        int n2 = n >= this.cchScript ? 0 : ((c = this.script.charAt(n)) != '\r' ? (c == '\n' ? 1 : 0) : (++n < this.cchScript && this.script.charAt(n) == '\n' ? 2 : 1));
        return n2;
    }

    private boolean lookingAtEndOfStatement() {
        boolean bl;
        boolean bl2 = bl = this.script.charAt(this.ichToken) == ';';
        if (bl && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!bl || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean bl;
        int n;
        char c = this.script.charAt(this.ichToken);
        int n2 = -1;
        if (this.ichToken == this.ichCurrentCommand && c == '$') {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            for (n = this.ichToken; c != ']' && n < this.cchScript && !this.eol(c = this.script.charAt(n)); ++n) {
            }
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            n2 = n;
        }
        if (c == '/' && n + 1 < this.cchScript) {
            switch (this.script.charAt(++n)) {
                case '/': {
                    n2 = this.ichToken;
                    this.ichEnd = n - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = n - 1;
                    String string = ++n < this.cchScript && (c = this.script.charAt(n)) == '*' ? "**/" : "*/";
                    n = this.script.indexOf(string, this.ichToken + 2);
                    if (n < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, n));
                    this.cchToken = n + (c == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl2 = bl = n2 < 0;
        if (bl && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > n) {
            n = this.ichComment;
        }
        while (n < this.cchScript) {
            c = this.script.charAt(n);
            if (this.eol(c)) {
                this.ichEnd = n;
                if (this.isLineContinuation(n - 1, false)) {
                    n += this.nCharNewLine(n);
                } else if (bl || c != ';') break;
            } else if (n2 < 0 && c == '#') {
                n2 = n;
            }
            ++n;
        }
        if (n2 < 0) {
            return 0;
        }
        this.ichComment = n2;
        if (bl && this.nTokens == 0 && this.cchScript - n2 >= 3 && this.script.charAt(n2 + 1) == 'j' && this.script.charAt(n2 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (n2 != this.ichToken) {
            return 0;
        }
        if (bl && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (n == this.ichToken) {
            return 0;
        }
        this.cchToken = n - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private int processTokenList(short s, boolean bl) {
        if (this.nTokens > 0 || this.comment != null) {
            Object object;
            if (this.nTokens == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.addTokenToPrefix(new Token(0, this.comment));
                }
            } else if (this.setBraceCount > 0 && this.endOfLine && this.ichToken < this.cchScript) {
                return 2;
            }
            if (this.tokCommand == 135271429 && this.checkImpliedScriptCmd) {
                Object object2 = object = this.nTokens == 2 ? this.lastToken.value.toString().toUpperCase() : null;
                if (this.nTokens > 2 || object != null && (((String)object).endsWith(".SORT") || ((String)object).endsWith(".REVERSE"))) {
                    this.ichToken = this.ichCurrentCommand;
                    this.nTokens = 0;
                    this.ltoken.clear();
                    this.cchToken = 0;
                    this.tokCommand = 0;
                    return 2;
                }
            }
            if (this.isNewSet && this.nTokens > 2 && this.tokAt(2) == 0x100008 && (this.tokAt(3) == 1276117010 || this.tokAt(3) == 1141899269)) {
                this.ltoken.set(0, Token.tokenSet);
                this.ltoken.add(1, this.ltoken.get(1));
            } else if (this.tokInitialPlusPlus != 0) {
                if (!this.isNewSet) {
                    this.checkNewSetCommand();
                }
                this.tokenizePlusPlus(this.tokInitialPlusPlus, true);
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (this.nTokens == 1 && this.braceCount == 1) {
                if (this.lastFlowCommand == null) {
                    this.braceCount = 0;
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.ltoken.remove(0);
                    ++this.iBrace;
                    object = new ContextToken(266280, 0, "{");
                    this.addTokenToPrefix(this.setCommand((Token)object));
                    ++this.pushCount;
                    this.vPush.add((Token)object);
                    this.vBraces.add(this.tokenCommand);
                } else {
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.setCommand(this.lastFlowCommand);
                    if (this.lastFlowCommand.tok != 102439 && this.tokAt(0) == 0x10000A) {
                        this.ltoken.remove(0);
                    }
                    this.lastFlowCommand = null;
                }
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(this.nTokens == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.ltoken.size() > 0) {
                if (bl && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.debug("-------------------------------------");
                }
                boolean bl2 = true;
                switch (this.tokCommand) {
                    case 102436: 
                    case 364558: 
                    case 0x119009: 
                    case 135368713: {
                        boolean bl3 = bl2 = this.atokenInfix.length > 0 && this.atokenInfix[0].intValue != Integer.MAX_VALUE;
                    }
                }
                if (bl2) {
                    if (this.iCommand == this.lnLength) {
                        short[] sArray = new short[this.lnLength * 2];
                        System.arraycopy(this.lineNumbers, 0, sArray, 0, this.lnLength);
                        this.lineNumbers = sArray;
                        int[][] nArray = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, nArray, 0, this.lnLength);
                        this.lineIndices = nArray;
                        this.lnLength *= 2;
                    }
                    this.lineNumbers[this.iCommand] = s;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.add(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 1085443) {
                    this.lastFlowCommand = null;
                }
            }
            this.setCommand(null);
            this.comment = null;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.clear();
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.tokInitialPlusPlus = 0;
            this.tokenAndEquals = null;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
        }
        if (this.endOfLine) {
            if (this.flowContext != null && this.flowContext.checkForceEndIf()) {
                this.forceFlowEnd(this.flowContext.token);
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                this.lineCurrent = (short)(this.lineCurrent - 1);
                return 2;
            }
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        if (this.ichToken >= this.cchScript) {
            this.setCommand(Token.tokenAll);
            this.theTok = 0;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private boolean compileCommand() {
        int n;
        if (this.ltoken.size() == 0) {
            this.atokenInfix = new Token[0];
            return true;
        }
        this.setCommand(this.tokenAt(0));
        int n2 = this.ltoken.size();
        if (n2 == 1 && Token.tokAttr(this.tokCommand, 524288)) {
            this.addTokenToPrefix(Token.tokenOn);
        }
        if (this.tokenAndEquals != null) {
            int n3 = 0;
            for (n3 = 1; n3 < n2 && (n = this.tokAt(n3)) != 269484242; ++n3) {
            }
            n2 = n3++;
            if (this.ltoken.size() < n3) {
                Logger.error("COMPILER ERROR! - andEquals ");
            } else {
                n = 1;
                while (n < n2) {
                    this.ltoken.add(n3, this.tokenAt(n));
                    ++n;
                    ++n3;
                }
                this.ltoken.set(n2, Token.tokenEquals);
                this.ltoken.add(n3, this.tokenAndEquals);
                this.ltoken.add(++n3, Token.tokenLeftParen);
                this.addTokenToPrefix(Token.tokenRightParen);
            }
        }
        n2 = this.ltoken.size();
        this.atokenInfix = new Token[n2];
        n = this.ltoken.size();
        while (--n >= 0) {
            this.atokenInfix[n] = this.ltoken.get(n);
        }
        if (this.logMessages) {
            Logger.debug("token list:");
            for (n = 0; n < this.atokenInfix.length; ++n) {
                Logger.debug(n + ": " + this.atokenInfix[n]);
            }
            Logger.debug("vBraces list:");
            for (n = 0; n < this.vBraces.size(); ++n) {
                Logger.debug(n + ": " + this.vBraces.get(n));
            }
            Logger.debug("-------------------------------------");
        }
        return this.compileExpressions();
    }

    private Token tokenAt(int n) {
        return this.ltoken.get(n);
    }

    @Override
    protected int tokAt(int n) {
        return n < this.ltoken.size() ? this.tokenAt((int)n).tok : 0;
    }

    private Token setCommand(Token token) {
        this.tokenCommand = token;
        if (token == null) {
            this.tokCommand = 0;
        } else {
            this.tokCommand = this.tokenCommand.tok;
            this.isMathExpressionCommand = this.tokCommand == 0x40000000 || Token.tokAttr(this.tokCommand, 36864);
            this.isSetOrDefine = this.tokCommand == 1085443 || this.tokCommand == 1060866;
            this.isCommaAsOrAllowed = Token.tokAttr(this.tokCommand, 12288);
        }
        return token;
    }

    private void replaceCommand(Token token) {
        this.ltoken.remove(0);
        this.ltoken.add(0, this.setCommand(token));
    }

    private String getPrefixToken() {
        String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        String string2 = string.toLowerCase();
        boolean bl = this.isContextVariable(string2);
        if (this.nTokens == 0) {
            this.isUserToken = bl;
        }
        if (this.nTokens == 1 && (this.tokCommand == 135368713 || this.tokCommand == 102436 || this.tokCommand == 36868) || this.nTokens != 0 && bl || this.isUserFunction(string2) && (this.thisFunction == null || !this.thisFunction.name.equals(string2))) {
            string = string2;
            this.theToken = null;
        } else if (string.length() == 1) {
            this.theToken = Token.getTokenFromName(string);
            if (this.theToken == null && (this.theToken = Token.getTokenFromName(string2)) != null) {
                this.theToken = new Token(this.theToken.tok, this.theToken.intValue, string);
            }
        } else {
            string = string2;
            this.theToken = Token.getTokenFromName(string);
        }
        if (this.theToken == null) {
            this.theToken = string.indexOf("property_") == 0 ? new Token(1716520973, string) : new Token(0x40000000, string);
        }
        this.theTok = this.theToken.tok;
        return string;
    }

    private int checkSpecialParameterSyntax() {
        char c;
        int n;
        char c2;
        if (this.nTokens == this.ptNewSetModifier) {
            c2 = this.script.charAt(this.ichToken);
            boolean bl = "+-\\*/&|=".indexOf(c2) >= 0;
            n = bl || c2 == '.' || c2 == '[' ? 1 : 0;
            char c3 = c = this.ichToken + 1 >= this.cchScript ? (char)'\u0000' : this.script.charAt(this.ichToken + 1);
            if (!this.isNewSet && this.isUserToken && n != 0 && (c2 == '=' || c == c2 || c == '=')) {
                this.isNewSet = true;
            }
            if (this.isNewSet || this.tokCommand == 1085443 || Token.tokAttr(this.tokCommand, 0x20000000)) {
                if (c2 == '=') {
                    this.setEqualPt = this.ichToken;
                }
                if (Token.tokAttr(this.tokCommand, 0x20000000) && c2 == '=' || (this.isNewSet || this.isSetBrace) && n != 0) {
                    this.setCommand(bl ? Token.tokenSet : (c2 == '[' && !this.isSetBrace ? Token.tokenSetArray : Token.tokenSetProperty));
                    this.ltoken.add(0, this.tokenCommand);
                    this.cchToken = 1;
                    switch (c2) {
                        case '[': {
                            this.addTokenToPrefix(new Token(0x10100040, "["));
                            ++this.bracketCount;
                            return 2;
                        }
                        case '.': {
                            this.addTokenToPrefix(new Token(0x100008, "."));
                            return 2;
                        }
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '\\': 
                        case '|': {
                            if (c == '\u0000') {
                                return this.ERROR(4);
                            }
                            if (c == c2 || c == '=') break;
                            return this.ERROR(1, "\"" + c2 + "\"");
                        }
                        default: {
                            this.lastToken = Token.tokenMinus;
                            return 2;
                        }
                    }
                }
            }
        }
        if (this.lookingAtString(!Token.tokAttr(this.tokCommand, 20480))) {
            String string;
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            if ((this.tokCommand == 1085443 && this.nTokens == 2 && this.lastToken.tok == 545259546 || this.tokCommand == 135271426 || this.tokCommand == 1610616835 || this.tokCommand == 135271429) && !this.iHaveQuotedString) {
                if (this.lastToken.tok == 1073741983) {
                    string = this.getUnescapedStringLiteral();
                } else {
                    string = this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1);
                    if (string.indexOf("\\u") >= 0) {
                        string = Escape.unescapeUnicode(string);
                    }
                }
            } else {
                string = this.getUnescapedStringLiteral();
            }
            this.iHaveQuotedString = true;
            if (this.tokCommand == 135271426 && this.lastToken.tok == 135270407 || this.tokCommand == 135270407 && string.indexOf("@") < 0) {
                if (!this.getData(string)) {
                    return this.ERROR(11, "data");
                }
            } else {
                this.addTokenToPrefix(new Token(4, string));
                if (Token.tokAttr(this.tokCommand, 20480)) {
                    this.isEndOfCommand = true;
                }
            }
            return 2;
        }
        if (this.tokCommand == 4156 && this.nTokens == 1 && this.charToken()) {
            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            n = Parser.parseInt(string);
            if (n == Integer.MIN_VALUE || Math.abs(n) < 1000) {
                this.addTokenToPrefix(new Token(0x40000000, string));
            } else {
                this.addTokenToPrefix(new Token(2, n));
            }
            return 2;
        }
        switch (this.tokCommand) {
            case 135271426: {
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (this.nTokens == 1 && this.lookingAtLoadFormat()) {
                    String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    Token token = Token.getTokenFromName(string.toLowerCase());
                    switch (token == null ? 0 : token.tok) {
                        case 135267336: 
                        case 135270407: 
                        case 0x2000000E: 
                        case 0x4000000F: 
                        case 1073741983: 
                        case 1073742015: 
                        case 1095766028: 
                        case 1229984263: {
                            this.addTokenToPrefix(token);
                            break;
                        }
                        default: {
                            char c4 = string.indexOf("=") == 0 || string.indexOf("$") == 0 ? (char)'\u0004' : (c = Parser.isOneOf(string = string.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge") ? (char)'\u40000000' : '\u0000');
                            if (c == '\u0000') break;
                            this.addTokenToPrefix(new Token((int)c, string));
                            this.iHaveQuotedString = c == '\u0004';
                        }
                    }
                    return 2;
                }
                if (this.script.charAt(this.ichToken) == '{' || this.parenCount > 0) break;
                BitSet bitSet = this.lookingAtBitset();
                if (bitSet != null) {
                    this.addTokenToPrefix(new Token(10, bitSet));
                    return 2;
                }
                if (this.iHaveQuotedString || !this.lookingAtImpliedString(false, true)) break;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                this.addTokenToPrefix(new Token(4, string));
                this.iHaveQuotedString = true;
                return 2;
            }
            case 135270410: 
            case 135271429: {
                if (this.iHaveQuotedString || !this.lookingAtImpliedString(false, false)) break;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (this.tokCommand == 135271429 && string.startsWith("javascript:")) {
                    this.lookingAtImpliedString(true, true);
                    string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                }
                this.addTokenToPrefix(new Token(4, string));
                this.iHaveQuotedString = true;
                return 2;
            }
            case 135270421: {
                if (this.nTokens == 2 && this.lastToken.tok == 4115) {
                    this.iHaveQuotedString = true;
                }
                if (this.iHaveQuotedString) break;
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (!this.lookingAtImpliedString(true, true)) break;
                n = this.cchToken;
                String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (string.indexOf(" ") < 0) {
                    this.addTokenToPrefix(new Token(4, string));
                    this.iHaveQuotedString = true;
                    return 2;
                }
                this.cchToken = n;
            }
        }
        if (Token.tokAttr(this.tokCommand, 20480) && (this.tokCommand != 135271429 || !this.iHaveQuotedString) && this.lookingAtImpliedString(true, true)) {
            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 1826248715 && Parser.isOneOf(string.toLowerCase(), "on;off;hide;display")) {
                this.addTokenToPrefix(Token.getTokenFromName(string.toLowerCase()));
            } else {
                this.addTokenToPrefix(new Token(4, string));
            }
            return 2;
        }
        float f = this.lookingAtExponential();
        if (!Float.isNaN(f)) {
            this.addTokenToPrefix(new Token(3, new Float(f)));
            return 2;
        }
        if (this.lookingAtObjectID(this.nTokens == 1)) {
            this.addTokenToPrefix(Token.getTokenFromName("$"));
            this.addTokenToPrefix(new Token(0x40000000, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            f = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
            n = ScriptEvaluator.getFloatEncodedInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addTokenToPrefix(new Token(3, n, new Float(f)));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            c2 = this.script.charAt(this.ichToken);
            try {
                n = c2 == '*' || c2 == '^' ? Integer.MAX_VALUE : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                c = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (c == '^') {
                    c = ' ';
                }
                if (n < 0) {
                    n = -n;
                    this.addTokenToPrefix(Token.tokenMinus);
                }
                int n2 = Group.getSeqcode(n, c);
                this.addTokenToPrefix(new Token(5, n2, "seqcode"));
                return 2;
            }
            catch (NumberFormatException numberFormatException) {
                return this.ERROR(9, "" + c2);
            }
        }
        n = this.lookingAtInteger();
        if (n != Integer.MAX_VALUE) {
            String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                ScriptFlowContext scriptFlowContext;
                ScriptFlowContext scriptFlowContext2;
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    scriptFlowContext2 = null;
                } else {
                    n = Math.abs(n);
                    scriptFlowContext2 = scriptFlowContext = this.flowContext.getBreakableContext(n);
                }
                if (scriptFlowContext == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                this.tokenAt((int)0).intValue = scriptFlowContext.pt0;
            }
            if (n == 0 && string.equals("-0")) {
                this.addTokenToPrefix(Token.tokenMinus);
            }
            this.addTokenToPrefix(new Token(2, n, string));
            return 2;
        }
        if (!this.isMathExpressionCommand && this.parenCount == 0 || this.lastToken.tok != 0x40000000 && !ScriptCompiler.tokenAttr(this.lastToken, 0x8100000)) {
            c = this.script.charAt(this.ichToken) == '[' ? (char)'\u0001' : '\u0000';
            BitSet bitSet = this.lookingAtBitset();
            if (bitSet == null) {
                Object object;
                if (c != '\u0000' && ((object = this.lookingAtMatrix()) instanceof Matrix3f || object instanceof Matrix4f)) {
                    this.addTokenToPrefix(new Token(object instanceof Matrix3f ? 11 : 12, object));
                    return 2;
                }
            } else {
                if (c != '\u0000') {
                    this.addTokenToPrefix(new Token(10, new Bond.BondSet(bitSet)));
                } else {
                    this.addTokenToPrefix(new Token(10, bitSet));
                }
                return 2;
            }
        }
        return 0;
    }

    private Object lookingAtMatrix() {
        Object object;
        int n;
        if (this.ichToken + 4 >= this.cchScript || this.script.charAt(this.ichToken) != '[' || this.script.charAt(this.ichToken + 1) != '[' || (n = this.script.indexOf("]]", this.ichToken)) < 0 || (object = Escape.unescapeMatrix(this.script.substring(this.ichToken, n + 2))) == null) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return object;
    }

    private int parseKnownToken(String string) {
        if (this.tokLastMath != 0) {
            this.tokLastMath = this.theTok;
        }
        if (this.flowContext != null && this.flowContext.token.tok == 102410 && this.flowContext.var != null && this.theTok != 102411 && this.theTok != 102413 && this.lastToken.tok != 102410) {
            return this.ERROR(1, string);
        }
        switch (this.theTok) {
            case 0x40000000: {
                if (this.nTokens != 0 || this.checkImpliedScriptCmd) break;
                if (string.charAt(0) == '\'') {
                    this.addTokenToPrefix(this.setCommand(Token.tokenScript));
                    this.cchToken = 0;
                    return 2;
                }
                if (this.ichToken + this.cchToken >= this.cchScript || this.script.charAt(this.ichToken + this.cchToken) != '.') break;
                this.addTokenToPrefix(this.setCommand(Token.tokenScript));
                this.nTokens = 1;
                this.cchToken = 0;
                this.checkImpliedScriptCmd = true;
                return 2;
            }
            case 269484242: {
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    Token token = this.lastToken;
                    this.addTokenToPrefix(Token.tokenEquals);
                    this.addTokenToPrefix(token);
                    token = Token.getTokenFromName(string.substring(0, 1));
                    this.addTokenToPrefix(token);
                    this.addTokenToPrefix(Token.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                this.checkNewSetCommand();
                if (this.tokCommand == 1085443) {
                    this.tokenAndEquals = Token.getTokenFromName(string.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                if (this.tokCommand == 554176565 || this.tokCommand == 554176526) {
                    this.addTokenToPrefix(this.tokenCommand);
                    this.replaceCommand(Token.tokenSet);
                    this.tokenAndEquals = Token.getTokenFromName(string.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 364548: 
            case 0x119009: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 135369224: {
                if (this.bracketCount > 0) break;
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 102411: 
            case 102412: 
            case 102413: 
            case 135369225: {
                if (this.nTokens <= 1 || this.tokCommand == 1085443) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
            case 0x101000C1: 
            case 269484226: {
                if (!this.isNewSet && this.nTokens == 1) {
                    this.checkNewSetCommand();
                }
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.tokenizePlusPlus(this.theTok, false);
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                Token token = this.lastToken;
                this.addTokenToPrefix(Token.tokenEquals);
                this.addTokenToPrefix(token);
                this.addTokenToPrefix(this.theTok == 0x101000C1 ? Token.tokenMinus : Token.tokenPlus);
                this.addTokenToPrefix(Token.intToken(1));
                return 2;
            }
            case 269484436: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x100008: {
                if (this.tokCommand != 1085443 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt) break;
                this.ltoken.add(1, Token.tokenExpressionBegin);
                this.addTokenToPrefix(Token.tokenExpressionEnd);
                this.ltoken.set(0, Token.tokenSetProperty);
                this.setEqualPt = 0;
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                if (this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                    return 2;
                }
            }
            case 0x10100010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 135280132 && this.lastToken.tok != 135369224 && this.lastToken.tok != 135369225) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x10000E: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        this.nSemiSkip = 0;
                        this.parenCount = 0;
                        this.braceCount = 0;
                        if (this.theToken.tok != 102411 && this.theToken.tok != 102413) {
                            this.vBraces.add(this.theToken);
                        }
                        ++this.iBrace;
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken;
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10100011: {
                --this.parenCount;
                if (this.parenCount < 0) {
                    return this.ERROR(16, string);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10100040: {
                if (this.ichToken > 0 && Character.isWhitespace(this.script.charAt(this.ichToken - 1))) {
                    this.addTokenToPrefix(Token.tokenSpaceBeforeSquare);
                }
                ++this.bracketCount;
                break;
            }
            case 0x10100041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
        }
        return 0;
    }

    private void tokenizePlusPlus(int n, boolean bl) {
        if (bl) {
            this.setCommand(Token.tokenSet);
            this.ltoken.add(0, this.tokenCommand);
        }
        this.nTokens = this.ltoken.size();
        this.addTokenToPrefix(Token.tokenEquals);
        this.setEqualPt = 0;
        for (int i = 1; i < this.nTokens; ++i) {
            this.addTokenToPrefix(this.ltoken.get(i));
        }
        this.addTokenToPrefix(n == 0x101000C1 ? Token.tokenMinus : Token.tokenPlus);
        this.addTokenToPrefix(Token.intToken(1));
    }

    private boolean checkNewSetCommand() {
        String string = this.ltoken.get((int)0).value.toString();
        if (!this.isContextVariable(string.toLowerCase())) {
            return false;
        }
        Token token = this.setNewSetCommand(false, string);
        this.setCommand(Token.tokenSet);
        this.ltoken.add(0, this.tokenCommand);
        this.ltoken.set(1, token);
        return true;
    }

    private int parseCommandParameter(String string) {
        this.nTokens = this.ltoken.size();
        block0 : switch (this.tokCommand) {
            case 0: {
                int n;
                this.lastToken = Token.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.setCommand(this.theToken);
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                }
                if ((n = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (n == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    if (!this.checkFlowCommand((String)this.tokenCommand.value)) {
                        return 4;
                    }
                    this.theToken = this.tokenCommand;
                    if (this.theTok != 102411) break;
                    this.addTokenToPrefix(this.tokenCommand);
                    this.theToken = Token.tokenLeftParen;
                    break;
                }
                if (this.theTok == 0x10100022) {
                    ++this.braceCount;
                    this.isEndOfCommand = true;
                    break;
                }
                if (this.theTok == 0x10000E) {
                    this.vBraces.add(this.tokenCommand);
                    ++this.iBrace;
                    this.tokCommand = 0;
                    return 2;
                }
                if (this.theTok != 0x10000A) {
                    this.lastFlowCommand = null;
                }
                if (Token.tokAttr(this.tokCommand, 4096)) break;
                boolean bl = this.isSetBrace = this.theTok == 0x10000A;
                if (this.isSetBrace) {
                    if (!this.lookingAtBraceSyntax()) {
                        this.isEndOfCommand = true;
                        if (this.flowContext != null) {
                            this.flowContext.forceEndIf = false;
                        }
                    }
                } else {
                    switch (this.theTok) {
                        case 0x101000C1: 
                        case 269484226: {
                            this.tokInitialPlusPlus = this.theTok;
                            this.tokCommand = 0;
                            return 2;
                        }
                        case 36868: 
                        case 1060866: 
                        case 0x10100010: 
                        case 0x40000000: {
                            break;
                        }
                        default: {
                            if (Token.tokAttr(this.theTok, 0x40000000) || Token.tokAttr(this.theTok, 0x20000000) || this.isContextVariable(string)) break;
                            this.commandExpected();
                            return 4;
                        }
                    }
                }
                this.theToken = this.setNewSetCommand(this.isSetBrace, string);
                break;
            }
            case 102412: {
                switch (this.nTokens) {
                    case 1: {
                        if (this.theTok == 0x10100010) break block0;
                        return this.ERROR(15, "(");
                    }
                    case 2: {
                        if (this.theTok != 0x10100011) {
                            ((ContextToken)this.tokenCommand).name0 = string;
                        }
                        this.addContextVariable(string);
                        break block0;
                    }
                    case 3: {
                        if (this.theTok != 0x10100011) {
                            return this.ERROR(15, ")");
                        }
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken + 1;
                        this.flowContext.setLine();
                        break block0;
                    }
                }
                return this.ERROR(0);
            }
            case 102436: 
            case 135368713: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = string;
                    return 2;
                }
                if (this.nTokens == 1) {
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = this.tokCommand == 102436 ? new ParallelProcessor(string, this.tokCommand) : new ScriptFunction(string, this.tokCommand);
                    this.htUserFunctions.put(string, Boolean.TRUE);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10100010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10100011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10100030 || this.theTok == 0x10100011) break;
                    return this.ERROR(15, ")");
                }
                this.thisFunction.addVariable(string, true);
                break;
            }
            case 102411: {
                if (this.nTokens <= 1 || this.parenCount != 0 || this.braceCount != 0 || this.theTok != 0x10100022) break;
                this.addTokenToPrefix(Token.tokenRightParen);
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102413: {
                if (this.nTokens <= 1) break;
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 135369225) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 135369225 && this.theTok != 0x10000A) {
                    return this.ERROR(0);
                }
                this.flowContext.token = new ContextToken(102402, "elseif");
                this.replaceCommand(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 36868: {
                if (this.nTokens != 1) break;
                this.addContextVariable(string);
                this.replaceCommand(Token.tokenSetVar);
                this.tokCommand = 1085443;
                break;
            }
            case 0x119009: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, string, this.ichCurrentCommand)) {
                    return 4;
                }
                if (this.theTok != 135368713 && this.theTok != 102436) break;
                return 2;
            }
            case 102406: 
            case 102410: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 102402: 
            case 135369225: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 102439: {
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 135369224: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10100010) {
                        return this.ERROR(19, string);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && this.tokAt(2) == 36868) {
                    this.addContextVariable(string);
                    break;
                }
                if ((this.nTokens == 3 || this.nTokens == 4) && this.theTok == 1073741980) {
                    this.nSemiSkip -= 2;
                    this.forPoint3 = 2;
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = Token.tokenLeftParen;
                    break;
                }
                if (this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 1085443: {
                if (this.theTok == 0x10000A) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x10000E) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == Integer.MAX_VALUE) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                Token token = this.tokenAt(0);
                if (this.theTok == 0x10100010 || this.isUserFunction(token.value.toString())) {
                    this.ltoken.set(0, this.setCommand(new Token(0x40000000, 0, token.value)));
                    this.setBraceCount = 0;
                    break;
                }
                if (this.theTok != 0x40000000 && this.theTok != 269484242 && this.theTok != 1060866 && !Token.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.error(18, "SET", ": " + string);
                    }
                    return 4;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 269484226 && this.lastToken.tok != 0x101000C1) break;
                this.replaceCommand(Token.tokenSet);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 135271426: {
                if (this.theTok == 1060866 && (this.nTokens == 1 || this.lastToken.tok == 0x40000074 || this.lastToken.tok == 1073742152)) {
                    this.addTokenToPrefix(Token.tokenDefineString);
                    return 2;
                }
                if (this.theTok != 1073741848) break;
                this.iHaveQuotedString = false;
                break;
            }
            case 12291: 
            case 12294: 
            case 12295: 
            case 1060866: 
            case 135280132: 
            case 1610625028: {
                if (this.tokCommand == 1060866) {
                    if (this.nTokens == 1) {
                        if (this.theTok != 0x40000000) {
                            if (this.preDefining) {
                                if (!Token.tokAttr(this.theTok, 0x300000)) {
                                    this.error("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + string, null);
                                    return 4;
                                }
                            } else if (Token.tokAttr(this.theTok, 0x300000)) {
                                Logger.warn("WARNING: predefined term '" + string + "' has been redefined by the user until the next file load.");
                            } else if (!this.isCheckOnly && string.length() > 1) {
                                Logger.warn("WARNING: redefining " + string + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                                this.theToken.tok = 0x40000000;
                                this.theTok = 0x40000000;
                                Token.addToken(string, this.theToken);
                            }
                        }
                        this.addTokenToPrefix(this.theToken);
                        this.lastToken = Token.tokenComma;
                        return 2;
                    }
                    if (this.nTokens == 2 && this.theTok == 269484436) {
                        this.ltoken.add(0, Token.tokenSet);
                        return 2;
                    }
                }
                if (this.bracketCount != 0 || this.theTok == 0x40000000 || Token.tokAttr(this.theTok, 0x100000) || Token.tokAttr(this.theTok, 0x40000000) || (this.theTok & 0x1E0) == this.theTok) break;
                return this.ERROR(9, string);
            }
            case 12289: {
                if (this.theTok == 0x40000000 || this.theTok == 0x100007 || Token.tokAttr(this.theTok, 0x100000)) break;
                return this.ERROR(9, string);
            }
            case 135180: 
            case 135188: 
            case 135190: {
                char c = this.nextChar();
                if (this.parenCount != 0 || this.bracketCount != 0 || ".:/\\+-!?".indexOf(c) < 0 || c == '-' && string.equals("=")) break;
                this.checkUnquotedFileName();
            }
        }
        return 0;
    }

    private Token setNewSetCommand(boolean bl, String string) {
        this.tokCommand = 1085443;
        this.isNewSet = !bl && !this.isUserFunction(string);
        this.setBraceCount = bl ? 1 : 0;
        this.bracketCount = 0;
        this.setEqualPt = Integer.MAX_VALUE;
        this.ptNewSetModifier = this.isNewSet ? (string.equals("(") ? 2 : 1) : Integer.MAX_VALUE;
        return bl || this.theToken.tok == 269484226 || this.theToken.tok == 0x101000C1 ? this.theToken : new Token(0x40000000, string);
    }

    private char nextChar() {
        int n = this.ichToken + this.cchToken;
        return n >= this.cchScript ? (char)' ' : this.script.charAt(n);
    }

    private void checkUnquotedFileName() {
        char c;
        int n = this.ichToken;
        while (++n < this.cchScript && !Character.isWhitespace(c = this.script.charAt(n)) && c != '#' && c != ';' && c != '}') {
        }
        String string = this.script.substring(this.ichToken, n).replace('\\', '/');
        this.cchToken = n - this.ichToken;
        this.theToken = new Token(4, string);
    }

    private boolean checkFlowStartBrace(boolean bl) {
        if (!Token.tokAttr(this.tokCommand, 102400) || this.tokCommand == 102407 || this.tokCommand == 102408) {
            return false;
        }
        if (bl) {
            if (this.tokenCommand.tok != 102411 && this.tokenCommand.tok != 102413) {
                ++this.iBrace;
                this.vBraces.add(this.tokenCommand);
                this.lastFlowCommand = null;
            }
            this.braceCount = 0;
            this.parenCount = 0;
        }
        return true;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || this.vBraces.get((int)(this.iBrace - 1)).tok != 0x10000E) {
            return 0;
        }
        this.vBraces.remove(--this.iBrace);
        Token token = this.vBraces.remove(--this.iBrace);
        if (this.theTok == 0x10000A) {
            --this.braceCount;
            --this.parenCount;
        }
        if (token.tok == 266280) {
            this.vPush.remove(--this.pushCount);
            this.addTokenToPrefix(this.setCommand(new ContextToken(266278, 0, "}")));
            this.isEndOfCommand = true;
            return 2;
        }
        switch (this.flowContext == null ? 0 : this.flowContext.token.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                if (this.tokCommand != 364547 && this.tokCommand != 102402) break;
                return 0;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                if (this.tokCommand != 102411 && this.tokCommand != 102413) break;
                return 0;
            }
        }
        return this.forceFlowEnd(token);
    }

    private int forceFlowEnd(Token token) {
        Token token2 = this.tokenCommand;
        this.setCommand(new Token(0x119009, "end"));
        if (!this.checkFlowCommand("end")) {
            return 0;
        }
        this.addTokenToPrefix(this.tokenCommand);
        switch (token.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                token = Token.tokenIf;
                break;
            }
            case 102411: 
            case 102413: {
                token = Token.tokenSwitch;
                break;
            }
            default: {
                token = Token.getTokenFromName((String)token.value);
            }
        }
        if (!this.checkFlowEnd(token.tok, (String)token.value, this.ichBrace)) {
            return 4;
        }
        if (token.tok != 135368713 && token.tok != 102436 && token.tok != 364558) {
            this.addTokenToPrefix(token);
        }
        this.setCommand(token2);
        return 2;
    }

    static boolean isBreakableContext(int n) {
        return n == 135369224 || n == 102439 || n == 102406 || n == 102411 || n == 102413;
    }

    private boolean checkFlowCommand(String string) {
        Object object;
        int n = this.lltoken.size();
        boolean bl = false;
        boolean bl2 = true;
        switch (this.tokCommand) {
            case 102436: 
            case 135368713: {
                if (this.flowContext == null) break;
                return this.error(1, Token.nameOf(this.tokCommand));
            }
            case 0x119009: {
                if (this.flowContext == null) {
                    return this.error(1, string);
                }
                bl = true;
                if (this.flowContext.token.tok == 135368713 || this.flowContext.token.tok == 102436 || this.flowContext.token.tok == 364558) break;
                this.setCommand(new Token(this.tokCommand, this.flowContext.ptDefault > 0 ? this.flowContext.ptDefault : -this.flowContext.pt0, string));
                break;
            }
            case 102412: 
            case 364558: {
                break;
            }
            case 102406: 
            case 102410: 
            case 102439: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 364548: {
                bl = true;
                if (this.flowContext != null && (this.flowContext.token.tok == 135369225 || this.flowContext.token.tok == 102439 || this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402)) break;
                return this.error(1, string);
            }
            case 364547: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402) {
                    return this.error(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                break;
            }
            case 102407: 
            case 102408: {
                bl2 = false;
                Object object2 = object = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (this.tokCommand == 102408) {
                    while (object != null && ((ScriptFlowContext)object).token.tok != 135369224 && ((ScriptFlowContext)object).token.tok != 102406) {
                        object = ((ScriptFlowContext)object).getParent();
                    }
                }
                if (object == null) {
                    return this.error(1, string);
                }
                this.setCommand(new Token(this.tokCommand, ((ScriptFlowContext)object).pt0, string));
                break;
            }
            case 102413: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && this.flowContext.ptDefault > 0) {
                    return this.error(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, true);
                break;
            }
            case 102411: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && this.flowContext.token.tok != 102413) {
                    return this.error(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                break;
            }
            case 102402: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402 && this.flowContext.token.tok != 364547) {
                    return this.error(1, "elseif");
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
            }
        }
        if (bl) {
            int n2 = this.flowContext.token.intValue = this.tokCommand == 102412 ? -n : n;
            if (this.tokCommand == 364548) {
                this.flowContext = this.flowContext.getParent();
            }
            if (this.tokCommand == 364558) {
                // empty if block
            }
        } else if (bl2) {
            object = new ContextToken(this.tokCommand, this.tokenCommand.value);
            this.setCommand((Token)object);
            switch (this.tokCommand) {
                case 364558: {
                    this.flowContext = new ScriptFlowContext(this, (ContextToken)object, n, this.flowContext);
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = new ParallelProcessor("", this.tokCommand);
                    this.flowContext.setFunction(this.thisFunction);
                    ++this.pushCount;
                    this.vPush.add((Token)object);
                    break;
                }
                case 102402: 
                case 364547: {
                    this.flowContext.token = object;
                    break;
                }
                case 102411: 
                case 102413: {
                    ((ContextToken)object).contextVariables = this.flowContext.token.contextVariables;
                    this.flowContext.token = object;
                    break;
                }
                case 102406: 
                case 102412: 
                case 102439: 
                case 135369224: {
                    ++this.pushCount;
                    this.vPush.add((Token)object);
                }
                default: {
                    this.flowContext = new ScriptFlowContext(this, (ContextToken)object, n, this.flowContext);
                }
            }
        }
        return true;
    }

    private boolean checkFlowEnd(int n, String string, int n2) {
        if (this.flowContext == null || this.flowContext.token.tok != n) {
            boolean bl = true;
            switch (n) {
                case 135369225: {
                    bl = this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402;
                    break;
                }
                case 102410: {
                    bl = this.flowContext.token.tok == 102411 || this.flowContext.token.tok == 102413;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                return this.error(1, "end " + string);
            }
        }
        switch (n) {
            case 102410: 
            case 135369225: {
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 135369224: {
                this.vPush.remove(--this.pushCount);
                break;
            }
            case 102436: 
            case 364558: 
            case 135368713: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(new Token(n, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, n2, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = this.vFunctionStack.size() == 0 ? null : this.vFunctionStack.remove(0);
                this.tokenCommand.intValue = 0;
                if (n != 364558) break;
                this.vPush.remove(--this.pushCount);
                break;
            }
            default: {
                return this.error(19, "end " + string);
            }
        }
        this.flowContext = this.flowContext.getParent();
        return true;
    }

    private boolean getData(String string) {
        int n;
        this.addTokenToPrefix(new Token(4, string));
        this.ichToken += string.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((n = this.script.indexOf(this.chFirst + string + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.incrementLineCount(string2);
        this.addTokenToPrefix(new Token(135270407, string2));
        this.addTokenToPrefix(new Token(0x40000000, "end"));
        this.addTokenToPrefix(new Token(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private int incrementLineCount(String string) {
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n < 0 && n2 < 0) {
            return 0;
        }
        short s = this.lineCurrent;
        if (n < 0 || n2 < n) {
            n = n2;
        }
        int n3 = string.length();
        while (--n3 >= n) {
            char c = string.charAt(n3);
            if (c != '\n' && c != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - s;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return ScriptCompiler.eol(c, this.nSemiSkip);
    }

    static boolean eol(char c, int n) {
        return c == '\r' || c == '\n' || c == ';' && n <= 0;
    }

    private boolean lookingAtBraceSyntax() {
        int n = this.ichToken;
        int n2 = 1;
        while (++n < this.cchScript && n2 > 0) {
            switch (this.script.charAt(n)) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    --n2;
                }
            }
        }
        if (n < this.cchScript && this.script.charAt(n) == '[' && ++n2 == 1) {
            while (++n < this.cchScript && n2 > 0) {
                switch (this.script.charAt(n)) {
                    case '[': {
                        ++n2;
                        break;
                    }
                    case ']': {
                        --n2;
                    }
                }
            }
        }
        return n < this.cchScript && this.script.charAt(n) == '.' && n2 == 0;
    }

    private boolean lookingAtString(boolean bl) {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || bl && this.chFirst == '\'')) {
            return false;
        }
        int n = this.ichToken;
        boolean bl2 = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != this.chFirst || bl2)) {
            bl2 = c == '\\' ? !bl2 : false;
        }
        if (n == this.cchScript) {
            this.cchToken = -1;
            this.ichEnd = this.cchScript;
        } else {
            this.cchToken = ++n - this.ichToken;
        }
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 98: {
                        n3 = 8;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Escape.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private boolean lookingAtLoadFormat() {
        int n;
        boolean bl;
        char c = '\u0000';
        boolean bl2 = bl = n < this.cchScript && ((c = this.script.charAt(n)) == '$' || c == '=');
        for (n = this.ichToken; n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) && (bl || Character.isLetter(c)) || bl && !this.eol(c) && !Character.isWhitespace(c)); ++n) {
        }
        if (!bl && n == this.ichToken || !ScriptCompiler.isSpaceOrTab(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString(boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.ichToken;
        char c = this.script.charAt(n);
        boolean bl4 = !Token.tokAttr(this.tokCommand, 20480) && (this.tokCommand & 1) != 0;
        boolean bl5 = c == '@';
        boolean bl6 = bl3 = bl5 && n + 3 < this.cchScript && this.script.charAt(n + 1) == '{';
        if (bl3 && bl4) {
            n = ScriptCompiler.ichMathTerminator(this.script, this.ichToken + 1, this.cchScript);
            return n != this.cchScript && (this.cchToken = n + 1 - this.ichToken) > 0;
        }
        int n2 = -1;
        int n3 = -1;
        boolean bl7 = true;
        int n4 = 0;
        block5: while (bl7 && n < this.cchScript && !this.eol(c = this.script.charAt(n))) {
            switch (c) {
                case '(': 
                case '=': {
                    if (bl2) break;
                    bl7 = false;
                    continue block5;
                }
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 >= 0 || this.braceCount <= 0 && this.iBrace <= 0) break;
                    bl7 = false;
                    continue block5;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        if (n2 >= 0) break;
                        n2 = n;
                        break;
                    }
                    n3 = n;
                }
            }
            if (Character.isWhitespace(c)) {
                if (n2 < 0) {
                    n2 = n;
                }
            } else {
                n3 = n;
            }
            ++n;
        }
        if (bl) {
            n = n3 + 1;
        } else if (n2 > 0) {
            n = n2;
        }
        if (bl5 && n2 < 0 && n4 <= 0 && n - this.ichToken > 1) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    public static int ichMathTerminator(String string, int n, int n2) {
        int n3 = 1;
        char c = '\u0000';
        int n4 = 0;
        while (n3 > 0 && ++n < n2) {
            char c2 = string.charAt(n);
            if (c != '\u0000') {
                if (n4 == 92) {
                    c2 = '\u0000';
                } else if (c2 == c) {
                    c = '\u0000';
                }
                n4 = c2;
                continue;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    c = c2;
                    break;
                }
                case '{': {
                    ++n3;
                    break;
                }
                case '}': {
                    --n3;
                }
            }
        }
        return n;
    }

    private float lookingAtExponential() {
        int n;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n2 = n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n3 = 88;
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n == this.cchScript || !bl) {
            return Float.NaN;
        }
        boolean bl2 = bl = n3 != 69 && n3 != 101;
        if (bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (!bl) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        return (float)Double.valueOf(this.script.substring(n2, n)).doubleValue();
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n2 = 88;
        while (n < this.cchScript) {
            char c2 = this.script.charAt(n++);
            n2 = c2;
            if (!Character.isDigit(c2)) break;
            bl = true;
        }
        if (n2 != 46) {
            return false;
        }
        if (n < this.cchScript && !this.eol(c = this.script.charAt(n))) {
            if (Character.isLetter(c) || c == '?' || c == '*') {
                return false;
            }
            if (n + 1 < this.cchScript && (Character.isLetter(c = this.script.charAt(n + 1)) || c == '?')) {
                return false;
            }
        }
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        int n = this.ichToken;
        char c = ' ';
        if (n + 1 < this.cchScript && this.script.charAt(n) == '*' && this.script.charAt(n + 1) == '^') {
            c = '^';
            ++n;
        } else {
            if (this.script.charAt(n) == '-') {
                ++n;
            }
            while (n < this.cchScript) {
                char c2 = this.script.charAt(n);
                c = c2;
                if (!Character.isDigit(c2)) break;
                ++n;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !Character.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return Integer.MAX_VALUE;
        }
        int n = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return Integer.MAX_VALUE;
        }
        this.cchToken = n - this.ichToken;
        try {
            int n3 = Integer.parseInt(this.script.substring(this.ichToken, n));
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    BitSet lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || (n = this.script.indexOf("}", this.ichToken)) < 0 || n + 1 == this.cchScript) {
            return null;
        }
        BitSet bitSet = Escape.unescapeBitset(this.script.substring(this.ichToken, n + 2));
        if (bitSet != null) {
            this.cchToken = n + 2 - this.ichToken;
        }
        return bitSet;
    }

    private boolean lookingAtObjectID(boolean bl) {
        int n = this.ichToken;
        if (n == this.cchScript || this.script.charAt(n) != '$') {
            return false;
        }
        if (++n != this.cchScript && this.script.charAt(n) == '\"') {
            return false;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            if (Character.isWhitespace(c)) {
                if (n != this.ichToken + 1) break;
                return false;
            }
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (bl) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++n;
        }
        this.cchToken = n - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int n) {
        if (n == this.cchScript) {
            return false;
        }
        int n2 = n;
        this.tokLastMath = 0;
        char c = this.script.charAt(n++);
        switch (c) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '|': {
                if (n < this.cchScript) {
                    if (this.script.charAt(n) == c) {
                        ++n;
                        if (c == '-' || c == '+') break;
                        if (c == '&' && n < this.cchScript && this.script.charAt(n) == c) {
                            ++n;
                        }
                    } else if (this.script.charAt(n) == '=') {
                        ++n;
                    }
                }
                this.tokLastMath = 1;
                break;
            }
            case '/': {
                if (n < this.cchScript && this.script.charAt(n) == '/') break;
            }
            case '!': 
            case '\\': {
                if (n < this.cchScript && this.script.charAt(n) == '=') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            case ')': 
            case '.': 
            case ']': 
            case '}': {
                break;
            }
            case '@': 
            case '{': {
                this.tokLastMath = 2;
                break;
            }
            case ':': {
                this.tokLastMath = 1;
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ';': 
            case '[': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (n < this.cchScript && ((c = this.script.charAt(n)) == '<' || c == '=' || c == '>')) {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!Character.isLetter(c)) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (c == '?') {
                    this.tokLastMath = 1;
                }
                while (n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) || c == '_' || c == '?' || c == '~' || c == '\'') || c == '^' && n > n2 && Character.isDigit(this.script.charAt(n - 1)) || c == '\\' && n + 1 < this.cchScript && this.script.charAt(n + 1) == '?') {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - n2;
        return true;
    }

    private boolean charToken() {
        int n;
        char c;
        if (this.ichToken == this.cchScript || (c = this.script.charAt(this.ichToken)) == '\"' || c == '@') {
            return false;
        }
        for (n = this.ichToken; n < this.cchScript && !ScriptCompiler.isSpaceOrTab(c = this.script.charAt(n)) && c != '#' && c != '}' && !this.eol(c); ++n) {
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int ERROR(int n) {
        this.error(n, null, null);
        return 4;
    }

    private int ERROR(int n, String string) {
        this.error(n, string);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken : this.ichEnd);
        String string = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT._("script compiler ERROR: ") + this.errorMessage + ScriptEvaluator.setErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.ichToken = Math.max(this.ichEnd, this.ichToken);
            while (!this.lookingAtEndOfLine() && !this.lookingAtEndOfStatement()) {
                ++this.ichToken;
            }
            this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichToken);
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }

    public static String[] splitCommandLine(String string) {
        String[] stringArray = new String[3];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.length() == 0) {
            return null;
        }
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        block7: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    if (bl3 || bl) break;
                    boolean bl4 = bl2 = !bl2;
                    if (!bl2) break;
                    n = n3 = i;
                    break;
                }
                case '\'': {
                    if (bl3 || bl2) break;
                    boolean bl5 = bl = !bl;
                    if (!bl) break;
                    n = n3 = i;
                    break;
                }
                case '\\': {
                    bl3 = !bl3;
                    continue block7;
                }
                case ' ': {
                    if (bl3 || bl || bl2) break;
                    n3 = i + 1;
                    n = -1;
                    break;
                }
                case ';': {
                    if (bl || bl2) break;
                    n2 = n3 = i + 1;
                    n = -1;
                    break;
                }
                default: {
                    if (bl || bl2) break;
                    n = -1;
                }
            }
            bl3 = false;
        }
        stringArray[0] = string.substring(0, n2);
        stringArray[1] = n3 == n2 ? string.substring(n2) : string.substring(n2, n3 > n ? n3 : n);
        stringArray[2] = n3 == n2 ? null : string.substring(n3);
        return stringArray;
    }
}

