/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.JmolConstants;

public final class Resolver
implements JmolBioResolver {
    private ModelLoader modelLoader;
    private ModelSet modelSet;
    private BitSet bsAddedHydrogens;
    private BitSet bsAtomsForHs;
    private Map<String, String> htBondMap;
    private Map<String, Boolean> htGroupBonds;
    private String[] hNames;
    private int lastSetH = Integer.MIN_VALUE;
    private int maxSerial = 0;
    private int baseBondIndex = 0;
    private boolean haveHsAlready;
    private Vector3f vAB;
    private Vector3f vAC;
    private Vector3f vNorm;
    private Point4f plane;

    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int n4, int[] nArray, Atom[] atomArray) {
        int n5 = n3 - 1;
        int n6 = 0;
        int n7 = JmolConstants.ATOMID_MAX;
        while (--n7 >= 0) {
            nArray[n7] = Integer.MIN_VALUE;
        }
        n7 = n3;
        while (--n7 >= n2) {
            byte by = atomArray[n7].getAtomID();
            if (by <= 0) continue;
            if (by < 14) {
                n6 |= 1 << by;
            }
            nArray[by] = n7;
        }
        if (n5 < n2) {
            throw new NullPointerException();
        }
        if ((n6 & 0xE) == 14) {
            return AminoMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray, atomArray);
        }
        if (n6 == 4) {
            return AlphaMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if ((n6 & 0x1FC0) == 8128) {
            return NucleicMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if (n6 == 8192) {
            return PhosphorusMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if (JmolConstants.checkCarbohydrate(string)) {
            return CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n5);
        }
        return null;
    }

    public Polymer buildBioPolymer(Group group, Group[] groupArray, int n, boolean bl) {
        return group instanceof Monomer && ((Monomer)group).getBioPolymer() == null ? BioPolymer.allocateBioPolymer(groupArray, n, bl) : null;
    }

    public void clearBioPolymers(Group[] groupArray, int n, BitSet bitSet) {
        for (int i = 0; i < n; ++i) {
            Monomer monomer;
            Group group = groupArray[i];
            if (!(group instanceof Monomer) || (monomer = (Monomer)group).getBioPolymer() == null || bitSet != null && bitSet.get(monomer.getModelIndex())) continue;
            monomer.setBioPolymer(null, -1);
        }
    }

    public void setHaveHsAlready(boolean bl) {
        this.haveHsAlready = bl;
    }

    public void initialize(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public void initializeHydrogenAddition(ModelLoader modelLoader, int n) {
        this.modelLoader = modelLoader;
        this.baseBondIndex = n;
        this.bsAddedHydrogens = new BitSet();
        this.bsAtomsForHs = new BitSet();
        this.htBondMap = new Hashtable<String, String>();
        this.htGroupBonds = new Hashtable<String, Boolean>();
        this.hNames = new String[3];
        this.vAB = new Vector3f();
        this.vAC = new Vector3f();
        this.vNorm = new Vector3f();
        this.plane = new Point4f();
    }

    public void addImplicitHydrogenAtoms(JmolAdapter jmolAdapter, int n) {
        int n2;
        String string = this.modelLoader.getGroup3(n);
        if (this.haveHsAlready || string == null || (n2 = JmolConstants.getStandardPdbHydrogenCount(Group.lookupGroupID(string))) == 0) {
            return;
        }
        Object object = null;
        int n3 = this.modelLoader.getFirstAtomIndex(n);
        int n4 = this.modelSet.getAtomCount();
        if (n2 < 0) {
            if (n4 - n3 == 1) {
                return;
            }
            object = this.modelSet.viewer.getLigandModel(string);
            if (object == null) {
                return;
            }
            n2 = jmolAdapter.getHydrogenAtomCount(object);
            if (n2 < 1) {
                return;
            }
        }
        this.getBondInfo(jmolAdapter, string, object);
        this.modelSet.getModels()[this.modelSet.atoms[n3].modelIndex].isPdbWithMultipleBonds = true;
        this.bsAtomsForHs.set(n3, n4);
        this.bsAddedHydrogens.set(n4, n4 + n2);
        boolean bl = this.modelSet.atoms[n3].isHetero();
        for (int i = 0; i < n2; ++i) {
            this.modelSet.addAtom(this.modelSet.atoms[n3].modelIndex, this.modelSet.atoms[n3].getGroup(), (short)1, "H", 0, 0, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, 0, 0.0f, 1, 0.0f, null, bl, '\u0000', (byte)0, null).delete(null);
        }
    }

    public void getBondInfo(JmolAdapter jmolAdapter, String string, Object object) {
        if (this.htGroupBonds.get(string) != null) {
            return;
        }
        String[][] stringArray = object == null ? this.modelSet.viewer.getPdbBondInfo(string) : this.getLigandBondInfo(jmolAdapter, object, string);
        if (stringArray == null) {
            return;
        }
        this.htGroupBonds.put(string, Boolean.TRUE);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i][1].charAt(0) == 'H') {
                this.htBondMap.put(string + "." + stringArray[i][0], stringArray[i][1]);
                continue;
            }
            this.htBondMap.put(string + ":" + stringArray[i][0] + ":" + stringArray[i][1], stringArray[i][2]);
        }
    }

    private String[][] getLigandBondInfo(JmolAdapter jmolAdapter, Object object, String string) {
        String[][] stringArray = jmolAdapter.getBondList(object);
        Hashtable<String, Point3f> hashtable = new Hashtable<String, Point3f>();
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        while (atomIterator.hasNext()) {
            hashtable.put(atomIterator.getAtomName(), atomIterator.getXYZ());
        }
        String[][] stringArray2 = new String[stringArray.length * 2][];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringArray3[0].charAt(0) != 'H') {
                stringArray2[n++] = new String[]{stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[1].startsWith("H") ? "0" : "1"};
            }
            if (stringArray3[1].charAt(0) == 'H') continue;
            stringArray2[n++] = new String[]{stringArray3[1], stringArray3[0], stringArray3[2], stringArray3[0].startsWith("H") ? "0" : "1"};
        }
        Arrays.sort(stringArray2, new BondSorter());
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = stringArray2[n2];
            String string2 = stringArray4[0];
            int n3 = 0;
            int n4 = 0;
            while (n2 < n && (stringArray4 = stringArray2[n2])[0].equals(string2)) {
                if (stringArray4[3].equals("0")) {
                    ++n3;
                } else if (stringArray4[3].equals("1")) {
                    ++n4;
                }
                ++n2;
            }
            int n5 = n2 - n3 - n4;
            if (n3 == 1) continue;
            switch (n4) {
                case 1: {
                    char c = n3 == 2 ? (char)'@' : '|';
                    for (int i = 1; i < n3; ++i) {
                        String[] stringArray5 = stringArray2[n5];
                        stringArray5[1] = stringArray5[1] + c + stringArray2[n5 + i][1];
                        stringArray2[n5 + i] = null;
                    }
                    break;
                }
                case 2: {
                    if (n3 != 2) break;
                    String string3 = stringArray2[n5][0];
                    String string4 = stringArray2[n5 + n3][1];
                    String string5 = stringArray2[n5 + n3 + 1][1];
                    int n6 = string4.compareTo(string5);
                    Measure.getPlaneThroughPoints((Point3f)hashtable.get(string4), (Point3f)hashtable.get(string3), (Point3f)hashtable.get(string5), this.vNorm, this.vAB, this.vAC, this.plane);
                    float f = Measure.distanceToPlane(this.plane, (Point3f)hashtable.get(stringArray2[n5][1])) * (float)n6;
                    stringArray2[n5][1] = f > 0.0f ? stringArray2[n5][1] + "@" + stringArray2[n5 + 1][1] : stringArray2[n5 + 1][1] + "@" + stringArray2[n5][1];
                    stringArray2[n5 + 1] = null;
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            String[] stringArray6 = stringArray2[n2];
            if (stringArray6 != null && stringArray6[1].charAt(0) != 'H' && stringArray6[0].compareTo(stringArray6[1]) > 0) {
                stringArray2[n2] = null;
                continue;
            }
            if (stringArray6 == null) continue;
            Logger.info(" ligand " + string + ": " + stringArray2[n2][0] + " - " + stringArray2[n2][1] + " order " + stringArray2[n2][2]);
        }
        return stringArray2;
    }

    public void finalizeHydrogens() {
        this.modelSet.viewer.getLigandModel(null);
        this.finalizePdbMultipleBonds();
        if (this.bsAddedHydrogens.nextSetBit(0) >= 0) {
            this.finalizePdbCharges();
            int[] nArray = new int[1];
            Point3f[][] point3fArray = this.modelSet.calculateHydrogens(this.bsAtomsForHs, nArray, true, false, null);
            Group group = null;
            int n = 0;
            block8: for (int i = 0; i < point3fArray.length; ++i) {
                if (point3fArray[i] == null) continue;
                Atom atom = this.modelSet.atoms[i];
                Group group2 = atom.getGroup();
                if (group2 != group) {
                    group = group2;
                    n = group2.lastAtomIndex;
                    while (this.bsAddedHydrogens.get(n)) {
                        --n;
                    }
                }
                String string = atom.getGroup3(false);
                String string2 = atom.getAtomName();
                String string3 = this.htBondMap.get(string + "." + string2);
                if (string3 == null) continue;
                boolean bl = string3.contains("@");
                boolean bl2 = string3.endsWith("?") || string3.indexOf("|") >= 0;
                int n2 = point3fArray[i].length;
                if (n2 == 3 && !bl2 && string3.equals("H@H2")) {
                    string3 = "H|H2|H3";
                    bl2 = true;
                    bl = false;
                }
                if (bl && n2 == 3 || bl2 != (n2 == 3)) {
                    Logger.info("Error adding H atoms to " + string + group2.getResno() + ": " + point3fArray[i].length + " atoms should not be added to " + string2);
                    continue;
                }
                int n3 = string3.indexOf("@");
                switch (point3fArray[i].length) {
                    case 1: {
                        if (n3 > 0) {
                            string3 = string3.substring(0, n3);
                        }
                        this.setHydrogen(i, ++n, string3, point3fArray[i][0]);
                        continue block8;
                    }
                    case 2: {
                        String string4;
                        String string5;
                        float f = -1.0f;
                        Bond[] bondArray = atom.getBonds();
                        if (bondArray != null) {
                            switch (bondArray.length) {
                                case 2: {
                                    Atom atom2 = bondArray[0].getOtherAtom(atom);
                                    Atom atom3 = bondArray[1].getOtherAtom(atom);
                                    int n4 = atom2.getAtomName().compareTo(atom3.getAtomName());
                                    Measure.getPlaneThroughPoints(atom2, atom, atom3, this.vNorm, this.vAB, this.vAC, this.plane);
                                    f = Measure.distanceToPlane(this.plane, point3fArray[i][0]) * (float)n4;
                                }
                            }
                        }
                        if (n3 < 0) {
                            Logger.info("Error adding H atoms to " + string + group2.getResno() + ": expected to only need 1 H but needed 2");
                            string5 = "H";
                            string4 = "H";
                        } else if (f < 0.0f) {
                            string5 = string3.substring(0, n3);
                            string4 = string3.substring(n3 + 1);
                        } else {
                            string4 = string3.substring(0, n3);
                            string5 = string3.substring(n3 + 1);
                        }
                        this.setHydrogen(i, ++n, string4, point3fArray[i][0]);
                        this.setHydrogen(i, ++n, string5, point3fArray[i][1]);
                        continue block8;
                    }
                    case 3: {
                        int n5 = string3.indexOf(124);
                        if (n5 >= 0) {
                            int n6 = string3.lastIndexOf(124);
                            this.hNames[0] = string3.substring(0, n5);
                            this.hNames[1] = string3.substring(n5 + 1, n6);
                            this.hNames[2] = string3.substring(n6 + 1);
                        } else {
                            this.hNames[0] = string3.replace('?', '1');
                            this.hNames[1] = string3.replace('?', '2');
                            this.hNames[2] = string3.replace('?', '3');
                        }
                        this.setHydrogen(i, ++n, this.hNames[0], point3fArray[i][0]);
                        this.setHydrogen(i, ++n, this.hNames[1], point3fArray[i][2]);
                        this.setHydrogen(i, ++n, this.hNames[2], point3fArray[i][1]);
                    }
                }
            }
            this.deleteUnneededAtoms();
        }
    }

    private void deleteUnneededAtoms() {
        BitSet bitSet = new BitSet();
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.modelSet.atoms[n];
            if (atom.isHetero() && atom.getElementNumber() == 8 && atom.getFormalCharge() == 0 && atom.getCovalentBondCount() == 2) {
                Bond[] bondArray;
                Bond[] bondArray2 = atom.getBonds();
                Bond[] bondArray3 = bondArray2[0].getOtherAtom(atom);
                Atom atom2 = bondArray2[1].getOtherAtom(atom);
                if (bondArray3.getElementNumber() == 1) {
                    bondArray = bondArray3;
                    bondArray3 = atom2;
                    atom2 = bondArray;
                }
                if (atom2.getElementNumber() == 1) {
                    bondArray = bondArray3.getBonds();
                    for (int i = 0; i < bondArray.length; ++i) {
                        Atom atom3;
                        if (bondArray[i].order != 2 || (atom3 = bondArray[i].getOtherAtom((Atom)bondArray3)).getElementNumber() != 8) continue;
                        this.bsAddedHydrogens.set(atom2.index);
                        atom2.delete(bitSet);
                        break;
                    }
                }
            }
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
        this.modelSet.deleteBonds(bitSet, true);
        this.modelLoader.deleteAtoms(this.bsAddedHydrogens);
    }

    private void finalizePdbCharges() {
        Atom[] atomArray = this.modelSet.atoms;
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            if (atomArray[n].getGroup().getNitrogenAtom() == atomArray[n] && atomArray[n].getCovalentBondCount() == 1) {
                atomArray[n].setFormalCharge(1);
            }
            if ((n = this.bsAtomsForHs.nextClearBit(n + 1)) < 0) break;
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finalizePdbMultipleBonds() {
        void var5_11;
        CharSequence charSequence;
        Object object;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = this.modelSet.getBondCount();
        Bond[] bondArray = this.modelSet.getBonds();
        for (int i = this.baseBondIndex; i < n; ++i) {
            Atom object3 = bondArray[i].getAtom1();
            Atom atom = bondArray[i].getAtom2();
            object = object3.getGroup();
            if (object != atom.getGroup()) continue;
            charSequence = new StringBuffer(((Group)object).getGroup3());
            charSequence.append(":");
            String string = object3.getAtomName();
            String string2 = atom.getAtomName();
            if (string.compareTo(string2) > 0) {
                charSequence.append(string2).append(":").append(string);
            } else {
                charSequence.append(string).append(":").append(string2);
            }
            String string3 = charSequence.toString();
            String string4 = this.htBondMap.get(string3);
            if (string4 == null) continue;
            hashtable.put(string3, Boolean.TRUE);
            bondArray[i].setOrder(Integer.valueOf(string4));
        }
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            if (string.indexOf(":") < 0) {
                hashtable.put(string, Boolean.TRUE);
                continue;
            }
            String string5 = this.htBondMap.get(string);
            Logger.info("bond " + string + " was not used; order=" + string5);
            if (!this.htBondMap.get(string).equals("1")) continue;
            hashtable.put(string, Boolean.TRUE);
        }
        Hashtable hashtable2 = new Hashtable();
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            hashtable2.put(string.substring(0, string.lastIndexOf(":")), this.htBondMap.get(string));
        }
        if (hashtable2.isEmpty()) {
            return;
        }
        boolean bl = false;
        while (var5_11 < n) {
            Atom atom = bondArray[var5_11].getAtom1();
            object = bondArray[var5_11].getAtom2();
            if (atom.getGroup() != ((Atom)object).getGroup() && ((charSequence = (String)hashtable2.get(atom.getGroup3(false) + ":" + atom.getAtomName())) != null || (charSequence = (String)hashtable2.get(((Atom)object).getGroup3(false) + ":" + ((Atom)object).getAtomName())) != null)) {
                bondArray[var5_11].setOrder(Integer.valueOf((String)charSequence));
                Logger.info("assigning order " + bondArray[var5_11].order + " to bond " + bondArray[var5_11]);
            }
            ++var5_11;
        }
    }

    private void setHydrogen(int n, int n2, String string, Point3f point3f) {
        if (!this.bsAddedHydrogens.get(n2)) {
            return;
        }
        Atom[] atomArray = this.modelSet.atoms;
        if (this.lastSetH == Integer.MIN_VALUE || atomArray[n2].modelIndex != atomArray[this.lastSetH].modelIndex) {
            this.lastSetH = n2;
            this.maxSerial = ((int[])this.modelSet.getModelAuxiliaryInfo(atomArray[this.lastSetH].modelIndex, "PDB_CONECT_firstAtom_count_max"))[2];
        }
        this.bsAddedHydrogens.clear(n2);
        this.modelSet.setAtomName(n2, string);
        atomArray[n2].set(point3f);
        this.modelSet.setAtomNumber(n2, ++this.maxSerial);
        this.modelLoader.undeleteAtom(n2);
        this.modelSet.bondAtoms(atomArray[n], atomArray[n2], 1, this.modelSet.getDefaultMadFromOrder(1), null, 0.0f, true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BondSorter
    implements Comparator<String[]> {
        BondSorter() {
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return stringArray2 == null ? (stringArray == null ? 0 : -1) : (stringArray == null ? 1 : (stringArray[0].compareTo(stringArray2[0]) < 0 ? -1 : (stringArray[0].compareTo(stringArray2[0]) > 0 ? 1 : (stringArray[3].compareTo(stringArray2[3]) < 0 ? -1 : (stringArray[3].compareTo(stringArray2[3]) > 0 ? 1 : (stringArray[1].compareTo(stringArray2[1]) < 0 ? -1 : (stringArray[1].compareTo(stringArray2[1]) > 0 ? 1 : 0)))))));
        }
    }
}

