/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.Polymer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BondCollection
extends AtomCollection {
    protected JmolMolecule[] molecules = new JmolMolecule[4];
    protected int moleculeCount;
    protected Bond[] bonds;
    protected int bondCount;
    protected static final int BOND_GROWTH_INCREMENT = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;
    protected int[] numCached = new int[5];
    protected Bond[][][] freeBonds = new Bond[5][][];
    protected BitSet bsHBondsRasmol;
    private boolean haveWarned;
    protected short defaultCovalentMad;
    private BitSet bsAromaticSingle;
    private BitSet bsAromaticDouble;
    protected BitSet bsAromatic;
    protected boolean haveHiddenBonds;

    public BondCollection() {
        int n = 5;
        while (--n > 0) {
            this.freeBonds[n] = new Bond[200][];
        }
        this.haveWarned = false;
        this.bsAromatic = new BitSet();
    }

    @Override
    protected void releaseModelSet() {
        this.bonds = null;
        this.freeBonds = null;
        super.releaseModelSet();
    }

    protected void resetMolecules() {
        this.molecules = null;
        this.moleculeCount = 0;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBondAt(int n) {
        return this.bonds[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public BondIterator getBondIterator(int n, BitSet bitSet) {
        return new BondIteratorSelected(this.bonds, this.bondCount, n, bitSet, this.viewer.getBondSelectionModeOr());
    }

    public BondIterator getBondIterator(BitSet bitSet) {
        return new BondIteratorSelected(this.bonds, this.bondCount, bitSet);
    }

    public Atom getBondAtom1(int n) {
        return this.bonds[n].atom1;
    }

    public Atom getBondAtom2(int n) {
        return this.bonds[n].atom2;
    }

    public float getBondRadius(int n) {
        return this.bonds[n].getRadius();
    }

    public int getBondOrder(int n) {
        return this.bonds[n].order;
    }

    public short getBondColix1(int n) {
        return this.bonds[n].getColix1();
    }

    public short getBondColix2(int n) {
        return this.bonds[n].getColix2();
    }

    public int getBondModelIndex(int n) {
        return this.bonds[n].atom1.modelIndex;
    }

    protected int getBondCountInModel(int n) {
        int n2 = 0;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (this.bonds[n3].atom1.modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    public BitSet getBondsForSelectedAtoms(BitSet bitSet, boolean bl) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.bondCount; ++i) {
            boolean bl2;
            boolean bl3;
            Bond bond = this.bonds[i];
            if (!(!bl & (bl3 = bitSet.get(bond.atom1.index)) & (bl2 = bitSet.get(bond.atom2.index))) && !(bl & (bl3 | bl2))) continue;
            bitSet2.set(i);
        }
        return bitSet2;
    }

    public Bond bondAtoms(Atom atom, Atom atom2, int n, short s, BitSet bitSet, float f, boolean bl, boolean bl2) {
        Bond bond = this.getOrAddBond(atom, atom2, n, s, bitSet, f, true);
        if (bl2) {
            bond.order |= 0x20000;
            if (bl) {
                atom.group = atom2.group;
                atom.group.addAtoms(atom.index);
            }
        }
        return bond;
    }

    private Bond getOrAddBond(Atom atom, Atom atom2, int n, short s, BitSet bitSet, float f, boolean bl) {
        int n2;
        if (n == 131071 || n == 65535) {
            n = 1;
        }
        if (atom.isBonded(atom2)) {
            n2 = atom.getBond((Atom)atom2).index;
            if (bl) {
                this.bonds[n2].setOrder(n);
                this.bonds[n2].setMad(s);
                if (this.bonds[n2] instanceof HBond) {
                    ((HBond)this.bonds[n2]).energy = f;
                }
            }
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
            }
            n2 = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)s, (float)f)).index;
        }
        if (bitSet != null) {
            bitSet.set(n2);
        }
        return this.bonds[n2];
    }

    protected Bond setBond(int n, Bond bond) {
        bond.index = n;
        this.bonds[bond.index] = bond;
        return this.bonds[bond.index];
    }

    protected Bond bondMutually(Atom atom, Atom atom2, int n, short s, float f) {
        Bond bond = Bond.isHydrogen(n) ? new HBond(atom, atom2, n, s, 0, f) : new Bond(atom, atom2, n, s, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atom2, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond bond, Bond[] bondArray) {
        Bond[] bondArray2;
        if (bondArray == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                bondArray2 = this.freeBonds[1][this.numCached[1]];
            } else {
                bondArray2 = new Bond[]{bond};
            }
        } else {
            int n = bondArray.length;
            int n2 = n + 1;
            if (n2 < 5 && this.numCached[n2] > 0) {
                int n3 = n2;
                int n4 = this.numCached[n3] - 1;
                this.numCached[n3] = n4;
                bondArray2 = this.freeBonds[n2][n4];
            } else {
                bondArray2 = new Bond[n2];
            }
            bondArray2[n] = bond;
            int n5 = n;
            while (--n5 >= 0) {
                bondArray2[n5] = bondArray[n5];
            }
            if (n < 5 && this.numCached[n] < 200) {
                int n6 = n;
                int n7 = this.numCached[n6];
                this.numCached[n6] = n7 + 1;
                this.freeBonds[n][n7] = bondArray;
            }
        }
        return bondArray2;
    }

    void getRasmolHydrogenBonds(Model model, BitSet bitSet, BitSet bitSet2, List<Bond> list, boolean bl, int n, boolean bl2) {
        int n2;
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = list == null;
        if (bl4) {
            list = new ArrayList<Bond>();
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        boolean bl6 = bl3 = bitSet2 == null;
        if (bl3 && model.bioPolymerCount > 0) {
            model.bioPolymers[0].calculateStructures(model.bioPolymers, model.bioPolymerCount, list, false, bl2, false);
        } else {
            n3 = model.bioPolymerCount;
            while (--n3 >= 0) {
                boolean bl7;
                Polymer polymer = model.bioPolymers[n3];
                int n4 = polymer.getType();
                if ((bl || n4 != 1) && n4 != 2) continue;
                boolean bl8 = polymer.isRna();
                boolean bl9 = bl7 = n4 == 1;
                if (bl7) {
                    polymer.calcRasmolHydrogenBonds(null, bitSet, bitSet2, list, n, null, true, false);
                }
                n2 = model.bioPolymerCount;
                while (--n2 >= 0) {
                    Polymer polymer2 = model.bioPolymers[n2];
                    if (polymer2 == null || !bl8 && n3 == n2 || n4 != polymer2.getType()) continue;
                    polymer2.calcRasmolHydrogenBonds(polymer, bitSet, bitSet2, list, n, null, true, false);
                }
            }
        }
        if (list.size() == 0 || !bl4) {
            return;
        }
        model.hasRasmolHBonds = true;
        for (n3 = 0; n3 < list.size(); ++n3) {
            HBond hBond = (HBond)list.get(n3);
            Atom atom = hBond.atom1;
            Atom atom2 = hBond.atom2;
            if (atom.isBonded(atom2)) continue;
            n2 = this.addHBond(atom, atom2, hBond.order, hBond.getEnergy());
            if (this.bsHBondsRasmol == null) continue;
            this.bsHBondsRasmol.set(n2);
        }
    }

    protected int addHBond(Atom atom, Atom atom2, int n, float f) {
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
        }
        return this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)1, (float)f)).index;
    }

    protected static short getBondOrder(float f, float f2, float f3, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f || f3 < f4) {
            return 0;
        }
        float f6 = f + f2 + f5;
        float f7 = f6 * f6;
        return f3 > f7 ? (short)0 : 1;
    }

    protected boolean checkValencesAndBond(Atom atom, Atom atom2, int n, short s, BitSet bitSet) {
        if (atom.getCurrentBondCount() > 20 || atom2.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.haveWarned = true;
            return false;
        }
        int n2 = atom.getFormalCharge();
        if (n2 != 0) {
            int n3 = atom2.getFormalCharge();
            if (n2 < 0 && n3 < 0 || n2 > 0 && n3 > 0) {
                return false;
            }
        }
        if (atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') {
            return false;
        }
        this.getOrAddBond(atom, atom2, n, s, bitSet, 0.0f, false);
        return true;
    }

    protected void deleteAllBonds() {
        this.viewer.setShapeProperty(1, "reset", null);
        int n = this.bondCount;
        while (--n >= 0) {
            this.bonds[n].deleteAtomReferences();
            this.bonds[n] = null;
        }
        this.bondCount = 0;
    }

    public short getDefaultMadFromOrder(int n) {
        return (short)(Bond.isHydrogen(n) ? 1 : ((n & 0x8000) != 0 ? (int)(this.viewer.getStrutDefaultRadius() * 2000.0f) : this.defaultCovalentMad));
    }

    protected int[] deleteConnections(float f, float f2, int n, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, float f3, float f4) {
        Object object;
        int n2;
        BitSet bitSet3;
        boolean bl3 = f < 0.0f;
        boolean bl4 = f2 < 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (bl3) {
            f = -f;
        }
        if (bl4) {
            f2 = -f2;
        }
        BitSet bitSet4 = new BitSet();
        int n3 = 0;
        int n4 = n |= 0x20000;
        if (!bl2 && Bond.isHydrogen(n)) {
            n = 30720;
        }
        if (bl) {
            bitSet3 = bitSet;
        } else {
            bitSet3 = new BitSet();
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                object = this.atoms[n2];
                if (((Atom)object).bonds != null) {
                    int n5 = ((Atom)object).bonds.length;
                    while (--n5 >= 0) {
                        if (!bitSet2.get(((Atom)object).getBondedAtomIndex(n5))) continue;
                        bitSet3.set(((Atom)object).bonds[n5].index);
                    }
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        n2 = bitSet3.nextSetBit(0);
        while (n2 < this.bondCount && n2 >= 0) {
            object = this.bonds[n2];
            Atom atom = ((Bond)object).atom1;
            Atom atom2 = ((Bond)object).atom2;
            float f7 = atom.distanceSquared(atom2);
            if (bl3 || bl4) {
                f5 = atom.distance(atom2);
                f6 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
            }
            if (!(!bl3 ? f7 < f3 : f5 < f6 * f) && !(!bl4 ? f7 > f4 : f5 > f6 * f2)) {
                if (bl2 || n4 == (((Bond)object).order & 0xFFFFFEFF | 0x20000) || (n & ((Bond)object).order & 0x7800) != 0) {
                    bitSet4.set(n2);
                    ++n3;
                }
            }
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
        if (n3 > 0) {
            this.deleteBonds(bitSet4, false);
        }
        return new int[]{0, n3};
    }

    public void deleteBonds(BitSet bitSet, boolean bl) {
        int n;
        int n2 = bitSet.nextSetBit(0);
        if (n2 < 0) {
            return;
        }
        this.resetMolecules();
        short s = -1;
        int n3 = bitSet.cardinality();
        for (n = n2; n < this.bondCount; ++n) {
            Bond bond = this.bonds[n];
            if (n3 > 0 && bitSet.get(n)) {
                short s2;
                --n3;
                if (!bl && (s2 = bond.atom1.modelIndex) != s) {
                    s = s2;
                    ((ModelCollection)this).models[s].resetBoundCount();
                }
                bond.deleteAtomReferences();
                continue;
            }
            this.setBond(n2++, bond);
        }
        n = this.bondCount;
        while (--n >= n2) {
            this.bonds[n] = null;
        }
        this.bondCount = n2;
        BitSet[] bitSetArray = (BitSet[])this.viewer.getShapeProperty(1, "sets");
        if (bitSetArray != null) {
            for (int i = 0; i < bitSetArray.length; ++i) {
                BitSetUtil.deleteBits(bitSetArray[i], bitSet);
            }
        }
        BitSetUtil.deleteBits(this.bsHBondsRasmol, bitSet);
        BitSetUtil.deleteBits(this.bsAromatic, bitSet);
    }

    public void resetAromatic() {
        int n = this.bondCount;
        while (--n >= 0) {
            Bond bond = this.bonds[n];
            if (!bond.isAromatic()) continue;
            bond.setOrder(515);
        }
    }

    public void assignAromaticBonds() {
        this.assignAromaticBonds(true, null);
    }

    protected void assignAromaticBonds(boolean bl, BitSet bitSet) {
        int n;
        if (!bl) {
            this.bsAromatic = new BitSet();
        }
        this.bsAromaticSingle = new BitSet();
        this.bsAromaticDouble = new BitSet();
        boolean bl2 = bitSet == null;
        int n2 = n = bl2 ? this.bondCount - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            Bond bond = this.bonds[n2];
            if (this.bsAromatic.get(n2)) {
                bond.setOrder(515);
            }
            switch (bond.order & 0xFFFDFFFF) {
                case 515: {
                    this.bsAromatic.set(n2);
                    break;
                }
                case 513: {
                    this.bsAromaticSingle.set(n2);
                    break;
                }
                case 514: {
                    this.bsAromaticDouble.set(n2);
                }
            }
            n2 = bl2 ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
        bl2 = bitSet == null;
        int n3 = n = bl2 ? this.bondCount - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (bond.is(515) && !this.bsAromaticDouble.get(n3) && !this.bsAromaticSingle.get(n3) && !this.assignAromaticDouble(bond)) {
                this.assignAromaticSingle(bond);
            }
            n3 = bl2 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        n3 = n;
        while (n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (this.bsAromaticDouble.get(n3)) {
                if (!bond.is(514)) {
                    this.bsAromatic.set(n3);
                    bond.setOrder(514);
                }
            } else if ((this.bsAromaticSingle.get(n3) || bond.isAromatic()) && !bond.is(513)) {
                this.bsAromatic.set(n3);
                bond.setOrder(513);
            }
            n3 = bl2 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        this.assignAromaticNandO(bitSet);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticSingle.get(n)) {
            return false;
        }
        if (this.bsAromaticDouble.get(n)) {
            return true;
        }
        this.bsAromaticDouble.set(n);
        if (!this.assignAromaticSingle(bond.atom1, n) || !this.assignAromaticSingle(bond.atom2, n)) {
            this.bsAromaticDouble.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticDouble.get(n)) {
            return false;
        }
        if (this.bsAromaticSingle.get(n)) {
            return true;
        }
        this.bsAromaticSingle.set(n);
        if (!this.assignAromaticDouble(bond.atom1) || !this.assignAromaticDouble(bond.atom2)) {
            this.bsAromaticSingle.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Atom atom, int n) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || this.assignAromaticSingleHetero(atom)) {
            return false;
        }
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (n3 == n || !bond.isAromatic() || this.bsAromaticSingle.get(n3) || !this.bsAromaticDouble.get(n3) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDouble(Atom atom) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return false;
        }
        boolean bl = this.assignAromaticSingleHetero(atom);
        int n = -1;
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            if (this.bsAromaticDouble.get(bondArray[n2].index)) {
                bl = true;
            }
            if (!bondArray[n2].isAromatic()) continue;
            n = n2;
        }
        n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(n3) || this.bsAromaticSingle.get(n3)) continue;
            if (!bl && this.assignAromaticDouble(bond)) {
                bl = true;
                continue;
            }
            if (!bl && n2 >= n || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return bl;
    }

    private boolean assignAromaticSingleHetero(Atom atom) {
        short s = atom.getElementNumber();
        switch (s) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int n = atom.getValence();
        switch (s) {
            case 6: {
                return n == 4;
            }
            case 7: 
            case 8: {
                return n == 10 - s && atom.getFormalCharge() < 1;
            }
            case 16: {
                return n == 18 - s && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BitSet bitSet) {
        int n;
        boolean bl = bitSet == null;
        int n2 = n = bl ? this.bondCount - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            Bond bond = this.bonds[n2];
            if (bond.is(513)) {
                int n3;
                Atom atom;
                short s;
                Atom atom2 = bond.atom2;
                short s2 = atom2.getElementNumber();
                if (s2 == 7 || s2 == 8) {
                    s = s2;
                    atom = atom2;
                    atom2 = bond.atom1;
                    s2 = atom2.getElementNumber();
                } else {
                    atom = bond.atom1;
                    s = atom.getElementNumber();
                }
                if ((s == 7 || s == 8) && (n3 = atom.getValence()) >= 0) {
                    int n4 = atom.getCovalentBondCount();
                    int n5 = atom.getFormalCharge();
                    switch (s) {
                        case 7: {
                            if (n3 != 3 || n4 != 3 || n5 >= 1 || s2 != 6 || atom2.getValence() != 3) break;
                            bond.setOrder(514);
                            break;
                        }
                        case 8: {
                            if (n3 != 1 || n5 != 0 || s2 != 14 && s2 != 16) break;
                            bond.setOrder(514);
                        }
                    }
                }
            }
            n2 = bl ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
    }

    @Override
    protected BitSet getAtomBitsMaybeDeleted(int n, Object object) {
        switch (n) {
            default: {
                return super.getAtomBitsMaybeDeleted(n, object);
            }
            case 0x100009: {
                BitSet bitSet = new BitSet();
                int n2 = this.bondCount;
                while (--n2 >= 0) {
                    if (!this.bonds[n2].isAromatic()) continue;
                    bitSet.set(this.bonds[n2].atom1.index);
                    bitSet.set(this.bonds[n2].atom2.index);
                }
                return bitSet;
            }
            case 1678770178: 
        }
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = (BitSet)object;
        int n3 = bitSet2.nextSetBit(0);
        while (n3 >= 0) {
            bitSet.set(this.bonds[n3].atom1.index);
            bitSet.set(this.bonds[n3].atom2.index);
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
        return bitSet;
    }

    public BitSet setBondOrder(int n, char c) {
        int n2 = c - 48;
        Bond bond = this.bonds[n];
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                break;
            }
            case 'm': 
            case 'p': {
                n2 = JmolEdge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (c == 'p' ? 1 : -1);
                if (n2 > 3) {
                    n2 = 1;
                    break;
                }
                if (n2 >= 0) break;
                n2 = 3;
                break;
            }
            default: {
                return null;
            }
        }
        BitSet bitSet = new BitSet();
        try {
            if (n2 == 0) {
                BitSet bitSet2 = new BitSet();
                bitSet2.set(bond.index);
                bitSet.set(bond.getAtomIndex1());
                bitSet.set(bond.getAtomIndex2());
                this.deleteBonds(bitSet2, false);
                return bitSet;
            }
            bond.setOrder(n2 | 0x20000);
            this.removeUnnecessaryBonds(bond.atom1, false);
            this.removeUnnecessaryBonds(bond.atom2, false);
            bitSet.set(bond.getAtomIndex1());
            bitSet.set(bond.getAtomIndex2());
        }
        catch (Exception exception) {
            Logger.error("Exception in seBondOrder: " + exception.getMessage());
        }
        return bitSet;
    }

    protected void removeUnnecessaryBonds(Atom atom, boolean bl) {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return;
        }
        for (int i = 0; i < bondArray.length; ++i) {
            if (bondArray[i].isCovalent()) {
                Atom atom2 = bondArray[i].getOtherAtom(atom);
                if (atom2.getElementNumber() != 1) continue;
                bitSet.set(bondArray[i].getOtherAtom((Atom)atom).index);
                continue;
            }
            bitSet2.set(bondArray[i].index);
        }
        if (bitSet2.nextSetBit(0) >= 0) {
            this.deleteBonds(bitSet2, false);
        }
        if (bl) {
            bitSet.set(atom.index);
        }
        if (bitSet.nextSetBit(0) >= 0) {
            this.viewer.deleteAtoms(bitSet, false);
        }
    }

    public void displayBonds(Bond.BondSet bondSet, boolean bl) {
        if (!bl) {
            this.haveHiddenBonds = true;
        }
        int n = bondSet.nextSetBit(0);
        while (n >= 0) {
            if (n < this.bondCount && this.bonds[n].mad != 0) {
                this.bonds[n].setShapeVisibility(bl);
            }
            n = bondSet.nextSetBit(n + 1);
        }
    }
}

