/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.api.ApiPlatform;
import org.jmol.g3d.Platform3D;

public final class Font3D {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final float fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final float fontSize;
    public final Object font;
    public final Object fontMetrics;
    private ApiPlatform apiPlatform;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount = 1;
    private static int[] fontkeys = new int[8];
    private static Font3D[] font3ds = new Font3D[8];
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};

    private Font3D(ApiPlatform apiPlatform, byte by, int n, int n2, float f, float f2, Object object) {
        this.apiPlatform = apiPlatform;
        this.fid = by;
        this.fontFace = fontFaces[n];
        this.fontStyle = fontStyles[n2];
        this.idFontFace = n;
        this.idFontStyle = n2;
        this.fontSize = f;
        this.fontSizeNominal = f2;
        this.font = apiPlatform.newFont(fontFaces[n], (n2 & 1) == 1, (n2 & 2) == 2, f);
        this.fontMetrics = apiPlatform.getFontMetrics(object, this.font);
    }

    static synchronized Font3D getFont3D(int n, int n2, float f, float f2, Platform3D platform3D) {
        Object object;
        if (platform3D == null) {
            return null;
        }
        if (f > 255.0f) {
            f = 255.0f;
        }
        int n3 = (int)f << 4;
        int n4 = n & 3 | (n2 & 3) << 2 | n3 << 4;
        int n5 = fontkeyCount;
        while (--n5 > 0) {
            if (n4 != fontkeys[n5] || Font3D.font3ds[n5].fontSizeNominal != f2) continue;
            return font3ds[n5];
        }
        if ((n5 = fontkeyCount++) == fontkeys.length) {
            object = new int[n5 + 8];
            System.arraycopy(fontkeys, 0, object, 0, n5);
            fontkeys = object;
            Font3D[] font3DArray = new Font3D[n5 + 8];
            System.arraycopy(font3ds, 0, font3DArray, 0, n5);
            font3ds = font3DArray;
        }
        object = new Font3D(platform3D.apiPlatform, (byte)n5, n, n2, f, f2, platform3D.graphicsOffscreen);
        Font3D.font3ds[n5] = object;
        Font3D.fontkeys[n5] = n4;
        return object;
    }

    public static int getFontFaceID(String string) {
        if ("Monospaced".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("Serif".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    public static int getFontStyleID(String string) {
        int n = 4;
        while (--n >= 0) {
            if (!fontStyles[n].equalsIgnoreCase(string)) continue;
            return n;
        }
        return -1;
    }

    public static Font3D getFont3D(byte by) {
        return font3ds[by & 0xFF];
    }

    public int getAscent() {
        return this.apiPlatform.getFontAscent(this.fontMetrics);
    }

    public int getDescent() {
        return this.apiPlatform.getFontDescent(this.fontMetrics);
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    public int stringWidth(String string) {
        return this.apiPlatform.fontStringWidth(this.fontMetrics, string);
    }
}

