/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import org.jmol.export.___Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class __CartesianExporter
extends ___Exporter {
    protected AxisAngle4f viewpoint = new AxisAngle4f();
    protected Matrix4f sphereMatrix = new Matrix4f();

    public __CartesianExporter() {
        this.exportType = 1;
        this.lineWidthMad = (short)100;
    }

    protected Point3f getModelCenter() {
        return this.referenceCenter;
    }

    protected Point3f getCameraPosition() {
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.viewer.unTransformPoint(point3f2, point3f);
        point3f.sub(this.center);
        this.tempP3.set(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistance * this.scalePixelsPerAngstrom);
        this.viewer.unTransformPoint(this.tempP3, this.tempP3);
        this.tempP3.sub(this.center);
        point3f.add(this.tempP3);
        System.out.println(point3f + " " + this.cameraPosition);
        return this.cameraPosition;
    }

    private void setTempPoints(Point3f point3f, Point3f point3f2, boolean bl) {
        if (bl) {
            this.tempP1.set(point3f);
            this.tempP2.set(point3f2);
        } else {
            this.viewer.unTransformPoint(point3f, this.tempP1);
            this.viewer.unTransformPoint(point3f2, this.tempP2);
        }
    }

    protected int getCoordinateMap(Tuple3f[] tuple3fArray, int[] nArray, BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (bitSet != null && !bitSet.get(i) || Float.isNaN(tuple3fArray[i].x)) {
                if (bitSet == null) continue;
                bitSet.clear(i);
                continue;
            }
            nArray[i] = n++;
        }
        return n;
    }

    protected int[] getNormalMap(Tuple3f[] tuple3fArray, int n, BitSet bitSet, List<String> list) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (bitSet != null && !bitSet.get(i) || Float.isNaN(tuple3fArray[i].x)) {
                if (bitSet == null) continue;
                bitSet.clear(i);
                continue;
            }
            String string = __CartesianExporter.round(tuple3fArray[i].x) + " " + __CartesianExporter.round(tuple3fArray[i].y) + " " + __CartesianExporter.round(tuple3fArray[i].z) + "\n";
            if (hashtable.containsKey(string)) {
                nArray[i] = (Integer)hashtable.get(string);
                continue;
            }
            nArray[i] = list.size();
            list.add(string);
            hashtable.put(string, nArray[i]);
        }
        return nArray;
    }

    protected void outputIndices(int[][] nArray, int[] nArray2, int n, BitSet bitSet, int n2) {
        int n3;
        boolean bl = bitSet == null;
        int n4 = n3 = bl ? n - 1 : bitSet.nextSetBit(0);
        while (n4 >= 0) {
            this.outputFace(nArray[n4], nArray2, n2);
            n4 = bl ? n4 - 1 : bitSet.nextSetBit(n4 + 1);
        }
    }

    protected abstract void outputFace(int[] var1, int[] var2, int var3);

    protected abstract void outputCircle(Point3f var1, Point3f var2, float var3, short var4, boolean var5);

    protected abstract void outputCone(Point3f var1, Point3f var2, float var3, short var4);

    protected abstract boolean outputCylinder(Point3f var1, Point3f var2, Point3f var3, short var4, byte var5, float var6, Point3f var7, Point3f var8);

    protected abstract void outputEllipsoid(Point3f var1, Point3f[] var2, short var3);

    protected abstract void outputSphere(Point3f var1, float var2, short var3);

    protected abstract void outputTextPixel(Point3f var1, int var2);

    protected abstract void outputTriangle(Point3f var1, Point3f var2, Point3f var3, short var4);

    @Override
    void drawAtom(Atom atom) {
        this.outputSphere(atom, (float)atom.madAtom / 2000.0f, atom.getColix());
    }

    @Override
    void drawCircle(int n, int n2, int n3, int n4, short s, boolean bl) {
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        float f = this.viewer.unscaleToScreen(n3, n4) / 2.0f;
        this.tempP3.set(n, n2, n3 + 1);
        this.viewer.unTransformPoint(this.tempP3, this.tempP3);
        this.outputCircle(this.tempP1, this.tempP3, f, s, bl);
    }

    @Override
    boolean drawEllipse(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, boolean bl) {
        this.tempV1.set(point3f2);
        this.tempV1.sub(point3f);
        this.tempV2.set(point3f3);
        this.tempV2.sub(point3f);
        this.tempV2.cross(this.tempV1, this.tempV2);
        this.tempV2.normalize();
        this.tempV2.scale(bl ? 0.002f : 0.005f);
        this.tempP1.set(point3f);
        this.tempP1.sub(this.tempV2);
        this.tempP2.set(point3f);
        this.tempP2.add(this.tempV2);
        return this.outputCylinder(point3f, this.tempP1, this.tempP2, s, bl ? (byte)2 : 0, 1.01f, point3f2, point3f3);
    }

    @Override
    void drawPixel(short s, int n, int n2, int n3, int n4) {
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.outputSphere(this.tempP1, 0.02f * (float)n4, s);
    }

    @Override
    void drawTextPixel(int n, int n2, int n3, int n4) {
        this.tempP3.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.outputTextPixel(this.tempP1, n);
    }

    @Override
    void fillConeScreen(short s, byte by, int n, Point3f point3f, Point3f point3f2, boolean bl) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        float f = this.viewer.unscaleToScreen(point3f.z, n) / 2.0f;
        if (f < 0.05f) {
            f = 0.05f;
        }
        this.outputCone(this.tempP1, this.tempP2, f, s);
    }

    @Override
    void drawCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        this.setTempPoints(point3f, point3f2, n2 == -1);
        float f = (float)n / 2000.0f;
        if (s == s2) {
            this.outputCylinder(null, this.tempP1, this.tempP2, s, by, f, null, null);
        } else {
            this.tempV2.set(this.tempP2);
            this.tempV2.add(this.tempP1);
            this.tempV2.scale(0.5f);
            this.tempP3.set(this.tempV2);
            this.outputCylinder(null, this.tempP1, this.tempP3, s, by == 3 ? (byte)0 : by, f, null, null);
            this.outputCylinder(null, this.tempP3, this.tempP2, s2, by == 3 ? (byte)0 : by, f, null, null);
            if (by == 3) {
                this.outputSphere(this.tempP1, f * 1.01f, s);
                this.outputSphere(this.tempP2, f * 1.01f, s2);
            }
        }
    }

    @Override
    void fillCylinderScreenMad(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        float f = (float)n / 2000.0f;
        this.setTempPoints(point3f, point3f2, false);
        this.outputCylinder(null, this.tempP1, this.tempP2, s, by, f, null, null);
    }

    @Override
    void fillCylinderScreen(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
        int n2 = (int)(this.viewer.unscaleToScreen((point3f.z + point3f2.z) / 2.0f, n) * 1000.0f);
        this.fillCylinderScreenMad(s, by, n2, point3f, point3f2);
    }

    @Override
    void fillEllipsoid(Point3f point3f, Point3f[] point3fArray, short s, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, Point3i[] point3iArray) {
        this.outputEllipsoid(point3f, point3fArray, s);
    }

    @Override
    void fillSphere(short s, int n, Point3f point3f) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.outputSphere(this.tempP1, this.viewer.unscaleToScreen(point3f.z, n) / 2.0f, s);
    }

    @Override
    protected void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3, boolean bl) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        this.viewer.unTransformPoint(point3f3, this.tempP3);
        this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, s);
        if (bl) {
            this.outputTriangle(this.tempP1, this.tempP3, this.tempP2, s);
        }
    }

    @Override
    void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
        this.g3d.plotImage(n, n2, n3, image, this.jmolRenderer, s, n4, n5);
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        this.g3d.plotText(n, n2, n3, this.g3d.getColorArgbOrGray(s), string, font3D, this.jmolRenderer);
    }

    protected void setSphereMatrix(Point3f point3f, float f, float f2, float f3, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        if (axisAngle4f != null) {
            Matrix3f matrix3f = new Matrix3f();
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.m00 = f;
            matrix3f2.m11 = f2;
            matrix3f2.m22 = f3;
            matrix3f.set(axisAngle4f);
            matrix3f.mul(matrix3f2);
            matrix4f.set(matrix3f);
        } else {
            matrix4f.setIdentity();
            matrix4f.m00 = f;
            matrix4f.m11 = f2;
            matrix4f.m22 = f3;
        }
        matrix4f.m03 = point3f.x;
        matrix4f.m13 = point3f.y;
        matrix4f.m23 = point3f.z;
        matrix4f.m33 = 1.0f;
    }
}

