/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export.__CartesianExporter;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.Geodesic;
import org.jmol.util.MeshSurface;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _IdtfExporter
extends __CartesianExporter {
    private boolean haveSphere;
    private boolean haveCylinder;
    private boolean haveCylinderIn;
    private boolean haveCone;
    private boolean haveCircle;
    private Point3f ptMin = new Point3f(1.0E10f, 1.0E10f, 1.0E10f);
    private Point3f ptMax = new Point3f(-1.0E10f, -1.0E10f, -1.0E10f);
    private int iObj;
    private Map<String, Boolean> htDefs = new Hashtable<String, Boolean>();
    private final Matrix4f m = new Matrix4f();
    private final StringBuffer models = new StringBuffer();
    private final StringBuffer resources = new StringBuffer();
    private final StringBuffer modifiers = new StringBuffer();
    private Map<String, List<String>> htNodes = new Hashtable<String, List<String>>();
    private Matrix4f cylinderMatrix = new Matrix4f();
    private StringBuffer sbTemp;
    private int[][] triangleFace = new int[1][];

    public _IdtfExporter() {
        this.triangleFace[0] = new int[]{0, 1, 2};
        this.commentChar = "% ";
    }

    @Override
    protected void output(Tuple3f tuple3f) {
        this.output(tuple3f, this.sbTemp, true);
    }

    private void output(Tuple3f tuple3f, StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            this.checkPoint(tuple3f);
        }
        stringBuffer.append(_IdtfExporter.round(tuple3f.x)).append(" ").append(_IdtfExporter.round(tuple3f.y)).append(" ").append(_IdtfExporter.round(tuple3f.z)).append(" ");
    }

    private void checkPoint(Tuple3f tuple3f) {
        if (tuple3f.x < this.ptMin.x) {
            this.ptMin.x = tuple3f.x;
        }
        if (tuple3f.y < this.ptMin.y) {
            this.ptMin.y = tuple3f.y;
        }
        if (tuple3f.z < this.ptMin.z) {
            this.ptMin.z = tuple3f.z;
        }
        if (tuple3f.x > this.ptMax.x) {
            this.ptMax.x = tuple3f.x;
        }
        if (tuple3f.y > this.ptMax.y) {
            this.ptMax.y = tuple3f.y;
        }
        if (tuple3f.z > this.ptMax.z) {
            this.ptMax.z = tuple3f.z;
        }
    }

    @Override
    protected void outputHeader() {
        this.output("FILE_FORMAT \"IDTF\"\nFORMAT_VERSION 100\n");
        this.m.setIdentity();
        Quaternion quaternion = this.viewer.getRotationQuaternion();
        this.m.set(quaternion.getMatrix());
        quaternion.transform(this.referenceCenter, this.tempP1);
        this.m.m03 = -this.tempP1.x;
        this.m.m13 = -this.tempP1.y;
        this.m.m23 = -this.tempP1.z;
        this.m.m33 = 1.0f;
        this.output("NODE \"GROUP\" {\n");
        this.output("NODE_NAME \"Jmol\"\n");
        this.output("PARENT_LIST {\nPARENT_COUNT 1\n");
        this.output("PARENT 0 {\n");
        this.output(this.getParentItem("", this.m));
        this.output("}}}\n");
    }

    @Override
    String finalizeOutput() {
        super.finalizeOutput();
        return this.getAuxiliaryFileData();
    }

    private String getAuxiliaryFileData() {
        String string = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
        string = string.substring(string.lastIndexOf("\\") + 1);
        String string2 = string + ".";
        string2 = string2.substring(0, string2.indexOf("."));
        return "% Created by: Jmol " + Viewer.getJmolVersion() + "\n% Creation date: " + _IdtfExporter.getExportDate() + "\n% File created: " + this.fileName + " (" + this.nBytes + " bytes)\n\n" + "\n\\documentclass[12pt,letter]{article}" + "\n\\usepackage{hyperref}" + "\n\\usepackage[3D]{movie15}" + "\n\\usepackage{verbatim}" + "\n\\pagestyle{empty}" + "\n\\begin{document}" + "\n \\begin{center}" + "\n  \\includemovie[" + "\n   label=" + string2 + "," + "\n    autoplay," + "\n    repeat=1," + "\n    toolbar=false," + "\n3Droo=" + this.cameraDistance + "," + "\n3Dcoo= 0.0 0.0 0.0," + "\n3Dc2c=0.0 0.0 1.0," + "\n3Daac=" + this.aperatureAngle + "," + "\n% 3Droll=0.0," + "\n3Dbg=" + this.rgbFractionalFromColix(this.backgroundColix, ' ') + "," + "\n3Dlights=Headlamp," + "\ninline=true," + "\n  ]{0.9\\textwidth}{0.9\\textwidth}{" + string2 + ".u3d}" + "\n%  \\\\" + "\n%\\movieref[3Dcalculate]{" + string2 + "}{Click here!}" + "\n\\end{center}" + "\n\\end{document}" + "\n\\begin{comment}" + this.viewer.getWrappedState(true, 0, 0) + "\n\\end{comment}";
    }

    private String getParentItem(String string, Matrix4f matrix4f) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PARENT_NAME \"" + string + "\"\n");
        stringBuffer.append("PARENT_TM {\n");
        stringBuffer.append(matrix4f.m00 + " " + matrix4f.m10 + " " + matrix4f.m20 + " 0.0\n");
        stringBuffer.append(matrix4f.m01 + " " + matrix4f.m11 + " " + matrix4f.m21 + " 0.0\n");
        stringBuffer.append(matrix4f.m02 + " " + matrix4f.m12 + " " + matrix4f.m22 + " 0.0\n");
        stringBuffer.append(matrix4f.m03 + " " + matrix4f.m13 + " " + matrix4f.m23 + " " + matrix4f.m33 + "\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private void addColix(short s, boolean bl) {
        String string = "_" + s;
        if (this.htDefs.containsKey(string)) {
            return;
        }
        String string2 = bl ? "1.0 1.0 1.0" : this.rgbFractionalFromColix(s, ' ');
        this.htDefs.put(string, Boolean.TRUE);
        this.resources.append("RESOURCE_LIST \"SHADER\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Shader" + string + "\"\n");
        this.resources.append("ATTRIBUTE_USE_VERTEX_COLOR \"FALSE\"\n");
        this.resources.append("SHADER_MATERIAL_NAME \"Mat" + string + "\"\n");
        this.resources.append("SHADER_ACTIVE_TEXTURE_COUNT 0\n");
        this.resources.append("}}\n");
        this.resources.append("RESOURCE_LIST \"MATERIAL\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Mat" + string + "\"\n");
        this.resources.append("MATERIAL_AMBIENT " + string2 + "\n");
        this.resources.append("MATERIAL_DIFFUSE " + string2 + "\n");
        this.resources.append("MATERIAL_SPECULAR 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_EMISSIVE 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_REFLECTIVITY 0.00000\n");
        this.resources.append("MATERIAL_OPACITY " + _IdtfExporter.opacityFractionalFromColix(s) + "\n");
        this.resources.append("}}\n");
    }

    private void addShader(String string, short s) {
        this.modifiers.append("MODIFIER \"SHADING\" {\n");
        this.modifiers.append("MODIFIER_NAME \"" + string + "\"\n");
        this.modifiers.append("PARAMETERS {\n");
        this.modifiers.append("SHADER_LIST_COUNT 1\n");
        this.modifiers.append("SHADING_GROUP {\n");
        this.modifiers.append("SHADER_LIST 0 {\n");
        this.modifiers.append("SHADER_COUNT 1\n");
        this.modifiers.append("SHADER_NAME_LIST {\n");
        this.modifiers.append("SHADER 0 NAME: \"Shader_" + s + "\"\n");
        this.modifiers.append("}}}}}\n");
    }

    @Override
    protected void outputFooter() {
        this.htDefs = null;
        this.outputNodes();
        this.output(this.models.toString());
        this.output(this.resources.toString());
        this.output("RESOURCE_LIST \"VIEW\" {\n");
        this.output("\tRESOURCE_COUNT 1\n");
        this.output("\tRESOURCE 0 {\n");
        this.output("\t\tRESOURCE_NAME \"View0\"\n");
        this.output("\t\tVIEW_PASS_COUNT 1\n");
        this.output("\t\tVIEW_ROOT_NODE_LIST {\n");
        this.output("\t\t\tROOT_NODE 0 {\n");
        this.output("\t\t\t\tROOT_NODE_NAME \"\"\n");
        this.output("\t\t\t}\n");
        this.output("\t\t}\n");
        this.output("\t}\n");
        this.output("}\n\n");
        this.output(this.modifiers.toString());
    }

    private void outputNodes() {
        for (Map.Entry<String, List<String>> entry : this.htNodes.entrySet()) {
            int n;
            String string = entry.getKey();
            List<String> list = entry.getValue();
            this.output("NODE \"MODEL\" {\n");
            this.output("NODE_NAME \"" + string + "\"\n");
            int n2 = list.size();
            this.output("PARENT_LIST {\nPARENT_COUNT " + n2 + "\n");
            for (n = 0; n < n2; ++n) {
                this.output("PARENT " + n + " {\n");
                this.output(list.get(n));
                this.output("}\n");
            }
            this.output("}\n");
            n = string.indexOf("_");
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (string.equals("Ellipse")) {
                string = "Circle";
            }
            this.output("RESOURCE_NAME \"" + string + "_Mesh\"\n}\n");
        }
    }

    @Override
    protected void outputEllipsoid(Point3f point3f, Point3f[] point3fArray, short s) {
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(point3f, point3fArray[1], point3fArray[3]).toAxisAngle4f();
        float f = point3fArray[1].distance(point3f);
        float f2 = point3fArray[3].distance(point3f);
        float f3 = point3fArray[5].distance(point3f);
        this.setSphereMatrix(point3f, f, f2, f3, axisAngle4f, this.sphereMatrix);
        this.outputEllipsoid(point3f, this.sphereMatrix, s);
    }

    private void outputEllipsoid(Point3f point3f, Matrix4f matrix4f, short s) {
        if (!this.haveSphere) {
            this.models.append(this.getSphereResource());
            this.haveSphere = true;
        }
        this.checkPoint(point3f);
        this.addColix(s, false);
        String string = "Sphere_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        list.add(this.getParentItem("Jmol", matrix4f));
    }

    private String getSphereResource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"Sphere_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n");
        int n = Geodesic.getVertexCount(2);
        short[] sArray = Geodesic.getFaceVertexes(2);
        int n2 = sArray.length / 3;
        int[][] nArrayArray = new int[n2][];
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            nArrayArray[i] = new int[]{sArray[++n3], sArray[++n3], sArray[++n3]};
        }
        Tuple3f[] tuple3fArray = new Vector3f[n];
        for (int i = 0; i < n; ++i) {
            tuple3fArray[i] = Geodesic.getVertexVector(i);
        }
        return this.getMeshData("Sphere", nArrayArray, tuple3fArray, tuple3fArray);
    }

    private String getMeshData(String string, int[][] nArray, Tuple3f[] tuple3fArray, Tuple3f[] tuple3fArray2) {
        int n;
        int n2 = nArray.length;
        int n3 = tuple3fArray.length;
        int n4 = tuple3fArray2.length;
        StringBuffer stringBuffer = new StringBuffer();
        this.getMeshHeader(string, n2, n3, n4, 0, stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer2.append(nArray[n][0]).append(" ");
            stringBuffer2.append(nArray[n][1]).append(" ");
            stringBuffer2.append(nArray[n][2]).append(" ");
        }
        stringBuffer.append("MESH_FACE_POSITION_LIST { ");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("}\n");
        stringBuffer.append("MESH_FACE_NORMAL_LIST { ");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("}\n");
        stringBuffer.append("MESH_FACE_SHADING_LIST { ");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("0 ");
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MODEL_POSITION_LIST { ");
        for (n = 0; n < n3; ++n) {
            this.output(tuple3fArray[n], stringBuffer, false);
        }
        stringBuffer.append("}\n");
        stringBuffer.append("MODEL_NORMAL_LIST { ");
        for (n = 0; n < n4; ++n) {
            this.output(tuple3fArray2[n], stringBuffer, false);
        }
        stringBuffer.append("}\n}}}\n");
        return stringBuffer.toString();
    }

    private void getMeshHeader(String string, int n, int n2, int n3, int n4, StringBuffer stringBuffer) {
        stringBuffer.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"").append(string).append("_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n").append("FACE_COUNT ").append(n).append("\n").append("MODEL_POSITION_COUNT ").append(n2).append("\n").append("MODEL_NORMAL_COUNT ").append(n3).append("\n").append("MODEL_DIFFUSE_COLOR_COUNT ").append(n4).append("\n").append("MODEL_SPECULAR_COLOR_COUNT 0\n").append("MODEL_TEXTURE_COORD_COUNT 0\n").append("MODEL_BONE_COUNT 0\n").append("MODEL_SHADING_COUNT 1\n").append("MODEL_SHADING_DESCRIPTION_LIST {\n").append("SHADING_DESCRIPTION 0 {\n").append("TEXTURE_LAYER_COUNT 0\n").append("SHADER_ID 0\n}}\n");
    }

    @Override
    protected boolean outputCylinder(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, byte by, float f, Point3f point3f4, Point3f point3f5) {
        if (point3f4 != null) {
            if (by == 2) {
                this.outputEllipse(point3f, point3f2, point3f4, point3f5, s);
                this.tempP3.set(point3f);
                this.tempP3.sub(point3f4);
                this.tempP3.add(point3f);
                this.outputEllipse(point3f, point3f3, this.tempP3, point3f5, s);
            }
        } else if (by == 3) {
            this.outputSphere(point3f2, f * 1.01f, s);
            this.outputSphere(point3f3, f * 1.01f, s);
        } else if (by == 2) {
            this.outputCircle(point3f2, point3f3, s, f);
            this.outputCircle(point3f3, point3f2, s, f);
        }
        if (!this.haveCylinder) {
            this.models.append(this.getCylinderResource(false));
            this.haveCylinder = true;
        }
        if (point3f4 != null && by == 0 && !this.haveCylinderIn) {
            this.models.append(this.getCylinderResource(true));
            this.haveCylinderIn = true;
        }
        this.checkPoint(point3f2);
        this.checkPoint(point3f3);
        this.addColix(s, false);
        int n = point3f4 != null && by == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            String string = "Cylinder" + (i == 0 ? "_" : "In_") + s;
            List<String> list = this.htNodes.get(string);
            if (list == null) {
                list = new ArrayList<String>();
                this.htNodes.put(string, list);
                this.addShader(string, s);
            }
            if (point3f4 == null) {
                this.cylinderMatrix.set(this.getRotationMatrix(point3f2, point3f3, f));
            } else {
                this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f3, f, point3f4, point3f5));
            }
            this.cylinderMatrix.m03 = point3f2.x;
            this.cylinderMatrix.m13 = point3f2.y;
            this.cylinderMatrix.m23 = point3f2.z;
            this.cylinderMatrix.m33 = 1.0f;
            list.add(this.getParentItem("Jmol", this.cylinderMatrix));
            f *= 0.95f;
        }
        return true;
    }

    @Override
    protected void outputCircle(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
        if (bl) {
            this.outputCircle(point3f, point3f2, s, f);
            return;
        }
    }

    private boolean outputEllipse(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, short s) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new Matrix4f();
        }
        this.addColix(s, false);
        String string = "Ellipse_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.checkPoint(point3f);
        this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f2, 1.0f, point3f3, point3f4));
        this.cylinderMatrix.m03 = point3f2.x;
        this.cylinderMatrix.m13 = point3f2.y;
        this.cylinderMatrix.m23 = point3f2.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.add(this.getParentItem("Jmol", this.cylinderMatrix));
        return true;
    }

    private void outputCircle(Point3f point3f, Point3f point3f2, short s, float f) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new Matrix4f();
        }
        this.addColix(s, false);
        String string = "Circle_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.checkPoint(point3f);
        this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f2, f));
        this.cylinderMatrix.m03 = point3f.x;
        this.cylinderMatrix.m13 = point3f.y;
        this.cylinderMatrix.m23 = point3f.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getCylinderResource(boolean bl) {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[][] nArrayArray = new int[n3][];
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                nArrayArray[++n5] = new int[]{i + n4, (i + 1) % n4, i};
                nArrayArray[++n5] = new int[]{i + n4, (i + 1) % n4 + n4, (i + 1) % n4};
                continue;
            }
            nArrayArray[++n5] = new int[]{i, (i + 1) % n4, i + n4};
            nArrayArray[++n5] = new int[]{(i + 1) % n4, (i + 1) % n4 + n4, i + n4};
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            tuple3fArray[n] = new Point3f(f2, f, 0.0f);
            tuple3fArray2[n] = new Point3f(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            tuple3fArray[n + n4] = new Point3f(f2, f, 1.0f);
            tuple3fArray2[n + n4] = tuple3fArray2[n];
        }
        if (bl) {
            for (n = 0; n < n4; ++n) {
                tuple3fArray2[n].scale(-1.0f);
            }
        }
        return this.getMeshData(bl ? "CylinderIn" : "Cylinder", nArrayArray, tuple3fArray, tuple3fArray2);
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
        this.sbTemp.append(" " + nArray2[nArray[0]] + " " + nArray2[nArray[1]] + " " + nArray2[nArray[2]]);
        if (n == 4 && nArray.length == 4) {
            this.sbTemp.append(" " + nArray2[nArray[0]] + " " + nArray2[nArray[2]] + " " + nArray2[nArray[3]]);
        }
    }

    @Override
    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, List<Short> list, Map<Short, Integer> map, Point3f point3f) {
        int n5;
        this.addColix(s, sArray2 != null || sArray != null);
        if (sArray2 != null) {
            return;
        }
        StringBuffer stringBuffer = this.sbTemp = new StringBuffer();
        int[] nArray2 = new int[n];
        int n6 = this.getCoordinateMap(point3fArray, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bitSet, n4);
        StringBuffer stringBuffer2 = this.sbTemp = new StringBuffer();
        ArrayList<String> arrayList = null;
        if (vector3fArray != null) {
            arrayList = new ArrayList<String>();
            nArray2 = this.getNormalMap(vector3fArray, n, null, arrayList);
            this.outputIndices(nArray, nArray2, n2, bitSet, n4);
        }
        nArray2 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        if (list != null) {
            int n7;
            boolean bl = bitSet == null;
            n5 = n7 = bl ? n2 - 1 : bitSet.nextSetBit(0);
            while (n5 >= 0) {
                if (sArray2 == null) {
                    stringBuffer3.append(" " + map.get("" + sArray[nArray[n5][0]]) + " " + map.get("" + sArray[nArray[n5][1]]) + " " + map.get("" + sArray[nArray[n5][2]]));
                    if (n4 == 4 && nArray[n5].length == 4) {
                        stringBuffer3.append(" " + map.get("" + sArray[nArray[n5][0]]) + " " + map.get("" + sArray[nArray[n5][2]]) + " " + map.get("" + sArray[nArray[n5][3]]));
                    }
                }
                n5 = bl ? n5 - 1 : bitSet.nextSetBit(n5 + 1);
            }
        }
        StringBuffer stringBuffer4 = this.sbTemp = new StringBuffer();
        this.outputVertices(point3fArray, n, point3f);
        StringBuffer stringBuffer5 = new StringBuffer();
        n5 = 0;
        if (vector3fArray != null) {
            n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                stringBuffer5.append((String)arrayList.get(i));
            }
            arrayList = null;
        }
        StringBuffer stringBuffer6 = new StringBuffer();
        int n8 = 0;
        if (list != null) {
            n8 = list.size();
            for (int i = 0; i < n8; ++i) {
                short s2 = list.get(i);
                stringBuffer6.append(this.rgbFractionalFromColix(s2, ' ')).append(" ").append(_IdtfExporter.translucencyFractionalFromColix(s2)).append(" ");
            }
        }
        String string = "mesh" + ++this.iObj;
        this.addMeshData(string, n3, n6, n5, n8, stringBuffer, stringBuffer2, stringBuffer3, stringBuffer4, stringBuffer5, stringBuffer6);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.htNodes.put(string, arrayList2);
        this.addShader(string, s);
        this.cylinderMatrix.setIdentity();
        arrayList2.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private void addMeshData(String string, int n, int n2, int n3, int n4, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4, StringBuffer stringBuffer5, StringBuffer stringBuffer6) {
        this.getMeshHeader(string, n, n2, n3, n4, this.models);
        this.models.append("MESH_FACE_POSITION_LIST { ").append(stringBuffer).append(" }\n").append("MESH_FACE_NORMAL_LIST { ").append(stringBuffer2).append(" }\n");
        this.models.append("MESH_FACE_SHADING_LIST { ");
        for (int i = 0; i < n; ++i) {
            this.models.append("0 ");
        }
        this.models.append("}\n");
        if (n4 > 0) {
            this.models.append("MESH_FACE_DIFFUSE_COLOR_LIST { ").append(stringBuffer3).append(" }\n");
        }
        this.models.append("MODEL_POSITION_LIST { ").append(stringBuffer4).append(" }\n").append("MODEL_NORMAL_LIST { ").append(stringBuffer5).append(" }\n");
        if (n4 > 0) {
            this.models.append("MODEL_DIFFUSE_COLOR_LIST { ").append(stringBuffer6).append(" }\n");
        }
        this.models.append("}}}\n");
    }

    @Override
    protected void outputCone(Point3f point3f, Point3f point3f2, float f, short s) {
        if (!this.haveCone) {
            this.models.append(this.getConeResource());
            this.haveCone = true;
        }
        this.checkPoint(point3f);
        this.checkPoint(point3f2);
        this.addColix(s, false);
        String string = "Cone_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.cylinderMatrix.set(this.getRotationMatrix(point3f, point3f2, f));
        this.cylinderMatrix.m03 = point3f.x;
        this.cylinderMatrix.m13 = point3f.y;
        this.cylinderMatrix.m23 = point3f.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getConeResource() {
        MeshSurface meshSurface = _IdtfExporter.getConeMesh(null, null, (short)0);
        return this.getMeshData("Cone", meshSurface.polygonIndexes, meshSurface.vertices, meshSurface.vertices);
    }

    private String getCircleResource() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            nArrayArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        Tuple3f[] tuple3fArray = new Point3f[n3];
        Tuple3f[] tuple3fArray2 = new Point3f[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            tuple3fArray[i] = new Point3f(f, f2, 0.0f);
            tuple3fArray2[i] = new Point3f(0.0f, 0.0f, 1.0f);
        }
        tuple3fArray[n2] = new Point3f(0.0f, 0.0f, 0.0f);
        tuple3fArray2[n2] = new Point3f(0.0f, 0.0f, 1.0f);
        return this.getMeshData("Circle", nArrayArray, tuple3fArray, tuple3fArray2);
    }

    @Override
    protected void outputSphere(Point3f point3f, float f, short s) {
        this.setSphereMatrix(point3f, f, f, f, null, this.sphereMatrix);
        this.outputEllipsoid(point3f, this.sphereMatrix, s);
    }

    @Override
    protected void outputTextPixel(Point3f point3f, int n) {
        short s = Graphics3D.getColix(n);
        this.outputSphere(point3f, 0.02f, s);
    }

    @Override
    protected void outputTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
        this.addColix(s, false);
        String string = "T" + ++this.iObj;
        this.models.append(this.getTriangleResource(string, point3f, point3f2, point3f3));
        ArrayList<String> arrayList = new ArrayList<String>();
        this.htNodes.put(string, arrayList);
        this.addShader(string, s);
        if (this.cylinderMatrix == null) {
            this.cylinderMatrix = new Matrix4f();
        }
        this.cylinderMatrix.setIdentity();
        arrayList.add(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getTriangleResource(String string, Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Tuple3f[] tuple3fArray = new Point3f[]{point3f, point3f2, point3f3};
        this.tempV1.set(point3f3);
        this.tempV1.sub(point3f);
        this.tempV2.set(point3f2);
        this.tempV2.sub(point3f);
        this.tempV2.cross(this.tempV2, this.tempV1);
        this.tempV2.normalize();
        Tuple3f[] tuple3fArray2 = new Vector3f[]{this.tempV2, this.tempV2, this.tempV2};
        return this.getMeshData(string, this.triangleFace, tuple3fArray, tuple3fArray2);
    }
}

