/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmolFileDropper
implements DropTargetListener {
    private String fd_oldFileName;
    private PropertyChangeSupport fd_propSupport;
    public static final String FD_PROPERTY_INLINE = "inline";
    JmolViewer viewer;
    PropertyChangeListener pcl;
    JmolStatusListener statusListener;

    public JmolFileDropper(JmolStatusListener jmolStatusListener, JmolViewer jmolViewer) {
        this.statusListener = jmolStatusListener;
        this.fd_oldFileName = "";
        this.fd_propSupport = new PropertyChangeSupport(this);
        this.viewer = jmolViewer;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JmolFileDropper.this.doDrop(propertyChangeEvent);
            }
        };
        this.addPropertyChangeListener(this.pcl);
        Component component = (Component)jmolViewer.getDisplay();
        component.setDropTarget(new DropTarget(component, this));
        component.setEnabled(true);
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
        this.viewer = null;
    }

    private void loadFile(String string) {
        if ((string = string.replace('\\', '/').trim()).indexOf("://") < 0) {
            string = (string.startsWith("/") ? "file://" : "file:///") + string;
        }
        if (this.statusListener != null) {
            try {
                String string2 = this.viewer.getFileAsString(string);
                if (string2.indexOf("preferredWidthHeight") >= 0) {
                    this.statusListener.resizeInnerPanel(string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.viewer.openFileAsynchronously(string);
    }

    private void loadFiles(List<File> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            String string = file.getAbsolutePath();
            string = string.replace('\\', '/').trim();
            string = (string.startsWith("/") ? "file://" : "file:///") + string;
            stringBuffer.append("load ").append(i == 0 ? "" : "APPEND ").append(Escape.escape(string)).append(";\n");
        }
        stringBuffer.append("frame *;reset;");
        this.viewer.script(stringBuffer.toString());
    }

    protected void doDrop(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == FD_PROPERTY_INLINE) {
            this.viewer.openStringInline((String)propertyChangeEvent.getNewValue());
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fd_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Logger.debug("DropOver detected...");
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Logger.debug("DropEnter detected...");
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        Logger.debug("DropExit detected...");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        Logger.debug("Drop detected...");
        Transferable transferable = dropTargetDropEvent.getTransferable();
        boolean bl = false;
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            object2 = null;
            try {
                dropTargetDropEvent.acceptDrop(3);
                object2 = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                bl = true;
            }
            catch (Exception exception) {
                Logger.error("transfer failed");
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                int n = list.size();
                if (n == 1) {
                    object = ((File)list.get(0)).getAbsolutePath().trim();
                    if (!((String)object).endsWith(".bmp")) {
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        this.loadFile((String)object);
                        return;
                    }
                } else {
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    this.loadFiles(list);
                    return;
                }
            }
        }
        Logger.debug("browsing supported flavours to find something useful...");
        object2 = transferable.getTransferDataFlavors();
        if (object2 == null || ((DataFlavor[])object2).length == 0) {
            return;
        }
        for (int i = 0; i < ((DataFlavor[])object2).length; ++i) {
            DataFlavor dataFlavor = object2[i];
            object = null;
            Logger.info("df " + i + " flavor " + dataFlavor);
            Logger.info("  class: " + dataFlavor.getRepresentationClass().getName());
            Logger.info("  mime : " + dataFlavor.getMimeType());
            if (dataFlavor.getMimeType().startsWith("text/uri-list") && dataFlavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    object = null;
                    if (!bl) {
                        dropTargetDropEvent.acceptDrop(3);
                    }
                    bl = true;
                    object = transferable.getTransferData(dataFlavor);
                }
                catch (Exception exception) {
                    Logger.error(null, exception);
                }
                if (!(object instanceof String)) continue;
                if (Logger.debugging) {
                    Logger.debug("  String: " + object.toString());
                }
                this.loadFile(object.toString());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                return;
            }
            if (!dataFlavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
            try {
                object = null;
                if (!bl) {
                    dropTargetDropEvent.acceptDrop(3);
                }
                bl = true;
                object = transferable.getTransferData(object2[i]);
            }
            catch (Exception exception) {
                Logger.error(null, exception);
            }
            if (!(object instanceof String)) continue;
            String string = object;
            if (Logger.debugging) {
                Logger.debug("  String: " + string);
            }
            if (string.startsWith("file:/")) {
                this.loadFile(string);
            } else {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, string);
                this.fd_propSupport.firePropertyChange(propertyChangeEvent);
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            return;
        }
        if (!bl) {
            dropTargetDropEvent.rejectDrop();
        }
    }
}

